/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/


// A Simple confirmation delegate to show when the clock times out in on the devices menu
class ContinueSearchingConfirmation extends Toybox.WatchUi.ConfirmationDelegate
{

    function initialize(){

        ConfirmationDelegate.initialize();
    }



    function onResponse( response ){

        if( response == CONFIRM_NO ){
            appData.setSearchState( false );
        }
        return true;
    }

}



// A Simple confirmation delegate to show when the user quits
class QuitConfirmation extends Toybox.WatchUi.ConfirmationDelegate
{

    function initialize(){

        ConfirmationDelegate.initialize();
    }


    function onResponse( response ){

        if( response == CONFIRM_YES ){
            Toybox.WatchUi.popView( Toybox.WatchUi.SLIDE_UP );
            return true;
        }
            System.exit;
            return true;
    }

}



// A Simple confirmation delegate to show when the user quits
class SaveConfirmation extends Toybox.WatchUi.ConfirmationDelegate
{

    hidden var _quitString;

    function initialize(){

        ConfirmationDelegate.initialize();
        self._quitString = Toybox.WatchUi.loadResource( Rez.Strings.QuitPrompt );
    }


    function onResponse( response ){

        if( response == CONFIRM_YES ){
            appData.saveSession();
        }
        else{
            appData.discardSession();
        }
        Toybox.WatchUi.pushView( new Toybox.WatchUi.Confirmation( self._quitString ), new QuitConfirmation(), Toybox.WatchUi.SLIDE_UP );
        return true;
    }

}