/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// A link between the applications data and the data view
// Controls things like the session timer, session state, getting data from the model
class DataController
{

    hidden var _isInProgress = false;
    hidden var _updateTimer = new Toybox.Timer.Timer();
    hidden var _stateTimer = new Toybox.Timer.Timer();
    hidden var _totalSeconds = 0;
    hidden var _currentState = "READY";

    function initialize(){

        self._stateTimer.start( method( :checkState ), 1000, true );
    }


    function checkState(){

        var test1 = self._currentState.toString().hashCode();
        var test2 = "";

        if( appData.getEquipmentState() instanceof Toybox.Lang.String ){
            test2 = appData.getEquipmentState().toString().hashCode();
        }
        if( test1 != test2){
            changeState( appData.getEquipmentState() );
        }

    }


    function changeState( newState ){
        var stateOptions = {
            "ASLEEP"=>:goToSleep,
            "READY"=>:goToReady,
            "IN_USE"=>:goToIn_Use,
            "FINISHED"=>:goToFinished
        };

        if( newState == null ){
            newState = "";
        }
        if( stateOptions.get(newState) != null ) {
            self.method( stateOptions.get( newState )).invoke();
            self._currentState = newState;
        }

    }


    function goToSleep(){

        goToReady();
    }


    function goToReady(){

        if( self._isInProgress ){
            self._stopTime();
        }
        self._totalSeconds = 0;
        Toybox.WatchUi.requestUpdate();
    }


    function goToIn_Use(){

        if( self._isInProgress ){
            return;
        }
        else{
            self._startTime();
        }
    }


    function goToFinished(){

        if( self._isInProgress ){
            self._stopTime();
        }
    }


    function getData(){

        return {
            :instantaneousPower => appData.getInstantaneousPower(),
            :instantaneousCadence => appData.getInstantaneousCadence(),
            :heartRate => appData.getHeartRate(),
            :isInProgress => self._isInProgress,
            :timeString => self.getTimeString()
        };
    }


    hidden function _startTime(){

        var vibeProfile = new Toybox.Attention.VibeProfile(90, 90);
        Toybox.Attention.vibrate([vibeProfile]);
        self._isInProgress = true;
        appData.startSession();
        self._updateTimer.start( method( :updateUi ), 1000, true );
    }


    hidden function _stopTime(){

        var vibeProfile = new Toybox.Attention.VibeProfile(90, 90);
        Toybox.Attention.vibrate([vibeProfile]);
        self._isInProgress = false;
        appData.stopSession();
        self._updateTimer.stop();
    }


    function startStopToggle(){

        if( self._isInProgress ){
            self._stopTime();
        }
        else{
            self._startTime();
        }
    }


    function updateUi(){

        Toybox.WatchUi.requestUpdate();
        appData.updateFitFile();
        self._totalSeconds += 1;
    }


    function secondsString( totalSeconds ){

        return (totalSeconds.toLong() % 60).format( "%02d" );
    }


    function minutesString( totalSeconds ){

        return (Toybox.Math.floor(totalSeconds.toLong() / 60) % 60).format( "%02d" );
    }


    function hoursString( totalSeconds ){

        return (Toybox.Math.floor(totalSeconds.toLong() / 3600) % 60).format( "%02d" );
    }


    function getTimeString(){

        return Toybox.Lang.format("$1$:$2$:$3$", [
            hoursString( self._totalSeconds ),
            minutesString( self._totalSeconds ),
            secondsString( self._totalSeconds )
        ]);
    }

}