/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Control response to user input while the data view is displayed
class DataDelegate extends Toybox.WatchUi.BehaviorDelegate
{

    hidden var _dataController;
    hidden var _saveString;

    function initialize( view ){

     BehaviorDelegate.initialize();
     self._dataController = view.dataController;
     self._saveString = Toybox.WatchUi.loadResource( Rez.Strings.SavePrompt );
    }


    function onSelect(){

        self._dataController.startStopToggle();
    }


    function onBack(){

        Toybox.WatchUi.pushView( new Toybox.WatchUi.Confirmation( self._saveString ), new SaveConfirmation(), Toybox.WatchUi.SLIDE_UP );
        self._dataController.goToReady();
        return true;
    }

}