/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// A link between the applications data and the devices view
// Controls things such as timeouts, opening/closing of the scanning channel
//

class DevicesController
{

    hidden var _timeoutTimer = new Timer.Timer();
    hidden var _searchString = Toybox.WatchUi.loadResource( Rez.Strings.SearchPrompt );

    function openChannel( deviceNumber ){

        self.removeAllDevices();
        appData.releaseScanner();
        appData.connectToDevice( deviceNumber );
        var dataView = new DataView();
        var dataDelegate = new DataDelegate( dataView );
        Toybox.WatchUi.switchToView( dataView, dataDelegate, Toybox.WatchUi.SLIDE_IMMEDIATE );
    }


    function checkKeepSearching(){

        Toybox.WatchUi.pushView( new Toybox.WatchUi.Confirmation( self._searchString ), new ContinueSearchingConfirmation(), Toybox.WatchUi.SLIDE_UP );
    }


    function startSearchTimer( millis ){

        _timeoutTimer.start( method( :checkKeepSearching ), millis, false );
    }


    function stopTimer(){

        _timeoutTimer.stop();
    }


    function openScan(){

        appData.openScanner();
    }


    function releaseScan(){

        appData.releaseScanner();
    }

    function resetScan(){

        releaseScan();
        openScan();
    }


    function getDevices(){

        return appData.getDevices();
    }


    function removeAllDevices(){

        appData.removeAllDevices();
    }

}