/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Control response to user input while the devices view is displayed
class DevicesDelegate extends Toybox.WatchUi.BehaviorDelegate {

    hidden var _devicesController;
    hidden var _devicesView;

    function initialize( view ){

        BehaviorDelegate.initialize();
        self._devicesView = view;
        self._devicesController = view.devicesController;

    }


    function onPreviousPage(){

        _devicesView.scrollUp();
    }


    function onNextPage(){

        _devicesView.scrollDown();
    }


    function onSelect(){

        self._devicesController.releaseScan();
        self._devicesView.selectDevice();
    }


    function onSwipe( evt ){

        if( evt.getDirection() == WatchUi.SWIPE_UP){
            self.onPreviousPage();
        }
        else if( evt.getDirection() == WatchUi.SWIPE_DOWN){
            self.onNextPage();
        }
    }


    function onBack(){

        Toybox.WatchUi.pushView( new VersionView(), new VersionDelegate(), Toybox.WatchUi.SLIDE_RIGHT );
        return true;
    }
}