/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Control how FE data from page 21 is handled and stored (stationary bike data)
// Protocol defined in the fitness equiptment documentation on www.thisisant.com
// Parse the message payload and set the values in the data model
class AntPage21 extends FitnessEquipmentMainPage
{

    const PAGE_NUM = 21;
    const INVALID_CADENCE = 0xFF;
    const INVALID_POWER = 0xFFFF;

    hidden var _cadence;
    hidden var _instantaneousPower;

    function initialize(payload){

        FitnessEquipmentMainPage.initialize(payload);
        self._cadence = "--";
        self._instantaneousPower = "--";
    }


    function parse(){

        FitnessEquipmentMainPage.parse();
        setCadence();
        setInstantaneousPower();
    }


    function updateAppData() {

        FitnessEquipmentMainPage.updateAppData();
        appData.setInstantaneousCadence( self._cadence );
        appData.setInstantaneousPower( self._instantaneousPower );
    }


    function setCadence(){

        var incommingCadence = self._currentPayload[4].toNumber();
        if( incommingCadence == INVALID_CADENCE ){ return; }
        self._cadence = incommingCadence;
    }


    function setInstantaneousPower(){

        var incommingPower = ( self._currentPayload[6].toNumber() * 256 ) + self._currentPayload[5].toNumber();
        if( incommingPower == INVALID_POWER ){ return; }
        self._instantaneousPower = incommingPower;
    }

}