/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Control how FE data from page 25 is handled and stored (trainer data)
// Protocol defined in the fitness equiptment documentation on www.thisisant.com
// Parse the message payload and set the values in the data model
class AntPage25 extends FitnessEquipmentMainPage
{

    const PAGE_NUM = 25;
    // Payload decoding
    const INST_POWER_UPPER_BIT_FIELD = 0x0F;
    const BIKE_POWER_CALIBRATION_BIT_FIELD = 0x10;
    const RESISTANCE_CALIBRATION_BIT_FIELD = 0x20;
    const USER_CONFIG_BIT_FIELD = 0x40;
    const TARGET_POWER_BIT_FIELD = 0x03;
    // Invalid values
    const INVALID_INST_CADENCE = 0xFF;
    const INVALID_POWER = 0xFFF;
    //Data values
    hidden var _updateEventCount;
    hidden var _instantaneousCadence;
    hidden var _accumulatedPower;
    hidden var _instantaneousPower;
    hidden var _bicyclePowerCalibration;
    hidden var _resistanceCalibration;
    hidden var _userConfiguration;
    hidden var _targetPowerLimits;

    function initialize(payload){

        FitnessEquipmentMainPage.initialize(payload);
        self._updateEventCount = "--";
        self._instantaneousCadence = "--";
        self._accumulatedPower = "--";
        self._instantaneousPower = "--";
        self._bicyclePowerCalibration = "--";
        self._resistanceCalibration = "--";
        self._userConfiguration = "--";
        self._targetPowerLimits = "--";
    }


    function parse(){

        FitnessEquipmentMainPage.parse();
        setUpdateEventCount();
        setInstantaneousCadence();
        setAccumulatedPower();
        setInstantaneousPower();
        setBicyclePowerCalibration();
        setResistanceCalibration();
        setUserConfiguration();
        setTargetPowerLimits();
    }


    function updateAppData(){

        FitnessEquipmentMainPage.updateAppData();
        appData.setUpdateEventCount( self._updateEventCount );
        appData.setInstantaneousCadence( self._instantaneousCadence );
        appData.setAccumulatedPower( self._accumulatedPower );
        appData.setInstantaneousPower( self._instantaneousPower );
        appData.setBicyclePowerCalibration( self._bicyclePowerCalibration );
        appData.setResistanceCalibration( self._resistanceCalibration );
        appData.setUserConfiguration( self._userConfiguration );
        appData.setTargetPowerLimits( self._targetPowerLimits );
    }


    function setUpdateEventCount(){

        self._updateEventCount = self._currentPayload[1].toNumber();
    }


    function setInstantaneousCadence(){

        var incommingInstantaneousCadence = self._currentPayload[2].toNumber();
        if( incommingInstantaneousCadence == INVALID_INST_CADENCE ){ return; }
        self._instantaneousCadence = incommingInstantaneousCadence;
    }


    function setAccumulatedPower(){

        var incommingInstantaneousPower = self._currentPayload[5].toNumber() + (( self._currentPayload[6].toNumber() & INST_POWER_UPPER_BIT_FIELD ) * 256 );
        var incommingAccumulatedPower = self._currentPayload[3].toNumber();
        if( incommingInstantaneousPower == INVALID_POWER ){ return; }
        self._accumulatedPower = incommingAccumulatedPower;
    }


    function setInstantaneousPower(){

        var incommingInstantaneousPower = self._currentPayload[5].toNumber() + (( self._currentPayload[6].toNumber() & INST_POWER_UPPER_BIT_FIELD ) * 256 );
        if( incommingInstantaneousPower == INVALID_POWER ){ return; }
        self._instantaneousPower = incommingInstantaneousPower;
    }


    function setBicyclePowerCalibration(){

        var flag = ( self._currentPayload[6].toNumber() & BIKE_POWER_CALIBRATION_BIT_FIELD );
        self._bicyclePowerCalibration = flag;
    }


    function setResistanceCalibration(){

        var flag = ( self._currentPayload[6].toNumber() & RESISTANCE_CALIBRATION_BIT_FIELD );
        self._resistanceCalibration = flag;
    }


    function setUserConfiguration(){

        var flag = ( self._currentPayload[6].toNumber() & USER_CONFIG_BIT_FIELD );
        self._userConfiguration = flag;
    }


    function setTargetPowerLimits(){

        var targetPower = ( self._currentPayload[7].toNumber() & TARGET_POWER_BIT_FIELD );
        self._targetPowerLimits = targetPower;
    }

}