/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Common data page across all types of fitness equiptment
class FitnessEquipmentMainPage
{

    const PAGE_NUM;
    const EQUIPMENT_STATE_BIT_FIELD = 0x70;
    hidden var _equipmentState = "";
    hidden var _currentPayload;
    hidden const FE_STATES = { 1=>"ASLEEP", 2=>"READY", 3=>"IN_USE", 4=>"FINISHED" };

    function initialize( payload ){

        self._currentPayload = payload;
    }


    function parse(){

        setStateData();
    }


    function getState(){

        return self._equipmentState;
    }


    function setStateData(){

        self._equipmentState = FE_STATES[( _currentPayload[7] & EQUIPMENT_STATE_BIT_FIELD ) >> 4];
    }


    function updateAppData(){

        appData.setEquipmentState( self._equipmentState );
    }

}