/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Represent a channel used by fitness equiptment
class GFitChannel extends Toybox.Ant.GenericChannel
{

    const FE_DEVICE_TYPE = 17;
    const PERIOD_4HZ = 8192;
    const FE_FREQ = 57;
    const NO_PROXIMITY_SEARCH = 0;

    hidden var _chanAssign;
    hidden var _channelType;
    hidden var _deviceConfig;
    hidden var _deviceNumber;
    hidden var _transmissionType = 0;
    hidden var _searchTimeoutLowPriority = 12;
    hidden var _searchThreshold = NO_PROXIMITY_SEARCH;

    function initialize( deviceNumber, backgroundScan ){

        self._deviceNumber = deviceNumber;

        if( backgroundScan == true ){
            self._channelType = Toybox.Ant.CHANNEL_TYPE_RX_ONLY;
        }
        else{
            self._channelType = Toybox.Ant.CHANNEL_TYPE_RX_NOT_TX;
        }

        self._chanAssign = new Toybox.Ant.ChannelAssignment( self._channelType, Toybox.Ant.NETWORK_PLUS );
        self._chanAssign.setBackgroundScan( backgroundScan );
        GenericChannel.initialize( method( :onMessage ), self._chanAssign );
        self.setConfig();
    }


    function setConfig(){

        self._deviceConfig = new Toybox.Ant.DeviceConfig( {
            :radioFrequency => FE_FREQ,
            :messagePeriod => PERIOD_4HZ,
            :deviceType => FE_DEVICE_TYPE,
            :deviceNumber => self._deviceNumber,
            :searchThreshold => self._searchThreshold,
            :transmissionType => self._transmissionType,
            :searchTimeoutLowPriority => self._searchTimeoutLowPriority
        } );
        GenericChannel.setDeviceConfig( self._deviceConfig );
    }

}