/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Deal with icoming ant messages.
// Pass them to a class to represent a specific page
class PageHandler
{

    hidden var _pageLookup = {
        16 => :createAntPage16,
        25 => :createAntPage25,
        21 => :createAntPage21
    };

    function handle( messagePayload )
    {

        if( _pageLookup.hasKey( pageNumber(messagePayload) ))
        {
            var page = self.method( _pageLookup[pageNumber( messagePayload )]).invoke( messagePayload );
            page.parse();
            page.updateAppData();
        }
    }


    function pageNumber(messagePayload){
        return messagePayload[0];
    }


    function createAntPage16(messagePayload){ return new AntPage16( messagePayload ); }


    function createAntPage21(messagePayload){ return new AntPage21( messagePayload ); }


    function createAntPage25(messagePayload){ return new AntPage25( messagePayload ); }

}