/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Scan for incoming messages while searching for devices
class Scanner extends GFitChannel
{

    const STATE_READY = "READY";

    function initialize(){

            GFitChannel.initialize( 0, true );
    }


    function onMessage( message ){

        if( messageIsRelevant( message ) ){
            appData.setDeviceFromMessage( message );
            Toybox.WatchUi.requestUpdate();
        }
    }


    function messageIsRelevant( message ){

        if( readState( message ) == null ){
            return false;
        }
        return ( message.messageId == Ant.MSG_ID_BROADCAST_DATA ) && ( readState( message ).hashCode() == STATE_READY.hashCode() );
    }


    function readState( message ){

        var page = new FitnessEquipmentMainPage( message.getPayload() );
        page.parse();
        return page.getState();
    }

}