/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Show data from a gfit module during an activity
class DataView extends Toybox.WatchUi.View
{

    var dataController;

    function initialize() {

        View.initialize();
        dataController = new DataController();
    }


    function onLayout(dc) {

        setLayout(Rez.Layouts.DataLayout(dc));
        dc.setColor( Toybox.Graphics.COLOR_TRANSPARENT, Toybox.Graphics.COLOR_BLACK );
    }


    function onShow() {

        self.showData();
    }


    function onUpdate(dc) {

        self.showData();
        View.onUpdate(dc);

    }


    function showData(){

        var data = dataController.getData();

        View.findDrawableById( "PowerData" ).setText( data[:instantaneousPower].toString() );
        View.findDrawableById( "HeartRateData" ).setText( data[:heartRate].toString() );
        View.findDrawableById( "CadenceData" ).setText( data[:instantaneousCadence].toString() );
        View.findDrawableById( "Clock" ).setText( data[:timeString] );
    }


    function showDefaultData(){

        View.findDrawableById( "PowerData" ).setText( "--" );
        View.findDrawableById( "HeartRateData" ).setText( "--" );
        View.findDrawableById( "CadenceData" ).setText( "--" );
        View.findDrawableById( "Clock" ).setText( dataController.getTimeString() );
    }

}