//
// Copyright  Dynastream Innovations Inc. 2017
// Subject to Garmin SDK License Agreement and Wearables
// Application Developer Agreement.
//
/*
This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
Copyright  Dynastream Innovations Inc. 2017
All rights reserved.
*/

// Control how rows in a device menu are displayed onscreen
class DeviceRow extends Toybox.WatchUi.Text
{

    const HIDDEN_COLOR = Toybox.Graphics.COLOR_TRANSPARENT;
    hidden var _textColor = Toybox.Graphics.COLOR_WHITE;
    hidden var _selectedColor = Toybox.Graphics.COLOR_BLUE;
    hidden var _isSelected = false;
    hidden var _isHidden = false;
    hidden var _isIndicated = false;
    hidden var _rssiSamples = [0, 0, 0, 0, 0, 0, 0, 0];

    function initialize( dictionary ){

        Text.initialize( dictionary );
        Text.setBackgroundColor( HIDDEN_COLOR );
        if( dictionary[:textColor] != null ){
            self._textColor = dictionary.get( :textColor );
        }
        if( dictionary[:selectedColor] != null ){
            self._selectedColor = dictionary.get( :selectedColor );
        }
        self._isSelected = false;
        self._isHidden = false;
    }


    function drawRow( dc ){
        var screenWidth = dc.getWidth();
        self.locX = screenWidth/3;
        if( self._isHidden ){
            Text.setColor( HIDDEN_COLOR );
            // Workaround for vivoactive decices
            // Setting text color to transparent does not work,
            // drawing text off screen to hide it.
            self.locX = screenWidth * 1.5;
        }
        else if( self._isSelected ){
            Text.setColor( self._selectedColor );
            dc.setColor( self._selectedColor, Toybox.Graphics.COLOR_BLACK );
            dc.drawLine(self.locX, self.locY + self.height, self.locX + self.width, self.locY + self.height);
        }
        else{
            dc.setColor( Toybox.Graphics.COLOR_TRANSPARENT, Toybox.Graphics.COLOR_BLACK );
            Text.setColor( self._textColor );
        }

        self.draw( dc );

        if( self._isIndicated ){
            drawSignalIndication( dc );
        }

    }


    function addRssiSample( sample ){

        self._rssiSamples = self._rssiSamples.slice(1, self._rssiSamples.size());
        self._rssiSamples.add(sample);
    }

    function rssiAverage(){
        var sum = 0;
        for(var i = 0; i < self._rssiSamples.size(); i++){
            sum += self._rssiSamples[i].toFloat();
        }
        return sum/self._rssiSamples.size();
    }

    function drawSignalIndication( dc ){

        dc.drawArc(self.locX - self.height/2, self.locY + self.height, self.height/4, Graphics.ARC_CLOCKWISE, 115, 65 );
        dc.drawArc(self.locX - self.height/2, self.locY + self.height, self.height/2, Graphics.ARC_CLOCKWISE, 115, 65 );
        dc.drawArc(self.locX - self.height/2, self.locY + self.height, self.height*3/4, Graphics.ARC_CLOCKWISE, 115, 65 );
    }


    function addIndicator(){

        self._isIndicated = true;
    }


    function removeIndicator(){

        self._isIndicated = false;
    }


    function addSelection(){

        self._isSelected = true;
    }


    function removeSelection(){

        self._isSelected = false;
    }


    function hide(){

        self._isHidden = true;
    }


    function show(){

        self._isHidden = false;
    }

}