/* Linker script to configure memory regions. */

SEARCH_DIR(.)
GROUP(-lgcc -lc -lnosys)

MEMORY
{
  FLASH (rx) : ORIGIN = 0x29000, LENGTH = 0x57000
  RAM (rwx) :  ORIGIN = 0x20005000, LENGTH = 0xB000
  BOOT_RSVD (rw) : ORIGIN = 0x00072000,  LENGTH = 0x0E000 
} 

SECTIONS
{
  .fs_data :
  {
    PROVIDE(__start_fs_data = .);
    KEEP(*(.fs_data))
    PROVIDE(__stop_fs_data = .);
  } > RAM
} INSERT AFTER .data;

INCLUDE "nrf5x_common.ld"
