/*
 This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
 Copyright © Dynastream Innovations Inc. 2017
 All rights reserved.
 */

import UIKit
import CoreBluetooth

// Represent a BLE peripheral device and the status of that device within the context of the app
class Device: Equatable {

    fileprivate let PERIPERAL_TIMEOUT = 5 as Double
    var signalStrength: Int32
    var peripheral: CBPeripheral
    var prevMsgTime: TimeInterval

    init?(withPeripheral peripheral: CBPeripheral, _ rssi: Int32 = 0) {
        self.peripheral = peripheral
        self.signalStrength = rssi
        self.prevMsgTime = NSDate.timeIntervalSinceReferenceDate
    }

    func peripheralName()->String{
        return peripheral.name ?? "N/A"
    }

    func updatePrevMsgTime(){
        prevMsgTime = NSDate.timeIntervalSinceReferenceDate
    }

    func timedOut() -> Bool{
        return NSDate.timeIntervalSinceReferenceDate - self.prevMsgTime > PERIPERAL_TIMEOUT
    }

    static func ==(d1: Device, d2: Device) -> Bool {
        return d1.peripheral.identifier == d2.peripheral.identifier
    }

    static func !=(d1: Device, d2: Device) -> Bool {
        return d1.peripheral.identifier != d2.peripheral.identifier
    }
}
