/*
 This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
 Copyright © Dynastream Innovations Inc. 2017
 All rights reserved.
 */

import UIKit

// Display Information from the "Device Information Service" BLE characteristic
class DeviceInfoViewController: UIViewController {

    var manufacturerNameValue: String = "---"
    var modelNumberValue: String = "---"
    var firmwareRevisionValue: String = "---"
    var softwareRevisionValue: String = "---"

    @IBOutlet weak var manufacturerName: UILabel!
    @IBOutlet weak var modelNumber: UILabel!
    @IBOutlet weak var firmwareRevision: UILabel!
    @IBOutlet weak var softwareRevision: UILabel!

    override func viewDidLoad() {
        super.viewDidLoad()
        manufacturerName.text = manufacturerNameValue
        modelNumber.text = modelNumberValue
        firmwareRevision.text = firmwareRevisionValue
        softwareRevision.text = softwareRevisionValue
    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
    }
}
