/*
 This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
 Copyright © Dynastream Innovations Inc. 2017
 All rights reserved.
 */

import UIKit

class DeviceTableViewCell: UITableViewCell {

    @IBOutlet weak var nameLabel: UILabel!
    @IBOutlet weak var rssiIcon: UIImageView!
    @IBOutlet weak var cellBackground: UIView!

    func pickRssiIcon(_ rssi: Int32) {
        switch rssi {
        case -75 ..< -62:
            self.rssiIcon.image = UIImage(named: "Signal2")!
        case -62 ..< -60:
            self.rssiIcon.image = UIImage(named: "Signal3")!
        case -60 ..< -45:
            self.rssiIcon.image = UIImage(named: "Signal4")!
        case -45 ..< 0:
            self.rssiIcon.image = UIImage(named: "Signal5")!
        default:
            self.rssiIcon.image = UIImage(named: "Signal1")!
        }
    }

}
