/*
 This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
 Copyright © Dynastream Innovations Inc. 2017
 All rights reserved.
 */

import UIKit

class FiltersViewController: UIViewController, UINavigationControllerDelegate {

    var rssiValue: Float?

    @IBOutlet weak var rssiSlider: UISlider!
    @IBOutlet weak var signalStrengthLabel: UILabel!
    @IBOutlet weak var setFiltersButton: UIBarButtonItem!

    override func viewDidLoad() {
        super.viewDidLoad()
        configureRssiSlider()
    }

    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        super.prepare(for: segue, sender: sender)
        guard let button = sender as? UIBarButtonItem, button === setFiltersButton else {
            fatalError("Error Setting filters")
        }
    }

    private func configureRssiSlider() {
        self.rssiSlider.minimumTrackTintColor = UserInterfaceElements.headingColor
        self.rssiSlider.minimumTrackTintColor?.withAlphaComponent(0.5)
        self.rssiSlider.minimumValue = -100
        self.rssiSlider.maximumValue = 0
        self.rssiSlider.value = self.rssiValue ?? rssiSlider.minimumValue
        self.signalStrengthLabel.font = UIFont.systemFont(ofSize: 17, weight: UIFontWeightBlack)
    }
}
