/*
 This software is subject to the license described in the license.txt file included with this software distribution. You may not use this file except in compliance with this license.
 Copyright © Dynastream Innovations Inc. 2017
 All rights reserved.
 */

//
//  FitManager.h
//  g.fit
//

#import <Foundation/Foundation.h>
#import "FitFileManagerDelegate.h"

typedef enum {
    DISTANCE_RECORD_MESSAGE,
    SPEED_RECORD_MESSAGE,
    CALORIES_RECORD_MESSAGE,
    ASCENT_RECORD_MESSAGE,
    DESCENT_RECORD_MESSAGE,
    RESISTANCE_RECORD_MESSAGE,
    GRADE_RECORD_MESSAGE,
    CADENCE_RECORD_MESSAGE,
    POWER_RECORD_MESSAGE,
    HEART_RATE_RECORD_MESSAGE,
    TIMESTAMP_RECORD_MESSAGE,

    DISTANCE_SESSION_MESSAGE,
    CALORIES_SESSION_MESSAGE,
    ASCENT_SESSION_MESSAGE,
    DESCENT_SESSION_MESSAGE,
    STROKE_COUNT_SESSION_MESSAGE,
    HEART_RATE_SESSION_MESSAGE
} FIT_MESSAGE_TYPE;

typedef struct {
    float value;
    FIT_MESSAGE_TYPE messageType;
} FitTypeValuePair;

@interface FitFileManager : NSObject

- (instancetype)init: (id<FitFileManagerDelegate>) delegate;
- (FILE *)openFileWithParams:(const char *)params withFileName: (NSString*) fileName;
- (void)encodeFile: (NSString*) fileName;
- (void)completeSessionWithName:(NSString*) fileName;
- (void)addSessionMessage: (FitTypeValuePair *) samples numberOfSamples: (int) numSamples;
- (void)addRecordMessage: (FitTypeValuePair *) samples numberOfSamples: (int) numSamples;
- (void)startRecording;
- (void)stopRecording;

@property id<FitFileManagerDelegate> delegate;
@property bool isRecording;

@end
