////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2017 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 20.38Release
// Tag = production/akw/20.38.00-0-geccbce3
////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_EVENT_MESG_HPP)
#define FIT_EVENT_MESG_HPP

#include "fit_mesg.hpp"
#include "fit_mesg_with_event.hpp"

namespace fit
{

class EventMesg : public Mesg, public MesgWithEvent
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 Timestamp = 253;
       static const FIT_UINT8 Event = 0;
       static const FIT_UINT8 EventType = 1;
       static const FIT_UINT8 Data16 = 2;
       static const FIT_UINT8 Data = 3;
       static const FIT_UINT8 EventGroup = 4;
       static const FIT_UINT8 Score = 7;
       static const FIT_UINT8 OpponentScore = 8;
       static const FIT_UINT8 FrontGearNum = 9;
       static const FIT_UINT8 FrontGear = 10;
       static const FIT_UINT8 RearGearNum = 11;
       static const FIT_UINT8 RearGear = 12;
       static const FIT_UINT8 DeviceIndex = 13;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    EventMesg(void) : Mesg(Profile::MESG_EVENT)
    {
    }

    EventMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timestamp field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimestampValid() const
    {
        const Field* field = GetField(253);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns timestamp field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetTimestamp(void) const
    {
        return GetFieldUINT32Value(253, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timestamp field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimestamp(FIT_DATE_TIME timestamp)
    {
        SetFieldUINT32Value(253, timestamp, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event field
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT GetEvent(void) const
    {
        return GetFieldENUMValue(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event field
    ///////////////////////////////////////////////////////////////////////
    void SetEvent(FIT_EVENT event)
    {
        SetFieldENUMValue(0, event, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventTypeValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT_TYPE GetEventType(void) const
    {
        return GetFieldENUMValue(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_type field
    ///////////////////////////////////////////////////////////////////////
    void SetEventType(FIT_EVENT_TYPE eventType)
    {
        SetFieldENUMValue(1, eventType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of data16 field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsData16Valid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns data16 field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetData16(void) const
    {
        return GetFieldUINT16Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set data16 field
    ///////////////////////////////////////////////////////////////////////
    void SetData16(FIT_UINT16 data16)
    {
        SetFieldUINT16Value(2, data16, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of data field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDataValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns data field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetData(void) const
    {
        return GetFieldUINT32Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set data field
    ///////////////////////////////////////////////////////////////////////
    void SetData(FIT_UINT32 data)
    {
        SetFieldUINT32Value(3, data, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timer_trigger field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimerTriggerValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIMER_TRIGGER ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIMER_TRIGGER);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns timer_trigger field
    ///////////////////////////////////////////////////////////////////////
    FIT_TIMER_TRIGGER GetTimerTrigger(void) const
    {
        return GetFieldENUMValue(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIMER_TRIGGER);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timer_trigger field
    ///////////////////////////////////////////////////////////////////////
    void SetTimerTrigger(FIT_TIMER_TRIGGER timerTrigger)
    {
        SetFieldENUMValue(3, timerTrigger, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIMER_TRIGGER);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of course_point_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCoursePointIndexValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COURSE_POINT_INDEX ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COURSE_POINT_INDEX);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns course_point_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetCoursePointIndex(void) const
    {
        return GetFieldUINT16Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COURSE_POINT_INDEX);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set course_point_index field
    ///////////////////////////////////////////////////////////////////////
    void SetCoursePointIndex(FIT_MESSAGE_INDEX coursePointIndex)
    {
        SetFieldUINT16Value(3, coursePointIndex, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COURSE_POINT_INDEX);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of battery_level field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBatteryLevelValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_BATTERY_LEVEL ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_BATTERY_LEVEL);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns battery_level field
    // Units: V
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetBatteryLevel(void) const
    {
        return GetFieldFLOAT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_BATTERY_LEVEL);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set battery_level field
    // Units: V
    ///////////////////////////////////////////////////////////////////////
    void SetBatteryLevel(FIT_FLOAT32 batteryLevel)
    {
        SetFieldFLOAT32Value(3, batteryLevel, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_BATTERY_LEVEL);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of virtual_partner_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsVirtualPartnerSpeedValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_VIRTUAL_PARTNER_SPEED ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_VIRTUAL_PARTNER_SPEED);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns virtual_partner_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetVirtualPartnerSpeed(void) const
    {
        return GetFieldFLOAT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_VIRTUAL_PARTNER_SPEED);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set virtual_partner_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetVirtualPartnerSpeed(FIT_FLOAT32 virtualPartnerSpeed)
    {
        SetFieldFLOAT32Value(3, virtualPartnerSpeed, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_VIRTUAL_PARTNER_SPEED);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of hr_high_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsHrHighAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_HIGH_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_HIGH_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns hr_high_alert field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetHrHighAlert(void) const
    {
        return GetFieldUINT8Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set hr_high_alert field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetHrHighAlert(FIT_UINT8 hrHighAlert)
    {
        SetFieldUINT8Value(3, hrHighAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of hr_low_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsHrLowAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_LOW_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_LOW_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns hr_low_alert field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetHrLowAlert(void) const
    {
        return GetFieldUINT8Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set hr_low_alert field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetHrLowAlert(FIT_UINT8 hrLowAlert)
    {
        SetFieldUINT8Value(3, hrLowAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_HR_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of speed_high_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSpeedHighAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_HIGH_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_HIGH_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns speed_high_alert field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSpeedHighAlert(void) const
    {
        return GetFieldFLOAT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set speed_high_alert field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetSpeedHighAlert(FIT_FLOAT32 speedHighAlert)
    {
        SetFieldFLOAT32Value(3, speedHighAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of speed_low_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSpeedLowAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_LOW_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_LOW_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns speed_low_alert field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSpeedLowAlert(void) const
    {
        return GetFieldFLOAT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set speed_low_alert field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetSpeedLowAlert(FIT_FLOAT32 speedLowAlert)
    {
        SetFieldFLOAT32Value(3, speedLowAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPEED_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cad_high_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCadHighAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_HIGH_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_HIGH_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns cad_high_alert field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetCadHighAlert(void) const
    {
        return GetFieldUINT16Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cad_high_alert field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetCadHighAlert(FIT_UINT16 cadHighAlert)
    {
        SetFieldUINT16Value(3, cadHighAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cad_low_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCadLowAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_LOW_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_LOW_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns cad_low_alert field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetCadLowAlert(void) const
    {
        return GetFieldUINT16Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cad_low_alert field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetCadLowAlert(FIT_UINT16 cadLowAlert)
    {
        SetFieldUINT16Value(3, cadLowAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CAD_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of power_high_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPowerHighAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_HIGH_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_HIGH_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns power_high_alert field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetPowerHighAlert(void) const
    {
        return GetFieldUINT16Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set power_high_alert field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetPowerHighAlert(FIT_UINT16 powerHighAlert)
    {
        SetFieldUINT16Value(3, powerHighAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_HIGH_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of power_low_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPowerLowAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_LOW_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_LOW_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns power_low_alert field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetPowerLowAlert(void) const
    {
        return GetFieldUINT16Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set power_low_alert field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetPowerLowAlert(FIT_UINT16 powerLowAlert)
    {
        SetFieldUINT16Value(3, powerLowAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_POWER_LOW_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_duration_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeDurationAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIME_DURATION_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIME_DURATION_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns time_duration_alert field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeDurationAlert(void) const
    {
        return GetFieldFLOAT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIME_DURATION_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_duration_alert field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeDurationAlert(FIT_FLOAT32 timeDurationAlert)
    {
        SetFieldFLOAT32Value(3, timeDurationAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_TIME_DURATION_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of distance_duration_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDistanceDurationAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_DISTANCE_DURATION_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_DISTANCE_DURATION_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns distance_duration_alert field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetDistanceDurationAlert(void) const
    {
        return GetFieldFLOAT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_DISTANCE_DURATION_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set distance_duration_alert field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetDistanceDurationAlert(FIT_FLOAT32 distanceDurationAlert)
    {
        SetFieldFLOAT32Value(3, distanceDurationAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_DISTANCE_DURATION_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of calorie_duration_alert field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCalorieDurationAlertValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CALORIE_DURATION_ALERT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CALORIE_DURATION_ALERT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns calorie_duration_alert field
    // Units: calories
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetCalorieDurationAlert(void) const
    {
        return GetFieldUINT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CALORIE_DURATION_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set calorie_duration_alert field
    // Units: calories
    ///////////////////////////////////////////////////////////////////////
    void SetCalorieDurationAlert(FIT_UINT32 calorieDurationAlert)
    {
        SetFieldUINT32Value(3, calorieDurationAlert, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_CALORIE_DURATION_ALERT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of fitness_equipment_state field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFitnessEquipmentStateValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_FITNESS_EQUIPMENT_STATE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_FITNESS_EQUIPMENT_STATE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns fitness_equipment_state field
    ///////////////////////////////////////////////////////////////////////
    FIT_FITNESS_EQUIPMENT_STATE GetFitnessEquipmentState(void) const
    {
        return GetFieldENUMValue(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_FITNESS_EQUIPMENT_STATE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set fitness_equipment_state field
    ///////////////////////////////////////////////////////////////////////
    void SetFitnessEquipmentState(FIT_FITNESS_EQUIPMENT_STATE fitnessEquipmentState)
    {
        SetFieldENUMValue(3, fitnessEquipmentState, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_FITNESS_EQUIPMENT_STATE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sport_point field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSportPointValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPORT_POINT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPORT_POINT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns sport_point field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetSportPoint(void) const
    {
        return GetFieldUINT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPORT_POINT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sport_point field
    ///////////////////////////////////////////////////////////////////////
    void SetSportPoint(FIT_UINT32 sportPoint)
    {
        SetFieldUINT32Value(3, sportPoint, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_SPORT_POINT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gear_change_data field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGearChangeDataValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_GEAR_CHANGE_DATA ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_GEAR_CHANGE_DATA);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns gear_change_data field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetGearChangeData(void) const
    {
        return GetFieldUINT32Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_GEAR_CHANGE_DATA);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gear_change_data field
    ///////////////////////////////////////////////////////////////////////
    void SetGearChangeData(FIT_UINT32 gearChangeData)
    {
        SetFieldUINT32Value(3, gearChangeData, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_GEAR_CHANGE_DATA);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of rider_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRiderPositionValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_RIDER_POSITION ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_RIDER_POSITION);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns rider_position field
    // Comment: Indicates the rider position value.
    ///////////////////////////////////////////////////////////////////////
    FIT_RIDER_POSITION_TYPE GetRiderPosition(void) const
    {
        return GetFieldENUMValue(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_RIDER_POSITION);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set rider_position field
    // Comment: Indicates the rider position value.
    ///////////////////////////////////////////////////////////////////////
    void SetRiderPosition(FIT_RIDER_POSITION_TYPE riderPosition)
    {
        SetFieldENUMValue(3, riderPosition, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_RIDER_POSITION);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of comm_timeout field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCommTimeoutValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COMM_TIMEOUT ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COMM_TIMEOUT);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns comm_timeout field
    ///////////////////////////////////////////////////////////////////////
    FIT_COMM_TIMEOUT_TYPE GetCommTimeout(void) const
    {
        return GetFieldUINT16Value(3, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COMM_TIMEOUT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set comm_timeout field
    ///////////////////////////////////////////////////////////////////////
    void SetCommTimeout(FIT_COMM_TIMEOUT_TYPE commTimeout)
    {
        SetFieldUINT16Value(3, commTimeout, 0, (FIT_UINT16) Profile::EVENT_MESG_DATA_FIELD_COMM_TIMEOUT);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_group field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventGroupValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_group field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetEventGroup(void) const
    {
        return GetFieldUINT8Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_group field
    ///////////////////////////////////////////////////////////////////////
    void SetEventGroup(FIT_UINT8 eventGroup)
    {
        SetFieldUINT8Value(4, eventGroup, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsScoreValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns score field
    // Comment: Do not populate directly.  Autogenerated by decoder for sport_point subfield components
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetScore(void) const
    {
        return GetFieldUINT16Value(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set score field
    // Comment: Do not populate directly.  Autogenerated by decoder for sport_point subfield components
    ///////////////////////////////////////////////////////////////////////
    void SetScore(FIT_UINT16 score)
    {
        SetFieldUINT16Value(7, score, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of opponent_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsOpponentScoreValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns opponent_score field
    // Comment: Do not populate directly.  Autogenerated by decoder for sport_point subfield components
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetOpponentScore(void) const
    {
        return GetFieldUINT16Value(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set opponent_score field
    // Comment: Do not populate directly.  Autogenerated by decoder for sport_point subfield components
    ///////////////////////////////////////////////////////////////////////
    void SetOpponentScore(FIT_UINT16 opponentScore)
    {
        SetFieldUINT16Value(8, opponentScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of front_gear_num field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFrontGearNumValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns front_gear_num field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Front gear number. 1 is innermost.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8Z GetFrontGearNum(void) const
    {
        return GetFieldUINT8ZValue(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set front_gear_num field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Front gear number. 1 is innermost.
    ///////////////////////////////////////////////////////////////////////
    void SetFrontGearNum(FIT_UINT8Z frontGearNum)
    {
        SetFieldUINT8ZValue(9, frontGearNum, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of front_gear field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFrontGearValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns front_gear field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Number of front teeth.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8Z GetFrontGear(void) const
    {
        return GetFieldUINT8ZValue(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set front_gear field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Number of front teeth.
    ///////////////////////////////////////////////////////////////////////
    void SetFrontGear(FIT_UINT8Z frontGear)
    {
        SetFieldUINT8ZValue(10, frontGear, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of rear_gear_num field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRearGearNumValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns rear_gear_num field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Rear gear number. 1 is innermost.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8Z GetRearGearNum(void) const
    {
        return GetFieldUINT8ZValue(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set rear_gear_num field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Rear gear number. 1 is innermost.
    ///////////////////////////////////////////////////////////////////////
    void SetRearGearNum(FIT_UINT8Z rearGearNum)
    {
        SetFieldUINT8ZValue(11, rearGearNum, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of rear_gear field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRearGearValid() const
    {
        const Field* field = GetField(12);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns rear_gear field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Number of rear teeth.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8Z GetRearGear(void) const
    {
        return GetFieldUINT8ZValue(12, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set rear_gear field
    // Comment: Do not populate directly.  Autogenerated by decoder for gear_change subfield components.  Number of rear teeth.
    ///////////////////////////////////////////////////////////////////////
    void SetRearGear(FIT_UINT8Z rearGear)
    {
        SetFieldUINT8ZValue(12, rearGear, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of device_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDeviceIndexValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns device_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_DEVICE_INDEX GetDeviceIndex(void) const
    {
        return GetFieldUINT8Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set device_index field
    ///////////////////////////////////////////////////////////////////////
    void SetDeviceIndex(FIT_DEVICE_INDEX deviceIndex)
    {
        SetFieldUINT8Value(13, deviceIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_EVENT_MESG_HPP)
