////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2017 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 20.38Release
// Tag = production/akw/20.38.00-0-geccbce3
////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_PROFILE_HPP)
#define FIT_PROFILE_HPP

#include <string>
#include "fit.hpp"
#include "fit_config.hpp"
#if defined(FIT_CPP_INCLUDE_C)
#include "fit_product.h"
#endif


///////////////////////////////////////////////////////////////////////
// Public Definitions
///////////////////////////////////////////////////////////////////////

#if !defined(FIT_CPP_INCLUDE_C) // Types defined in fit_product.h if including C code.

///////////////////////////////////////////////////////////////////////
// Types
///////////////////////////////////////////////////////////////////////


typedef FIT_ENUM FIT_FILE;
#define FIT_FILE_INVALID                                                         FIT_ENUM_INVALID
#define FIT_FILE_DEVICE                                                          ((FIT_FILE)1) // Read only, single file. Must be in root directory.
#define FIT_FILE_SETTINGS                                                        ((FIT_FILE)2) // Read/write, single file. Directory=Settings
#define FIT_FILE_SPORT                                                           ((FIT_FILE)3) // Read/write, multiple files, file number = sport type. Directory=Sports
#define FIT_FILE_ACTIVITY                                                        ((FIT_FILE)4) // Read/erase, multiple files. Directory=Activities
#define FIT_FILE_WORKOUT                                                         ((FIT_FILE)5) // Read/write/erase, multiple files. Directory=Workouts
#define FIT_FILE_COURSE                                                          ((FIT_FILE)6) // Read/write/erase, multiple files. Directory=Courses
#define FIT_FILE_SCHEDULES                                                       ((FIT_FILE)7) // Read/write, single file. Directory=Schedules
#define FIT_FILE_WEIGHT                                                          ((FIT_FILE)9) // Read only, single file. Circular buffer. All message definitions at start of file. Directory=Weight
#define FIT_FILE_TOTALS                                                          ((FIT_FILE)10) // Read only, single file. Directory=Totals
#define FIT_FILE_GOALS                                                           ((FIT_FILE)11) // Read/write, single file. Directory=Goals
#define FIT_FILE_BLOOD_PRESSURE                                                  ((FIT_FILE)14) // Read only. Directory=Blood Pressure
#define FIT_FILE_MONITORING_A                                                    ((FIT_FILE)15) // Read only. Directory=Monitoring. File number=sub type.
#define FIT_FILE_ACTIVITY_SUMMARY                                                ((FIT_FILE)20) // Read/erase, multiple files. Directory=Activities
#define FIT_FILE_MONITORING_DAILY                                                ((FIT_FILE)28)
#define FIT_FILE_MONITORING_B                                                    ((FIT_FILE)32) // Read only. Directory=Monitoring. File number=identifier
#define FIT_FILE_SEGMENT                                                         ((FIT_FILE)34) // Read/write/erase. Multiple Files.  Directory=Segments
#define FIT_FILE_SEGMENT_LIST                                                    ((FIT_FILE)35) // Read/write/erase. Single File.  Directory=Segments
#define FIT_FILE_EXD_CONFIGURATION                                               ((FIT_FILE)40) // Read/write/erase. Single File. Directory=Settings
#define FIT_FILE_MFG_RANGE_MIN                                                   ((FIT_FILE)0xF7) // 0xF7 - 0xFE reserved for manufacturer specific file types
#define FIT_FILE_MFG_RANGE_MAX                                                   ((FIT_FILE)0xFE) // 0xF7 - 0xFE reserved for manufacturer specific file types
#define FIT_FILE_COUNT                                                           20

typedef FIT_UINT16 FIT_MESG_NUM;
#define FIT_MESG_NUM_INVALID                                                     FIT_UINT16_INVALID
#define FIT_MESG_NUM_FILE_ID                                                     ((FIT_MESG_NUM)0)
#define FIT_MESG_NUM_CAPABILITIES                                                ((FIT_MESG_NUM)1)
#define FIT_MESG_NUM_DEVICE_SETTINGS                                             ((FIT_MESG_NUM)2)
#define FIT_MESG_NUM_USER_PROFILE                                                ((FIT_MESG_NUM)3)
#define FIT_MESG_NUM_HRM_PROFILE                                                 ((FIT_MESG_NUM)4)
#define FIT_MESG_NUM_SDM_PROFILE                                                 ((FIT_MESG_NUM)5)
#define FIT_MESG_NUM_BIKE_PROFILE                                                ((FIT_MESG_NUM)6)
#define FIT_MESG_NUM_ZONES_TARGET                                                ((FIT_MESG_NUM)7)
#define FIT_MESG_NUM_HR_ZONE                                                     ((FIT_MESG_NUM)8)
#define FIT_MESG_NUM_POWER_ZONE                                                  ((FIT_MESG_NUM)9)
#define FIT_MESG_NUM_MET_ZONE                                                    ((FIT_MESG_NUM)10)
#define FIT_MESG_NUM_SPORT                                                       ((FIT_MESG_NUM)12)
#define FIT_MESG_NUM_GOAL                                                        ((FIT_MESG_NUM)15)
#define FIT_MESG_NUM_SESSION                                                     ((FIT_MESG_NUM)18)
#define FIT_MESG_NUM_LAP                                                         ((FIT_MESG_NUM)19)
#define FIT_MESG_NUM_RECORD                                                      ((FIT_MESG_NUM)20)
#define FIT_MESG_NUM_EVENT                                                       ((FIT_MESG_NUM)21)
#define FIT_MESG_NUM_DEVICE_INFO                                                 ((FIT_MESG_NUM)23)
#define FIT_MESG_NUM_WORKOUT                                                     ((FIT_MESG_NUM)26)
#define FIT_MESG_NUM_WORKOUT_STEP                                                ((FIT_MESG_NUM)27)
#define FIT_MESG_NUM_SCHEDULE                                                    ((FIT_MESG_NUM)28)
#define FIT_MESG_NUM_WEIGHT_SCALE                                                ((FIT_MESG_NUM)30)
#define FIT_MESG_NUM_COURSE                                                      ((FIT_MESG_NUM)31)
#define FIT_MESG_NUM_COURSE_POINT                                                ((FIT_MESG_NUM)32)
#define FIT_MESG_NUM_TOTALS                                                      ((FIT_MESG_NUM)33)
#define FIT_MESG_NUM_ACTIVITY                                                    ((FIT_MESG_NUM)34)
#define FIT_MESG_NUM_SOFTWARE                                                    ((FIT_MESG_NUM)35)
#define FIT_MESG_NUM_FILE_CAPABILITIES                                           ((FIT_MESG_NUM)37)
#define FIT_MESG_NUM_MESG_CAPABILITIES                                           ((FIT_MESG_NUM)38)
#define FIT_MESG_NUM_FIELD_CAPABILITIES                                          ((FIT_MESG_NUM)39)
#define FIT_MESG_NUM_FILE_CREATOR                                                ((FIT_MESG_NUM)49)
#define FIT_MESG_NUM_BLOOD_PRESSURE                                              ((FIT_MESG_NUM)51)
#define FIT_MESG_NUM_SPEED_ZONE                                                  ((FIT_MESG_NUM)53)
#define FIT_MESG_NUM_MONITORING                                                  ((FIT_MESG_NUM)55)
#define FIT_MESG_NUM_TRAINING_FILE                                               ((FIT_MESG_NUM)72)
#define FIT_MESG_NUM_HRV                                                         ((FIT_MESG_NUM)78)
#define FIT_MESG_NUM_ANT_RX                                                      ((FIT_MESG_NUM)80)
#define FIT_MESG_NUM_ANT_TX                                                      ((FIT_MESG_NUM)81)
#define FIT_MESG_NUM_ANT_CHANNEL_ID                                              ((FIT_MESG_NUM)82)
#define FIT_MESG_NUM_LENGTH                                                      ((FIT_MESG_NUM)101)
#define FIT_MESG_NUM_MONITORING_INFO                                             ((FIT_MESG_NUM)103)
#define FIT_MESG_NUM_PAD                                                         ((FIT_MESG_NUM)105)
#define FIT_MESG_NUM_SLAVE_DEVICE                                                ((FIT_MESG_NUM)106)
#define FIT_MESG_NUM_CONNECTIVITY                                                ((FIT_MESG_NUM)127)
#define FIT_MESG_NUM_WEATHER_CONDITIONS                                          ((FIT_MESG_NUM)128)
#define FIT_MESG_NUM_WEATHER_ALERT                                               ((FIT_MESG_NUM)129)
#define FIT_MESG_NUM_CADENCE_ZONE                                                ((FIT_MESG_NUM)131)
#define FIT_MESG_NUM_HR                                                          ((FIT_MESG_NUM)132)
#define FIT_MESG_NUM_SEGMENT_LAP                                                 ((FIT_MESG_NUM)142)
#define FIT_MESG_NUM_MEMO_GLOB                                                   ((FIT_MESG_NUM)145)
#define FIT_MESG_NUM_SEGMENT_ID                                                  ((FIT_MESG_NUM)148)
#define FIT_MESG_NUM_SEGMENT_LEADERBOARD_ENTRY                                   ((FIT_MESG_NUM)149)
#define FIT_MESG_NUM_SEGMENT_POINT                                               ((FIT_MESG_NUM)150)
#define FIT_MESG_NUM_SEGMENT_FILE                                                ((FIT_MESG_NUM)151)
#define FIT_MESG_NUM_WORKOUT_SESSION                                             ((FIT_MESG_NUM)158)
#define FIT_MESG_NUM_WATCHFACE_SETTINGS                                          ((FIT_MESG_NUM)159)
#define FIT_MESG_NUM_GPS_METADATA                                                ((FIT_MESG_NUM)160)
#define FIT_MESG_NUM_CAMERA_EVENT                                                ((FIT_MESG_NUM)161)
#define FIT_MESG_NUM_TIMESTAMP_CORRELATION                                       ((FIT_MESG_NUM)162)
#define FIT_MESG_NUM_GYROSCOPE_DATA                                              ((FIT_MESG_NUM)164)
#define FIT_MESG_NUM_ACCELEROMETER_DATA                                          ((FIT_MESG_NUM)165)
#define FIT_MESG_NUM_THREE_D_SENSOR_CALIBRATION                                  ((FIT_MESG_NUM)167)
#define FIT_MESG_NUM_VIDEO_FRAME                                                 ((FIT_MESG_NUM)169)
#define FIT_MESG_NUM_OBDII_DATA                                                  ((FIT_MESG_NUM)174)
#define FIT_MESG_NUM_NMEA_SENTENCE                                               ((FIT_MESG_NUM)177)
#define FIT_MESG_NUM_AVIATION_ATTITUDE                                           ((FIT_MESG_NUM)178)
#define FIT_MESG_NUM_VIDEO                                                       ((FIT_MESG_NUM)184)
#define FIT_MESG_NUM_VIDEO_TITLE                                                 ((FIT_MESG_NUM)185)
#define FIT_MESG_NUM_VIDEO_DESCRIPTION                                           ((FIT_MESG_NUM)186)
#define FIT_MESG_NUM_VIDEO_CLIP                                                  ((FIT_MESG_NUM)187)
#define FIT_MESG_NUM_OHR_SETTINGS                                                ((FIT_MESG_NUM)188)
#define FIT_MESG_NUM_EXD_SCREEN_CONFIGURATION                                    ((FIT_MESG_NUM)200)
#define FIT_MESG_NUM_EXD_DATA_FIELD_CONFIGURATION                                ((FIT_MESG_NUM)201)
#define FIT_MESG_NUM_EXD_DATA_CONCEPT_CONFIGURATION                              ((FIT_MESG_NUM)202)
#define FIT_MESG_NUM_FIELD_DESCRIPTION                                           ((FIT_MESG_NUM)206)
#define FIT_MESG_NUM_DEVELOPER_DATA_ID                                           ((FIT_MESG_NUM)207)
#define FIT_MESG_NUM_MAGNETOMETER_DATA                                           ((FIT_MESG_NUM)208)
#define FIT_MESG_NUM_MFG_RANGE_MIN                                               ((FIT_MESG_NUM)0xFF00) // 0xFF00 - 0xFFFE reserved for manufacturer specific messages
#define FIT_MESG_NUM_MFG_RANGE_MAX                                               ((FIT_MESG_NUM)0xFFFE) // 0xFF00 - 0xFFFE reserved for manufacturer specific messages
#define FIT_MESG_NUM_COUNT                                                       79

typedef FIT_UINT8 FIT_CHECKSUM;
#define FIT_CHECKSUM_INVALID                                                     FIT_UINT8_INVALID
#define FIT_CHECKSUM_CLEAR                                                       ((FIT_CHECKSUM)0) // Allows clear of checksum for flash memory where can only write 1 to 0 without erasing sector.
#define FIT_CHECKSUM_OK                                                          ((FIT_CHECKSUM)1) // Set to mark checksum as valid if computes to invalid values 0 or 0xFF.  Checksum can also be set to ok to save encoding computation time.
#define FIT_CHECKSUM_COUNT                                                       2

typedef FIT_UINT8Z FIT_FILE_FLAGS;
#define FIT_FILE_FLAGS_INVALID                                                   FIT_UINT8Z_INVALID
#define FIT_FILE_FLAGS_READ                                                      ((FIT_FILE_FLAGS)0x02)
#define FIT_FILE_FLAGS_WRITE                                                     ((FIT_FILE_FLAGS)0x04)
#define FIT_FILE_FLAGS_ERASE                                                     ((FIT_FILE_FLAGS)0x08)
#define FIT_FILE_FLAGS_COUNT                                                     3

typedef FIT_ENUM FIT_MESG_COUNT;
#define FIT_MESG_COUNT_INVALID                                                   FIT_ENUM_INVALID
#define FIT_MESG_COUNT_NUM_PER_FILE                                              ((FIT_MESG_COUNT)0)
#define FIT_MESG_COUNT_MAX_PER_FILE                                              ((FIT_MESG_COUNT)1)
#define FIT_MESG_COUNT_MAX_PER_FILE_TYPE                                         ((FIT_MESG_COUNT)2)
#define FIT_MESG_COUNT_COUNT                                                     3

typedef FIT_UINT32 FIT_DATE_TIME; // seconds since UTC 00:00 Dec 31 1989
#define FIT_DATE_TIME_INVALID                                                    FIT_UINT32_INVALID
#define FIT_DATE_TIME_MIN                                                        ((FIT_DATE_TIME)0x10000000) // if date_time is < 0x10000000 then it is system time (seconds from device power on)
#define FIT_DATE_TIME_COUNT                                                      1

typedef FIT_UINT32 FIT_LOCAL_DATE_TIME; // seconds since 00:00 Dec 31 1989 in local time zone
#define FIT_LOCAL_DATE_TIME_INVALID                                              FIT_UINT32_INVALID
#define FIT_LOCAL_DATE_TIME_MIN                                                  ((FIT_LOCAL_DATE_TIME)0x10000000) // if date_time is < 0x10000000 then it is system time (seconds from device power on)
#define FIT_LOCAL_DATE_TIME_COUNT                                                1

typedef FIT_UINT16 FIT_MESSAGE_INDEX;
#define FIT_MESSAGE_INDEX_INVALID                                                FIT_UINT16_INVALID
#define FIT_MESSAGE_INDEX_SELECTED                                               ((FIT_MESSAGE_INDEX)0x8000) // message is selected if set
#define FIT_MESSAGE_INDEX_RESERVED                                               ((FIT_MESSAGE_INDEX)0x7000) // reserved (default 0)
#define FIT_MESSAGE_INDEX_MASK                                                   ((FIT_MESSAGE_INDEX)0x0FFF) // index
#define FIT_MESSAGE_INDEX_COUNT                                                  3

typedef FIT_UINT8 FIT_DEVICE_INDEX;
#define FIT_DEVICE_INDEX_INVALID                                                 FIT_UINT8_INVALID
#define FIT_DEVICE_INDEX_CREATOR                                                 ((FIT_DEVICE_INDEX)0) // Creator of the file is always device index 0.
#define FIT_DEVICE_INDEX_COUNT                                                   1

typedef FIT_ENUM FIT_GENDER;
#define FIT_GENDER_INVALID                                                       FIT_ENUM_INVALID
#define FIT_GENDER_FEMALE                                                        ((FIT_GENDER)0)
#define FIT_GENDER_MALE                                                          ((FIT_GENDER)1)
#define FIT_GENDER_COUNT                                                         2

typedef FIT_ENUM FIT_LANGUAGE;
#define FIT_LANGUAGE_INVALID                                                     FIT_ENUM_INVALID
#define FIT_LANGUAGE_ENGLISH                                                     ((FIT_LANGUAGE)0)
#define FIT_LANGUAGE_FRENCH                                                      ((FIT_LANGUAGE)1)
#define FIT_LANGUAGE_ITALIAN                                                     ((FIT_LANGUAGE)2)
#define FIT_LANGUAGE_GERMAN                                                      ((FIT_LANGUAGE)3)
#define FIT_LANGUAGE_SPANISH                                                     ((FIT_LANGUAGE)4)
#define FIT_LANGUAGE_CROATIAN                                                    ((FIT_LANGUAGE)5)
#define FIT_LANGUAGE_CZECH                                                       ((FIT_LANGUAGE)6)
#define FIT_LANGUAGE_DANISH                                                      ((FIT_LANGUAGE)7)
#define FIT_LANGUAGE_DUTCH                                                       ((FIT_LANGUAGE)8)
#define FIT_LANGUAGE_FINNISH                                                     ((FIT_LANGUAGE)9)
#define FIT_LANGUAGE_GREEK                                                       ((FIT_LANGUAGE)10)
#define FIT_LANGUAGE_HUNGARIAN                                                   ((FIT_LANGUAGE)11)
#define FIT_LANGUAGE_NORWEGIAN                                                   ((FIT_LANGUAGE)12)
#define FIT_LANGUAGE_POLISH                                                      ((FIT_LANGUAGE)13)
#define FIT_LANGUAGE_PORTUGUESE                                                  ((FIT_LANGUAGE)14)
#define FIT_LANGUAGE_SLOVAKIAN                                                   ((FIT_LANGUAGE)15)
#define FIT_LANGUAGE_SLOVENIAN                                                   ((FIT_LANGUAGE)16)
#define FIT_LANGUAGE_SWEDISH                                                     ((FIT_LANGUAGE)17)
#define FIT_LANGUAGE_RUSSIAN                                                     ((FIT_LANGUAGE)18)
#define FIT_LANGUAGE_TURKISH                                                     ((FIT_LANGUAGE)19)
#define FIT_LANGUAGE_LATVIAN                                                     ((FIT_LANGUAGE)20)
#define FIT_LANGUAGE_UKRAINIAN                                                   ((FIT_LANGUAGE)21)
#define FIT_LANGUAGE_ARABIC                                                      ((FIT_LANGUAGE)22)
#define FIT_LANGUAGE_FARSI                                                       ((FIT_LANGUAGE)23)
#define FIT_LANGUAGE_BULGARIAN                                                   ((FIT_LANGUAGE)24)
#define FIT_LANGUAGE_ROMANIAN                                                    ((FIT_LANGUAGE)25)
#define FIT_LANGUAGE_CHINESE                                                     ((FIT_LANGUAGE)26)
#define FIT_LANGUAGE_JAPANESE                                                    ((FIT_LANGUAGE)27)
#define FIT_LANGUAGE_KOREAN                                                      ((FIT_LANGUAGE)28)
#define FIT_LANGUAGE_TAIWANESE                                                   ((FIT_LANGUAGE)29)
#define FIT_LANGUAGE_THAI                                                        ((FIT_LANGUAGE)30)
#define FIT_LANGUAGE_HEBREW                                                      ((FIT_LANGUAGE)31)
#define FIT_LANGUAGE_BRAZILIAN_PORTUGUESE                                        ((FIT_LANGUAGE)32)
#define FIT_LANGUAGE_INDONESIAN                                                  ((FIT_LANGUAGE)33)
#define FIT_LANGUAGE_MALAYSIAN                                                   ((FIT_LANGUAGE)34)
#define FIT_LANGUAGE_VIETNAMESE                                                  ((FIT_LANGUAGE)35)
#define FIT_LANGUAGE_BURMESE                                                     ((FIT_LANGUAGE)36)
#define FIT_LANGUAGE_MONGOLIAN                                                   ((FIT_LANGUAGE)37)
#define FIT_LANGUAGE_CUSTOM                                                      ((FIT_LANGUAGE)254)
#define FIT_LANGUAGE_COUNT                                                       39

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_0; // Bit field corresponding to language enum type (1 << language).
#define FIT_LANGUAGE_BITS_0_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_0_ENGLISH                                              ((FIT_LANGUAGE_BITS_0)0x01)
#define FIT_LANGUAGE_BITS_0_FRENCH                                               ((FIT_LANGUAGE_BITS_0)0x02)
#define FIT_LANGUAGE_BITS_0_ITALIAN                                              ((FIT_LANGUAGE_BITS_0)0x04)
#define FIT_LANGUAGE_BITS_0_GERMAN                                               ((FIT_LANGUAGE_BITS_0)0x08)
#define FIT_LANGUAGE_BITS_0_SPANISH                                              ((FIT_LANGUAGE_BITS_0)0x10)
#define FIT_LANGUAGE_BITS_0_CROATIAN                                             ((FIT_LANGUAGE_BITS_0)0x20)
#define FIT_LANGUAGE_BITS_0_CZECH                                                ((FIT_LANGUAGE_BITS_0)0x40)
#define FIT_LANGUAGE_BITS_0_DANISH                                               ((FIT_LANGUAGE_BITS_0)0x80)
#define FIT_LANGUAGE_BITS_0_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_1;
#define FIT_LANGUAGE_BITS_1_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_1_DUTCH                                                ((FIT_LANGUAGE_BITS_1)0x01)
#define FIT_LANGUAGE_BITS_1_FINNISH                                              ((FIT_LANGUAGE_BITS_1)0x02)
#define FIT_LANGUAGE_BITS_1_GREEK                                                ((FIT_LANGUAGE_BITS_1)0x04)
#define FIT_LANGUAGE_BITS_1_HUNGARIAN                                            ((FIT_LANGUAGE_BITS_1)0x08)
#define FIT_LANGUAGE_BITS_1_NORWEGIAN                                            ((FIT_LANGUAGE_BITS_1)0x10)
#define FIT_LANGUAGE_BITS_1_POLISH                                               ((FIT_LANGUAGE_BITS_1)0x20)
#define FIT_LANGUAGE_BITS_1_PORTUGUESE                                           ((FIT_LANGUAGE_BITS_1)0x40)
#define FIT_LANGUAGE_BITS_1_SLOVAKIAN                                            ((FIT_LANGUAGE_BITS_1)0x80)
#define FIT_LANGUAGE_BITS_1_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_2;
#define FIT_LANGUAGE_BITS_2_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_2_SLOVENIAN                                            ((FIT_LANGUAGE_BITS_2)0x01)
#define FIT_LANGUAGE_BITS_2_SWEDISH                                              ((FIT_LANGUAGE_BITS_2)0x02)
#define FIT_LANGUAGE_BITS_2_RUSSIAN                                              ((FIT_LANGUAGE_BITS_2)0x04)
#define FIT_LANGUAGE_BITS_2_TURKISH                                              ((FIT_LANGUAGE_BITS_2)0x08)
#define FIT_LANGUAGE_BITS_2_LATVIAN                                              ((FIT_LANGUAGE_BITS_2)0x10)
#define FIT_LANGUAGE_BITS_2_UKRAINIAN                                            ((FIT_LANGUAGE_BITS_2)0x20)
#define FIT_LANGUAGE_BITS_2_ARABIC                                               ((FIT_LANGUAGE_BITS_2)0x40)
#define FIT_LANGUAGE_BITS_2_FARSI                                                ((FIT_LANGUAGE_BITS_2)0x80)
#define FIT_LANGUAGE_BITS_2_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_3;
#define FIT_LANGUAGE_BITS_3_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_3_BULGARIAN                                            ((FIT_LANGUAGE_BITS_3)0x01)
#define FIT_LANGUAGE_BITS_3_ROMANIAN                                             ((FIT_LANGUAGE_BITS_3)0x02)
#define FIT_LANGUAGE_BITS_3_CHINESE                                              ((FIT_LANGUAGE_BITS_3)0x04)
#define FIT_LANGUAGE_BITS_3_JAPANESE                                             ((FIT_LANGUAGE_BITS_3)0x08)
#define FIT_LANGUAGE_BITS_3_KOREAN                                               ((FIT_LANGUAGE_BITS_3)0x10)
#define FIT_LANGUAGE_BITS_3_TAIWANESE                                            ((FIT_LANGUAGE_BITS_3)0x20)
#define FIT_LANGUAGE_BITS_3_THAI                                                 ((FIT_LANGUAGE_BITS_3)0x40)
#define FIT_LANGUAGE_BITS_3_HEBREW                                               ((FIT_LANGUAGE_BITS_3)0x80)
#define FIT_LANGUAGE_BITS_3_COUNT                                                8

typedef FIT_UINT8Z FIT_LANGUAGE_BITS_4;
#define FIT_LANGUAGE_BITS_4_INVALID                                              FIT_UINT8Z_INVALID
#define FIT_LANGUAGE_BITS_4_BRAZILIAN_PORTUGUESE                                 ((FIT_LANGUAGE_BITS_4)0x01)
#define FIT_LANGUAGE_BITS_4_INDONESIAN                                           ((FIT_LANGUAGE_BITS_4)0x02)
#define FIT_LANGUAGE_BITS_4_MALAYSIAN                                            ((FIT_LANGUAGE_BITS_4)0x04)
#define FIT_LANGUAGE_BITS_4_VIETNAMESE                                           ((FIT_LANGUAGE_BITS_4)0x08)
#define FIT_LANGUAGE_BITS_4_BURMESE                                              ((FIT_LANGUAGE_BITS_4)0x10)
#define FIT_LANGUAGE_BITS_4_MONGOLIAN                                            ((FIT_LANGUAGE_BITS_4)0x20)
#define FIT_LANGUAGE_BITS_4_COUNT                                                6

typedef FIT_ENUM FIT_TIME_ZONE;
#define FIT_TIME_ZONE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_TIME_ZONE_ALMATY                                                     ((FIT_TIME_ZONE)0)
#define FIT_TIME_ZONE_BANGKOK                                                    ((FIT_TIME_ZONE)1)
#define FIT_TIME_ZONE_BOMBAY                                                     ((FIT_TIME_ZONE)2)
#define FIT_TIME_ZONE_BRASILIA                                                   ((FIT_TIME_ZONE)3)
#define FIT_TIME_ZONE_CAIRO                                                      ((FIT_TIME_ZONE)4)
#define FIT_TIME_ZONE_CAPE_VERDE_IS                                              ((FIT_TIME_ZONE)5)
#define FIT_TIME_ZONE_DARWIN                                                     ((FIT_TIME_ZONE)6)
#define FIT_TIME_ZONE_ENIWETOK                                                   ((FIT_TIME_ZONE)7)
#define FIT_TIME_ZONE_FIJI                                                       ((FIT_TIME_ZONE)8)
#define FIT_TIME_ZONE_HONG_KONG                                                  ((FIT_TIME_ZONE)9)
#define FIT_TIME_ZONE_ISLAMABAD                                                  ((FIT_TIME_ZONE)10)
#define FIT_TIME_ZONE_KABUL                                                      ((FIT_TIME_ZONE)11)
#define FIT_TIME_ZONE_MAGADAN                                                    ((FIT_TIME_ZONE)12)
#define FIT_TIME_ZONE_MID_ATLANTIC                                               ((FIT_TIME_ZONE)13)
#define FIT_TIME_ZONE_MOSCOW                                                     ((FIT_TIME_ZONE)14)
#define FIT_TIME_ZONE_MUSCAT                                                     ((FIT_TIME_ZONE)15)
#define FIT_TIME_ZONE_NEWFOUNDLAND                                               ((FIT_TIME_ZONE)16)
#define FIT_TIME_ZONE_SAMOA                                                      ((FIT_TIME_ZONE)17)
#define FIT_TIME_ZONE_SYDNEY                                                     ((FIT_TIME_ZONE)18)
#define FIT_TIME_ZONE_TEHRAN                                                     ((FIT_TIME_ZONE)19)
#define FIT_TIME_ZONE_TOKYO                                                      ((FIT_TIME_ZONE)20)
#define FIT_TIME_ZONE_US_ALASKA                                                  ((FIT_TIME_ZONE)21)
#define FIT_TIME_ZONE_US_ATLANTIC                                                ((FIT_TIME_ZONE)22)
#define FIT_TIME_ZONE_US_CENTRAL                                                 ((FIT_TIME_ZONE)23)
#define FIT_TIME_ZONE_US_EASTERN                                                 ((FIT_TIME_ZONE)24)
#define FIT_TIME_ZONE_US_HAWAII                                                  ((FIT_TIME_ZONE)25)
#define FIT_TIME_ZONE_US_MOUNTAIN                                                ((FIT_TIME_ZONE)26)
#define FIT_TIME_ZONE_US_PACIFIC                                                 ((FIT_TIME_ZONE)27)
#define FIT_TIME_ZONE_OTHER                                                      ((FIT_TIME_ZONE)28)
#define FIT_TIME_ZONE_AUCKLAND                                                   ((FIT_TIME_ZONE)29)
#define FIT_TIME_ZONE_KATHMANDU                                                  ((FIT_TIME_ZONE)30)
#define FIT_TIME_ZONE_EUROPE_WESTERN_WET                                         ((FIT_TIME_ZONE)31)
#define FIT_TIME_ZONE_EUROPE_CENTRAL_CET                                         ((FIT_TIME_ZONE)32)
#define FIT_TIME_ZONE_EUROPE_EASTERN_EET                                         ((FIT_TIME_ZONE)33)
#define FIT_TIME_ZONE_JAKARTA                                                    ((FIT_TIME_ZONE)34)
#define FIT_TIME_ZONE_PERTH                                                      ((FIT_TIME_ZONE)35)
#define FIT_TIME_ZONE_ADELAIDE                                                   ((FIT_TIME_ZONE)36)
#define FIT_TIME_ZONE_BRISBANE                                                   ((FIT_TIME_ZONE)37)
#define FIT_TIME_ZONE_TASMANIA                                                   ((FIT_TIME_ZONE)38)
#define FIT_TIME_ZONE_ICELAND                                                    ((FIT_TIME_ZONE)39)
#define FIT_TIME_ZONE_AMSTERDAM                                                  ((FIT_TIME_ZONE)40)
#define FIT_TIME_ZONE_ATHENS                                                     ((FIT_TIME_ZONE)41)
#define FIT_TIME_ZONE_BARCELONA                                                  ((FIT_TIME_ZONE)42)
#define FIT_TIME_ZONE_BERLIN                                                     ((FIT_TIME_ZONE)43)
#define FIT_TIME_ZONE_BRUSSELS                                                   ((FIT_TIME_ZONE)44)
#define FIT_TIME_ZONE_BUDAPEST                                                   ((FIT_TIME_ZONE)45)
#define FIT_TIME_ZONE_COPENHAGEN                                                 ((FIT_TIME_ZONE)46)
#define FIT_TIME_ZONE_DUBLIN                                                     ((FIT_TIME_ZONE)47)
#define FIT_TIME_ZONE_HELSINKI                                                   ((FIT_TIME_ZONE)48)
#define FIT_TIME_ZONE_LISBON                                                     ((FIT_TIME_ZONE)49)
#define FIT_TIME_ZONE_LONDON                                                     ((FIT_TIME_ZONE)50)
#define FIT_TIME_ZONE_MADRID                                                     ((FIT_TIME_ZONE)51)
#define FIT_TIME_ZONE_MUNICH                                                     ((FIT_TIME_ZONE)52)
#define FIT_TIME_ZONE_OSLO                                                       ((FIT_TIME_ZONE)53)
#define FIT_TIME_ZONE_PARIS                                                      ((FIT_TIME_ZONE)54)
#define FIT_TIME_ZONE_PRAGUE                                                     ((FIT_TIME_ZONE)55)
#define FIT_TIME_ZONE_REYKJAVIK                                                  ((FIT_TIME_ZONE)56)
#define FIT_TIME_ZONE_ROME                                                       ((FIT_TIME_ZONE)57)
#define FIT_TIME_ZONE_STOCKHOLM                                                  ((FIT_TIME_ZONE)58)
#define FIT_TIME_ZONE_VIENNA                                                     ((FIT_TIME_ZONE)59)
#define FIT_TIME_ZONE_WARSAW                                                     ((FIT_TIME_ZONE)60)
#define FIT_TIME_ZONE_ZURICH                                                     ((FIT_TIME_ZONE)61)
#define FIT_TIME_ZONE_QUEBEC                                                     ((FIT_TIME_ZONE)62)
#define FIT_TIME_ZONE_ONTARIO                                                    ((FIT_TIME_ZONE)63)
#define FIT_TIME_ZONE_MANITOBA                                                   ((FIT_TIME_ZONE)64)
#define FIT_TIME_ZONE_SASKATCHEWAN                                               ((FIT_TIME_ZONE)65)
#define FIT_TIME_ZONE_ALBERTA                                                    ((FIT_TIME_ZONE)66)
#define FIT_TIME_ZONE_BRITISH_COLUMBIA                                           ((FIT_TIME_ZONE)67)
#define FIT_TIME_ZONE_BOISE                                                      ((FIT_TIME_ZONE)68)
#define FIT_TIME_ZONE_BOSTON                                                     ((FIT_TIME_ZONE)69)
#define FIT_TIME_ZONE_CHICAGO                                                    ((FIT_TIME_ZONE)70)
#define FIT_TIME_ZONE_DALLAS                                                     ((FIT_TIME_ZONE)71)
#define FIT_TIME_ZONE_DENVER                                                     ((FIT_TIME_ZONE)72)
#define FIT_TIME_ZONE_KANSAS_CITY                                                ((FIT_TIME_ZONE)73)
#define FIT_TIME_ZONE_LAS_VEGAS                                                  ((FIT_TIME_ZONE)74)
#define FIT_TIME_ZONE_LOS_ANGELES                                                ((FIT_TIME_ZONE)75)
#define FIT_TIME_ZONE_MIAMI                                                      ((FIT_TIME_ZONE)76)
#define FIT_TIME_ZONE_MINNEAPOLIS                                                ((FIT_TIME_ZONE)77)
#define FIT_TIME_ZONE_NEW_YORK                                                   ((FIT_TIME_ZONE)78)
#define FIT_TIME_ZONE_NEW_ORLEANS                                                ((FIT_TIME_ZONE)79)
#define FIT_TIME_ZONE_PHOENIX                                                    ((FIT_TIME_ZONE)80)
#define FIT_TIME_ZONE_SANTA_FE                                                   ((FIT_TIME_ZONE)81)
#define FIT_TIME_ZONE_SEATTLE                                                    ((FIT_TIME_ZONE)82)
#define FIT_TIME_ZONE_WASHINGTON_DC                                              ((FIT_TIME_ZONE)83)
#define FIT_TIME_ZONE_US_ARIZONA                                                 ((FIT_TIME_ZONE)84)
#define FIT_TIME_ZONE_CHITA                                                      ((FIT_TIME_ZONE)85)
#define FIT_TIME_ZONE_EKATERINBURG                                               ((FIT_TIME_ZONE)86)
#define FIT_TIME_ZONE_IRKUTSK                                                    ((FIT_TIME_ZONE)87)
#define FIT_TIME_ZONE_KALININGRAD                                                ((FIT_TIME_ZONE)88)
#define FIT_TIME_ZONE_KRASNOYARSK                                                ((FIT_TIME_ZONE)89)
#define FIT_TIME_ZONE_NOVOSIBIRSK                                                ((FIT_TIME_ZONE)90)
#define FIT_TIME_ZONE_PETROPAVLOVSK_KAMCHATSKIY                                  ((FIT_TIME_ZONE)91)
#define FIT_TIME_ZONE_SAMARA                                                     ((FIT_TIME_ZONE)92)
#define FIT_TIME_ZONE_VLADIVOSTOK                                                ((FIT_TIME_ZONE)93)
#define FIT_TIME_ZONE_MEXICO_CENTRAL                                             ((FIT_TIME_ZONE)94)
#define FIT_TIME_ZONE_MEXICO_MOUNTAIN                                            ((FIT_TIME_ZONE)95)
#define FIT_TIME_ZONE_MEXICO_PACIFIC                                             ((FIT_TIME_ZONE)96)
#define FIT_TIME_ZONE_CAPE_TOWN                                                  ((FIT_TIME_ZONE)97)
#define FIT_TIME_ZONE_WINKHOEK                                                   ((FIT_TIME_ZONE)98)
#define FIT_TIME_ZONE_LAGOS                                                      ((FIT_TIME_ZONE)99)
#define FIT_TIME_ZONE_RIYAHD                                                     ((FIT_TIME_ZONE)100)
#define FIT_TIME_ZONE_VENEZUELA                                                  ((FIT_TIME_ZONE)101)
#define FIT_TIME_ZONE_AUSTRALIA_LH                                               ((FIT_TIME_ZONE)102)
#define FIT_TIME_ZONE_SANTIAGO                                                   ((FIT_TIME_ZONE)103)
#define FIT_TIME_ZONE_MANUAL                                                     ((FIT_TIME_ZONE)253)
#define FIT_TIME_ZONE_AUTOMATIC                                                  ((FIT_TIME_ZONE)254)
#define FIT_TIME_ZONE_COUNT                                                      106

typedef FIT_ENUM FIT_DISPLAY_MEASURE;
#define FIT_DISPLAY_MEASURE_INVALID                                              FIT_ENUM_INVALID
#define FIT_DISPLAY_MEASURE_METRIC                                               ((FIT_DISPLAY_MEASURE)0)
#define FIT_DISPLAY_MEASURE_STATUTE                                              ((FIT_DISPLAY_MEASURE)1)
#define FIT_DISPLAY_MEASURE_NAUTICAL                                             ((FIT_DISPLAY_MEASURE)2)
#define FIT_DISPLAY_MEASURE_COUNT                                                3

typedef FIT_ENUM FIT_DISPLAY_HEART;
#define FIT_DISPLAY_HEART_INVALID                                                FIT_ENUM_INVALID
#define FIT_DISPLAY_HEART_BPM                                                    ((FIT_DISPLAY_HEART)0)
#define FIT_DISPLAY_HEART_MAX                                                    ((FIT_DISPLAY_HEART)1)
#define FIT_DISPLAY_HEART_RESERVE                                                ((FIT_DISPLAY_HEART)2)
#define FIT_DISPLAY_HEART_COUNT                                                  3

typedef FIT_ENUM FIT_DISPLAY_POWER;
#define FIT_DISPLAY_POWER_INVALID                                                FIT_ENUM_INVALID
#define FIT_DISPLAY_POWER_WATTS                                                  ((FIT_DISPLAY_POWER)0)
#define FIT_DISPLAY_POWER_PERCENT_FTP                                            ((FIT_DISPLAY_POWER)1)
#define FIT_DISPLAY_POWER_COUNT                                                  2

typedef FIT_ENUM FIT_DISPLAY_POSITION;
#define FIT_DISPLAY_POSITION_INVALID                                             FIT_ENUM_INVALID
#define FIT_DISPLAY_POSITION_DEGREE                                              ((FIT_DISPLAY_POSITION)0) // dd.dddddd
#define FIT_DISPLAY_POSITION_DEGREE_MINUTE                                       ((FIT_DISPLAY_POSITION)1) // dddmm.mmm
#define FIT_DISPLAY_POSITION_DEGREE_MINUTE_SECOND                                ((FIT_DISPLAY_POSITION)2) // dddmmss
#define FIT_DISPLAY_POSITION_AUSTRIAN_GRID                                       ((FIT_DISPLAY_POSITION)3) // Austrian Grid (BMN)
#define FIT_DISPLAY_POSITION_BRITISH_GRID                                        ((FIT_DISPLAY_POSITION)4) // British National Grid
#define FIT_DISPLAY_POSITION_DUTCH_GRID                                          ((FIT_DISPLAY_POSITION)5) // Dutch grid system
#define FIT_DISPLAY_POSITION_HUNGARIAN_GRID                                      ((FIT_DISPLAY_POSITION)6) // Hungarian grid system
#define FIT_DISPLAY_POSITION_FINNISH_GRID                                        ((FIT_DISPLAY_POSITION)7) // Finnish grid system Zone3 KKJ27
#define FIT_DISPLAY_POSITION_GERMAN_GRID                                         ((FIT_DISPLAY_POSITION)8) // Gausss Krueger (German)
#define FIT_DISPLAY_POSITION_ICELANDIC_GRID                                      ((FIT_DISPLAY_POSITION)9) // Icelandic Grid
#define FIT_DISPLAY_POSITION_INDONESIAN_EQUATORIAL                               ((FIT_DISPLAY_POSITION)10) // Indonesian Equatorial LCO
#define FIT_DISPLAY_POSITION_INDONESIAN_IRIAN                                    ((FIT_DISPLAY_POSITION)11) // Indonesian Irian LCO
#define FIT_DISPLAY_POSITION_INDONESIAN_SOUTHERN                                 ((FIT_DISPLAY_POSITION)12) // Indonesian Southern LCO
#define FIT_DISPLAY_POSITION_INDIA_ZONE_0                                        ((FIT_DISPLAY_POSITION)13) // India zone 0
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IA                                       ((FIT_DISPLAY_POSITION)14) // India zone IA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IB                                       ((FIT_DISPLAY_POSITION)15) // India zone IB
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIA                                      ((FIT_DISPLAY_POSITION)16) // India zone IIA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIB                                      ((FIT_DISPLAY_POSITION)17) // India zone IIB
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIIA                                     ((FIT_DISPLAY_POSITION)18) // India zone IIIA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IIIB                                     ((FIT_DISPLAY_POSITION)19) // India zone IIIB
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IVA                                      ((FIT_DISPLAY_POSITION)20) // India zone IVA
#define FIT_DISPLAY_POSITION_INDIA_ZONE_IVB                                      ((FIT_DISPLAY_POSITION)21) // India zone IVB
#define FIT_DISPLAY_POSITION_IRISH_TRANSVERSE                                    ((FIT_DISPLAY_POSITION)22) // Irish Transverse Mercator
#define FIT_DISPLAY_POSITION_IRISH_GRID                                          ((FIT_DISPLAY_POSITION)23) // Irish Grid
#define FIT_DISPLAY_POSITION_LORAN                                               ((FIT_DISPLAY_POSITION)24) // Loran TD
#define FIT_DISPLAY_POSITION_MAIDENHEAD_GRID                                     ((FIT_DISPLAY_POSITION)25) // Maidenhead grid system
#define FIT_DISPLAY_POSITION_MGRS_GRID                                           ((FIT_DISPLAY_POSITION)26) // MGRS grid system
#define FIT_DISPLAY_POSITION_NEW_ZEALAND_GRID                                    ((FIT_DISPLAY_POSITION)27) // New Zealand grid system
#define FIT_DISPLAY_POSITION_NEW_ZEALAND_TRANSVERSE                              ((FIT_DISPLAY_POSITION)28) // New Zealand Transverse Mercator
#define FIT_DISPLAY_POSITION_QATAR_GRID                                          ((FIT_DISPLAY_POSITION)29) // Qatar National Grid
#define FIT_DISPLAY_POSITION_MODIFIED_SWEDISH_GRID                               ((FIT_DISPLAY_POSITION)30) // Modified RT-90 (Sweden)
#define FIT_DISPLAY_POSITION_SWEDISH_GRID                                        ((FIT_DISPLAY_POSITION)31) // RT-90 (Sweden)
#define FIT_DISPLAY_POSITION_SOUTH_AFRICAN_GRID                                  ((FIT_DISPLAY_POSITION)32) // South African Grid
#define FIT_DISPLAY_POSITION_SWISS_GRID                                          ((FIT_DISPLAY_POSITION)33) // Swiss CH-1903 grid
#define FIT_DISPLAY_POSITION_TAIWAN_GRID                                         ((FIT_DISPLAY_POSITION)34) // Taiwan Grid
#define FIT_DISPLAY_POSITION_UNITED_STATES_GRID                                  ((FIT_DISPLAY_POSITION)35) // United States National Grid
#define FIT_DISPLAY_POSITION_UTM_UPS_GRID                                        ((FIT_DISPLAY_POSITION)36) // UTM/UPS grid system
#define FIT_DISPLAY_POSITION_WEST_MALAYAN                                        ((FIT_DISPLAY_POSITION)37) // West Malayan RSO
#define FIT_DISPLAY_POSITION_BORNEO_RSO                                          ((FIT_DISPLAY_POSITION)38) // Borneo RSO
#define FIT_DISPLAY_POSITION_ESTONIAN_GRID                                       ((FIT_DISPLAY_POSITION)39) // Estonian grid system
#define FIT_DISPLAY_POSITION_LATVIAN_GRID                                        ((FIT_DISPLAY_POSITION)40) // Latvian Transverse Mercator
#define FIT_DISPLAY_POSITION_SWEDISH_REF_99_GRID                                 ((FIT_DISPLAY_POSITION)41) // Reference Grid 99 TM (Swedish)
#define FIT_DISPLAY_POSITION_COUNT                                               42

typedef FIT_ENUM FIT_SWITCH;
#define FIT_SWITCH_INVALID                                                       FIT_ENUM_INVALID
#define FIT_SWITCH_OFF                                                           ((FIT_SWITCH)0)
#define FIT_SWITCH_ON                                                            ((FIT_SWITCH)1)
#define FIT_SWITCH_AUTO                                                          ((FIT_SWITCH)2)
#define FIT_SWITCH_COUNT                                                         3

typedef FIT_ENUM FIT_SPORT;
#define FIT_SPORT_INVALID                                                        FIT_ENUM_INVALID
#define FIT_SPORT_GENERIC                                                        ((FIT_SPORT)0)
#define FIT_SPORT_RUNNING                                                        ((FIT_SPORT)1)
#define FIT_SPORT_CYCLING                                                        ((FIT_SPORT)2)
#define FIT_SPORT_TRANSITION                                                     ((FIT_SPORT)3) // Mulitsport transition
#define FIT_SPORT_FITNESS_EQUIPMENT                                              ((FIT_SPORT)4)
#define FIT_SPORT_SWIMMING                                                       ((FIT_SPORT)5)
#define FIT_SPORT_BASKETBALL                                                     ((FIT_SPORT)6)
#define FIT_SPORT_SOCCER                                                         ((FIT_SPORT)7)
#define FIT_SPORT_TENNIS                                                         ((FIT_SPORT)8)
#define FIT_SPORT_AMERICAN_FOOTBALL                                              ((FIT_SPORT)9)
#define FIT_SPORT_TRAINING                                                       ((FIT_SPORT)10)
#define FIT_SPORT_WALKING                                                        ((FIT_SPORT)11)
#define FIT_SPORT_CROSS_COUNTRY_SKIING                                           ((FIT_SPORT)12)
#define FIT_SPORT_ALPINE_SKIING                                                  ((FIT_SPORT)13)
#define FIT_SPORT_SNOWBOARDING                                                   ((FIT_SPORT)14)
#define FIT_SPORT_ROWING                                                         ((FIT_SPORT)15)
#define FIT_SPORT_MOUNTAINEERING                                                 ((FIT_SPORT)16)
#define FIT_SPORT_HIKING                                                         ((FIT_SPORT)17)
#define FIT_SPORT_MULTISPORT                                                     ((FIT_SPORT)18)
#define FIT_SPORT_PADDLING                                                       ((FIT_SPORT)19)
#define FIT_SPORT_FLYING                                                         ((FIT_SPORT)20)
#define FIT_SPORT_E_BIKING                                                       ((FIT_SPORT)21)
#define FIT_SPORT_MOTORCYCLING                                                   ((FIT_SPORT)22)
#define FIT_SPORT_BOATING                                                        ((FIT_SPORT)23)
#define FIT_SPORT_DRIVING                                                        ((FIT_SPORT)24)
#define FIT_SPORT_GOLF                                                           ((FIT_SPORT)25)
#define FIT_SPORT_HANG_GLIDING                                                   ((FIT_SPORT)26)
#define FIT_SPORT_HORSEBACK_RIDING                                               ((FIT_SPORT)27)
#define FIT_SPORT_HUNTING                                                        ((FIT_SPORT)28)
#define FIT_SPORT_FISHING                                                        ((FIT_SPORT)29)
#define FIT_SPORT_INLINE_SKATING                                                 ((FIT_SPORT)30)
#define FIT_SPORT_ROCK_CLIMBING                                                  ((FIT_SPORT)31)
#define FIT_SPORT_SAILING                                                        ((FIT_SPORT)32)
#define FIT_SPORT_ICE_SKATING                                                    ((FIT_SPORT)33)
#define FIT_SPORT_SKY_DIVING                                                     ((FIT_SPORT)34)
#define FIT_SPORT_SNOWSHOEING                                                    ((FIT_SPORT)35)
#define FIT_SPORT_SNOWMOBILING                                                   ((FIT_SPORT)36)
#define FIT_SPORT_STAND_UP_PADDLEBOARDING                                        ((FIT_SPORT)37)
#define FIT_SPORT_SURFING                                                        ((FIT_SPORT)38)
#define FIT_SPORT_WAKEBOARDING                                                   ((FIT_SPORT)39)
#define FIT_SPORT_WATER_SKIING                                                   ((FIT_SPORT)40)
#define FIT_SPORT_KAYAKING                                                       ((FIT_SPORT)41)
#define FIT_SPORT_RAFTING                                                        ((FIT_SPORT)42)
#define FIT_SPORT_WINDSURFING                                                    ((FIT_SPORT)43)
#define FIT_SPORT_KITESURFING                                                    ((FIT_SPORT)44)
#define FIT_SPORT_TACTICAL                                                       ((FIT_SPORT)45)
#define FIT_SPORT_JUMPMASTER                                                     ((FIT_SPORT)46)
#define FIT_SPORT_BOXING                                                         ((FIT_SPORT)47)
#define FIT_SPORT_FLOOR_CLIMBING                                                 ((FIT_SPORT)48)
#define FIT_SPORT_ALL                                                            ((FIT_SPORT)254) // All is for goals only to include all sports.
#define FIT_SPORT_COUNT                                                          50

typedef FIT_UINT8Z FIT_SPORT_BITS_0; // Bit field corresponding to sport enum type (1 << sport).
#define FIT_SPORT_BITS_0_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_0_GENERIC                                                 ((FIT_SPORT_BITS_0)0x01)
#define FIT_SPORT_BITS_0_RUNNING                                                 ((FIT_SPORT_BITS_0)0x02)
#define FIT_SPORT_BITS_0_CYCLING                                                 ((FIT_SPORT_BITS_0)0x04)
#define FIT_SPORT_BITS_0_TRANSITION                                              ((FIT_SPORT_BITS_0)0x08) // Mulitsport transition
#define FIT_SPORT_BITS_0_FITNESS_EQUIPMENT                                       ((FIT_SPORT_BITS_0)0x10)
#define FIT_SPORT_BITS_0_SWIMMING                                                ((FIT_SPORT_BITS_0)0x20)
#define FIT_SPORT_BITS_0_BASKETBALL                                              ((FIT_SPORT_BITS_0)0x40)
#define FIT_SPORT_BITS_0_SOCCER                                                  ((FIT_SPORT_BITS_0)0x80)
#define FIT_SPORT_BITS_0_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_1; // Bit field corresponding to sport enum type (1 << (sport-8)).
#define FIT_SPORT_BITS_1_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_1_TENNIS                                                  ((FIT_SPORT_BITS_1)0x01)
#define FIT_SPORT_BITS_1_AMERICAN_FOOTBALL                                       ((FIT_SPORT_BITS_1)0x02)
#define FIT_SPORT_BITS_1_TRAINING                                                ((FIT_SPORT_BITS_1)0x04)
#define FIT_SPORT_BITS_1_WALKING                                                 ((FIT_SPORT_BITS_1)0x08)
#define FIT_SPORT_BITS_1_CROSS_COUNTRY_SKIING                                    ((FIT_SPORT_BITS_1)0x10)
#define FIT_SPORT_BITS_1_ALPINE_SKIING                                           ((FIT_SPORT_BITS_1)0x20)
#define FIT_SPORT_BITS_1_SNOWBOARDING                                            ((FIT_SPORT_BITS_1)0x40)
#define FIT_SPORT_BITS_1_ROWING                                                  ((FIT_SPORT_BITS_1)0x80)
#define FIT_SPORT_BITS_1_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_2; // Bit field corresponding to sport enum type (1 << (sport-16)).
#define FIT_SPORT_BITS_2_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_2_MOUNTAINEERING                                          ((FIT_SPORT_BITS_2)0x01)
#define FIT_SPORT_BITS_2_HIKING                                                  ((FIT_SPORT_BITS_2)0x02)
#define FIT_SPORT_BITS_2_MULTISPORT                                              ((FIT_SPORT_BITS_2)0x04)
#define FIT_SPORT_BITS_2_PADDLING                                                ((FIT_SPORT_BITS_2)0x08)
#define FIT_SPORT_BITS_2_FLYING                                                  ((FIT_SPORT_BITS_2)0x10)
#define FIT_SPORT_BITS_2_E_BIKING                                                ((FIT_SPORT_BITS_2)0x20)
#define FIT_SPORT_BITS_2_MOTORCYCLING                                            ((FIT_SPORT_BITS_2)0x40)
#define FIT_SPORT_BITS_2_BOATING                                                 ((FIT_SPORT_BITS_2)0x80)
#define FIT_SPORT_BITS_2_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_3; // Bit field corresponding to sport enum type (1 << (sport-24)).
#define FIT_SPORT_BITS_3_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_3_DRIVING                                                 ((FIT_SPORT_BITS_3)0x01)
#define FIT_SPORT_BITS_3_GOLF                                                    ((FIT_SPORT_BITS_3)0x02)
#define FIT_SPORT_BITS_3_HANG_GLIDING                                            ((FIT_SPORT_BITS_3)0x04)
#define FIT_SPORT_BITS_3_HORSEBACK_RIDING                                        ((FIT_SPORT_BITS_3)0x08)
#define FIT_SPORT_BITS_3_HUNTING                                                 ((FIT_SPORT_BITS_3)0x10)
#define FIT_SPORT_BITS_3_FISHING                                                 ((FIT_SPORT_BITS_3)0x20)
#define FIT_SPORT_BITS_3_INLINE_SKATING                                          ((FIT_SPORT_BITS_3)0x40)
#define FIT_SPORT_BITS_3_ROCK_CLIMBING                                           ((FIT_SPORT_BITS_3)0x80)
#define FIT_SPORT_BITS_3_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_4; // Bit field corresponding to sport enum type (1 << (sport-32)).
#define FIT_SPORT_BITS_4_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_4_SAILING                                                 ((FIT_SPORT_BITS_4)0x01)
#define FIT_SPORT_BITS_4_ICE_SKATING                                             ((FIT_SPORT_BITS_4)0x02)
#define FIT_SPORT_BITS_4_SKY_DIVING                                              ((FIT_SPORT_BITS_4)0x04)
#define FIT_SPORT_BITS_4_SNOWSHOEING                                             ((FIT_SPORT_BITS_4)0x08)
#define FIT_SPORT_BITS_4_SNOWMOBILING                                            ((FIT_SPORT_BITS_4)0x10)
#define FIT_SPORT_BITS_4_STAND_UP_PADDLEBOARDING                                 ((FIT_SPORT_BITS_4)0x20)
#define FIT_SPORT_BITS_4_SURFING                                                 ((FIT_SPORT_BITS_4)0x40)
#define FIT_SPORT_BITS_4_WAKEBOARDING                                            ((FIT_SPORT_BITS_4)0x80)
#define FIT_SPORT_BITS_4_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_5; // Bit field corresponding to sport enum type (1 << (sport-40)).
#define FIT_SPORT_BITS_5_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_5_WATER_SKIING                                            ((FIT_SPORT_BITS_5)0x01)
#define FIT_SPORT_BITS_5_KAYAKING                                                ((FIT_SPORT_BITS_5)0x02)
#define FIT_SPORT_BITS_5_RAFTING                                                 ((FIT_SPORT_BITS_5)0x04)
#define FIT_SPORT_BITS_5_WINDSURFING                                             ((FIT_SPORT_BITS_5)0x08)
#define FIT_SPORT_BITS_5_KITESURFING                                             ((FIT_SPORT_BITS_5)0x10)
#define FIT_SPORT_BITS_5_TACTICAL                                                ((FIT_SPORT_BITS_5)0x20)
#define FIT_SPORT_BITS_5_JUMPMASTER                                              ((FIT_SPORT_BITS_5)0x40)
#define FIT_SPORT_BITS_5_BOXING                                                  ((FIT_SPORT_BITS_5)0x80)
#define FIT_SPORT_BITS_5_COUNT                                                   8

typedef FIT_UINT8Z FIT_SPORT_BITS_6; // Bit field corresponding to sport enum type (1 << (sport-48)).
#define FIT_SPORT_BITS_6_INVALID                                                 FIT_UINT8Z_INVALID
#define FIT_SPORT_BITS_6_FLOOR_CLIMBING                                          ((FIT_SPORT_BITS_6)0x01)
#define FIT_SPORT_BITS_6_COUNT                                                   1

typedef FIT_ENUM FIT_SUB_SPORT;
#define FIT_SUB_SPORT_INVALID                                                    FIT_ENUM_INVALID
#define FIT_SUB_SPORT_GENERIC                                                    ((FIT_SUB_SPORT)0)
#define FIT_SUB_SPORT_TREADMILL                                                  ((FIT_SUB_SPORT)1) // Run/Fitness Equipment
#define FIT_SUB_SPORT_STREET                                                     ((FIT_SUB_SPORT)2) // Run
#define FIT_SUB_SPORT_TRAIL                                                      ((FIT_SUB_SPORT)3) // Run
#define FIT_SUB_SPORT_TRACK                                                      ((FIT_SUB_SPORT)4) // Run
#define FIT_SUB_SPORT_SPIN                                                       ((FIT_SUB_SPORT)5) // Cycling
#define FIT_SUB_SPORT_INDOOR_CYCLING                                             ((FIT_SUB_SPORT)6) // Cycling/Fitness Equipment
#define FIT_SUB_SPORT_ROAD                                                       ((FIT_SUB_SPORT)7) // Cycling
#define FIT_SUB_SPORT_MOUNTAIN                                                   ((FIT_SUB_SPORT)8) // Cycling
#define FIT_SUB_SPORT_DOWNHILL                                                   ((FIT_SUB_SPORT)9) // Cycling
#define FIT_SUB_SPORT_RECUMBENT                                                  ((FIT_SUB_SPORT)10) // Cycling
#define FIT_SUB_SPORT_CYCLOCROSS                                                 ((FIT_SUB_SPORT)11) // Cycling
#define FIT_SUB_SPORT_HAND_CYCLING                                               ((FIT_SUB_SPORT)12) // Cycling
#define FIT_SUB_SPORT_TRACK_CYCLING                                              ((FIT_SUB_SPORT)13) // Cycling
#define FIT_SUB_SPORT_INDOOR_ROWING                                              ((FIT_SUB_SPORT)14) // Fitness Equipment
#define FIT_SUB_SPORT_ELLIPTICAL                                                 ((FIT_SUB_SPORT)15) // Fitness Equipment
#define FIT_SUB_SPORT_STAIR_CLIMBING                                             ((FIT_SUB_SPORT)16) // Fitness Equipment
#define FIT_SUB_SPORT_LAP_SWIMMING                                               ((FIT_SUB_SPORT)17) // Swimming
#define FIT_SUB_SPORT_OPEN_WATER                                                 ((FIT_SUB_SPORT)18) // Swimming
#define FIT_SUB_SPORT_FLEXIBILITY_TRAINING                                       ((FIT_SUB_SPORT)19) // Training
#define FIT_SUB_SPORT_STRENGTH_TRAINING                                          ((FIT_SUB_SPORT)20) // Training
#define FIT_SUB_SPORT_WARM_UP                                                    ((FIT_SUB_SPORT)21) // Tennis
#define FIT_SUB_SPORT_MATCH                                                      ((FIT_SUB_SPORT)22) // Tennis
#define FIT_SUB_SPORT_EXERCISE                                                   ((FIT_SUB_SPORT)23) // Tennis
#define FIT_SUB_SPORT_CHALLENGE                                                  ((FIT_SUB_SPORT)24) // Tennis
#define FIT_SUB_SPORT_INDOOR_SKIING                                              ((FIT_SUB_SPORT)25) // Fitness Equipment
#define FIT_SUB_SPORT_CARDIO_TRAINING                                            ((FIT_SUB_SPORT)26) // Training
#define FIT_SUB_SPORT_INDOOR_WALKING                                             ((FIT_SUB_SPORT)27) // Walking/Fitness Equipment
#define FIT_SUB_SPORT_E_BIKE_FITNESS                                             ((FIT_SUB_SPORT)28) // E-Biking
#define FIT_SUB_SPORT_BMX                                                        ((FIT_SUB_SPORT)29) // Cycling
#define FIT_SUB_SPORT_CASUAL_WALKING                                             ((FIT_SUB_SPORT)30) // Walking
#define FIT_SUB_SPORT_SPEED_WALKING                                              ((FIT_SUB_SPORT)31) // Walking
#define FIT_SUB_SPORT_BIKE_TO_RUN_TRANSITION                                     ((FIT_SUB_SPORT)32) // Transition
#define FIT_SUB_SPORT_RUN_TO_BIKE_TRANSITION                                     ((FIT_SUB_SPORT)33) // Transition
#define FIT_SUB_SPORT_SWIM_TO_BIKE_TRANSITION                                    ((FIT_SUB_SPORT)34) // Transition
#define FIT_SUB_SPORT_ATV                                                        ((FIT_SUB_SPORT)35) // Motorcycling
#define FIT_SUB_SPORT_MOTOCROSS                                                  ((FIT_SUB_SPORT)36) // Motorcycling
#define FIT_SUB_SPORT_BACKCOUNTRY                                                ((FIT_SUB_SPORT)37) // Alpine Skiing/Snowboarding
#define FIT_SUB_SPORT_RESORT                                                     ((FIT_SUB_SPORT)38) // Alpine Skiing/Snowboarding
#define FIT_SUB_SPORT_RC_DRONE                                                   ((FIT_SUB_SPORT)39) // Flying
#define FIT_SUB_SPORT_WINGSUIT                                                   ((FIT_SUB_SPORT)40) // Flying
#define FIT_SUB_SPORT_WHITEWATER                                                 ((FIT_SUB_SPORT)41) // Kayaking/Rafting
#define FIT_SUB_SPORT_SKATE_SKIING                                               ((FIT_SUB_SPORT)42) // Cross Country Skiing
#define FIT_SUB_SPORT_YOGA                                                       ((FIT_SUB_SPORT)43) // Training
#define FIT_SUB_SPORT_PILATES                                                    ((FIT_SUB_SPORT)44) // Training
#define FIT_SUB_SPORT_INDOOR_RUNNING                                             ((FIT_SUB_SPORT)45) // Run
#define FIT_SUB_SPORT_GRAVEL_CYCLING                                             ((FIT_SUB_SPORT)46) // Cycling
#define FIT_SUB_SPORT_E_BIKE_MOUNTAIN                                            ((FIT_SUB_SPORT)47) // Cycling
#define FIT_SUB_SPORT_COMMUTING                                                  ((FIT_SUB_SPORT)48) // Cycling
#define FIT_SUB_SPORT_MIXED_SURFACE                                              ((FIT_SUB_SPORT)49) // Cycling
#define FIT_SUB_SPORT_NAVIGATE                                                   ((FIT_SUB_SPORT)50)
#define FIT_SUB_SPORT_TRACK_ME                                                   ((FIT_SUB_SPORT)51)
#define FIT_SUB_SPORT_MAP                                                        ((FIT_SUB_SPORT)52)
#define FIT_SUB_SPORT_ALL                                                        ((FIT_SUB_SPORT)254)
#define FIT_SUB_SPORT_COUNT                                                      54

typedef FIT_ENUM FIT_SPORT_EVENT;
#define FIT_SPORT_EVENT_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SPORT_EVENT_UNCATEGORIZED                                            ((FIT_SPORT_EVENT)0)
#define FIT_SPORT_EVENT_GEOCACHING                                               ((FIT_SPORT_EVENT)1)
#define FIT_SPORT_EVENT_FITNESS                                                  ((FIT_SPORT_EVENT)2)
#define FIT_SPORT_EVENT_RECREATION                                               ((FIT_SPORT_EVENT)3)
#define FIT_SPORT_EVENT_RACE                                                     ((FIT_SPORT_EVENT)4)
#define FIT_SPORT_EVENT_SPECIAL_EVENT                                            ((FIT_SPORT_EVENT)5)
#define FIT_SPORT_EVENT_TRAINING                                                 ((FIT_SPORT_EVENT)6)
#define FIT_SPORT_EVENT_TRANSPORTATION                                           ((FIT_SPORT_EVENT)7)
#define FIT_SPORT_EVENT_TOURING                                                  ((FIT_SPORT_EVENT)8)
#define FIT_SPORT_EVENT_COUNT                                                    9

typedef FIT_ENUM FIT_ACTIVITY;
#define FIT_ACTIVITY_INVALID                                                     FIT_ENUM_INVALID
#define FIT_ACTIVITY_MANUAL                                                      ((FIT_ACTIVITY)0)
#define FIT_ACTIVITY_AUTO_MULTI_SPORT                                            ((FIT_ACTIVITY)1)
#define FIT_ACTIVITY_COUNT                                                       2

typedef FIT_ENUM FIT_INTENSITY;
#define FIT_INTENSITY_INVALID                                                    FIT_ENUM_INVALID
#define FIT_INTENSITY_ACTIVE                                                     ((FIT_INTENSITY)0)
#define FIT_INTENSITY_REST                                                       ((FIT_INTENSITY)1)
#define FIT_INTENSITY_WARMUP                                                     ((FIT_INTENSITY)2)
#define FIT_INTENSITY_COOLDOWN                                                   ((FIT_INTENSITY)3)
#define FIT_INTENSITY_COUNT                                                      4

typedef FIT_ENUM FIT_SESSION_TRIGGER;
#define FIT_SESSION_TRIGGER_INVALID                                              FIT_ENUM_INVALID
#define FIT_SESSION_TRIGGER_ACTIVITY_END                                         ((FIT_SESSION_TRIGGER)0)
#define FIT_SESSION_TRIGGER_MANUAL                                               ((FIT_SESSION_TRIGGER)1) // User changed sport.
#define FIT_SESSION_TRIGGER_AUTO_MULTI_SPORT                                     ((FIT_SESSION_TRIGGER)2) // Auto multi-sport feature is enabled and user pressed lap button to advance session.
#define FIT_SESSION_TRIGGER_FITNESS_EQUIPMENT                                    ((FIT_SESSION_TRIGGER)3) // Auto sport change caused by user linking to fitness equipment.
#define FIT_SESSION_TRIGGER_COUNT                                                4

typedef FIT_ENUM FIT_AUTOLAP_TRIGGER;
#define FIT_AUTOLAP_TRIGGER_INVALID                                              FIT_ENUM_INVALID
#define FIT_AUTOLAP_TRIGGER_TIME                                                 ((FIT_AUTOLAP_TRIGGER)0)
#define FIT_AUTOLAP_TRIGGER_DISTANCE                                             ((FIT_AUTOLAP_TRIGGER)1)
#define FIT_AUTOLAP_TRIGGER_POSITION_START                                       ((FIT_AUTOLAP_TRIGGER)2)
#define FIT_AUTOLAP_TRIGGER_POSITION_LAP                                         ((FIT_AUTOLAP_TRIGGER)3)
#define FIT_AUTOLAP_TRIGGER_POSITION_WAYPOINT                                    ((FIT_AUTOLAP_TRIGGER)4)
#define FIT_AUTOLAP_TRIGGER_POSITION_MARKED                                      ((FIT_AUTOLAP_TRIGGER)5)
#define FIT_AUTOLAP_TRIGGER_OFF                                                  ((FIT_AUTOLAP_TRIGGER)6)
#define FIT_AUTOLAP_TRIGGER_COUNT                                                7

typedef FIT_ENUM FIT_LAP_TRIGGER;
#define FIT_LAP_TRIGGER_INVALID                                                  FIT_ENUM_INVALID
#define FIT_LAP_TRIGGER_MANUAL                                                   ((FIT_LAP_TRIGGER)0)
#define FIT_LAP_TRIGGER_TIME                                                     ((FIT_LAP_TRIGGER)1)
#define FIT_LAP_TRIGGER_DISTANCE                                                 ((FIT_LAP_TRIGGER)2)
#define FIT_LAP_TRIGGER_POSITION_START                                           ((FIT_LAP_TRIGGER)3)
#define FIT_LAP_TRIGGER_POSITION_LAP                                             ((FIT_LAP_TRIGGER)4)
#define FIT_LAP_TRIGGER_POSITION_WAYPOINT                                        ((FIT_LAP_TRIGGER)5)
#define FIT_LAP_TRIGGER_POSITION_MARKED                                          ((FIT_LAP_TRIGGER)6)
#define FIT_LAP_TRIGGER_SESSION_END                                              ((FIT_LAP_TRIGGER)7)
#define FIT_LAP_TRIGGER_FITNESS_EQUIPMENT                                        ((FIT_LAP_TRIGGER)8)
#define FIT_LAP_TRIGGER_COUNT                                                    9

typedef FIT_ENUM FIT_TIME_MODE;
#define FIT_TIME_MODE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_TIME_MODE_HOUR12                                                     ((FIT_TIME_MODE)0)
#define FIT_TIME_MODE_HOUR24                                                     ((FIT_TIME_MODE)1) // Does not use a leading zero and has a colon
#define FIT_TIME_MODE_MILITARY                                                   ((FIT_TIME_MODE)2) // Uses a leading zero and does not have a colon
#define FIT_TIME_MODE_HOUR_12_WITH_SECONDS                                       ((FIT_TIME_MODE)3)
#define FIT_TIME_MODE_HOUR_24_WITH_SECONDS                                       ((FIT_TIME_MODE)4)
#define FIT_TIME_MODE_UTC                                                        ((FIT_TIME_MODE)5)
#define FIT_TIME_MODE_COUNT                                                      6

typedef FIT_ENUM FIT_BACKLIGHT_MODE;
#define FIT_BACKLIGHT_MODE_INVALID                                               FIT_ENUM_INVALID
#define FIT_BACKLIGHT_MODE_OFF                                                   ((FIT_BACKLIGHT_MODE)0)
#define FIT_BACKLIGHT_MODE_MANUAL                                                ((FIT_BACKLIGHT_MODE)1)
#define FIT_BACKLIGHT_MODE_KEY_AND_MESSAGES                                      ((FIT_BACKLIGHT_MODE)2)
#define FIT_BACKLIGHT_MODE_AUTO_BRIGHTNESS                                       ((FIT_BACKLIGHT_MODE)3)
#define FIT_BACKLIGHT_MODE_SMART_NOTIFICATIONS                                   ((FIT_BACKLIGHT_MODE)4)
#define FIT_BACKLIGHT_MODE_KEY_AND_MESSAGES_NIGHT                                ((FIT_BACKLIGHT_MODE)5)
#define FIT_BACKLIGHT_MODE_KEY_AND_MESSAGES_AND_SMART_NOTIFICATIONS              ((FIT_BACKLIGHT_MODE)6)
#define FIT_BACKLIGHT_MODE_COUNT                                                 7

typedef FIT_ENUM FIT_DATE_MODE;
#define FIT_DATE_MODE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_DATE_MODE_DAY_MONTH                                                  ((FIT_DATE_MODE)0)
#define FIT_DATE_MODE_MONTH_DAY                                                  ((FIT_DATE_MODE)1)
#define FIT_DATE_MODE_COUNT                                                      2

typedef FIT_ENUM FIT_EVENT;
#define FIT_EVENT_INVALID                                                        FIT_ENUM_INVALID
#define FIT_EVENT_TIMER                                                          ((FIT_EVENT)0) // Group 0.  Start / stop_all
#define FIT_EVENT_WORKOUT                                                        ((FIT_EVENT)3) // start / stop
#define FIT_EVENT_WORKOUT_STEP                                                   ((FIT_EVENT)4) // Start at beginning of workout.  Stop at end of each step.
#define FIT_EVENT_POWER_DOWN                                                     ((FIT_EVENT)5) // stop_all group 0
#define FIT_EVENT_POWER_UP                                                       ((FIT_EVENT)6) // stop_all group 0
#define FIT_EVENT_OFF_COURSE                                                     ((FIT_EVENT)7) // start / stop group 0
#define FIT_EVENT_SESSION                                                        ((FIT_EVENT)8) // Stop at end of each session.
#define FIT_EVENT_LAP                                                            ((FIT_EVENT)9) // Stop at end of each lap.
#define FIT_EVENT_COURSE_POINT                                                   ((FIT_EVENT)10) // marker
#define FIT_EVENT_BATTERY                                                        ((FIT_EVENT)11) // marker
#define FIT_EVENT_VIRTUAL_PARTNER_PACE                                           ((FIT_EVENT)12) // Group 1. Start at beginning of activity if VP enabled, when VP pace is changed during activity or VP enabled mid activity.  stop_disable when VP disabled.
#define FIT_EVENT_HR_HIGH_ALERT                                                  ((FIT_EVENT)13) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_HR_LOW_ALERT                                                   ((FIT_EVENT)14) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_SPEED_HIGH_ALERT                                               ((FIT_EVENT)15) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_SPEED_LOW_ALERT                                                ((FIT_EVENT)16) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_CAD_HIGH_ALERT                                                 ((FIT_EVENT)17) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_CAD_LOW_ALERT                                                  ((FIT_EVENT)18) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_POWER_HIGH_ALERT                                               ((FIT_EVENT)19) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_POWER_LOW_ALERT                                                ((FIT_EVENT)20) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_RECOVERY_HR                                                    ((FIT_EVENT)21) // marker
#define FIT_EVENT_BATTERY_LOW                                                    ((FIT_EVENT)22) // marker
#define FIT_EVENT_TIME_DURATION_ALERT                                            ((FIT_EVENT)23) // Group 1.  Start if enabled mid activity (not required at start of activity). Stop when duration is reached.  stop_disable if disabled.
#define FIT_EVENT_DISTANCE_DURATION_ALERT                                        ((FIT_EVENT)24) // Group 1.  Start if enabled mid activity (not required at start of activity). Stop when duration is reached.  stop_disable if disabled.
#define FIT_EVENT_CALORIE_DURATION_ALERT                                         ((FIT_EVENT)25) // Group 1.  Start if enabled mid activity (not required at start of activity). Stop when duration is reached.  stop_disable if disabled.
#define FIT_EVENT_ACTIVITY                                                       ((FIT_EVENT)26) // Group 1..  Stop at end of activity.
#define FIT_EVENT_FITNESS_EQUIPMENT                                              ((FIT_EVENT)27) // marker
#define FIT_EVENT_LENGTH                                                         ((FIT_EVENT)28) // Stop at end of each length.
#define FIT_EVENT_USER_MARKER                                                    ((FIT_EVENT)32) // marker
#define FIT_EVENT_SPORT_POINT                                                    ((FIT_EVENT)33) // marker
#define FIT_EVENT_CALIBRATION                                                    ((FIT_EVENT)36) // start/stop/marker
#define FIT_EVENT_FRONT_GEAR_CHANGE                                              ((FIT_EVENT)42) // marker
#define FIT_EVENT_REAR_GEAR_CHANGE                                               ((FIT_EVENT)43) // marker
#define FIT_EVENT_RIDER_POSITION_CHANGE                                          ((FIT_EVENT)44) // marker
#define FIT_EVENT_ELEV_HIGH_ALERT                                                ((FIT_EVENT)45) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_ELEV_LOW_ALERT                                                 ((FIT_EVENT)46) // Group 0.  Start / stop when in alert condition.
#define FIT_EVENT_COMM_TIMEOUT                                                   ((FIT_EVENT)47) // marker
#define FIT_EVENT_COUNT                                                          36

typedef FIT_ENUM FIT_EVENT_TYPE;
#define FIT_EVENT_TYPE_INVALID                                                   FIT_ENUM_INVALID
#define FIT_EVENT_TYPE_START                                                     ((FIT_EVENT_TYPE)0)
#define FIT_EVENT_TYPE_STOP                                                      ((FIT_EVENT_TYPE)1)
#define FIT_EVENT_TYPE_CONSECUTIVE_DEPRECIATED                                   ((FIT_EVENT_TYPE)2)
#define FIT_EVENT_TYPE_MARKER                                                    ((FIT_EVENT_TYPE)3)
#define FIT_EVENT_TYPE_STOP_ALL                                                  ((FIT_EVENT_TYPE)4)
#define FIT_EVENT_TYPE_BEGIN_DEPRECIATED                                         ((FIT_EVENT_TYPE)5)
#define FIT_EVENT_TYPE_END_DEPRECIATED                                           ((FIT_EVENT_TYPE)6)
#define FIT_EVENT_TYPE_END_ALL_DEPRECIATED                                       ((FIT_EVENT_TYPE)7)
#define FIT_EVENT_TYPE_STOP_DISABLE                                              ((FIT_EVENT_TYPE)8)
#define FIT_EVENT_TYPE_STOP_DISABLE_ALL                                          ((FIT_EVENT_TYPE)9)
#define FIT_EVENT_TYPE_COUNT                                                     10

typedef FIT_ENUM FIT_TIMER_TRIGGER; // timer event data
#define FIT_TIMER_TRIGGER_INVALID                                                FIT_ENUM_INVALID
#define FIT_TIMER_TRIGGER_MANUAL                                                 ((FIT_TIMER_TRIGGER)0)
#define FIT_TIMER_TRIGGER_AUTO                                                   ((FIT_TIMER_TRIGGER)1)
#define FIT_TIMER_TRIGGER_FITNESS_EQUIPMENT                                      ((FIT_TIMER_TRIGGER)2)
#define FIT_TIMER_TRIGGER_COUNT                                                  3

typedef FIT_ENUM FIT_FITNESS_EQUIPMENT_STATE; // fitness equipment event data
#define FIT_FITNESS_EQUIPMENT_STATE_INVALID                                      FIT_ENUM_INVALID
#define FIT_FITNESS_EQUIPMENT_STATE_READY                                        ((FIT_FITNESS_EQUIPMENT_STATE)0)
#define FIT_FITNESS_EQUIPMENT_STATE_IN_USE                                       ((FIT_FITNESS_EQUIPMENT_STATE)1)
#define FIT_FITNESS_EQUIPMENT_STATE_PAUSED                                       ((FIT_FITNESS_EQUIPMENT_STATE)2)
#define FIT_FITNESS_EQUIPMENT_STATE_UNKNOWN                                      ((FIT_FITNESS_EQUIPMENT_STATE)3) // lost connection to fitness equipment
#define FIT_FITNESS_EQUIPMENT_STATE_COUNT                                        4

typedef FIT_ENUM FIT_AUTOSCROLL;
#define FIT_AUTOSCROLL_INVALID                                                   FIT_ENUM_INVALID
#define FIT_AUTOSCROLL_NONE                                                      ((FIT_AUTOSCROLL)0)
#define FIT_AUTOSCROLL_SLOW                                                      ((FIT_AUTOSCROLL)1)
#define FIT_AUTOSCROLL_MEDIUM                                                    ((FIT_AUTOSCROLL)2)
#define FIT_AUTOSCROLL_FAST                                                      ((FIT_AUTOSCROLL)3)
#define FIT_AUTOSCROLL_COUNT                                                     4

typedef FIT_ENUM FIT_ACTIVITY_CLASS;
#define FIT_ACTIVITY_CLASS_INVALID                                               FIT_ENUM_INVALID
#define FIT_ACTIVITY_CLASS_LEVEL                                                 ((FIT_ACTIVITY_CLASS)0x7F) // 0 to 100
#define FIT_ACTIVITY_CLASS_LEVEL_MAX                                             ((FIT_ACTIVITY_CLASS)100)
#define FIT_ACTIVITY_CLASS_ATHLETE                                               ((FIT_ACTIVITY_CLASS)0x80)
#define FIT_ACTIVITY_CLASS_COUNT                                                 3

typedef FIT_ENUM FIT_HR_ZONE_CALC;
#define FIT_HR_ZONE_CALC_INVALID                                                 FIT_ENUM_INVALID
#define FIT_HR_ZONE_CALC_CUSTOM                                                  ((FIT_HR_ZONE_CALC)0)
#define FIT_HR_ZONE_CALC_PERCENT_MAX_HR                                          ((FIT_HR_ZONE_CALC)1)
#define FIT_HR_ZONE_CALC_PERCENT_HRR                                             ((FIT_HR_ZONE_CALC)2)
#define FIT_HR_ZONE_CALC_COUNT                                                   3

typedef FIT_ENUM FIT_PWR_ZONE_CALC;
#define FIT_PWR_ZONE_CALC_INVALID                                                FIT_ENUM_INVALID
#define FIT_PWR_ZONE_CALC_CUSTOM                                                 ((FIT_PWR_ZONE_CALC)0)
#define FIT_PWR_ZONE_CALC_PERCENT_FTP                                            ((FIT_PWR_ZONE_CALC)1)
#define FIT_PWR_ZONE_CALC_COUNT                                                  2

typedef FIT_ENUM FIT_WKT_STEP_DURATION;
#define FIT_WKT_STEP_DURATION_INVALID                                            FIT_ENUM_INVALID
#define FIT_WKT_STEP_DURATION_TIME                                               ((FIT_WKT_STEP_DURATION)0)
#define FIT_WKT_STEP_DURATION_DISTANCE                                           ((FIT_WKT_STEP_DURATION)1)
#define FIT_WKT_STEP_DURATION_HR_LESS_THAN                                       ((FIT_WKT_STEP_DURATION)2)
#define FIT_WKT_STEP_DURATION_HR_GREATER_THAN                                    ((FIT_WKT_STEP_DURATION)3)
#define FIT_WKT_STEP_DURATION_CALORIES                                           ((FIT_WKT_STEP_DURATION)4)
#define FIT_WKT_STEP_DURATION_OPEN                                               ((FIT_WKT_STEP_DURATION)5)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_STEPS_CMPLT                           ((FIT_WKT_STEP_DURATION)6)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_TIME                                  ((FIT_WKT_STEP_DURATION)7)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_DISTANCE                              ((FIT_WKT_STEP_DURATION)8)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_CALORIES                              ((FIT_WKT_STEP_DURATION)9)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_HR_LESS_THAN                          ((FIT_WKT_STEP_DURATION)10)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_HR_GREATER_THAN                       ((FIT_WKT_STEP_DURATION)11)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_POWER_LESS_THAN                       ((FIT_WKT_STEP_DURATION)12)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_POWER_GREATER_THAN                    ((FIT_WKT_STEP_DURATION)13)
#define FIT_WKT_STEP_DURATION_POWER_LESS_THAN                                    ((FIT_WKT_STEP_DURATION)14)
#define FIT_WKT_STEP_DURATION_POWER_GREATER_THAN                                 ((FIT_WKT_STEP_DURATION)15)
#define FIT_WKT_STEP_DURATION_TRAINING_PEAKS_TSS                                 ((FIT_WKT_STEP_DURATION)16)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_POWER_LAST_LAP_LESS_THAN              ((FIT_WKT_STEP_DURATION)17)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_MAX_POWER_LAST_LAP_LESS_THAN          ((FIT_WKT_STEP_DURATION)18)
#define FIT_WKT_STEP_DURATION_POWER_3S_LESS_THAN                                 ((FIT_WKT_STEP_DURATION)19)
#define FIT_WKT_STEP_DURATION_POWER_10S_LESS_THAN                                ((FIT_WKT_STEP_DURATION)20)
#define FIT_WKT_STEP_DURATION_POWER_30S_LESS_THAN                                ((FIT_WKT_STEP_DURATION)21)
#define FIT_WKT_STEP_DURATION_POWER_3S_GREATER_THAN                              ((FIT_WKT_STEP_DURATION)22)
#define FIT_WKT_STEP_DURATION_POWER_10S_GREATER_THAN                             ((FIT_WKT_STEP_DURATION)23)
#define FIT_WKT_STEP_DURATION_POWER_30S_GREATER_THAN                             ((FIT_WKT_STEP_DURATION)24)
#define FIT_WKT_STEP_DURATION_POWER_LAP_LESS_THAN                                ((FIT_WKT_STEP_DURATION)25)
#define FIT_WKT_STEP_DURATION_POWER_LAP_GREATER_THAN                             ((FIT_WKT_STEP_DURATION)26)
#define FIT_WKT_STEP_DURATION_REPEAT_UNTIL_TRAINING_PEAKS_TSS                    ((FIT_WKT_STEP_DURATION)27)
#define FIT_WKT_STEP_DURATION_REPETITION_TIME                                    ((FIT_WKT_STEP_DURATION)28)
#define FIT_WKT_STEP_DURATION_COUNT                                              29

typedef FIT_ENUM FIT_WKT_STEP_TARGET;
#define FIT_WKT_STEP_TARGET_INVALID                                              FIT_ENUM_INVALID
#define FIT_WKT_STEP_TARGET_SPEED                                                ((FIT_WKT_STEP_TARGET)0)
#define FIT_WKT_STEP_TARGET_HEART_RATE                                           ((FIT_WKT_STEP_TARGET)1)
#define FIT_WKT_STEP_TARGET_OPEN                                                 ((FIT_WKT_STEP_TARGET)2)
#define FIT_WKT_STEP_TARGET_CADENCE                                              ((FIT_WKT_STEP_TARGET)3)
#define FIT_WKT_STEP_TARGET_POWER                                                ((FIT_WKT_STEP_TARGET)4)
#define FIT_WKT_STEP_TARGET_GRADE                                                ((FIT_WKT_STEP_TARGET)5)
#define FIT_WKT_STEP_TARGET_RESISTANCE                                           ((FIT_WKT_STEP_TARGET)6)
#define FIT_WKT_STEP_TARGET_POWER_3S                                             ((FIT_WKT_STEP_TARGET)7)
#define FIT_WKT_STEP_TARGET_POWER_10S                                            ((FIT_WKT_STEP_TARGET)8)
#define FIT_WKT_STEP_TARGET_POWER_30S                                            ((FIT_WKT_STEP_TARGET)9)
#define FIT_WKT_STEP_TARGET_POWER_LAP                                            ((FIT_WKT_STEP_TARGET)10)
#define FIT_WKT_STEP_TARGET_SWIM_STROKE                                          ((FIT_WKT_STEP_TARGET)11)
#define FIT_WKT_STEP_TARGET_SPEED_LAP                                            ((FIT_WKT_STEP_TARGET)12)
#define FIT_WKT_STEP_TARGET_HEART_RATE_LAP                                       ((FIT_WKT_STEP_TARGET)13)
#define FIT_WKT_STEP_TARGET_COUNT                                                14

typedef FIT_ENUM FIT_GOAL;
#define FIT_GOAL_INVALID                                                         FIT_ENUM_INVALID
#define FIT_GOAL_TIME                                                            ((FIT_GOAL)0)
#define FIT_GOAL_DISTANCE                                                        ((FIT_GOAL)1)
#define FIT_GOAL_CALORIES                                                        ((FIT_GOAL)2)
#define FIT_GOAL_FREQUENCY                                                       ((FIT_GOAL)3)
#define FIT_GOAL_STEPS                                                           ((FIT_GOAL)4)
#define FIT_GOAL_ASCENT                                                          ((FIT_GOAL)5)
#define FIT_GOAL_ACTIVE_MINUTES                                                  ((FIT_GOAL)6)
#define FIT_GOAL_COUNT                                                           7

typedef FIT_ENUM FIT_GOAL_RECURRENCE;
#define FIT_GOAL_RECURRENCE_INVALID                                              FIT_ENUM_INVALID
#define FIT_GOAL_RECURRENCE_OFF                                                  ((FIT_GOAL_RECURRENCE)0)
#define FIT_GOAL_RECURRENCE_DAILY                                                ((FIT_GOAL_RECURRENCE)1)
#define FIT_GOAL_RECURRENCE_WEEKLY                                               ((FIT_GOAL_RECURRENCE)2)
#define FIT_GOAL_RECURRENCE_MONTHLY                                              ((FIT_GOAL_RECURRENCE)3)
#define FIT_GOAL_RECURRENCE_YEARLY                                               ((FIT_GOAL_RECURRENCE)4)
#define FIT_GOAL_RECURRENCE_CUSTOM                                               ((FIT_GOAL_RECURRENCE)5)
#define FIT_GOAL_RECURRENCE_COUNT                                                6

typedef FIT_ENUM FIT_GOAL_SOURCE;
#define FIT_GOAL_SOURCE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_GOAL_SOURCE_AUTO                                                     ((FIT_GOAL_SOURCE)0) // Device generated
#define FIT_GOAL_SOURCE_COMMUNITY                                                ((FIT_GOAL_SOURCE)1) // Social network sourced goal
#define FIT_GOAL_SOURCE_USER                                                     ((FIT_GOAL_SOURCE)2) // Manually generated
#define FIT_GOAL_SOURCE_COUNT                                                    3

typedef FIT_ENUM FIT_SCHEDULE;
#define FIT_SCHEDULE_INVALID                                                     FIT_ENUM_INVALID
#define FIT_SCHEDULE_WORKOUT                                                     ((FIT_SCHEDULE)0)
#define FIT_SCHEDULE_COURSE                                                      ((FIT_SCHEDULE)1)
#define FIT_SCHEDULE_COUNT                                                       2

typedef FIT_ENUM FIT_COURSE_POINT;
#define FIT_COURSE_POINT_INVALID                                                 FIT_ENUM_INVALID
#define FIT_COURSE_POINT_GENERIC                                                 ((FIT_COURSE_POINT)0)
#define FIT_COURSE_POINT_SUMMIT                                                  ((FIT_COURSE_POINT)1)
#define FIT_COURSE_POINT_VALLEY                                                  ((FIT_COURSE_POINT)2)
#define FIT_COURSE_POINT_WATER                                                   ((FIT_COURSE_POINT)3)
#define FIT_COURSE_POINT_FOOD                                                    ((FIT_COURSE_POINT)4)
#define FIT_COURSE_POINT_DANGER                                                  ((FIT_COURSE_POINT)5)
#define FIT_COURSE_POINT_LEFT                                                    ((FIT_COURSE_POINT)6)
#define FIT_COURSE_POINT_RIGHT                                                   ((FIT_COURSE_POINT)7)
#define FIT_COURSE_POINT_STRAIGHT                                                ((FIT_COURSE_POINT)8)
#define FIT_COURSE_POINT_FIRST_AID                                               ((FIT_COURSE_POINT)9)
#define FIT_COURSE_POINT_FOURTH_CATEGORY                                         ((FIT_COURSE_POINT)10)
#define FIT_COURSE_POINT_THIRD_CATEGORY                                          ((FIT_COURSE_POINT)11)
#define FIT_COURSE_POINT_SECOND_CATEGORY                                         ((FIT_COURSE_POINT)12)
#define FIT_COURSE_POINT_FIRST_CATEGORY                                          ((FIT_COURSE_POINT)13)
#define FIT_COURSE_POINT_HORS_CATEGORY                                           ((FIT_COURSE_POINT)14)
#define FIT_COURSE_POINT_SPRINT                                                  ((FIT_COURSE_POINT)15)
#define FIT_COURSE_POINT_LEFT_FORK                                               ((FIT_COURSE_POINT)16)
#define FIT_COURSE_POINT_RIGHT_FORK                                              ((FIT_COURSE_POINT)17)
#define FIT_COURSE_POINT_MIDDLE_FORK                                             ((FIT_COURSE_POINT)18)
#define FIT_COURSE_POINT_SLIGHT_LEFT                                             ((FIT_COURSE_POINT)19)
#define FIT_COURSE_POINT_SHARP_LEFT                                              ((FIT_COURSE_POINT)20)
#define FIT_COURSE_POINT_SLIGHT_RIGHT                                            ((FIT_COURSE_POINT)21)
#define FIT_COURSE_POINT_SHARP_RIGHT                                             ((FIT_COURSE_POINT)22)
#define FIT_COURSE_POINT_U_TURN                                                  ((FIT_COURSE_POINT)23)
#define FIT_COURSE_POINT_SEGMENT_START                                           ((FIT_COURSE_POINT)24)
#define FIT_COURSE_POINT_SEGMENT_END                                             ((FIT_COURSE_POINT)25)
#define FIT_COURSE_POINT_COUNT                                                   26

typedef FIT_UINT16 FIT_MANUFACTURER;
#define FIT_MANUFACTURER_INVALID                                                 FIT_UINT16_INVALID
#define FIT_MANUFACTURER_GARMIN                                                  ((FIT_MANUFACTURER)1)
#define FIT_MANUFACTURER_GARMIN_FR405_ANTFS                                      ((FIT_MANUFACTURER)2) // Do not use.  Used by FR405 for ANTFS man id.
#define FIT_MANUFACTURER_ZEPHYR                                                  ((FIT_MANUFACTURER)3)
#define FIT_MANUFACTURER_DAYTON                                                  ((FIT_MANUFACTURER)4)
#define FIT_MANUFACTURER_IDT                                                     ((FIT_MANUFACTURER)5)
#define FIT_MANUFACTURER_SRM                                                     ((FIT_MANUFACTURER)6)
#define FIT_MANUFACTURER_QUARQ                                                   ((FIT_MANUFACTURER)7)
#define FIT_MANUFACTURER_IBIKE                                                   ((FIT_MANUFACTURER)8)
#define FIT_MANUFACTURER_SARIS                                                   ((FIT_MANUFACTURER)9)
#define FIT_MANUFACTURER_SPARK_HK                                                ((FIT_MANUFACTURER)10)
#define FIT_MANUFACTURER_TANITA                                                  ((FIT_MANUFACTURER)11)
#define FIT_MANUFACTURER_ECHOWELL                                                ((FIT_MANUFACTURER)12)
#define FIT_MANUFACTURER_DYNASTREAM_OEM                                          ((FIT_MANUFACTURER)13)
#define FIT_MANUFACTURER_NAUTILUS                                                ((FIT_MANUFACTURER)14)
#define FIT_MANUFACTURER_DYNASTREAM                                              ((FIT_MANUFACTURER)15)
#define FIT_MANUFACTURER_TIMEX                                                   ((FIT_MANUFACTURER)16)
#define FIT_MANUFACTURER_METRIGEAR                                               ((FIT_MANUFACTURER)17)
#define FIT_MANUFACTURER_XELIC                                                   ((FIT_MANUFACTURER)18)
#define FIT_MANUFACTURER_BEURER                                                  ((FIT_MANUFACTURER)19)
#define FIT_MANUFACTURER_CARDIOSPORT                                             ((FIT_MANUFACTURER)20)
#define FIT_MANUFACTURER_A_AND_D                                                 ((FIT_MANUFACTURER)21)
#define FIT_MANUFACTURER_HMM                                                     ((FIT_MANUFACTURER)22)
#define FIT_MANUFACTURER_SUUNTO                                                  ((FIT_MANUFACTURER)23)
#define FIT_MANUFACTURER_THITA_ELEKTRONIK                                        ((FIT_MANUFACTURER)24)
#define FIT_MANUFACTURER_GPULSE                                                  ((FIT_MANUFACTURER)25)
#define FIT_MANUFACTURER_CLEAN_MOBILE                                            ((FIT_MANUFACTURER)26)
#define FIT_MANUFACTURER_PEDAL_BRAIN                                             ((FIT_MANUFACTURER)27)
#define FIT_MANUFACTURER_PEAKSWARE                                               ((FIT_MANUFACTURER)28)
#define FIT_MANUFACTURER_SAXONAR                                                 ((FIT_MANUFACTURER)29)
#define FIT_MANUFACTURER_LEMOND_FITNESS                                          ((FIT_MANUFACTURER)30)
#define FIT_MANUFACTURER_DEXCOM                                                  ((FIT_MANUFACTURER)31)
#define FIT_MANUFACTURER_WAHOO_FITNESS                                           ((FIT_MANUFACTURER)32)
#define FIT_MANUFACTURER_OCTANE_FITNESS                                          ((FIT_MANUFACTURER)33)
#define FIT_MANUFACTURER_ARCHINOETICS                                            ((FIT_MANUFACTURER)34)
#define FIT_MANUFACTURER_THE_HURT_BOX                                            ((FIT_MANUFACTURER)35)
#define FIT_MANUFACTURER_CITIZEN_SYSTEMS                                         ((FIT_MANUFACTURER)36)
#define FIT_MANUFACTURER_MAGELLAN                                                ((FIT_MANUFACTURER)37)
#define FIT_MANUFACTURER_OSYNCE                                                  ((FIT_MANUFACTURER)38)
#define FIT_MANUFACTURER_HOLUX                                                   ((FIT_MANUFACTURER)39)
#define FIT_MANUFACTURER_CONCEPT2                                                ((FIT_MANUFACTURER)40)
#define FIT_MANUFACTURER_ONE_GIANT_LEAP                                          ((FIT_MANUFACTURER)42)
#define FIT_MANUFACTURER_ACE_SENSOR                                              ((FIT_MANUFACTURER)43)
#define FIT_MANUFACTURER_BRIM_BROTHERS                                           ((FIT_MANUFACTURER)44)
#define FIT_MANUFACTURER_XPLOVA                                                  ((FIT_MANUFACTURER)45)
#define FIT_MANUFACTURER_PERCEPTION_DIGITAL                                      ((FIT_MANUFACTURER)46)
#define FIT_MANUFACTURER_BF1SYSTEMS                                              ((FIT_MANUFACTURER)47)
#define FIT_MANUFACTURER_PIONEER                                                 ((FIT_MANUFACTURER)48)
#define FIT_MANUFACTURER_SPANTEC                                                 ((FIT_MANUFACTURER)49)
#define FIT_MANUFACTURER_METALOGICS                                              ((FIT_MANUFACTURER)50)
#define FIT_MANUFACTURER_4IIIIS                                                  ((FIT_MANUFACTURER)51)
#define FIT_MANUFACTURER_SEIKO_EPSON                                             ((FIT_MANUFACTURER)52)
#define FIT_MANUFACTURER_SEIKO_EPSON_OEM                                         ((FIT_MANUFACTURER)53)
#define FIT_MANUFACTURER_IFOR_POWELL                                             ((FIT_MANUFACTURER)54)
#define FIT_MANUFACTURER_MAXWELL_GUIDER                                          ((FIT_MANUFACTURER)55)
#define FIT_MANUFACTURER_STAR_TRAC                                               ((FIT_MANUFACTURER)56)
#define FIT_MANUFACTURER_BREAKAWAY                                               ((FIT_MANUFACTURER)57)
#define FIT_MANUFACTURER_ALATECH_TECHNOLOGY_LTD                                  ((FIT_MANUFACTURER)58)
#define FIT_MANUFACTURER_MIO_TECHNOLOGY_EUROPE                                   ((FIT_MANUFACTURER)59)
#define FIT_MANUFACTURER_ROTOR                                                   ((FIT_MANUFACTURER)60)
#define FIT_MANUFACTURER_GEONAUTE                                                ((FIT_MANUFACTURER)61)
#define FIT_MANUFACTURER_ID_BIKE                                                 ((FIT_MANUFACTURER)62)
#define FIT_MANUFACTURER_SPECIALIZED                                             ((FIT_MANUFACTURER)63)
#define FIT_MANUFACTURER_WTEK                                                    ((FIT_MANUFACTURER)64)
#define FIT_MANUFACTURER_PHYSICAL_ENTERPRISES                                    ((FIT_MANUFACTURER)65)
#define FIT_MANUFACTURER_NORTH_POLE_ENGINEERING                                  ((FIT_MANUFACTURER)66)
#define FIT_MANUFACTURER_BKOOL                                                   ((FIT_MANUFACTURER)67)
#define FIT_MANUFACTURER_CATEYE                                                  ((FIT_MANUFACTURER)68)
#define FIT_MANUFACTURER_STAGES_CYCLING                                          ((FIT_MANUFACTURER)69)
#define FIT_MANUFACTURER_SIGMASPORT                                              ((FIT_MANUFACTURER)70)
#define FIT_MANUFACTURER_TOMTOM                                                  ((FIT_MANUFACTURER)71)
#define FIT_MANUFACTURER_PERIPEDAL                                               ((FIT_MANUFACTURER)72)
#define FIT_MANUFACTURER_WATTBIKE                                                ((FIT_MANUFACTURER)73)
#define FIT_MANUFACTURER_MOXY                                                    ((FIT_MANUFACTURER)76)
#define FIT_MANUFACTURER_CICLOSPORT                                              ((FIT_MANUFACTURER)77)
#define FIT_MANUFACTURER_POWERBAHN                                               ((FIT_MANUFACTURER)78)
#define FIT_MANUFACTURER_ACORN_PROJECTS_APS                                      ((FIT_MANUFACTURER)79)
#define FIT_MANUFACTURER_LIFEBEAM                                                ((FIT_MANUFACTURER)80)
#define FIT_MANUFACTURER_BONTRAGER                                               ((FIT_MANUFACTURER)81)
#define FIT_MANUFACTURER_WELLGO                                                  ((FIT_MANUFACTURER)82)
#define FIT_MANUFACTURER_SCOSCHE                                                 ((FIT_MANUFACTURER)83)
#define FIT_MANUFACTURER_MAGURA                                                  ((FIT_MANUFACTURER)84)
#define FIT_MANUFACTURER_WOODWAY                                                 ((FIT_MANUFACTURER)85)
#define FIT_MANUFACTURER_ELITE                                                   ((FIT_MANUFACTURER)86)
#define FIT_MANUFACTURER_NIELSEN_KELLERMAN                                       ((FIT_MANUFACTURER)87)
#define FIT_MANUFACTURER_DK_CITY                                                 ((FIT_MANUFACTURER)88)
#define FIT_MANUFACTURER_TACX                                                    ((FIT_MANUFACTURER)89)
#define FIT_MANUFACTURER_DIRECTION_TECHNOLOGY                                    ((FIT_MANUFACTURER)90)
#define FIT_MANUFACTURER_MAGTONIC                                                ((FIT_MANUFACTURER)91)
#define FIT_MANUFACTURER_1PARTCARBON                                             ((FIT_MANUFACTURER)92)
#define FIT_MANUFACTURER_INSIDE_RIDE_TECHNOLOGIES                                ((FIT_MANUFACTURER)93)
#define FIT_MANUFACTURER_SOUND_OF_MOTION                                         ((FIT_MANUFACTURER)94)
#define FIT_MANUFACTURER_STRYD                                                   ((FIT_MANUFACTURER)95)
#define FIT_MANUFACTURER_ICG                                                     ((FIT_MANUFACTURER)96) // Indoorcycling Group
#define FIT_MANUFACTURER_MIPULSE                                                 ((FIT_MANUFACTURER)97)
#define FIT_MANUFACTURER_BSX_ATHLETICS                                           ((FIT_MANUFACTURER)98)
#define FIT_MANUFACTURER_LOOK                                                    ((FIT_MANUFACTURER)99)
#define FIT_MANUFACTURER_CAMPAGNOLO_SRL                                          ((FIT_MANUFACTURER)100)
#define FIT_MANUFACTURER_BODY_BIKE_SMART                                         ((FIT_MANUFACTURER)101)
#define FIT_MANUFACTURER_PRAXISWORKS                                             ((FIT_MANUFACTURER)102)
#define FIT_MANUFACTURER_LIMITS_TECHNOLOGY                                       ((FIT_MANUFACTURER)103) // Limits Technology Ltd.
#define FIT_MANUFACTURER_TOPACTION_TECHNOLOGY                                    ((FIT_MANUFACTURER)104) // TopAction Technology Inc.
#define FIT_MANUFACTURER_COSINUSS                                                ((FIT_MANUFACTURER)105)
#define FIT_MANUFACTURER_FITCARE                                                 ((FIT_MANUFACTURER)106)
#define FIT_MANUFACTURER_MAGENE                                                  ((FIT_MANUFACTURER)107)
#define FIT_MANUFACTURER_GIANT_MANUFACTURING_CO                                  ((FIT_MANUFACTURER)108)
#define FIT_MANUFACTURER_TIGRASPORT                                              ((FIT_MANUFACTURER)109) // Tigrasport
#define FIT_MANUFACTURER_SALUTRON                                                ((FIT_MANUFACTURER)110)
#define FIT_MANUFACTURER_TECHNOGYM                                               ((FIT_MANUFACTURER)111)
#define FIT_MANUFACTURER_BRYTON_SENSORS                                          ((FIT_MANUFACTURER)112)
#define FIT_MANUFACTURER_LATITUDE_LIMITED                                        ((FIT_MANUFACTURER)113)
#define FIT_MANUFACTURER_DEVELOPMENT                                             ((FIT_MANUFACTURER)255)
#define FIT_MANUFACTURER_HEALTHANDLIFE                                           ((FIT_MANUFACTURER)257)
#define FIT_MANUFACTURER_LEZYNE                                                  ((FIT_MANUFACTURER)258)
#define FIT_MANUFACTURER_SCRIBE_LABS                                             ((FIT_MANUFACTURER)259)
#define FIT_MANUFACTURER_ZWIFT                                                   ((FIT_MANUFACTURER)260)
#define FIT_MANUFACTURER_WATTEAM                                                 ((FIT_MANUFACTURER)261)
#define FIT_MANUFACTURER_RECON                                                   ((FIT_MANUFACTURER)262)
#define FIT_MANUFACTURER_FAVERO_ELECTRONICS                                      ((FIT_MANUFACTURER)263)
#define FIT_MANUFACTURER_DYNOVELO                                                ((FIT_MANUFACTURER)264)
#define FIT_MANUFACTURER_STRAVA                                                  ((FIT_MANUFACTURER)265)
#define FIT_MANUFACTURER_PRECOR                                                  ((FIT_MANUFACTURER)266) // Amer Sports
#define FIT_MANUFACTURER_BRYTON                                                  ((FIT_MANUFACTURER)267)
#define FIT_MANUFACTURER_SRAM                                                    ((FIT_MANUFACTURER)268)
#define FIT_MANUFACTURER_NAVMAN                                                  ((FIT_MANUFACTURER)269) // MiTAC Global Corporation (Mio Technology)
#define FIT_MANUFACTURER_COBI                                                    ((FIT_MANUFACTURER)270) // COBI GmbH
#define FIT_MANUFACTURER_SPIVI                                                   ((FIT_MANUFACTURER)271)
#define FIT_MANUFACTURER_MIO_MAGELLAN                                            ((FIT_MANUFACTURER)272)
#define FIT_MANUFACTURER_EVESPORTS                                               ((FIT_MANUFACTURER)273)
#define FIT_MANUFACTURER_SENSITIVUS_GAUGE                                        ((FIT_MANUFACTURER)274)
#define FIT_MANUFACTURER_PODOON                                                  ((FIT_MANUFACTURER)275)
#define FIT_MANUFACTURER_LIFE_TIME_FITNESS                                       ((FIT_MANUFACTURER)276)
#define FIT_MANUFACTURER_FALCO_E_MOTORS                                          ((FIT_MANUFACTURER)277) // Falco eMotors Inc.
#define FIT_MANUFACTURER_MINOURA                                                 ((FIT_MANUFACTURER)278)
#define FIT_MANUFACTURER_ACTIGRAPHCORP                                           ((FIT_MANUFACTURER)5759)
#define FIT_MANUFACTURER_COUNT                                                   134

typedef FIT_UINT16 FIT_GARMIN_PRODUCT;
#define FIT_GARMIN_PRODUCT_INVALID                                               FIT_UINT16_INVALID
#define FIT_GARMIN_PRODUCT_HRM1                                                  ((FIT_GARMIN_PRODUCT)1)
#define FIT_GARMIN_PRODUCT_AXH01                                                 ((FIT_GARMIN_PRODUCT)2) // AXH01 HRM chipset
#define FIT_GARMIN_PRODUCT_AXB01                                                 ((FIT_GARMIN_PRODUCT)3)
#define FIT_GARMIN_PRODUCT_AXB02                                                 ((FIT_GARMIN_PRODUCT)4)
#define FIT_GARMIN_PRODUCT_HRM2SS                                                ((FIT_GARMIN_PRODUCT)5)
#define FIT_GARMIN_PRODUCT_DSI_ALF02                                             ((FIT_GARMIN_PRODUCT)6)
#define FIT_GARMIN_PRODUCT_HRM3SS                                                ((FIT_GARMIN_PRODUCT)7)
#define FIT_GARMIN_PRODUCT_HRM_RUN_SINGLE_BYTE_PRODUCT_ID                        ((FIT_GARMIN_PRODUCT)8) // hrm_run model for HRM ANT+ messaging
#define FIT_GARMIN_PRODUCT_BSM                                                   ((FIT_GARMIN_PRODUCT)9) // BSM model for ANT+ messaging
#define FIT_GARMIN_PRODUCT_BCM                                                   ((FIT_GARMIN_PRODUCT)10) // BCM model for ANT+ messaging
#define FIT_GARMIN_PRODUCT_AXS01                                                 ((FIT_GARMIN_PRODUCT)11) // AXS01 HRM Bike Chipset model for ANT+ messaging
#define FIT_GARMIN_PRODUCT_HRM_TRI_SINGLE_BYTE_PRODUCT_ID                        ((FIT_GARMIN_PRODUCT)12) // hrm_tri model for HRM ANT+ messaging
#define FIT_GARMIN_PRODUCT_FR225_SINGLE_BYTE_PRODUCT_ID                          ((FIT_GARMIN_PRODUCT)14) // fr225 model for HRM ANT+ messaging
#define FIT_GARMIN_PRODUCT_FR301_CHINA                                           ((FIT_GARMIN_PRODUCT)473)
#define FIT_GARMIN_PRODUCT_FR301_JAPAN                                           ((FIT_GARMIN_PRODUCT)474)
#define FIT_GARMIN_PRODUCT_FR301_KOREA                                           ((FIT_GARMIN_PRODUCT)475)
#define FIT_GARMIN_PRODUCT_FR301_TAIWAN                                          ((FIT_GARMIN_PRODUCT)494)
#define FIT_GARMIN_PRODUCT_FR405                                                 ((FIT_GARMIN_PRODUCT)717) // Forerunner 405
#define FIT_GARMIN_PRODUCT_FR50                                                  ((FIT_GARMIN_PRODUCT)782) // Forerunner 50
#define FIT_GARMIN_PRODUCT_FR405_JAPAN                                           ((FIT_GARMIN_PRODUCT)987)
#define FIT_GARMIN_PRODUCT_FR60                                                  ((FIT_GARMIN_PRODUCT)988) // Forerunner 60
#define FIT_GARMIN_PRODUCT_DSI_ALF01                                             ((FIT_GARMIN_PRODUCT)1011)
#define FIT_GARMIN_PRODUCT_FR310XT                                               ((FIT_GARMIN_PRODUCT)1018) // Forerunner 310
#define FIT_GARMIN_PRODUCT_EDGE500                                               ((FIT_GARMIN_PRODUCT)1036)
#define FIT_GARMIN_PRODUCT_FR110                                                 ((FIT_GARMIN_PRODUCT)1124) // Forerunner 110
#define FIT_GARMIN_PRODUCT_EDGE800                                               ((FIT_GARMIN_PRODUCT)1169)
#define FIT_GARMIN_PRODUCT_EDGE500_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1199)
#define FIT_GARMIN_PRODUCT_EDGE500_JAPAN                                         ((FIT_GARMIN_PRODUCT)1213)
#define FIT_GARMIN_PRODUCT_CHIRP                                                 ((FIT_GARMIN_PRODUCT)1253)
#define FIT_GARMIN_PRODUCT_FR110_JAPAN                                           ((FIT_GARMIN_PRODUCT)1274)
#define FIT_GARMIN_PRODUCT_EDGE200                                               ((FIT_GARMIN_PRODUCT)1325)
#define FIT_GARMIN_PRODUCT_FR910XT                                               ((FIT_GARMIN_PRODUCT)1328)
#define FIT_GARMIN_PRODUCT_EDGE800_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1333)
#define FIT_GARMIN_PRODUCT_EDGE800_JAPAN                                         ((FIT_GARMIN_PRODUCT)1334)
#define FIT_GARMIN_PRODUCT_ALF04                                                 ((FIT_GARMIN_PRODUCT)1341)
#define FIT_GARMIN_PRODUCT_FR610                                                 ((FIT_GARMIN_PRODUCT)1345)
#define FIT_GARMIN_PRODUCT_FR210_JAPAN                                           ((FIT_GARMIN_PRODUCT)1360)
#define FIT_GARMIN_PRODUCT_VECTOR_SS                                             ((FIT_GARMIN_PRODUCT)1380)
#define FIT_GARMIN_PRODUCT_VECTOR_CP                                             ((FIT_GARMIN_PRODUCT)1381)
#define FIT_GARMIN_PRODUCT_EDGE800_CHINA                                         ((FIT_GARMIN_PRODUCT)1386)
#define FIT_GARMIN_PRODUCT_EDGE500_CHINA                                         ((FIT_GARMIN_PRODUCT)1387)
#define FIT_GARMIN_PRODUCT_FR610_JAPAN                                           ((FIT_GARMIN_PRODUCT)1410)
#define FIT_GARMIN_PRODUCT_EDGE500_KOREA                                         ((FIT_GARMIN_PRODUCT)1422)
#define FIT_GARMIN_PRODUCT_FR70                                                  ((FIT_GARMIN_PRODUCT)1436)
#define FIT_GARMIN_PRODUCT_FR310XT_4T                                            ((FIT_GARMIN_PRODUCT)1446)
#define FIT_GARMIN_PRODUCT_AMX                                                   ((FIT_GARMIN_PRODUCT)1461)
#define FIT_GARMIN_PRODUCT_FR10                                                  ((FIT_GARMIN_PRODUCT)1482)
#define FIT_GARMIN_PRODUCT_EDGE800_KOREA                                         ((FIT_GARMIN_PRODUCT)1497)
#define FIT_GARMIN_PRODUCT_SWIM                                                  ((FIT_GARMIN_PRODUCT)1499)
#define FIT_GARMIN_PRODUCT_FR910XT_CHINA                                         ((FIT_GARMIN_PRODUCT)1537)
#define FIT_GARMIN_PRODUCT_FENIX                                                 ((FIT_GARMIN_PRODUCT)1551)
#define FIT_GARMIN_PRODUCT_EDGE200_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1555)
#define FIT_GARMIN_PRODUCT_EDGE510                                               ((FIT_GARMIN_PRODUCT)1561)
#define FIT_GARMIN_PRODUCT_EDGE810                                               ((FIT_GARMIN_PRODUCT)1567)
#define FIT_GARMIN_PRODUCT_TEMPE                                                 ((FIT_GARMIN_PRODUCT)1570)
#define FIT_GARMIN_PRODUCT_FR910XT_JAPAN                                         ((FIT_GARMIN_PRODUCT)1600)
#define FIT_GARMIN_PRODUCT_FR620                                                 ((FIT_GARMIN_PRODUCT)1623)
#define FIT_GARMIN_PRODUCT_FR220                                                 ((FIT_GARMIN_PRODUCT)1632)
#define FIT_GARMIN_PRODUCT_FR910XT_KOREA                                         ((FIT_GARMIN_PRODUCT)1664)
#define FIT_GARMIN_PRODUCT_FR10_JAPAN                                            ((FIT_GARMIN_PRODUCT)1688)
#define FIT_GARMIN_PRODUCT_EDGE810_JAPAN                                         ((FIT_GARMIN_PRODUCT)1721)
#define FIT_GARMIN_PRODUCT_VIRB_ELITE                                            ((FIT_GARMIN_PRODUCT)1735)
#define FIT_GARMIN_PRODUCT_EDGE_TOURING                                          ((FIT_GARMIN_PRODUCT)1736) // Also Edge Touring Plus
#define FIT_GARMIN_PRODUCT_EDGE510_JAPAN                                         ((FIT_GARMIN_PRODUCT)1742)
#define FIT_GARMIN_PRODUCT_HRM_TRI                                               ((FIT_GARMIN_PRODUCT)1743)
#define FIT_GARMIN_PRODUCT_HRM_RUN                                               ((FIT_GARMIN_PRODUCT)1752)
#define FIT_GARMIN_PRODUCT_FR920XT                                               ((FIT_GARMIN_PRODUCT)1765)
#define FIT_GARMIN_PRODUCT_EDGE510_ASIA                                          ((FIT_GARMIN_PRODUCT)1821)
#define FIT_GARMIN_PRODUCT_EDGE810_CHINA                                         ((FIT_GARMIN_PRODUCT)1822)
#define FIT_GARMIN_PRODUCT_EDGE810_TAIWAN                                        ((FIT_GARMIN_PRODUCT)1823)
#define FIT_GARMIN_PRODUCT_EDGE1000                                              ((FIT_GARMIN_PRODUCT)1836)
#define FIT_GARMIN_PRODUCT_VIVO_FIT                                              ((FIT_GARMIN_PRODUCT)1837)
#define FIT_GARMIN_PRODUCT_VIRB_REMOTE                                           ((FIT_GARMIN_PRODUCT)1853)
#define FIT_GARMIN_PRODUCT_VIVO_KI                                               ((FIT_GARMIN_PRODUCT)1885)
#define FIT_GARMIN_PRODUCT_FR15                                                  ((FIT_GARMIN_PRODUCT)1903)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE                                           ((FIT_GARMIN_PRODUCT)1907)
#define FIT_GARMIN_PRODUCT_EDGE510_KOREA                                         ((FIT_GARMIN_PRODUCT)1918)
#define FIT_GARMIN_PRODUCT_FR620_JAPAN                                           ((FIT_GARMIN_PRODUCT)1928)
#define FIT_GARMIN_PRODUCT_FR620_CHINA                                           ((FIT_GARMIN_PRODUCT)1929)
#define FIT_GARMIN_PRODUCT_FR220_JAPAN                                           ((FIT_GARMIN_PRODUCT)1930)
#define FIT_GARMIN_PRODUCT_FR220_CHINA                                           ((FIT_GARMIN_PRODUCT)1931)
#define FIT_GARMIN_PRODUCT_APPROACH_S6                                           ((FIT_GARMIN_PRODUCT)1936)
#define FIT_GARMIN_PRODUCT_VIVO_SMART                                            ((FIT_GARMIN_PRODUCT)1956)
#define FIT_GARMIN_PRODUCT_FENIX2                                                ((FIT_GARMIN_PRODUCT)1967)
#define FIT_GARMIN_PRODUCT_EPIX                                                  ((FIT_GARMIN_PRODUCT)1988)
#define FIT_GARMIN_PRODUCT_FENIX3                                                ((FIT_GARMIN_PRODUCT)2050)
#define FIT_GARMIN_PRODUCT_EDGE1000_TAIWAN                                       ((FIT_GARMIN_PRODUCT)2052)
#define FIT_GARMIN_PRODUCT_EDGE1000_JAPAN                                        ((FIT_GARMIN_PRODUCT)2053)
#define FIT_GARMIN_PRODUCT_FR15_JAPAN                                            ((FIT_GARMIN_PRODUCT)2061)
#define FIT_GARMIN_PRODUCT_EDGE520                                               ((FIT_GARMIN_PRODUCT)2067)
#define FIT_GARMIN_PRODUCT_EDGE1000_CHINA                                        ((FIT_GARMIN_PRODUCT)2070)
#define FIT_GARMIN_PRODUCT_FR620_RUSSIA                                          ((FIT_GARMIN_PRODUCT)2072)
#define FIT_GARMIN_PRODUCT_FR220_RUSSIA                                          ((FIT_GARMIN_PRODUCT)2073)
#define FIT_GARMIN_PRODUCT_VECTOR_S                                              ((FIT_GARMIN_PRODUCT)2079)
#define FIT_GARMIN_PRODUCT_EDGE1000_KOREA                                        ((FIT_GARMIN_PRODUCT)2100)
#define FIT_GARMIN_PRODUCT_FR920XT_TAIWAN                                        ((FIT_GARMIN_PRODUCT)2130)
#define FIT_GARMIN_PRODUCT_FR920XT_CHINA                                         ((FIT_GARMIN_PRODUCT)2131)
#define FIT_GARMIN_PRODUCT_FR920XT_JAPAN                                         ((FIT_GARMIN_PRODUCT)2132)
#define FIT_GARMIN_PRODUCT_VIRBX                                                 ((FIT_GARMIN_PRODUCT)2134)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_APAC                                       ((FIT_GARMIN_PRODUCT)2135)
#define FIT_GARMIN_PRODUCT_ETREX_TOUCH                                           ((FIT_GARMIN_PRODUCT)2140)
#define FIT_GARMIN_PRODUCT_EDGE25                                                ((FIT_GARMIN_PRODUCT)2147)
#define FIT_GARMIN_PRODUCT_FR25                                                  ((FIT_GARMIN_PRODUCT)2148)
#define FIT_GARMIN_PRODUCT_VIVO_FIT2                                             ((FIT_GARMIN_PRODUCT)2150)
#define FIT_GARMIN_PRODUCT_FR225                                                 ((FIT_GARMIN_PRODUCT)2153)
#define FIT_GARMIN_PRODUCT_FR630                                                 ((FIT_GARMIN_PRODUCT)2156)
#define FIT_GARMIN_PRODUCT_FR230                                                 ((FIT_GARMIN_PRODUCT)2157)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE_APAC                                      ((FIT_GARMIN_PRODUCT)2160)
#define FIT_GARMIN_PRODUCT_VECTOR_2                                              ((FIT_GARMIN_PRODUCT)2161)
#define FIT_GARMIN_PRODUCT_VECTOR_2S                                             ((FIT_GARMIN_PRODUCT)2162)
#define FIT_GARMIN_PRODUCT_VIRBXE                                                ((FIT_GARMIN_PRODUCT)2172)
#define FIT_GARMIN_PRODUCT_FR620_TAIWAN                                          ((FIT_GARMIN_PRODUCT)2173)
#define FIT_GARMIN_PRODUCT_FR220_TAIWAN                                          ((FIT_GARMIN_PRODUCT)2174)
#define FIT_GARMIN_PRODUCT_TRUSWING                                              ((FIT_GARMIN_PRODUCT)2175)
#define FIT_GARMIN_PRODUCT_FENIX3_CHINA                                          ((FIT_GARMIN_PRODUCT)2188)
#define FIT_GARMIN_PRODUCT_FENIX3_TWN                                            ((FIT_GARMIN_PRODUCT)2189)
#define FIT_GARMIN_PRODUCT_VARIA_HEADLIGHT                                       ((FIT_GARMIN_PRODUCT)2192)
#define FIT_GARMIN_PRODUCT_VARIA_TAILLIGHT_OLD                                   ((FIT_GARMIN_PRODUCT)2193)
#define FIT_GARMIN_PRODUCT_EDGE_EXPLORE_1000                                     ((FIT_GARMIN_PRODUCT)2204)
#define FIT_GARMIN_PRODUCT_FR225_ASIA                                            ((FIT_GARMIN_PRODUCT)2219)
#define FIT_GARMIN_PRODUCT_VARIA_RADAR_TAILLIGHT                                 ((FIT_GARMIN_PRODUCT)2225)
#define FIT_GARMIN_PRODUCT_VARIA_RADAR_DISPLAY                                   ((FIT_GARMIN_PRODUCT)2226)
#define FIT_GARMIN_PRODUCT_EDGE20                                                ((FIT_GARMIN_PRODUCT)2238)
#define FIT_GARMIN_PRODUCT_D2_BRAVO                                              ((FIT_GARMIN_PRODUCT)2262)
#define FIT_GARMIN_PRODUCT_APPROACH_S20                                          ((FIT_GARMIN_PRODUCT)2266)
#define FIT_GARMIN_PRODUCT_VARIA_REMOTE                                          ((FIT_GARMIN_PRODUCT)2276)
#define FIT_GARMIN_PRODUCT_HRM4_RUN                                              ((FIT_GARMIN_PRODUCT)2327)
#define FIT_GARMIN_PRODUCT_VIVO_ACTIVE_HR                                        ((FIT_GARMIN_PRODUCT)2337)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_GPS_HR                                     ((FIT_GARMIN_PRODUCT)2347)
#define FIT_GARMIN_PRODUCT_VIVO_SMART_HR                                         ((FIT_GARMIN_PRODUCT)2348)
#define FIT_GARMIN_PRODUCT_VIVO_MOVE                                             ((FIT_GARMIN_PRODUCT)2368)
#define FIT_GARMIN_PRODUCT_VARIA_VISION                                          ((FIT_GARMIN_PRODUCT)2398)
#define FIT_GARMIN_PRODUCT_VIVO_FIT3                                             ((FIT_GARMIN_PRODUCT)2406)
#define FIT_GARMIN_PRODUCT_FENIX3_HR                                             ((FIT_GARMIN_PRODUCT)2413)
#define FIT_GARMIN_PRODUCT_VIRB_ULTRA_30                                         ((FIT_GARMIN_PRODUCT)2417)
#define FIT_GARMIN_PRODUCT_INDEX_SMART_SCALE                                     ((FIT_GARMIN_PRODUCT)2429)
#define FIT_GARMIN_PRODUCT_FR235                                                 ((FIT_GARMIN_PRODUCT)2431)
#define FIT_GARMIN_PRODUCT_FENIX3_CHRONOS                                        ((FIT_GARMIN_PRODUCT)2432)
#define FIT_GARMIN_PRODUCT_OREGON7XX                                             ((FIT_GARMIN_PRODUCT)2441)
#define FIT_GARMIN_PRODUCT_RINO7XX                                               ((FIT_GARMIN_PRODUCT)2444)
#define FIT_GARMIN_PRODUCT_NAUTIX                                                ((FIT_GARMIN_PRODUCT)2496)
#define FIT_GARMIN_PRODUCT_EDGE_820                                              ((FIT_GARMIN_PRODUCT)2530)
#define FIT_GARMIN_PRODUCT_EDGE_EXPLORE_820                                      ((FIT_GARMIN_PRODUCT)2531)
#define FIT_GARMIN_PRODUCT_FENIX5S                                               ((FIT_GARMIN_PRODUCT)2544)
#define FIT_GARMIN_PRODUCT_D2_BRAVO_TITANIUM                                     ((FIT_GARMIN_PRODUCT)2547)
#define FIT_GARMIN_PRODUCT_RUNNING_DYNAMICS_POD                                  ((FIT_GARMIN_PRODUCT)2593)
#define FIT_GARMIN_PRODUCT_FENIX5X                                               ((FIT_GARMIN_PRODUCT)2604)
#define FIT_GARMIN_PRODUCT_VIVO_FIT_JR                                           ((FIT_GARMIN_PRODUCT)2606)
#define FIT_GARMIN_PRODUCT_FR935                                                 ((FIT_GARMIN_PRODUCT)2691)
#define FIT_GARMIN_PRODUCT_FENIX5                                                ((FIT_GARMIN_PRODUCT)2697)
#define FIT_GARMIN_PRODUCT_SDM4                                                  ((FIT_GARMIN_PRODUCT)10007) // SDM4 footpod
#define FIT_GARMIN_PRODUCT_EDGE_REMOTE                                           ((FIT_GARMIN_PRODUCT)10014)
#define FIT_GARMIN_PRODUCT_TRAINING_CENTER                                       ((FIT_GARMIN_PRODUCT)20119)
#define FIT_GARMIN_PRODUCT_CONNECTIQ_SIMULATOR                                   ((FIT_GARMIN_PRODUCT)65531)
#define FIT_GARMIN_PRODUCT_ANDROID_ANTPLUS_PLUGIN                                ((FIT_GARMIN_PRODUCT)65532)
#define FIT_GARMIN_PRODUCT_CONNECT                                               ((FIT_GARMIN_PRODUCT)65534) // Garmin Connect website
#define FIT_GARMIN_PRODUCT_COUNT                                                 156

typedef FIT_UINT8 FIT_ANTPLUS_DEVICE_TYPE;
#define FIT_ANTPLUS_DEVICE_TYPE_INVALID                                          FIT_UINT8_INVALID
#define FIT_ANTPLUS_DEVICE_TYPE_ANTFS                                            ((FIT_ANTPLUS_DEVICE_TYPE)1)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_POWER                                       ((FIT_ANTPLUS_DEVICE_TYPE)11)
#define FIT_ANTPLUS_DEVICE_TYPE_ENVIRONMENT_SENSOR_LEGACY                        ((FIT_ANTPLUS_DEVICE_TYPE)12)
#define FIT_ANTPLUS_DEVICE_TYPE_MULTI_SPORT_SPEED_DISTANCE                       ((FIT_ANTPLUS_DEVICE_TYPE)15)
#define FIT_ANTPLUS_DEVICE_TYPE_CONTROL                                          ((FIT_ANTPLUS_DEVICE_TYPE)16)
#define FIT_ANTPLUS_DEVICE_TYPE_FITNESS_EQUIPMENT                                ((FIT_ANTPLUS_DEVICE_TYPE)17)
#define FIT_ANTPLUS_DEVICE_TYPE_BLOOD_PRESSURE                                   ((FIT_ANTPLUS_DEVICE_TYPE)18)
#define FIT_ANTPLUS_DEVICE_TYPE_GEOCACHE_NODE                                    ((FIT_ANTPLUS_DEVICE_TYPE)19)
#define FIT_ANTPLUS_DEVICE_TYPE_LIGHT_ELECTRIC_VEHICLE                           ((FIT_ANTPLUS_DEVICE_TYPE)20)
#define FIT_ANTPLUS_DEVICE_TYPE_ENV_SENSOR                                       ((FIT_ANTPLUS_DEVICE_TYPE)25)
#define FIT_ANTPLUS_DEVICE_TYPE_RACQUET                                          ((FIT_ANTPLUS_DEVICE_TYPE)26)
#define FIT_ANTPLUS_DEVICE_TYPE_CONTROL_HUB                                      ((FIT_ANTPLUS_DEVICE_TYPE)27)
#define FIT_ANTPLUS_DEVICE_TYPE_MUSCLE_OXYGEN                                    ((FIT_ANTPLUS_DEVICE_TYPE)31)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_LIGHT_MAIN                                  ((FIT_ANTPLUS_DEVICE_TYPE)35)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_LIGHT_SHARED                                ((FIT_ANTPLUS_DEVICE_TYPE)36)
#define FIT_ANTPLUS_DEVICE_TYPE_EXD                                              ((FIT_ANTPLUS_DEVICE_TYPE)38)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_RADAR                                       ((FIT_ANTPLUS_DEVICE_TYPE)40)
#define FIT_ANTPLUS_DEVICE_TYPE_WEIGHT_SCALE                                     ((FIT_ANTPLUS_DEVICE_TYPE)119)
#define FIT_ANTPLUS_DEVICE_TYPE_HEART_RATE                                       ((FIT_ANTPLUS_DEVICE_TYPE)120)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_SPEED_CADENCE                               ((FIT_ANTPLUS_DEVICE_TYPE)121)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_CADENCE                                     ((FIT_ANTPLUS_DEVICE_TYPE)122)
#define FIT_ANTPLUS_DEVICE_TYPE_BIKE_SPEED                                       ((FIT_ANTPLUS_DEVICE_TYPE)123)
#define FIT_ANTPLUS_DEVICE_TYPE_STRIDE_SPEED_DISTANCE                            ((FIT_ANTPLUS_DEVICE_TYPE)124)
#define FIT_ANTPLUS_DEVICE_TYPE_COUNT                                            23

typedef FIT_ENUM FIT_ANT_NETWORK;
#define FIT_ANT_NETWORK_INVALID                                                  FIT_ENUM_INVALID
#define FIT_ANT_NETWORK_PUBLIC                                                   ((FIT_ANT_NETWORK)0)
#define FIT_ANT_NETWORK_ANTPLUS                                                  ((FIT_ANT_NETWORK)1)
#define FIT_ANT_NETWORK_ANTFS                                                    ((FIT_ANT_NETWORK)2)
#define FIT_ANT_NETWORK_PRIVATE                                                  ((FIT_ANT_NETWORK)3)
#define FIT_ANT_NETWORK_COUNT                                                    4

typedef FIT_UINT32Z FIT_WORKOUT_CAPABILITIES;
#define FIT_WORKOUT_CAPABILITIES_INVALID                                         FIT_UINT32Z_INVALID
#define FIT_WORKOUT_CAPABILITIES_INTERVAL                                        ((FIT_WORKOUT_CAPABILITIES)0x00000001)
#define FIT_WORKOUT_CAPABILITIES_CUSTOM                                          ((FIT_WORKOUT_CAPABILITIES)0x00000002)
#define FIT_WORKOUT_CAPABILITIES_FITNESS_EQUIPMENT                               ((FIT_WORKOUT_CAPABILITIES)0x00000004)
#define FIT_WORKOUT_CAPABILITIES_FIRSTBEAT                                       ((FIT_WORKOUT_CAPABILITIES)0x00000008)
#define FIT_WORKOUT_CAPABILITIES_NEW_LEAF                                        ((FIT_WORKOUT_CAPABILITIES)0x00000010)
#define FIT_WORKOUT_CAPABILITIES_TCX                                             ((FIT_WORKOUT_CAPABILITIES)0x00000020) // For backwards compatibility.  Watch should add missing id fields then clear flag.
#define FIT_WORKOUT_CAPABILITIES_SPEED                                           ((FIT_WORKOUT_CAPABILITIES)0x00000080) // Speed source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_HEART_RATE                                      ((FIT_WORKOUT_CAPABILITIES)0x00000100) // Heart rate source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_DISTANCE                                        ((FIT_WORKOUT_CAPABILITIES)0x00000200) // Distance source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_CADENCE                                         ((FIT_WORKOUT_CAPABILITIES)0x00000400) // Cadence source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_POWER                                           ((FIT_WORKOUT_CAPABILITIES)0x00000800) // Power source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_GRADE                                           ((FIT_WORKOUT_CAPABILITIES)0x00001000) // Grade source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_RESISTANCE                                      ((FIT_WORKOUT_CAPABILITIES)0x00002000) // Resistance source required for workout step.
#define FIT_WORKOUT_CAPABILITIES_PROTECTED                                       ((FIT_WORKOUT_CAPABILITIES)0x00004000)
#define FIT_WORKOUT_CAPABILITIES_COUNT                                           14

typedef FIT_UINT8 FIT_BATTERY_STATUS;
#define FIT_BATTERY_STATUS_INVALID                                               FIT_UINT8_INVALID
#define FIT_BATTERY_STATUS_NEW                                                   ((FIT_BATTERY_STATUS)1)
#define FIT_BATTERY_STATUS_GOOD                                                  ((FIT_BATTERY_STATUS)2)
#define FIT_BATTERY_STATUS_OK                                                    ((FIT_BATTERY_STATUS)3)
#define FIT_BATTERY_STATUS_LOW                                                   ((FIT_BATTERY_STATUS)4)
#define FIT_BATTERY_STATUS_CRITICAL                                              ((FIT_BATTERY_STATUS)5)
#define FIT_BATTERY_STATUS_CHARGING                                              ((FIT_BATTERY_STATUS)6)
#define FIT_BATTERY_STATUS_UNKNOWN                                               ((FIT_BATTERY_STATUS)7)
#define FIT_BATTERY_STATUS_COUNT                                                 7

typedef FIT_ENUM FIT_HR_TYPE;
#define FIT_HR_TYPE_INVALID                                                      FIT_ENUM_INVALID
#define FIT_HR_TYPE_NORMAL                                                       ((FIT_HR_TYPE)0)
#define FIT_HR_TYPE_IRREGULAR                                                    ((FIT_HR_TYPE)1)
#define FIT_HR_TYPE_COUNT                                                        2

typedef FIT_UINT32Z FIT_COURSE_CAPABILITIES;
#define FIT_COURSE_CAPABILITIES_INVALID                                          FIT_UINT32Z_INVALID
#define FIT_COURSE_CAPABILITIES_PROCESSED                                        ((FIT_COURSE_CAPABILITIES)0x00000001)
#define FIT_COURSE_CAPABILITIES_VALID                                            ((FIT_COURSE_CAPABILITIES)0x00000002)
#define FIT_COURSE_CAPABILITIES_TIME                                             ((FIT_COURSE_CAPABILITIES)0x00000004)
#define FIT_COURSE_CAPABILITIES_DISTANCE                                         ((FIT_COURSE_CAPABILITIES)0x00000008)
#define FIT_COURSE_CAPABILITIES_POSITION                                         ((FIT_COURSE_CAPABILITIES)0x00000010)
#define FIT_COURSE_CAPABILITIES_HEART_RATE                                       ((FIT_COURSE_CAPABILITIES)0x00000020)
#define FIT_COURSE_CAPABILITIES_POWER                                            ((FIT_COURSE_CAPABILITIES)0x00000040)
#define FIT_COURSE_CAPABILITIES_CADENCE                                          ((FIT_COURSE_CAPABILITIES)0x00000080)
#define FIT_COURSE_CAPABILITIES_TRAINING                                         ((FIT_COURSE_CAPABILITIES)0x00000100)
#define FIT_COURSE_CAPABILITIES_NAVIGATION                                       ((FIT_COURSE_CAPABILITIES)0x00000200)
#define FIT_COURSE_CAPABILITIES_BIKEWAY                                          ((FIT_COURSE_CAPABILITIES)0x00000400)
#define FIT_COURSE_CAPABILITIES_COUNT                                            11

typedef FIT_UINT16 FIT_WEIGHT;
#define FIT_WEIGHT_INVALID                                                       FIT_UINT16_INVALID
#define FIT_WEIGHT_CALCULATING                                                   ((FIT_WEIGHT)0xFFFE)
#define FIT_WEIGHT_COUNT                                                         1

typedef FIT_UINT32 FIT_WORKOUT_HR; // 0 - 100 indicates% of max hr; >100 indicates bpm (255 max) plus 100
#define FIT_WORKOUT_HR_INVALID                                                   FIT_UINT32_INVALID
#define FIT_WORKOUT_HR_BPM_OFFSET                                                ((FIT_WORKOUT_HR)100)
#define FIT_WORKOUT_HR_COUNT                                                     1

typedef FIT_UINT32 FIT_WORKOUT_POWER; // 0 - 1000 indicates % of functional threshold power; >1000 indicates watts plus 1000.
#define FIT_WORKOUT_POWER_INVALID                                                FIT_UINT32_INVALID
#define FIT_WORKOUT_POWER_WATTS_OFFSET                                           ((FIT_WORKOUT_POWER)1000)
#define FIT_WORKOUT_POWER_COUNT                                                  1

typedef FIT_ENUM FIT_BP_STATUS;
#define FIT_BP_STATUS_INVALID                                                    FIT_ENUM_INVALID
#define FIT_BP_STATUS_NO_ERROR                                                   ((FIT_BP_STATUS)0)
#define FIT_BP_STATUS_ERROR_INCOMPLETE_DATA                                      ((FIT_BP_STATUS)1)
#define FIT_BP_STATUS_ERROR_NO_MEASUREMENT                                       ((FIT_BP_STATUS)2)
#define FIT_BP_STATUS_ERROR_DATA_OUT_OF_RANGE                                    ((FIT_BP_STATUS)3)
#define FIT_BP_STATUS_ERROR_IRREGULAR_HEART_RATE                                 ((FIT_BP_STATUS)4)
#define FIT_BP_STATUS_COUNT                                                      5

typedef FIT_UINT16 FIT_USER_LOCAL_ID;
#define FIT_USER_LOCAL_ID_INVALID                                                FIT_UINT16_INVALID
#define FIT_USER_LOCAL_ID_LOCAL_MIN                                              ((FIT_USER_LOCAL_ID)0x0000)
#define FIT_USER_LOCAL_ID_LOCAL_MAX                                              ((FIT_USER_LOCAL_ID)0x000F)
#define FIT_USER_LOCAL_ID_STATIONARY_MIN                                         ((FIT_USER_LOCAL_ID)0x0010)
#define FIT_USER_LOCAL_ID_STATIONARY_MAX                                         ((FIT_USER_LOCAL_ID)0x00FF)
#define FIT_USER_LOCAL_ID_PORTABLE_MIN                                           ((FIT_USER_LOCAL_ID)0x0100)
#define FIT_USER_LOCAL_ID_PORTABLE_MAX                                           ((FIT_USER_LOCAL_ID)0xFFFE)
#define FIT_USER_LOCAL_ID_COUNT                                                  6

typedef FIT_ENUM FIT_SWIM_STROKE;
#define FIT_SWIM_STROKE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SWIM_STROKE_FREESTYLE                                                ((FIT_SWIM_STROKE)0)
#define FIT_SWIM_STROKE_BACKSTROKE                                               ((FIT_SWIM_STROKE)1)
#define FIT_SWIM_STROKE_BREASTSTROKE                                             ((FIT_SWIM_STROKE)2)
#define FIT_SWIM_STROKE_BUTTERFLY                                                ((FIT_SWIM_STROKE)3)
#define FIT_SWIM_STROKE_DRILL                                                    ((FIT_SWIM_STROKE)4)
#define FIT_SWIM_STROKE_MIXED                                                    ((FIT_SWIM_STROKE)5)
#define FIT_SWIM_STROKE_IM                                                       ((FIT_SWIM_STROKE)6) // IM is a mixed interval containing the same number of lengths for each of: Butterfly, Backstroke, Breaststroke, Freestyle, swam in that order.
#define FIT_SWIM_STROKE_COUNT                                                    7

typedef FIT_ENUM FIT_ACTIVITY_TYPE;
#define FIT_ACTIVITY_TYPE_INVALID                                                FIT_ENUM_INVALID
#define FIT_ACTIVITY_TYPE_GENERIC                                                ((FIT_ACTIVITY_TYPE)0)
#define FIT_ACTIVITY_TYPE_RUNNING                                                ((FIT_ACTIVITY_TYPE)1)
#define FIT_ACTIVITY_TYPE_CYCLING                                                ((FIT_ACTIVITY_TYPE)2)
#define FIT_ACTIVITY_TYPE_TRANSITION                                             ((FIT_ACTIVITY_TYPE)3) // Mulitsport transition
#define FIT_ACTIVITY_TYPE_FITNESS_EQUIPMENT                                      ((FIT_ACTIVITY_TYPE)4)
#define FIT_ACTIVITY_TYPE_SWIMMING                                               ((FIT_ACTIVITY_TYPE)5)
#define FIT_ACTIVITY_TYPE_WALKING                                                ((FIT_ACTIVITY_TYPE)6)
#define FIT_ACTIVITY_TYPE_SEDENTARY                                              ((FIT_ACTIVITY_TYPE)8)
#define FIT_ACTIVITY_TYPE_ALL                                                    ((FIT_ACTIVITY_TYPE)254) // All is for goals only to include all sports.
#define FIT_ACTIVITY_TYPE_COUNT                                                  9

typedef FIT_ENUM FIT_ACTIVITY_SUBTYPE;
#define FIT_ACTIVITY_SUBTYPE_INVALID                                             FIT_ENUM_INVALID
#define FIT_ACTIVITY_SUBTYPE_GENERIC                                             ((FIT_ACTIVITY_SUBTYPE)0)
#define FIT_ACTIVITY_SUBTYPE_TREADMILL                                           ((FIT_ACTIVITY_SUBTYPE)1) // Run
#define FIT_ACTIVITY_SUBTYPE_STREET                                              ((FIT_ACTIVITY_SUBTYPE)2) // Run
#define FIT_ACTIVITY_SUBTYPE_TRAIL                                               ((FIT_ACTIVITY_SUBTYPE)3) // Run
#define FIT_ACTIVITY_SUBTYPE_TRACK                                               ((FIT_ACTIVITY_SUBTYPE)4) // Run
#define FIT_ACTIVITY_SUBTYPE_SPIN                                                ((FIT_ACTIVITY_SUBTYPE)5) // Cycling
#define FIT_ACTIVITY_SUBTYPE_INDOOR_CYCLING                                      ((FIT_ACTIVITY_SUBTYPE)6) // Cycling
#define FIT_ACTIVITY_SUBTYPE_ROAD                                                ((FIT_ACTIVITY_SUBTYPE)7) // Cycling
#define FIT_ACTIVITY_SUBTYPE_MOUNTAIN                                            ((FIT_ACTIVITY_SUBTYPE)8) // Cycling
#define FIT_ACTIVITY_SUBTYPE_DOWNHILL                                            ((FIT_ACTIVITY_SUBTYPE)9) // Cycling
#define FIT_ACTIVITY_SUBTYPE_RECUMBENT                                           ((FIT_ACTIVITY_SUBTYPE)10) // Cycling
#define FIT_ACTIVITY_SUBTYPE_CYCLOCROSS                                          ((FIT_ACTIVITY_SUBTYPE)11) // Cycling
#define FIT_ACTIVITY_SUBTYPE_HAND_CYCLING                                        ((FIT_ACTIVITY_SUBTYPE)12) // Cycling
#define FIT_ACTIVITY_SUBTYPE_TRACK_CYCLING                                       ((FIT_ACTIVITY_SUBTYPE)13) // Cycling
#define FIT_ACTIVITY_SUBTYPE_INDOOR_ROWING                                       ((FIT_ACTIVITY_SUBTYPE)14) // Fitness Equipment
#define FIT_ACTIVITY_SUBTYPE_ELLIPTICAL                                          ((FIT_ACTIVITY_SUBTYPE)15) // Fitness Equipment
#define FIT_ACTIVITY_SUBTYPE_STAIR_CLIMBING                                      ((FIT_ACTIVITY_SUBTYPE)16) // Fitness Equipment
#define FIT_ACTIVITY_SUBTYPE_LAP_SWIMMING                                        ((FIT_ACTIVITY_SUBTYPE)17) // Swimming
#define FIT_ACTIVITY_SUBTYPE_OPEN_WATER                                          ((FIT_ACTIVITY_SUBTYPE)18) // Swimming
#define FIT_ACTIVITY_SUBTYPE_ALL                                                 ((FIT_ACTIVITY_SUBTYPE)254)
#define FIT_ACTIVITY_SUBTYPE_COUNT                                               20

typedef FIT_ENUM FIT_ACTIVITY_LEVEL;
#define FIT_ACTIVITY_LEVEL_INVALID                                               FIT_ENUM_INVALID
#define FIT_ACTIVITY_LEVEL_LOW                                                   ((FIT_ACTIVITY_LEVEL)0)
#define FIT_ACTIVITY_LEVEL_MEDIUM                                                ((FIT_ACTIVITY_LEVEL)1)
#define FIT_ACTIVITY_LEVEL_HIGH                                                  ((FIT_ACTIVITY_LEVEL)2)
#define FIT_ACTIVITY_LEVEL_COUNT                                                 3

typedef FIT_ENUM FIT_SIDE;
#define FIT_SIDE_INVALID                                                         FIT_ENUM_INVALID
#define FIT_SIDE_RIGHT                                                           ((FIT_SIDE)0)
#define FIT_SIDE_LEFT                                                            ((FIT_SIDE)1)
#define FIT_SIDE_COUNT                                                           2

typedef FIT_UINT8 FIT_LEFT_RIGHT_BALANCE;
#define FIT_LEFT_RIGHT_BALANCE_INVALID                                           FIT_UINT8_INVALID
#define FIT_LEFT_RIGHT_BALANCE_MASK                                              ((FIT_LEFT_RIGHT_BALANCE)0x7F) // % contribution
#define FIT_LEFT_RIGHT_BALANCE_RIGHT                                             ((FIT_LEFT_RIGHT_BALANCE)0x80) // data corresponds to right if set, otherwise unknown
#define FIT_LEFT_RIGHT_BALANCE_COUNT                                             2

typedef FIT_UINT16 FIT_LEFT_RIGHT_BALANCE_100;
#define FIT_LEFT_RIGHT_BALANCE_100_INVALID                                       FIT_UINT16_INVALID
#define FIT_LEFT_RIGHT_BALANCE_100_MASK                                          ((FIT_LEFT_RIGHT_BALANCE_100)0x3FFF) // % contribution scaled by 100
#define FIT_LEFT_RIGHT_BALANCE_100_RIGHT                                         ((FIT_LEFT_RIGHT_BALANCE_100)0x8000) // data corresponds to right if set, otherwise unknown
#define FIT_LEFT_RIGHT_BALANCE_100_COUNT                                         2

typedef FIT_ENUM FIT_LENGTH_TYPE;
#define FIT_LENGTH_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_LENGTH_TYPE_IDLE                                                     ((FIT_LENGTH_TYPE)0) // Rest period. Length with no strokes
#define FIT_LENGTH_TYPE_ACTIVE                                                   ((FIT_LENGTH_TYPE)1) // Length with strokes.
#define FIT_LENGTH_TYPE_COUNT                                                    2

typedef FIT_ENUM FIT_DAY_OF_WEEK;
#define FIT_DAY_OF_WEEK_INVALID                                                  FIT_ENUM_INVALID
#define FIT_DAY_OF_WEEK_SUNDAY                                                   ((FIT_DAY_OF_WEEK)0)
#define FIT_DAY_OF_WEEK_MONDAY                                                   ((FIT_DAY_OF_WEEK)1)
#define FIT_DAY_OF_WEEK_TUESDAY                                                  ((FIT_DAY_OF_WEEK)2)
#define FIT_DAY_OF_WEEK_WEDNESDAY                                                ((FIT_DAY_OF_WEEK)3)
#define FIT_DAY_OF_WEEK_THURSDAY                                                 ((FIT_DAY_OF_WEEK)4)
#define FIT_DAY_OF_WEEK_FRIDAY                                                   ((FIT_DAY_OF_WEEK)5)
#define FIT_DAY_OF_WEEK_SATURDAY                                                 ((FIT_DAY_OF_WEEK)6)
#define FIT_DAY_OF_WEEK_COUNT                                                    7

typedef FIT_UINT32Z FIT_CONNECTIVITY_CAPABILITIES;
#define FIT_CONNECTIVITY_CAPABILITIES_INVALID                                    FIT_UINT32Z_INVALID
#define FIT_CONNECTIVITY_CAPABILITIES_BLUETOOTH                                  ((FIT_CONNECTIVITY_CAPABILITIES)0x00000001)
#define FIT_CONNECTIVITY_CAPABILITIES_BLUETOOTH_LE                               ((FIT_CONNECTIVITY_CAPABILITIES)0x00000002)
#define FIT_CONNECTIVITY_CAPABILITIES_ANT                                        ((FIT_CONNECTIVITY_CAPABILITIES)0x00000004)
#define FIT_CONNECTIVITY_CAPABILITIES_ACTIVITY_UPLOAD                            ((FIT_CONNECTIVITY_CAPABILITIES)0x00000008)
#define FIT_CONNECTIVITY_CAPABILITIES_COURSE_DOWNLOAD                            ((FIT_CONNECTIVITY_CAPABILITIES)0x00000010)
#define FIT_CONNECTIVITY_CAPABILITIES_WORKOUT_DOWNLOAD                           ((FIT_CONNECTIVITY_CAPABILITIES)0x00000020)
#define FIT_CONNECTIVITY_CAPABILITIES_LIVE_TRACK                                 ((FIT_CONNECTIVITY_CAPABILITIES)0x00000040)
#define FIT_CONNECTIVITY_CAPABILITIES_WEATHER_CONDITIONS                         ((FIT_CONNECTIVITY_CAPABILITIES)0x00000080)
#define FIT_CONNECTIVITY_CAPABILITIES_WEATHER_ALERTS                             ((FIT_CONNECTIVITY_CAPABILITIES)0x00000100)
#define FIT_CONNECTIVITY_CAPABILITIES_GPS_EPHEMERIS_DOWNLOAD                     ((FIT_CONNECTIVITY_CAPABILITIES)0x00000200)
#define FIT_CONNECTIVITY_CAPABILITIES_EXPLICIT_ARCHIVE                           ((FIT_CONNECTIVITY_CAPABILITIES)0x00000400)
#define FIT_CONNECTIVITY_CAPABILITIES_SETUP_INCOMPLETE                           ((FIT_CONNECTIVITY_CAPABILITIES)0x00000800)
#define FIT_CONNECTIVITY_CAPABILITIES_CONTINUE_SYNC_AFTER_SOFTWARE_UPDATE        ((FIT_CONNECTIVITY_CAPABILITIES)0x00001000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_APP_DOWNLOAD                    ((FIT_CONNECTIVITY_CAPABILITIES)0x00002000)
#define FIT_CONNECTIVITY_CAPABILITIES_GOLF_COURSE_DOWNLOAD                       ((FIT_CONNECTIVITY_CAPABILITIES)0x00004000)
#define FIT_CONNECTIVITY_CAPABILITIES_DEVICE_INITIATES_SYNC                      ((FIT_CONNECTIVITY_CAPABILITIES)0x00008000) // Indicates device is in control of initiating all syncs
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_WATCH_APP_DOWNLOAD              ((FIT_CONNECTIVITY_CAPABILITIES)0x00010000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_WIDGET_DOWNLOAD                 ((FIT_CONNECTIVITY_CAPABILITIES)0x00020000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_WATCH_FACE_DOWNLOAD             ((FIT_CONNECTIVITY_CAPABILITIES)0x00040000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_DATA_FIELD_DOWNLOAD             ((FIT_CONNECTIVITY_CAPABILITIES)0x00080000)
#define FIT_CONNECTIVITY_CAPABILITIES_CONNECT_IQ_APP_MANAGMENT                   ((FIT_CONNECTIVITY_CAPABILITIES)0x00100000) // Device supports delete and reorder of apps via GCM
#define FIT_CONNECTIVITY_CAPABILITIES_SWING_SENSOR                               ((FIT_CONNECTIVITY_CAPABILITIES)0x00200000)
#define FIT_CONNECTIVITY_CAPABILITIES_SWING_SENSOR_REMOTE                        ((FIT_CONNECTIVITY_CAPABILITIES)0x00400000)
#define FIT_CONNECTIVITY_CAPABILITIES_INCIDENT_DETECTION                         ((FIT_CONNECTIVITY_CAPABILITIES)0x00800000) // Device supports incident detection
#define FIT_CONNECTIVITY_CAPABILITIES_AUDIO_PROMPTS                              ((FIT_CONNECTIVITY_CAPABILITIES)0x01000000)
#define FIT_CONNECTIVITY_CAPABILITIES_WIFI_VERIFICATION                          ((FIT_CONNECTIVITY_CAPABILITIES)0x02000000) // Device supports reporting wifi verification via GCM
#define FIT_CONNECTIVITY_CAPABILITIES_TRUE_UP                                    ((FIT_CONNECTIVITY_CAPABILITIES)0x04000000) // Device supports True Up
#define FIT_CONNECTIVITY_CAPABILITIES_FIND_MY_WATCH                              ((FIT_CONNECTIVITY_CAPABILITIES)0x08000000) // Device supports Find My Watch
#define FIT_CONNECTIVITY_CAPABILITIES_REMOTE_MANUAL_SYNC                         ((FIT_CONNECTIVITY_CAPABILITIES)0x10000000)
#define FIT_CONNECTIVITY_CAPABILITIES_LIVE_TRACK_AUTO_START                      ((FIT_CONNECTIVITY_CAPABILITIES)0x20000000) // Device supports LiveTrack auto start
#define FIT_CONNECTIVITY_CAPABILITIES_LIVE_TRACK_MESSAGING                       ((FIT_CONNECTIVITY_CAPABILITIES)0x40000000) // Device supports LiveTrack Messaging
#define FIT_CONNECTIVITY_CAPABILITIES_INSTANT_INPUT                              ((FIT_CONNECTIVITY_CAPABILITIES)0x80000000) // Device supports instant input feature
#define FIT_CONNECTIVITY_CAPABILITIES_COUNT                                      32

typedef FIT_ENUM FIT_WEATHER_REPORT;
#define FIT_WEATHER_REPORT_INVALID                                               FIT_ENUM_INVALID
#define FIT_WEATHER_REPORT_CURRENT                                               ((FIT_WEATHER_REPORT)0)
#define FIT_WEATHER_REPORT_FORECAST                                              ((FIT_WEATHER_REPORT)1) // Deprecated use hourly_forecast instead
#define FIT_WEATHER_REPORT_HOURLY_FORECAST                                       ((FIT_WEATHER_REPORT)1)
#define FIT_WEATHER_REPORT_DAILY_FORECAST                                        ((FIT_WEATHER_REPORT)2)
#define FIT_WEATHER_REPORT_COUNT                                                 4

typedef FIT_ENUM FIT_WEATHER_STATUS;
#define FIT_WEATHER_STATUS_INVALID                                               FIT_ENUM_INVALID
#define FIT_WEATHER_STATUS_CLEAR                                                 ((FIT_WEATHER_STATUS)0)
#define FIT_WEATHER_STATUS_PARTLY_CLOUDY                                         ((FIT_WEATHER_STATUS)1)
#define FIT_WEATHER_STATUS_MOSTLY_CLOUDY                                         ((FIT_WEATHER_STATUS)2)
#define FIT_WEATHER_STATUS_RAIN                                                  ((FIT_WEATHER_STATUS)3)
#define FIT_WEATHER_STATUS_SNOW                                                  ((FIT_WEATHER_STATUS)4)
#define FIT_WEATHER_STATUS_WINDY                                                 ((FIT_WEATHER_STATUS)5)
#define FIT_WEATHER_STATUS_THUNDERSTORMS                                         ((FIT_WEATHER_STATUS)6)
#define FIT_WEATHER_STATUS_WINTRY_MIX                                            ((FIT_WEATHER_STATUS)7)
#define FIT_WEATHER_STATUS_FOG                                                   ((FIT_WEATHER_STATUS)8)
#define FIT_WEATHER_STATUS_HAZY                                                  ((FIT_WEATHER_STATUS)11)
#define FIT_WEATHER_STATUS_HAIL                                                  ((FIT_WEATHER_STATUS)12)
#define FIT_WEATHER_STATUS_SCATTERED_SHOWERS                                     ((FIT_WEATHER_STATUS)13)
#define FIT_WEATHER_STATUS_SCATTERED_THUNDERSTORMS                               ((FIT_WEATHER_STATUS)14)
#define FIT_WEATHER_STATUS_UNKNOWN_PRECIPITATION                                 ((FIT_WEATHER_STATUS)15)
#define FIT_WEATHER_STATUS_LIGHT_RAIN                                            ((FIT_WEATHER_STATUS)16)
#define FIT_WEATHER_STATUS_HEAVY_RAIN                                            ((FIT_WEATHER_STATUS)17)
#define FIT_WEATHER_STATUS_LIGHT_SNOW                                            ((FIT_WEATHER_STATUS)18)
#define FIT_WEATHER_STATUS_HEAVY_SNOW                                            ((FIT_WEATHER_STATUS)19)
#define FIT_WEATHER_STATUS_LIGHT_RAIN_SNOW                                       ((FIT_WEATHER_STATUS)20)
#define FIT_WEATHER_STATUS_HEAVY_RAIN_SNOW                                       ((FIT_WEATHER_STATUS)21)
#define FIT_WEATHER_STATUS_CLOUDY                                                ((FIT_WEATHER_STATUS)22)
#define FIT_WEATHER_STATUS_COUNT                                                 21

typedef FIT_ENUM FIT_WEATHER_SEVERITY;
#define FIT_WEATHER_SEVERITY_INVALID                                             FIT_ENUM_INVALID
#define FIT_WEATHER_SEVERITY_UNKNOWN                                             ((FIT_WEATHER_SEVERITY)0)
#define FIT_WEATHER_SEVERITY_WARNING                                             ((FIT_WEATHER_SEVERITY)1)
#define FIT_WEATHER_SEVERITY_WATCH                                               ((FIT_WEATHER_SEVERITY)2)
#define FIT_WEATHER_SEVERITY_ADVISORY                                            ((FIT_WEATHER_SEVERITY)3)
#define FIT_WEATHER_SEVERITY_STATEMENT                                           ((FIT_WEATHER_SEVERITY)4)
#define FIT_WEATHER_SEVERITY_COUNT                                               5

typedef FIT_ENUM FIT_WEATHER_SEVERE_TYPE;
#define FIT_WEATHER_SEVERE_TYPE_INVALID                                          FIT_ENUM_INVALID
#define FIT_WEATHER_SEVERE_TYPE_UNSPECIFIED                                      ((FIT_WEATHER_SEVERE_TYPE)0)
#define FIT_WEATHER_SEVERE_TYPE_TORNADO                                          ((FIT_WEATHER_SEVERE_TYPE)1)
#define FIT_WEATHER_SEVERE_TYPE_TSUNAMI                                          ((FIT_WEATHER_SEVERE_TYPE)2)
#define FIT_WEATHER_SEVERE_TYPE_HURRICANE                                        ((FIT_WEATHER_SEVERE_TYPE)3)
#define FIT_WEATHER_SEVERE_TYPE_EXTREME_WIND                                     ((FIT_WEATHER_SEVERE_TYPE)4)
#define FIT_WEATHER_SEVERE_TYPE_TYPHOON                                          ((FIT_WEATHER_SEVERE_TYPE)5)
#define FIT_WEATHER_SEVERE_TYPE_INLAND_HURRICANE                                 ((FIT_WEATHER_SEVERE_TYPE)6)
#define FIT_WEATHER_SEVERE_TYPE_HURRICANE_FORCE_WIND                             ((FIT_WEATHER_SEVERE_TYPE)7)
#define FIT_WEATHER_SEVERE_TYPE_WATERSPOUT                                       ((FIT_WEATHER_SEVERE_TYPE)8)
#define FIT_WEATHER_SEVERE_TYPE_SEVERE_THUNDERSTORM                              ((FIT_WEATHER_SEVERE_TYPE)9)
#define FIT_WEATHER_SEVERE_TYPE_WRECKHOUSE_WINDS                                 ((FIT_WEATHER_SEVERE_TYPE)10)
#define FIT_WEATHER_SEVERE_TYPE_LES_SUETES_WIND                                  ((FIT_WEATHER_SEVERE_TYPE)11)
#define FIT_WEATHER_SEVERE_TYPE_AVALANCHE                                        ((FIT_WEATHER_SEVERE_TYPE)12)
#define FIT_WEATHER_SEVERE_TYPE_FLASH_FLOOD                                      ((FIT_WEATHER_SEVERE_TYPE)13)
#define FIT_WEATHER_SEVERE_TYPE_TROPICAL_STORM                                   ((FIT_WEATHER_SEVERE_TYPE)14)
#define FIT_WEATHER_SEVERE_TYPE_INLAND_TROPICAL_STORM                            ((FIT_WEATHER_SEVERE_TYPE)15)
#define FIT_WEATHER_SEVERE_TYPE_BLIZZARD                                         ((FIT_WEATHER_SEVERE_TYPE)16)
#define FIT_WEATHER_SEVERE_TYPE_ICE_STORM                                        ((FIT_WEATHER_SEVERE_TYPE)17)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_RAIN                                    ((FIT_WEATHER_SEVERE_TYPE)18)
#define FIT_WEATHER_SEVERE_TYPE_DEBRIS_FLOW                                      ((FIT_WEATHER_SEVERE_TYPE)19)
#define FIT_WEATHER_SEVERE_TYPE_FLASH_FREEZE                                     ((FIT_WEATHER_SEVERE_TYPE)20)
#define FIT_WEATHER_SEVERE_TYPE_DUST_STORM                                       ((FIT_WEATHER_SEVERE_TYPE)21)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_WIND                                        ((FIT_WEATHER_SEVERE_TYPE)22)
#define FIT_WEATHER_SEVERE_TYPE_WINTER_STORM                                     ((FIT_WEATHER_SEVERE_TYPE)23)
#define FIT_WEATHER_SEVERE_TYPE_HEAVY_FREEZING_SPRAY                             ((FIT_WEATHER_SEVERE_TYPE)24)
#define FIT_WEATHER_SEVERE_TYPE_EXTREME_COLD                                     ((FIT_WEATHER_SEVERE_TYPE)25)
#define FIT_WEATHER_SEVERE_TYPE_WIND_CHILL                                       ((FIT_WEATHER_SEVERE_TYPE)26)
#define FIT_WEATHER_SEVERE_TYPE_COLD_WAVE                                        ((FIT_WEATHER_SEVERE_TYPE)27)
#define FIT_WEATHER_SEVERE_TYPE_HEAVY_SNOW_ALERT                                 ((FIT_WEATHER_SEVERE_TYPE)28)
#define FIT_WEATHER_SEVERE_TYPE_LAKE_EFFECT_BLOWING_SNOW                         ((FIT_WEATHER_SEVERE_TYPE)29)
#define FIT_WEATHER_SEVERE_TYPE_SNOW_SQUALL                                      ((FIT_WEATHER_SEVERE_TYPE)30)
#define FIT_WEATHER_SEVERE_TYPE_LAKE_EFFECT_SNOW                                 ((FIT_WEATHER_SEVERE_TYPE)31)
#define FIT_WEATHER_SEVERE_TYPE_WINTER_WEATHER                                   ((FIT_WEATHER_SEVERE_TYPE)32)
#define FIT_WEATHER_SEVERE_TYPE_SLEET                                            ((FIT_WEATHER_SEVERE_TYPE)33)
#define FIT_WEATHER_SEVERE_TYPE_SNOWFALL                                         ((FIT_WEATHER_SEVERE_TYPE)34)
#define FIT_WEATHER_SEVERE_TYPE_SNOW_AND_BLOWING_SNOW                            ((FIT_WEATHER_SEVERE_TYPE)35)
#define FIT_WEATHER_SEVERE_TYPE_BLOWING_SNOW                                     ((FIT_WEATHER_SEVERE_TYPE)36)
#define FIT_WEATHER_SEVERE_TYPE_SNOW_ALERT                                       ((FIT_WEATHER_SEVERE_TYPE)37)
#define FIT_WEATHER_SEVERE_TYPE_ARCTIC_OUTFLOW                                   ((FIT_WEATHER_SEVERE_TYPE)38)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_DRIZZLE                                 ((FIT_WEATHER_SEVERE_TYPE)39)
#define FIT_WEATHER_SEVERE_TYPE_STORM                                            ((FIT_WEATHER_SEVERE_TYPE)40)
#define FIT_WEATHER_SEVERE_TYPE_STORM_SURGE                                      ((FIT_WEATHER_SEVERE_TYPE)41)
#define FIT_WEATHER_SEVERE_TYPE_RAINFALL                                         ((FIT_WEATHER_SEVERE_TYPE)42)
#define FIT_WEATHER_SEVERE_TYPE_AREAL_FLOOD                                      ((FIT_WEATHER_SEVERE_TYPE)43)
#define FIT_WEATHER_SEVERE_TYPE_COASTAL_FLOOD                                    ((FIT_WEATHER_SEVERE_TYPE)44)
#define FIT_WEATHER_SEVERE_TYPE_LAKESHORE_FLOOD                                  ((FIT_WEATHER_SEVERE_TYPE)45)
#define FIT_WEATHER_SEVERE_TYPE_EXCESSIVE_HEAT                                   ((FIT_WEATHER_SEVERE_TYPE)46)
#define FIT_WEATHER_SEVERE_TYPE_HEAT                                             ((FIT_WEATHER_SEVERE_TYPE)47)
#define FIT_WEATHER_SEVERE_TYPE_WEATHER                                          ((FIT_WEATHER_SEVERE_TYPE)48)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_HEAT_AND_HUMIDITY                           ((FIT_WEATHER_SEVERE_TYPE)49)
#define FIT_WEATHER_SEVERE_TYPE_HUMIDEX_AND_HEALTH                               ((FIT_WEATHER_SEVERE_TYPE)50)
#define FIT_WEATHER_SEVERE_TYPE_HUMIDEX                                          ((FIT_WEATHER_SEVERE_TYPE)51)
#define FIT_WEATHER_SEVERE_TYPE_GALE                                             ((FIT_WEATHER_SEVERE_TYPE)52)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_SPRAY                                   ((FIT_WEATHER_SEVERE_TYPE)53)
#define FIT_WEATHER_SEVERE_TYPE_SPECIAL_MARINE                                   ((FIT_WEATHER_SEVERE_TYPE)54)
#define FIT_WEATHER_SEVERE_TYPE_SQUALL                                           ((FIT_WEATHER_SEVERE_TYPE)55)
#define FIT_WEATHER_SEVERE_TYPE_STRONG_WIND                                      ((FIT_WEATHER_SEVERE_TYPE)56)
#define FIT_WEATHER_SEVERE_TYPE_LAKE_WIND                                        ((FIT_WEATHER_SEVERE_TYPE)57)
#define FIT_WEATHER_SEVERE_TYPE_MARINE_WEATHER                                   ((FIT_WEATHER_SEVERE_TYPE)58)
#define FIT_WEATHER_SEVERE_TYPE_WIND                                             ((FIT_WEATHER_SEVERE_TYPE)59)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT_HAZARDOUS_SEAS                       ((FIT_WEATHER_SEVERE_TYPE)60)
#define FIT_WEATHER_SEVERE_TYPE_HAZARDOUS_SEAS                                   ((FIT_WEATHER_SEVERE_TYPE)61)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT                                      ((FIT_WEATHER_SEVERE_TYPE)62)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT_WINDS                                ((FIT_WEATHER_SEVERE_TYPE)63)
#define FIT_WEATHER_SEVERE_TYPE_SMALL_CRAFT_ROUGH_BAR                            ((FIT_WEATHER_SEVERE_TYPE)64)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_WATER_LEVEL                                 ((FIT_WEATHER_SEVERE_TYPE)65)
#define FIT_WEATHER_SEVERE_TYPE_ASHFALL                                          ((FIT_WEATHER_SEVERE_TYPE)66)
#define FIT_WEATHER_SEVERE_TYPE_FREEZING_FOG                                     ((FIT_WEATHER_SEVERE_TYPE)67)
#define FIT_WEATHER_SEVERE_TYPE_DENSE_FOG                                        ((FIT_WEATHER_SEVERE_TYPE)68)
#define FIT_WEATHER_SEVERE_TYPE_DENSE_SMOKE                                      ((FIT_WEATHER_SEVERE_TYPE)69)
#define FIT_WEATHER_SEVERE_TYPE_BLOWING_DUST                                     ((FIT_WEATHER_SEVERE_TYPE)70)
#define FIT_WEATHER_SEVERE_TYPE_HARD_FREEZE                                      ((FIT_WEATHER_SEVERE_TYPE)71)
#define FIT_WEATHER_SEVERE_TYPE_FREEZE                                           ((FIT_WEATHER_SEVERE_TYPE)72)
#define FIT_WEATHER_SEVERE_TYPE_FROST                                            ((FIT_WEATHER_SEVERE_TYPE)73)
#define FIT_WEATHER_SEVERE_TYPE_FIRE_WEATHER                                     ((FIT_WEATHER_SEVERE_TYPE)74)
#define FIT_WEATHER_SEVERE_TYPE_FLOOD                                            ((FIT_WEATHER_SEVERE_TYPE)75)
#define FIT_WEATHER_SEVERE_TYPE_RIP_TIDE                                         ((FIT_WEATHER_SEVERE_TYPE)76)
#define FIT_WEATHER_SEVERE_TYPE_HIGH_SURF                                        ((FIT_WEATHER_SEVERE_TYPE)77)
#define FIT_WEATHER_SEVERE_TYPE_SMOG                                             ((FIT_WEATHER_SEVERE_TYPE)78)
#define FIT_WEATHER_SEVERE_TYPE_AIR_QUALITY                                      ((FIT_WEATHER_SEVERE_TYPE)79)
#define FIT_WEATHER_SEVERE_TYPE_BRISK_WIND                                       ((FIT_WEATHER_SEVERE_TYPE)80)
#define FIT_WEATHER_SEVERE_TYPE_AIR_STAGNATION                                   ((FIT_WEATHER_SEVERE_TYPE)81)
#define FIT_WEATHER_SEVERE_TYPE_LOW_WATER                                        ((FIT_WEATHER_SEVERE_TYPE)82)
#define FIT_WEATHER_SEVERE_TYPE_HYDROLOGICAL                                     ((FIT_WEATHER_SEVERE_TYPE)83)
#define FIT_WEATHER_SEVERE_TYPE_SPECIAL_WEATHER                                  ((FIT_WEATHER_SEVERE_TYPE)84)
#define FIT_WEATHER_SEVERE_TYPE_COUNT                                            85

typedef FIT_UINT32 FIT_TIME_INTO_DAY; // number of seconds into the day since 00:00:00 UTC
#define FIT_TIME_INTO_DAY_INVALID                                                FIT_UINT32_INVALID
#define FIT_TIME_INTO_DAY_COUNT                                                  0

typedef FIT_UINT32 FIT_LOCALTIME_INTO_DAY; // number of seconds into the day since local 00:00:00
#define FIT_LOCALTIME_INTO_DAY_INVALID                                           FIT_UINT32_INVALID
#define FIT_LOCALTIME_INTO_DAY_COUNT                                             0

typedef FIT_ENUM FIT_STROKE_TYPE;
#define FIT_STROKE_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_STROKE_TYPE_NO_EVENT                                                 ((FIT_STROKE_TYPE)0)
#define FIT_STROKE_TYPE_OTHER                                                    ((FIT_STROKE_TYPE)1) // stroke was detected but cannot be identified
#define FIT_STROKE_TYPE_SERVE                                                    ((FIT_STROKE_TYPE)2)
#define FIT_STROKE_TYPE_FOREHAND                                                 ((FIT_STROKE_TYPE)3)
#define FIT_STROKE_TYPE_BACKHAND                                                 ((FIT_STROKE_TYPE)4)
#define FIT_STROKE_TYPE_SMASH                                                    ((FIT_STROKE_TYPE)5)
#define FIT_STROKE_TYPE_COUNT                                                    6

typedef FIT_ENUM FIT_BODY_LOCATION;
#define FIT_BODY_LOCATION_INVALID                                                FIT_ENUM_INVALID
#define FIT_BODY_LOCATION_LEFT_LEG                                               ((FIT_BODY_LOCATION)0)
#define FIT_BODY_LOCATION_LEFT_CALF                                              ((FIT_BODY_LOCATION)1)
#define FIT_BODY_LOCATION_LEFT_SHIN                                              ((FIT_BODY_LOCATION)2)
#define FIT_BODY_LOCATION_LEFT_HAMSTRING                                         ((FIT_BODY_LOCATION)3)
#define FIT_BODY_LOCATION_LEFT_QUAD                                              ((FIT_BODY_LOCATION)4)
#define FIT_BODY_LOCATION_LEFT_GLUTE                                             ((FIT_BODY_LOCATION)5)
#define FIT_BODY_LOCATION_RIGHT_LEG                                              ((FIT_BODY_LOCATION)6)
#define FIT_BODY_LOCATION_RIGHT_CALF                                             ((FIT_BODY_LOCATION)7)
#define FIT_BODY_LOCATION_RIGHT_SHIN                                             ((FIT_BODY_LOCATION)8)
#define FIT_BODY_LOCATION_RIGHT_HAMSTRING                                        ((FIT_BODY_LOCATION)9)
#define FIT_BODY_LOCATION_RIGHT_QUAD                                             ((FIT_BODY_LOCATION)10)
#define FIT_BODY_LOCATION_RIGHT_GLUTE                                            ((FIT_BODY_LOCATION)11)
#define FIT_BODY_LOCATION_TORSO_BACK                                             ((FIT_BODY_LOCATION)12)
#define FIT_BODY_LOCATION_LEFT_LOWER_BACK                                        ((FIT_BODY_LOCATION)13)
#define FIT_BODY_LOCATION_LEFT_UPPER_BACK                                        ((FIT_BODY_LOCATION)14)
#define FIT_BODY_LOCATION_RIGHT_LOWER_BACK                                       ((FIT_BODY_LOCATION)15)
#define FIT_BODY_LOCATION_RIGHT_UPPER_BACK                                       ((FIT_BODY_LOCATION)16)
#define FIT_BODY_LOCATION_TORSO_FRONT                                            ((FIT_BODY_LOCATION)17)
#define FIT_BODY_LOCATION_LEFT_ABDOMEN                                           ((FIT_BODY_LOCATION)18)
#define FIT_BODY_LOCATION_LEFT_CHEST                                             ((FIT_BODY_LOCATION)19)
#define FIT_BODY_LOCATION_RIGHT_ABDOMEN                                          ((FIT_BODY_LOCATION)20)
#define FIT_BODY_LOCATION_RIGHT_CHEST                                            ((FIT_BODY_LOCATION)21)
#define FIT_BODY_LOCATION_LEFT_ARM                                               ((FIT_BODY_LOCATION)22)
#define FIT_BODY_LOCATION_LEFT_SHOULDER                                          ((FIT_BODY_LOCATION)23)
#define FIT_BODY_LOCATION_LEFT_BICEP                                             ((FIT_BODY_LOCATION)24)
#define FIT_BODY_LOCATION_LEFT_TRICEP                                            ((FIT_BODY_LOCATION)25)
#define FIT_BODY_LOCATION_LEFT_BRACHIORADIALIS                                   ((FIT_BODY_LOCATION)26) // Left anterior forearm
#define FIT_BODY_LOCATION_LEFT_FOREARM_EXTENSORS                                 ((FIT_BODY_LOCATION)27) // Left posterior forearm
#define FIT_BODY_LOCATION_RIGHT_ARM                                              ((FIT_BODY_LOCATION)28)
#define FIT_BODY_LOCATION_RIGHT_SHOULDER                                         ((FIT_BODY_LOCATION)29)
#define FIT_BODY_LOCATION_RIGHT_BICEP                                            ((FIT_BODY_LOCATION)30)
#define FIT_BODY_LOCATION_RIGHT_TRICEP                                           ((FIT_BODY_LOCATION)31)
#define FIT_BODY_LOCATION_RIGHT_BRACHIORADIALIS                                  ((FIT_BODY_LOCATION)32) // Right anterior forearm
#define FIT_BODY_LOCATION_RIGHT_FOREARM_EXTENSORS                                ((FIT_BODY_LOCATION)33) // Right posterior forearm
#define FIT_BODY_LOCATION_NECK                                                   ((FIT_BODY_LOCATION)34)
#define FIT_BODY_LOCATION_THROAT                                                 ((FIT_BODY_LOCATION)35)
#define FIT_BODY_LOCATION_WAIST_MID_BACK                                         ((FIT_BODY_LOCATION)36)
#define FIT_BODY_LOCATION_WAIST_FRONT                                            ((FIT_BODY_LOCATION)37)
#define FIT_BODY_LOCATION_WAIST_LEFT                                             ((FIT_BODY_LOCATION)38)
#define FIT_BODY_LOCATION_WAIST_RIGHT                                            ((FIT_BODY_LOCATION)39)
#define FIT_BODY_LOCATION_COUNT                                                  40

typedef FIT_ENUM FIT_SEGMENT_LAP_STATUS;
#define FIT_SEGMENT_LAP_STATUS_INVALID                                           FIT_ENUM_INVALID
#define FIT_SEGMENT_LAP_STATUS_END                                               ((FIT_SEGMENT_LAP_STATUS)0)
#define FIT_SEGMENT_LAP_STATUS_FAIL                                              ((FIT_SEGMENT_LAP_STATUS)1)
#define FIT_SEGMENT_LAP_STATUS_COUNT                                             2

typedef FIT_ENUM FIT_SEGMENT_LEADERBOARD_TYPE;
#define FIT_SEGMENT_LEADERBOARD_TYPE_INVALID                                     FIT_ENUM_INVALID
#define FIT_SEGMENT_LEADERBOARD_TYPE_OVERALL                                     ((FIT_SEGMENT_LEADERBOARD_TYPE)0)
#define FIT_SEGMENT_LEADERBOARD_TYPE_PERSONAL_BEST                               ((FIT_SEGMENT_LEADERBOARD_TYPE)1)
#define FIT_SEGMENT_LEADERBOARD_TYPE_CONNECTIONS                                 ((FIT_SEGMENT_LEADERBOARD_TYPE)2)
#define FIT_SEGMENT_LEADERBOARD_TYPE_GROUP                                       ((FIT_SEGMENT_LEADERBOARD_TYPE)3)
#define FIT_SEGMENT_LEADERBOARD_TYPE_CHALLENGER                                  ((FIT_SEGMENT_LEADERBOARD_TYPE)4)
#define FIT_SEGMENT_LEADERBOARD_TYPE_KOM                                         ((FIT_SEGMENT_LEADERBOARD_TYPE)5)
#define FIT_SEGMENT_LEADERBOARD_TYPE_QOM                                         ((FIT_SEGMENT_LEADERBOARD_TYPE)6)
#define FIT_SEGMENT_LEADERBOARD_TYPE_PR                                          ((FIT_SEGMENT_LEADERBOARD_TYPE)7)
#define FIT_SEGMENT_LEADERBOARD_TYPE_GOAL                                        ((FIT_SEGMENT_LEADERBOARD_TYPE)8)
#define FIT_SEGMENT_LEADERBOARD_TYPE_RIVAL                                       ((FIT_SEGMENT_LEADERBOARD_TYPE)9)
#define FIT_SEGMENT_LEADERBOARD_TYPE_CLUB_LEADER                                 ((FIT_SEGMENT_LEADERBOARD_TYPE)10)
#define FIT_SEGMENT_LEADERBOARD_TYPE_COUNT                                       11

typedef FIT_ENUM FIT_SEGMENT_DELETE_STATUS;
#define FIT_SEGMENT_DELETE_STATUS_INVALID                                        FIT_ENUM_INVALID
#define FIT_SEGMENT_DELETE_STATUS_DO_NOT_DELETE                                  ((FIT_SEGMENT_DELETE_STATUS)0)
#define FIT_SEGMENT_DELETE_STATUS_DELETE_ONE                                     ((FIT_SEGMENT_DELETE_STATUS)1)
#define FIT_SEGMENT_DELETE_STATUS_DELETE_ALL                                     ((FIT_SEGMENT_DELETE_STATUS)2)
#define FIT_SEGMENT_DELETE_STATUS_COUNT                                          3

typedef FIT_ENUM FIT_SEGMENT_SELECTION_TYPE;
#define FIT_SEGMENT_SELECTION_TYPE_INVALID                                       FIT_ENUM_INVALID
#define FIT_SEGMENT_SELECTION_TYPE_STARRED                                       ((FIT_SEGMENT_SELECTION_TYPE)0)
#define FIT_SEGMENT_SELECTION_TYPE_SUGGESTED                                     ((FIT_SEGMENT_SELECTION_TYPE)1)
#define FIT_SEGMENT_SELECTION_TYPE_COUNT                                         2

typedef FIT_ENUM FIT_SOURCE_TYPE;
#define FIT_SOURCE_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SOURCE_TYPE_ANT                                                      ((FIT_SOURCE_TYPE)0) // External device connected with ANT
#define FIT_SOURCE_TYPE_ANTPLUS                                                  ((FIT_SOURCE_TYPE)1) // External device connected with ANT+
#define FIT_SOURCE_TYPE_BLUETOOTH                                                ((FIT_SOURCE_TYPE)2) // External device connected with BT
#define FIT_SOURCE_TYPE_BLUETOOTH_LOW_ENERGY                                     ((FIT_SOURCE_TYPE)3) // External device connected with BLE
#define FIT_SOURCE_TYPE_WIFI                                                     ((FIT_SOURCE_TYPE)4) // External device connected with Wifi
#define FIT_SOURCE_TYPE_LOCAL                                                    ((FIT_SOURCE_TYPE)5) // Onboard device
#define FIT_SOURCE_TYPE_COUNT                                                    6

typedef FIT_ENUM FIT_DISPLAY_ORIENTATION;
#define FIT_DISPLAY_ORIENTATION_INVALID                                          FIT_ENUM_INVALID
#define FIT_DISPLAY_ORIENTATION_AUTO                                             ((FIT_DISPLAY_ORIENTATION)0) // automatic if the device supports it
#define FIT_DISPLAY_ORIENTATION_PORTRAIT                                         ((FIT_DISPLAY_ORIENTATION)1)
#define FIT_DISPLAY_ORIENTATION_LANDSCAPE                                        ((FIT_DISPLAY_ORIENTATION)2)
#define FIT_DISPLAY_ORIENTATION_PORTRAIT_FLIPPED                                 ((FIT_DISPLAY_ORIENTATION)3) // portrait mode but rotated 180 degrees
#define FIT_DISPLAY_ORIENTATION_LANDSCAPE_FLIPPED                                ((FIT_DISPLAY_ORIENTATION)4) // landscape mode but rotated 180 degrees
#define FIT_DISPLAY_ORIENTATION_COUNT                                            5

typedef FIT_ENUM FIT_WORKOUT_EQUIPMENT;
#define FIT_WORKOUT_EQUIPMENT_INVALID                                            FIT_ENUM_INVALID
#define FIT_WORKOUT_EQUIPMENT_NONE                                               ((FIT_WORKOUT_EQUIPMENT)0)
#define FIT_WORKOUT_EQUIPMENT_SWIM_FINS                                          ((FIT_WORKOUT_EQUIPMENT)1)
#define FIT_WORKOUT_EQUIPMENT_SWIM_KICKBOARD                                     ((FIT_WORKOUT_EQUIPMENT)2)
#define FIT_WORKOUT_EQUIPMENT_SWIM_PADDLES                                       ((FIT_WORKOUT_EQUIPMENT)3)
#define FIT_WORKOUT_EQUIPMENT_SWIM_PULL_BUOY                                     ((FIT_WORKOUT_EQUIPMENT)4)
#define FIT_WORKOUT_EQUIPMENT_SWIM_SNORKEL                                       ((FIT_WORKOUT_EQUIPMENT)5)
#define FIT_WORKOUT_EQUIPMENT_COUNT                                              6

typedef FIT_ENUM FIT_WATCHFACE_MODE;
#define FIT_WATCHFACE_MODE_INVALID                                               FIT_ENUM_INVALID
#define FIT_WATCHFACE_MODE_DIGITAL                                               ((FIT_WATCHFACE_MODE)0)
#define FIT_WATCHFACE_MODE_ANALOG                                                ((FIT_WATCHFACE_MODE)1)
#define FIT_WATCHFACE_MODE_CONNECT_IQ                                            ((FIT_WATCHFACE_MODE)2)
#define FIT_WATCHFACE_MODE_DISABLED                                              ((FIT_WATCHFACE_MODE)3)
#define FIT_WATCHFACE_MODE_COUNT                                                 4

typedef FIT_ENUM FIT_DIGITAL_WATCHFACE_LAYOUT;
#define FIT_DIGITAL_WATCHFACE_LAYOUT_INVALID                                     FIT_ENUM_INVALID
#define FIT_DIGITAL_WATCHFACE_LAYOUT_TRADITIONAL                                 ((FIT_DIGITAL_WATCHFACE_LAYOUT)0)
#define FIT_DIGITAL_WATCHFACE_LAYOUT_MODERN                                      ((FIT_DIGITAL_WATCHFACE_LAYOUT)1)
#define FIT_DIGITAL_WATCHFACE_LAYOUT_BOLD                                        ((FIT_DIGITAL_WATCHFACE_LAYOUT)2)
#define FIT_DIGITAL_WATCHFACE_LAYOUT_COUNT                                       3

typedef FIT_ENUM FIT_ANALOG_WATCHFACE_LAYOUT;
#define FIT_ANALOG_WATCHFACE_LAYOUT_INVALID                                      FIT_ENUM_INVALID
#define FIT_ANALOG_WATCHFACE_LAYOUT_MINIMAL                                      ((FIT_ANALOG_WATCHFACE_LAYOUT)0)
#define FIT_ANALOG_WATCHFACE_LAYOUT_TRADITIONAL                                  ((FIT_ANALOG_WATCHFACE_LAYOUT)1)
#define FIT_ANALOG_WATCHFACE_LAYOUT_MODERN                                       ((FIT_ANALOG_WATCHFACE_LAYOUT)2)
#define FIT_ANALOG_WATCHFACE_LAYOUT_COUNT                                        3

typedef FIT_ENUM FIT_RIDER_POSITION_TYPE;
#define FIT_RIDER_POSITION_TYPE_INVALID                                          FIT_ENUM_INVALID
#define FIT_RIDER_POSITION_TYPE_SEATED                                           ((FIT_RIDER_POSITION_TYPE)0)
#define FIT_RIDER_POSITION_TYPE_STANDING                                         ((FIT_RIDER_POSITION_TYPE)1)
#define FIT_RIDER_POSITION_TYPE_TRANSITION_TO_SEATED                             ((FIT_RIDER_POSITION_TYPE)2)
#define FIT_RIDER_POSITION_TYPE_TRANSITION_TO_STANDING                           ((FIT_RIDER_POSITION_TYPE)3)
#define FIT_RIDER_POSITION_TYPE_COUNT                                            4

typedef FIT_ENUM FIT_POWER_PHASE_TYPE;
#define FIT_POWER_PHASE_TYPE_INVALID                                             FIT_ENUM_INVALID
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_START_ANGLE                             ((FIT_POWER_PHASE_TYPE)0)
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_END_ANGLE                               ((FIT_POWER_PHASE_TYPE)1)
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_ARC_LENGTH                              ((FIT_POWER_PHASE_TYPE)2)
#define FIT_POWER_PHASE_TYPE_POWER_PHASE_CENTER                                  ((FIT_POWER_PHASE_TYPE)3)
#define FIT_POWER_PHASE_TYPE_COUNT                                               4

typedef FIT_ENUM FIT_CAMERA_EVENT_TYPE;
#define FIT_CAMERA_EVENT_TYPE_INVALID                                            FIT_ENUM_INVALID
#define FIT_CAMERA_EVENT_TYPE_VIDEO_START                                        ((FIT_CAMERA_EVENT_TYPE)0) // Start of video recording
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SPLIT                                        ((FIT_CAMERA_EVENT_TYPE)1) // Mark of video file split (end of one file, beginning of the other)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_END                                          ((FIT_CAMERA_EVENT_TYPE)2) // End of video recording
#define FIT_CAMERA_EVENT_TYPE_PHOTO_TAKEN                                        ((FIT_CAMERA_EVENT_TYPE)3) // Still photo taken
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_START                          ((FIT_CAMERA_EVENT_TYPE)4)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_SPLIT                          ((FIT_CAMERA_EVENT_TYPE)5)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_END                            ((FIT_CAMERA_EVENT_TYPE)6)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SPLIT_START                                  ((FIT_CAMERA_EVENT_TYPE)7) // Mark of video file split start
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_SPLIT_START                    ((FIT_CAMERA_EVENT_TYPE)8)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_PAUSE                                        ((FIT_CAMERA_EVENT_TYPE)11) // Mark when a video recording has been paused
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_PAUSE                          ((FIT_CAMERA_EVENT_TYPE)12)
#define FIT_CAMERA_EVENT_TYPE_VIDEO_RESUME                                       ((FIT_CAMERA_EVENT_TYPE)13) // Mark when a video recording has been resumed
#define FIT_CAMERA_EVENT_TYPE_VIDEO_SECOND_STREAM_RESUME                         ((FIT_CAMERA_EVENT_TYPE)14)
#define FIT_CAMERA_EVENT_TYPE_COUNT                                              13

typedef FIT_ENUM FIT_SENSOR_TYPE;
#define FIT_SENSOR_TYPE_INVALID                                                  FIT_ENUM_INVALID
#define FIT_SENSOR_TYPE_ACCELEROMETER                                            ((FIT_SENSOR_TYPE)0)
#define FIT_SENSOR_TYPE_GYROSCOPE                                                ((FIT_SENSOR_TYPE)1)
#define FIT_SENSOR_TYPE_COMPASS                                                  ((FIT_SENSOR_TYPE)2) // Magnetometer
#define FIT_SENSOR_TYPE_COUNT                                                    3

typedef FIT_ENUM FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE;
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_INVALID                               FIT_ENUM_INVALID
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_AUTO                                  ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)0)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_INDIVIDUAL                            ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)4)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_HIGH_VISIBILITY                       ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)5)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_TRAIL                                 ((FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE)6)
#define FIT_BIKE_LIGHT_NETWORK_CONFIG_TYPE_COUNT                                 4

typedef FIT_UINT16 FIT_COMM_TIMEOUT_TYPE;
#define FIT_COMM_TIMEOUT_TYPE_INVALID                                            FIT_UINT16_INVALID
#define FIT_COMM_TIMEOUT_TYPE_WILDCARD_PAIRING_TIMEOUT                           ((FIT_COMM_TIMEOUT_TYPE)0) // Timeout pairing to any device
#define FIT_COMM_TIMEOUT_TYPE_PAIRING_TIMEOUT                                    ((FIT_COMM_TIMEOUT_TYPE)1) // Timeout pairing to previously paired device
#define FIT_COMM_TIMEOUT_TYPE_CONNECTION_LOST                                    ((FIT_COMM_TIMEOUT_TYPE)2) // Temporary loss of communications
#define FIT_COMM_TIMEOUT_TYPE_CONNECTION_TIMEOUT                                 ((FIT_COMM_TIMEOUT_TYPE)3) // Connection closed due to extended bad communications
#define FIT_COMM_TIMEOUT_TYPE_COUNT                                              4

typedef FIT_ENUM FIT_CAMERA_ORIENTATION_TYPE;
#define FIT_CAMERA_ORIENTATION_TYPE_INVALID                                      FIT_ENUM_INVALID
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_0                         ((FIT_CAMERA_ORIENTATION_TYPE)0)
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_90                        ((FIT_CAMERA_ORIENTATION_TYPE)1)
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_180                       ((FIT_CAMERA_ORIENTATION_TYPE)2)
#define FIT_CAMERA_ORIENTATION_TYPE_CAMERA_ORIENTATION_270                       ((FIT_CAMERA_ORIENTATION_TYPE)3)
#define FIT_CAMERA_ORIENTATION_TYPE_COUNT                                        4

typedef FIT_ENUM FIT_ATTITUDE_STAGE;
#define FIT_ATTITUDE_STAGE_INVALID                                               FIT_ENUM_INVALID
#define FIT_ATTITUDE_STAGE_FAILED                                                ((FIT_ATTITUDE_STAGE)0)
#define FIT_ATTITUDE_STAGE_ALIGNING                                              ((FIT_ATTITUDE_STAGE)1)
#define FIT_ATTITUDE_STAGE_DEGRADED                                              ((FIT_ATTITUDE_STAGE)2)
#define FIT_ATTITUDE_STAGE_VALID                                                 ((FIT_ATTITUDE_STAGE)3)
#define FIT_ATTITUDE_STAGE_COUNT                                                 4

typedef FIT_UINT16 FIT_ATTITUDE_VALIDITY;
#define FIT_ATTITUDE_VALIDITY_INVALID                                            FIT_UINT16_INVALID
#define FIT_ATTITUDE_VALIDITY_TRACK_ANGLE_HEADING_VALID                          ((FIT_ATTITUDE_VALIDITY)0x0001)
#define FIT_ATTITUDE_VALIDITY_PITCH_VALID                                        ((FIT_ATTITUDE_VALIDITY)0x0002)
#define FIT_ATTITUDE_VALIDITY_ROLL_VALID                                         ((FIT_ATTITUDE_VALIDITY)0x0004)
#define FIT_ATTITUDE_VALIDITY_LATERAL_BODY_ACCEL_VALID                           ((FIT_ATTITUDE_VALIDITY)0x0008)
#define FIT_ATTITUDE_VALIDITY_NORMAL_BODY_ACCEL_VALID                            ((FIT_ATTITUDE_VALIDITY)0x0010)
#define FIT_ATTITUDE_VALIDITY_TURN_RATE_VALID                                    ((FIT_ATTITUDE_VALIDITY)0x0020)
#define FIT_ATTITUDE_VALIDITY_HW_FAIL                                            ((FIT_ATTITUDE_VALIDITY)0x0040)
#define FIT_ATTITUDE_VALIDITY_MAG_INVALID                                        ((FIT_ATTITUDE_VALIDITY)0x0080)
#define FIT_ATTITUDE_VALIDITY_NO_GPS                                             ((FIT_ATTITUDE_VALIDITY)0x0100)
#define FIT_ATTITUDE_VALIDITY_GPS_INVALID                                        ((FIT_ATTITUDE_VALIDITY)0x0200)
#define FIT_ATTITUDE_VALIDITY_SOLUTION_COASTING                                  ((FIT_ATTITUDE_VALIDITY)0x0400)
#define FIT_ATTITUDE_VALIDITY_TRUE_TRACK_ANGLE                                   ((FIT_ATTITUDE_VALIDITY)0x0800)
#define FIT_ATTITUDE_VALIDITY_MAGNETIC_HEADING                                   ((FIT_ATTITUDE_VALIDITY)0x1000)
#define FIT_ATTITUDE_VALIDITY_COUNT                                              13

typedef FIT_ENUM FIT_AUTO_SYNC_FREQUENCY;
#define FIT_AUTO_SYNC_FREQUENCY_INVALID                                          FIT_ENUM_INVALID
#define FIT_AUTO_SYNC_FREQUENCY_NEVER                                            ((FIT_AUTO_SYNC_FREQUENCY)0)
#define FIT_AUTO_SYNC_FREQUENCY_OCCASIONALLY                                     ((FIT_AUTO_SYNC_FREQUENCY)1)
#define FIT_AUTO_SYNC_FREQUENCY_FREQUENT                                         ((FIT_AUTO_SYNC_FREQUENCY)2)
#define FIT_AUTO_SYNC_FREQUENCY_ONCE_A_DAY                                       ((FIT_AUTO_SYNC_FREQUENCY)3)
#define FIT_AUTO_SYNC_FREQUENCY_REMOTE                                           ((FIT_AUTO_SYNC_FREQUENCY)4)
#define FIT_AUTO_SYNC_FREQUENCY_COUNT                                            5

typedef FIT_ENUM FIT_EXD_LAYOUT;
#define FIT_EXD_LAYOUT_INVALID                                                   FIT_ENUM_INVALID
#define FIT_EXD_LAYOUT_FULL_SCREEN                                               ((FIT_EXD_LAYOUT)0)
#define FIT_EXD_LAYOUT_HALF_VERTICAL                                             ((FIT_EXD_LAYOUT)1)
#define FIT_EXD_LAYOUT_HALF_HORIZONTAL                                           ((FIT_EXD_LAYOUT)2)
#define FIT_EXD_LAYOUT_HALF_VERTICAL_RIGHT_SPLIT                                 ((FIT_EXD_LAYOUT)3)
#define FIT_EXD_LAYOUT_HALF_HORIZONTAL_BOTTOM_SPLIT                              ((FIT_EXD_LAYOUT)4)
#define FIT_EXD_LAYOUT_FULL_QUARTER_SPLIT                                        ((FIT_EXD_LAYOUT)5)
#define FIT_EXD_LAYOUT_HALF_VERTICAL_LEFT_SPLIT                                  ((FIT_EXD_LAYOUT)6)
#define FIT_EXD_LAYOUT_HALF_HORIZONTAL_TOP_SPLIT                                 ((FIT_EXD_LAYOUT)7)
#define FIT_EXD_LAYOUT_COUNT                                                     8

typedef FIT_ENUM FIT_EXD_DISPLAY_TYPE;
#define FIT_EXD_DISPLAY_TYPE_INVALID                                             FIT_ENUM_INVALID
#define FIT_EXD_DISPLAY_TYPE_NUMERICAL                                           ((FIT_EXD_DISPLAY_TYPE)0)
#define FIT_EXD_DISPLAY_TYPE_SIMPLE                                              ((FIT_EXD_DISPLAY_TYPE)1)
#define FIT_EXD_DISPLAY_TYPE_GRAPH                                               ((FIT_EXD_DISPLAY_TYPE)2)
#define FIT_EXD_DISPLAY_TYPE_BAR                                                 ((FIT_EXD_DISPLAY_TYPE)3)
#define FIT_EXD_DISPLAY_TYPE_CIRCLE_GRAPH                                        ((FIT_EXD_DISPLAY_TYPE)4)
#define FIT_EXD_DISPLAY_TYPE_VIRTUAL_PARTNER                                     ((FIT_EXD_DISPLAY_TYPE)5)
#define FIT_EXD_DISPLAY_TYPE_BALANCE                                             ((FIT_EXD_DISPLAY_TYPE)6)
#define FIT_EXD_DISPLAY_TYPE_STRING_LIST                                         ((FIT_EXD_DISPLAY_TYPE)7)
#define FIT_EXD_DISPLAY_TYPE_STRING                                              ((FIT_EXD_DISPLAY_TYPE)8)
#define FIT_EXD_DISPLAY_TYPE_SIMPLE_DYNAMIC_ICON                                 ((FIT_EXD_DISPLAY_TYPE)9)
#define FIT_EXD_DISPLAY_TYPE_GAUGE                                               ((FIT_EXD_DISPLAY_TYPE)10)
#define FIT_EXD_DISPLAY_TYPE_COUNT                                               11

typedef FIT_ENUM FIT_EXD_DATA_UNITS;
#define FIT_EXD_DATA_UNITS_INVALID                                               FIT_ENUM_INVALID
#define FIT_EXD_DATA_UNITS_NO_UNITS                                              ((FIT_EXD_DATA_UNITS)0)
#define FIT_EXD_DATA_UNITS_LAPS                                                  ((FIT_EXD_DATA_UNITS)1)
#define FIT_EXD_DATA_UNITS_MILES_PER_HOUR                                        ((FIT_EXD_DATA_UNITS)2)
#define FIT_EXD_DATA_UNITS_KILOMETERS_PER_HOUR                                   ((FIT_EXD_DATA_UNITS)3)
#define FIT_EXD_DATA_UNITS_FEET_PER_HOUR                                         ((FIT_EXD_DATA_UNITS)4)
#define FIT_EXD_DATA_UNITS_METERS_PER_HOUR                                       ((FIT_EXD_DATA_UNITS)5)
#define FIT_EXD_DATA_UNITS_DEGREES_CELSIUS                                       ((FIT_EXD_DATA_UNITS)6)
#define FIT_EXD_DATA_UNITS_DEGREES_FARENHEIT                                     ((FIT_EXD_DATA_UNITS)7)
#define FIT_EXD_DATA_UNITS_ZONE                                                  ((FIT_EXD_DATA_UNITS)8)
#define FIT_EXD_DATA_UNITS_GEAR                                                  ((FIT_EXD_DATA_UNITS)9)
#define FIT_EXD_DATA_UNITS_RPM                                                   ((FIT_EXD_DATA_UNITS)10)
#define FIT_EXD_DATA_UNITS_BPM                                                   ((FIT_EXD_DATA_UNITS)11)
#define FIT_EXD_DATA_UNITS_DEGREES                                               ((FIT_EXD_DATA_UNITS)12)
#define FIT_EXD_DATA_UNITS_MILLIMETERS                                           ((FIT_EXD_DATA_UNITS)13)
#define FIT_EXD_DATA_UNITS_METERS                                                ((FIT_EXD_DATA_UNITS)14)
#define FIT_EXD_DATA_UNITS_KILOMETERS                                            ((FIT_EXD_DATA_UNITS)15)
#define FIT_EXD_DATA_UNITS_FEET                                                  ((FIT_EXD_DATA_UNITS)16)
#define FIT_EXD_DATA_UNITS_YARDS                                                 ((FIT_EXD_DATA_UNITS)17)
#define FIT_EXD_DATA_UNITS_KILOFEET                                              ((FIT_EXD_DATA_UNITS)18)
#define FIT_EXD_DATA_UNITS_MILES                                                 ((FIT_EXD_DATA_UNITS)19)
#define FIT_EXD_DATA_UNITS_TIME                                                  ((FIT_EXD_DATA_UNITS)20)
#define FIT_EXD_DATA_UNITS_ENUM_TURN_TYPE                                        ((FIT_EXD_DATA_UNITS)21)
#define FIT_EXD_DATA_UNITS_PERCENT                                               ((FIT_EXD_DATA_UNITS)22)
#define FIT_EXD_DATA_UNITS_WATTS                                                 ((FIT_EXD_DATA_UNITS)23)
#define FIT_EXD_DATA_UNITS_WATTS_PER_KILOGRAM                                    ((FIT_EXD_DATA_UNITS)24)
#define FIT_EXD_DATA_UNITS_ENUM_BATTERY_STATUS                                   ((FIT_EXD_DATA_UNITS)25)
#define FIT_EXD_DATA_UNITS_ENUM_BIKE_LIGHT_BEAM_ANGLE_MODE                       ((FIT_EXD_DATA_UNITS)26)
#define FIT_EXD_DATA_UNITS_ENUM_BIKE_LIGHT_BATTERY_STATUS                        ((FIT_EXD_DATA_UNITS)27)
#define FIT_EXD_DATA_UNITS_ENUM_BIKE_LIGHT_NETWORK_CONFIG_TYPE                   ((FIT_EXD_DATA_UNITS)28)
#define FIT_EXD_DATA_UNITS_LIGHTS                                                ((FIT_EXD_DATA_UNITS)29)
#define FIT_EXD_DATA_UNITS_SECONDS                                               ((FIT_EXD_DATA_UNITS)30)
#define FIT_EXD_DATA_UNITS_MINUTES                                               ((FIT_EXD_DATA_UNITS)31)
#define FIT_EXD_DATA_UNITS_HOURS                                                 ((FIT_EXD_DATA_UNITS)32)
#define FIT_EXD_DATA_UNITS_CALORIES                                              ((FIT_EXD_DATA_UNITS)33)
#define FIT_EXD_DATA_UNITS_KILOJOULES                                            ((FIT_EXD_DATA_UNITS)34)
#define FIT_EXD_DATA_UNITS_MILLISECONDS                                          ((FIT_EXD_DATA_UNITS)35)
#define FIT_EXD_DATA_UNITS_SECOND_PER_MILE                                       ((FIT_EXD_DATA_UNITS)36)
#define FIT_EXD_DATA_UNITS_SECOND_PER_KILOMETER                                  ((FIT_EXD_DATA_UNITS)37)
#define FIT_EXD_DATA_UNITS_CENTIMETER                                            ((FIT_EXD_DATA_UNITS)38)
#define FIT_EXD_DATA_UNITS_ENUM_COURSE_POINT                                     ((FIT_EXD_DATA_UNITS)39)
#define FIT_EXD_DATA_UNITS_BRADIANS                                              ((FIT_EXD_DATA_UNITS)40)
#define FIT_EXD_DATA_UNITS_ENUM_SPORT                                            ((FIT_EXD_DATA_UNITS)41)
#define FIT_EXD_DATA_UNITS_INCHES_HG                                             ((FIT_EXD_DATA_UNITS)42)
#define FIT_EXD_DATA_UNITS_MM_HG                                                 ((FIT_EXD_DATA_UNITS)43)
#define FIT_EXD_DATA_UNITS_MBARS                                                 ((FIT_EXD_DATA_UNITS)44)
#define FIT_EXD_DATA_UNITS_HECTO_PASCALS                                         ((FIT_EXD_DATA_UNITS)45)
#define FIT_EXD_DATA_UNITS_FEET_PER_MIN                                          ((FIT_EXD_DATA_UNITS)46)
#define FIT_EXD_DATA_UNITS_METERS_PER_MIN                                        ((FIT_EXD_DATA_UNITS)47)
#define FIT_EXD_DATA_UNITS_METERS_PER_SEC                                        ((FIT_EXD_DATA_UNITS)48)
#define FIT_EXD_DATA_UNITS_EIGHT_CARDINAL                                        ((FIT_EXD_DATA_UNITS)49)
#define FIT_EXD_DATA_UNITS_COUNT                                                 50

typedef FIT_ENUM FIT_EXD_QUALIFIERS;
#define FIT_EXD_QUALIFIERS_INVALID                                               FIT_ENUM_INVALID
#define FIT_EXD_QUALIFIERS_NO_QUALIFIER                                          ((FIT_EXD_QUALIFIERS)0)
#define FIT_EXD_QUALIFIERS_INSTANTANEOUS                                         ((FIT_EXD_QUALIFIERS)1)
#define FIT_EXD_QUALIFIERS_AVERAGE                                               ((FIT_EXD_QUALIFIERS)2)
#define FIT_EXD_QUALIFIERS_LAP                                                   ((FIT_EXD_QUALIFIERS)3)
#define FIT_EXD_QUALIFIERS_MAXIMUM                                               ((FIT_EXD_QUALIFIERS)4)
#define FIT_EXD_QUALIFIERS_MAXIMUM_AVERAGE                                       ((FIT_EXD_QUALIFIERS)5)
#define FIT_EXD_QUALIFIERS_MAXIMUM_LAP                                           ((FIT_EXD_QUALIFIERS)6)
#define FIT_EXD_QUALIFIERS_LAST_LAP                                              ((FIT_EXD_QUALIFIERS)7)
#define FIT_EXD_QUALIFIERS_AVERAGE_LAP                                           ((FIT_EXD_QUALIFIERS)8)
#define FIT_EXD_QUALIFIERS_TO_DESTINATION                                        ((FIT_EXD_QUALIFIERS)9)
#define FIT_EXD_QUALIFIERS_TO_GO                                                 ((FIT_EXD_QUALIFIERS)10)
#define FIT_EXD_QUALIFIERS_TO_NEXT                                               ((FIT_EXD_QUALIFIERS)11)
#define FIT_EXD_QUALIFIERS_NEXT_COURSE_POINT                                     ((FIT_EXD_QUALIFIERS)12)
#define FIT_EXD_QUALIFIERS_TOTAL                                                 ((FIT_EXD_QUALIFIERS)13)
#define FIT_EXD_QUALIFIERS_THREE_SECOND_AVERAGE                                  ((FIT_EXD_QUALIFIERS)14)
#define FIT_EXD_QUALIFIERS_TEN_SECOND_AVERAGE                                    ((FIT_EXD_QUALIFIERS)15)
#define FIT_EXD_QUALIFIERS_THIRTY_SECOND_AVERAGE                                 ((FIT_EXD_QUALIFIERS)16)
#define FIT_EXD_QUALIFIERS_PERCENT_MAXIMUM                                       ((FIT_EXD_QUALIFIERS)17)
#define FIT_EXD_QUALIFIERS_PERCENT_MAXIMUM_AVERAGE                               ((FIT_EXD_QUALIFIERS)18)
#define FIT_EXD_QUALIFIERS_LAP_PERCENT_MAXIMUM                                   ((FIT_EXD_QUALIFIERS)19)
#define FIT_EXD_QUALIFIERS_ELAPSED                                               ((FIT_EXD_QUALIFIERS)20)
#define FIT_EXD_QUALIFIERS_SUNRISE                                               ((FIT_EXD_QUALIFIERS)21)
#define FIT_EXD_QUALIFIERS_SUNSET                                                ((FIT_EXD_QUALIFIERS)22)
#define FIT_EXD_QUALIFIERS_COMPARED_TO_VIRTUAL_PARTNER                           ((FIT_EXD_QUALIFIERS)23)
#define FIT_EXD_QUALIFIERS_MAXIMUM_24H                                           ((FIT_EXD_QUALIFIERS)24)
#define FIT_EXD_QUALIFIERS_MINIMUM_24H                                           ((FIT_EXD_QUALIFIERS)25)
#define FIT_EXD_QUALIFIERS_MINIMUM                                               ((FIT_EXD_QUALIFIERS)26)
#define FIT_EXD_QUALIFIERS_FIRST                                                 ((FIT_EXD_QUALIFIERS)27)
#define FIT_EXD_QUALIFIERS_SECOND                                                ((FIT_EXD_QUALIFIERS)28)
#define FIT_EXD_QUALIFIERS_THIRD                                                 ((FIT_EXD_QUALIFIERS)29)
#define FIT_EXD_QUALIFIERS_SHIFTER                                               ((FIT_EXD_QUALIFIERS)30)
#define FIT_EXD_QUALIFIERS_LAST_SPORT                                            ((FIT_EXD_QUALIFIERS)31)
#define FIT_EXD_QUALIFIERS_MOVING                                                ((FIT_EXD_QUALIFIERS)32)
#define FIT_EXD_QUALIFIERS_STOPPED                                               ((FIT_EXD_QUALIFIERS)33)
#define FIT_EXD_QUALIFIERS_ZONE_9                                                ((FIT_EXD_QUALIFIERS)242)
#define FIT_EXD_QUALIFIERS_ZONE_8                                                ((FIT_EXD_QUALIFIERS)243)
#define FIT_EXD_QUALIFIERS_ZONE_7                                                ((FIT_EXD_QUALIFIERS)244)
#define FIT_EXD_QUALIFIERS_ZONE_6                                                ((FIT_EXD_QUALIFIERS)245)
#define FIT_EXD_QUALIFIERS_ZONE_5                                                ((FIT_EXD_QUALIFIERS)246)
#define FIT_EXD_QUALIFIERS_ZONE_4                                                ((FIT_EXD_QUALIFIERS)247)
#define FIT_EXD_QUALIFIERS_ZONE_3                                                ((FIT_EXD_QUALIFIERS)248)
#define FIT_EXD_QUALIFIERS_ZONE_2                                                ((FIT_EXD_QUALIFIERS)249)
#define FIT_EXD_QUALIFIERS_ZONE_1                                                ((FIT_EXD_QUALIFIERS)250)
#define FIT_EXD_QUALIFIERS_COUNT                                                 43

typedef FIT_ENUM FIT_EXD_DESCRIPTORS;
#define FIT_EXD_DESCRIPTORS_INVALID                                              FIT_ENUM_INVALID
#define FIT_EXD_DESCRIPTORS_BIKE_LIGHT_BATTERY_STATUS                            ((FIT_EXD_DESCRIPTORS)0)
#define FIT_EXD_DESCRIPTORS_BEAM_ANGLE_STATUS                                    ((FIT_EXD_DESCRIPTORS)1)
#define FIT_EXD_DESCRIPTORS_BATERY_LEVEL                                         ((FIT_EXD_DESCRIPTORS)2)
#define FIT_EXD_DESCRIPTORS_LIGHT_NETWORK_MODE                                   ((FIT_EXD_DESCRIPTORS)3)
#define FIT_EXD_DESCRIPTORS_NUMBER_LIGHTS_CONNECTED                              ((FIT_EXD_DESCRIPTORS)4)
#define FIT_EXD_DESCRIPTORS_CADENCE                                              ((FIT_EXD_DESCRIPTORS)5)
#define FIT_EXD_DESCRIPTORS_DISTANCE                                             ((FIT_EXD_DESCRIPTORS)6)
#define FIT_EXD_DESCRIPTORS_ESTIMATED_TIME_OF_ARRIVAL                            ((FIT_EXD_DESCRIPTORS)7)
#define FIT_EXD_DESCRIPTORS_HEADING                                              ((FIT_EXD_DESCRIPTORS)8)
#define FIT_EXD_DESCRIPTORS_TIME                                                 ((FIT_EXD_DESCRIPTORS)9)
#define FIT_EXD_DESCRIPTORS_BATTERY_LEVEL                                        ((FIT_EXD_DESCRIPTORS)10)
#define FIT_EXD_DESCRIPTORS_TRAINER_RESISTANCE                                   ((FIT_EXD_DESCRIPTORS)11)
#define FIT_EXD_DESCRIPTORS_TRAINER_TARGET_POWER                                 ((FIT_EXD_DESCRIPTORS)12)
#define FIT_EXD_DESCRIPTORS_TIME_SEATED                                          ((FIT_EXD_DESCRIPTORS)13)
#define FIT_EXD_DESCRIPTORS_TIME_STANDING                                        ((FIT_EXD_DESCRIPTORS)14)
#define FIT_EXD_DESCRIPTORS_ELEVATION                                            ((FIT_EXD_DESCRIPTORS)15)
#define FIT_EXD_DESCRIPTORS_GRADE                                                ((FIT_EXD_DESCRIPTORS)16)
#define FIT_EXD_DESCRIPTORS_ASCENT                                               ((FIT_EXD_DESCRIPTORS)17)
#define FIT_EXD_DESCRIPTORS_DESCENT                                              ((FIT_EXD_DESCRIPTORS)18)
#define FIT_EXD_DESCRIPTORS_VERTICAL_SPEED                                       ((FIT_EXD_DESCRIPTORS)19)
#define FIT_EXD_DESCRIPTORS_DI2_BATTERY_LEVEL                                    ((FIT_EXD_DESCRIPTORS)20)
#define FIT_EXD_DESCRIPTORS_FRONT_GEAR                                           ((FIT_EXD_DESCRIPTORS)21)
#define FIT_EXD_DESCRIPTORS_REAR_GEAR                                            ((FIT_EXD_DESCRIPTORS)22)
#define FIT_EXD_DESCRIPTORS_GEAR_RATIO                                           ((FIT_EXD_DESCRIPTORS)23)
#define FIT_EXD_DESCRIPTORS_HEART_RATE                                           ((FIT_EXD_DESCRIPTORS)24)
#define FIT_EXD_DESCRIPTORS_HEART_RATE_ZONE                                      ((FIT_EXD_DESCRIPTORS)25)
#define FIT_EXD_DESCRIPTORS_TIME_IN_HEART_RATE_ZONE                              ((FIT_EXD_DESCRIPTORS)26)
#define FIT_EXD_DESCRIPTORS_HEART_RATE_RESERVE                                   ((FIT_EXD_DESCRIPTORS)27)
#define FIT_EXD_DESCRIPTORS_CALORIES                                             ((FIT_EXD_DESCRIPTORS)28)
#define FIT_EXD_DESCRIPTORS_GPS_ACCURACY                                         ((FIT_EXD_DESCRIPTORS)29)
#define FIT_EXD_DESCRIPTORS_GPS_SIGNAL_STRENGTH                                  ((FIT_EXD_DESCRIPTORS)30)
#define FIT_EXD_DESCRIPTORS_TEMPERATURE                                          ((FIT_EXD_DESCRIPTORS)31)
#define FIT_EXD_DESCRIPTORS_TIME_OF_DAY                                          ((FIT_EXD_DESCRIPTORS)32)
#define FIT_EXD_DESCRIPTORS_BALANCE                                              ((FIT_EXD_DESCRIPTORS)33)
#define FIT_EXD_DESCRIPTORS_PEDAL_SMOOTHNESS                                     ((FIT_EXD_DESCRIPTORS)34)
#define FIT_EXD_DESCRIPTORS_POWER                                                ((FIT_EXD_DESCRIPTORS)35)
#define FIT_EXD_DESCRIPTORS_FUNCTIONAL_THRESHOLD_POWER                           ((FIT_EXD_DESCRIPTORS)36)
#define FIT_EXD_DESCRIPTORS_INTENSITY_FACTOR                                     ((FIT_EXD_DESCRIPTORS)37)
#define FIT_EXD_DESCRIPTORS_WORK                                                 ((FIT_EXD_DESCRIPTORS)38)
#define FIT_EXD_DESCRIPTORS_POWER_RATIO                                          ((FIT_EXD_DESCRIPTORS)39)
#define FIT_EXD_DESCRIPTORS_NORMALIZED_POWER                                     ((FIT_EXD_DESCRIPTORS)40)
#define FIT_EXD_DESCRIPTORS_TRAINING_STRESS_SCORE                                ((FIT_EXD_DESCRIPTORS)41)
#define FIT_EXD_DESCRIPTORS_TIME_ON_ZONE                                         ((FIT_EXD_DESCRIPTORS)42)
#define FIT_EXD_DESCRIPTORS_SPEED                                                ((FIT_EXD_DESCRIPTORS)43)
#define FIT_EXD_DESCRIPTORS_LAPS                                                 ((FIT_EXD_DESCRIPTORS)44)
#define FIT_EXD_DESCRIPTORS_REPS                                                 ((FIT_EXD_DESCRIPTORS)45)
#define FIT_EXD_DESCRIPTORS_WORKOUT_STEP                                         ((FIT_EXD_DESCRIPTORS)46)
#define FIT_EXD_DESCRIPTORS_COURSE_DISTANCE                                      ((FIT_EXD_DESCRIPTORS)47)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_DISTANCE                                  ((FIT_EXD_DESCRIPTORS)48)
#define FIT_EXD_DESCRIPTORS_COURSE_ESTIMATED_TIME_OF_ARRIVAL                     ((FIT_EXD_DESCRIPTORS)49)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_ESTIMATED_TIME_OF_ARRIVAL                 ((FIT_EXD_DESCRIPTORS)50)
#define FIT_EXD_DESCRIPTORS_COURSE_TIME                                          ((FIT_EXD_DESCRIPTORS)51)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_TIME                                      ((FIT_EXD_DESCRIPTORS)52)
#define FIT_EXD_DESCRIPTORS_COURSE_HEADING                                       ((FIT_EXD_DESCRIPTORS)53)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_HEADING                                   ((FIT_EXD_DESCRIPTORS)54)
#define FIT_EXD_DESCRIPTORS_POWER_ZONE                                           ((FIT_EXD_DESCRIPTORS)55)
#define FIT_EXD_DESCRIPTORS_TORQUE_EFFECTIVENESS                                 ((FIT_EXD_DESCRIPTORS)56)
#define FIT_EXD_DESCRIPTORS_TIMER_TIME                                           ((FIT_EXD_DESCRIPTORS)57)
#define FIT_EXD_DESCRIPTORS_POWER_WEIGHT_RATIO                                   ((FIT_EXD_DESCRIPTORS)58)
#define FIT_EXD_DESCRIPTORS_LEFT_PLATFORM_CENTER_OFFSET                          ((FIT_EXD_DESCRIPTORS)59)
#define FIT_EXD_DESCRIPTORS_RIGHT_PLATFORM_CENTER_OFFSET                         ((FIT_EXD_DESCRIPTORS)60)
#define FIT_EXD_DESCRIPTORS_LEFT_POWER_PHASE_START_ANGLE                         ((FIT_EXD_DESCRIPTORS)61)
#define FIT_EXD_DESCRIPTORS_RIGHT_POWER_PHASE_START_ANGLE                        ((FIT_EXD_DESCRIPTORS)62)
#define FIT_EXD_DESCRIPTORS_LEFT_POWER_PHASE_FINISH_ANGLE                        ((FIT_EXD_DESCRIPTORS)63)
#define FIT_EXD_DESCRIPTORS_RIGHT_POWER_PHASE_FINISH_ANGLE                       ((FIT_EXD_DESCRIPTORS)64)
#define FIT_EXD_DESCRIPTORS_GEARS                                                ((FIT_EXD_DESCRIPTORS)65) // Combined gear information
#define FIT_EXD_DESCRIPTORS_PACE                                                 ((FIT_EXD_DESCRIPTORS)66)
#define FIT_EXD_DESCRIPTORS_TRAINING_EFFECT                                      ((FIT_EXD_DESCRIPTORS)67)
#define FIT_EXD_DESCRIPTORS_VERTICAL_OSCILLATION                                 ((FIT_EXD_DESCRIPTORS)68)
#define FIT_EXD_DESCRIPTORS_VERTICAL_RATIO                                       ((FIT_EXD_DESCRIPTORS)69)
#define FIT_EXD_DESCRIPTORS_GROUND_CONTACT_TIME                                  ((FIT_EXD_DESCRIPTORS)70)
#define FIT_EXD_DESCRIPTORS_LEFT_GROUND_CONTACT_TIME_BALANCE                     ((FIT_EXD_DESCRIPTORS)71)
#define FIT_EXD_DESCRIPTORS_RIGHT_GROUND_CONTACT_TIME_BALANCE                    ((FIT_EXD_DESCRIPTORS)72)
#define FIT_EXD_DESCRIPTORS_STRIDE_LENGTH                                        ((FIT_EXD_DESCRIPTORS)73)
#define FIT_EXD_DESCRIPTORS_RUNNING_CADENCE                                      ((FIT_EXD_DESCRIPTORS)74)
#define FIT_EXD_DESCRIPTORS_PERFORMANCE_CONDITION                                ((FIT_EXD_DESCRIPTORS)75)
#define FIT_EXD_DESCRIPTORS_COURSE_TYPE                                          ((FIT_EXD_DESCRIPTORS)76)
#define FIT_EXD_DESCRIPTORS_TIME_IN_POWER_ZONE                                   ((FIT_EXD_DESCRIPTORS)77)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_TURN                                      ((FIT_EXD_DESCRIPTORS)78)
#define FIT_EXD_DESCRIPTORS_COURSE_LOCATION                                      ((FIT_EXD_DESCRIPTORS)79)
#define FIT_EXD_DESCRIPTORS_NAVIGATION_LOCATION                                  ((FIT_EXD_DESCRIPTORS)80)
#define FIT_EXD_DESCRIPTORS_COMPASS                                              ((FIT_EXD_DESCRIPTORS)81)
#define FIT_EXD_DESCRIPTORS_GEAR_COMBO                                           ((FIT_EXD_DESCRIPTORS)82)
#define FIT_EXD_DESCRIPTORS_MUSCLE_OXYGEN                                        ((FIT_EXD_DESCRIPTORS)83)
#define FIT_EXD_DESCRIPTORS_ICON                                                 ((FIT_EXD_DESCRIPTORS)84)
#define FIT_EXD_DESCRIPTORS_COMPASS_HEADING                                      ((FIT_EXD_DESCRIPTORS)85)
#define FIT_EXD_DESCRIPTORS_GPS_HEADING                                          ((FIT_EXD_DESCRIPTORS)86)
#define FIT_EXD_DESCRIPTORS_GPS_ELEVATION                                        ((FIT_EXD_DESCRIPTORS)87)
#define FIT_EXD_DESCRIPTORS_ANAEROBIC_TRAINING_EFFECT                            ((FIT_EXD_DESCRIPTORS)88)
#define FIT_EXD_DESCRIPTORS_COURSE                                               ((FIT_EXD_DESCRIPTORS)89)
#define FIT_EXD_DESCRIPTORS_OFF_COURSE                                           ((FIT_EXD_DESCRIPTORS)90)
#define FIT_EXD_DESCRIPTORS_GLIDE_RATIO                                          ((FIT_EXD_DESCRIPTORS)91)
#define FIT_EXD_DESCRIPTORS_VERTICAL_DISTANCE                                    ((FIT_EXD_DESCRIPTORS)92)
#define FIT_EXD_DESCRIPTORS_VMG                                                  ((FIT_EXD_DESCRIPTORS)93)
#define FIT_EXD_DESCRIPTORS_AMBIENT_PRESSURE                                     ((FIT_EXD_DESCRIPTORS)94)
#define FIT_EXD_DESCRIPTORS_PRESSURE                                             ((FIT_EXD_DESCRIPTORS)95)
#define FIT_EXD_DESCRIPTORS_VAM                                                  ((FIT_EXD_DESCRIPTORS)96)
#define FIT_EXD_DESCRIPTORS_COUNT                                                97

typedef FIT_UINT32 FIT_AUTO_ACTIVITY_DETECT;
#define FIT_AUTO_ACTIVITY_DETECT_INVALID                                         FIT_UINT32_INVALID
#define FIT_AUTO_ACTIVITY_DETECT_NONE                                            ((FIT_AUTO_ACTIVITY_DETECT)0x00000000)
#define FIT_AUTO_ACTIVITY_DETECT_RUNNING                                         ((FIT_AUTO_ACTIVITY_DETECT)0x00000001)
#define FIT_AUTO_ACTIVITY_DETECT_CYCLING                                         ((FIT_AUTO_ACTIVITY_DETECT)0x00000002)
#define FIT_AUTO_ACTIVITY_DETECT_SWIMMING                                        ((FIT_AUTO_ACTIVITY_DETECT)0x00000004)
#define FIT_AUTO_ACTIVITY_DETECT_WALKING                                         ((FIT_AUTO_ACTIVITY_DETECT)0x00000008)
#define FIT_AUTO_ACTIVITY_DETECT_ELLIPTICAL                                      ((FIT_AUTO_ACTIVITY_DETECT)0x00000020)
#define FIT_AUTO_ACTIVITY_DETECT_SEDENTARY                                       ((FIT_AUTO_ACTIVITY_DETECT)0x00000400)
#define FIT_AUTO_ACTIVITY_DETECT_COUNT                                           7

typedef FIT_UINT32Z FIT_SUPPORTED_EXD_SCREEN_LAYOUTS;
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_INVALID                                 FIT_UINT32Z_INVALID
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_FULL_SCREEN                             ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000001)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_VERTICAL                           ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000002)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_HORIZONTAL                         ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000004)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_VERTICAL_RIGHT_SPLIT               ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000008)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_HORIZONTAL_BOTTOM_SPLIT            ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000010)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_FULL_QUARTER_SPLIT                      ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000020)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_VERTICAL_LEFT_SPLIT                ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000040)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_HALF_HORIZONTAL_TOP_SPLIT               ((FIT_SUPPORTED_EXD_SCREEN_LAYOUTS)0x00000080)
#define FIT_SUPPORTED_EXD_SCREEN_LAYOUTS_COUNT                                   8

typedef FIT_UINT8 FIT_FIT_BASE_TYPE;
#define FIT_FIT_BASE_TYPE_INVALID                                                FIT_UINT8_INVALID
#define FIT_FIT_BASE_TYPE_ENUM                                                   ((FIT_FIT_BASE_TYPE)0)
#define FIT_FIT_BASE_TYPE_SINT8                                                  ((FIT_FIT_BASE_TYPE)1)
#define FIT_FIT_BASE_TYPE_UINT8                                                  ((FIT_FIT_BASE_TYPE)2)
#define FIT_FIT_BASE_TYPE_SINT16                                                 ((FIT_FIT_BASE_TYPE)131)
#define FIT_FIT_BASE_TYPE_UINT16                                                 ((FIT_FIT_BASE_TYPE)132)
#define FIT_FIT_BASE_TYPE_SINT32                                                 ((FIT_FIT_BASE_TYPE)133)
#define FIT_FIT_BASE_TYPE_UINT32                                                 ((FIT_FIT_BASE_TYPE)134)
#define FIT_FIT_BASE_TYPE_STRING                                                 ((FIT_FIT_BASE_TYPE)7)
#define FIT_FIT_BASE_TYPE_FLOAT32                                                ((FIT_FIT_BASE_TYPE)136)
#define FIT_FIT_BASE_TYPE_FLOAT64                                                ((FIT_FIT_BASE_TYPE)137)
#define FIT_FIT_BASE_TYPE_UINT8Z                                                 ((FIT_FIT_BASE_TYPE)10)
#define FIT_FIT_BASE_TYPE_UINT16Z                                                ((FIT_FIT_BASE_TYPE)139)
#define FIT_FIT_BASE_TYPE_UINT32Z                                                ((FIT_FIT_BASE_TYPE)140)
#define FIT_FIT_BASE_TYPE_BYTE                                                   ((FIT_FIT_BASE_TYPE)13)
#define FIT_FIT_BASE_TYPE_SINT64                                                 ((FIT_FIT_BASE_TYPE)142)
#define FIT_FIT_BASE_TYPE_UINT64                                                 ((FIT_FIT_BASE_TYPE)143)
#define FIT_FIT_BASE_TYPE_UINT64Z                                                ((FIT_FIT_BASE_TYPE)144)
#define FIT_FIT_BASE_TYPE_COUNT                                                  17

typedef FIT_ENUM FIT_TURN_TYPE;
#define FIT_TURN_TYPE_INVALID                                                    FIT_ENUM_INVALID
#define FIT_TURN_TYPE_ARRIVING_IDX                                               ((FIT_TURN_TYPE)0)
#define FIT_TURN_TYPE_ARRIVING_LEFT_IDX                                          ((FIT_TURN_TYPE)1)
#define FIT_TURN_TYPE_ARRIVING_RIGHT_IDX                                         ((FIT_TURN_TYPE)2)
#define FIT_TURN_TYPE_ARRIVING_VIA_IDX                                           ((FIT_TURN_TYPE)3)
#define FIT_TURN_TYPE_ARRIVING_VIA_LEFT_IDX                                      ((FIT_TURN_TYPE)4)
#define FIT_TURN_TYPE_ARRIVING_VIA_RIGHT_IDX                                     ((FIT_TURN_TYPE)5)
#define FIT_TURN_TYPE_BEAR_KEEP_LEFT_IDX                                         ((FIT_TURN_TYPE)6)
#define FIT_TURN_TYPE_BEAR_KEEP_RIGHT_IDX                                        ((FIT_TURN_TYPE)7)
#define FIT_TURN_TYPE_CONTINUE_IDX                                               ((FIT_TURN_TYPE)8)
#define FIT_TURN_TYPE_EXIT_LEFT_IDX                                              ((FIT_TURN_TYPE)9)
#define FIT_TURN_TYPE_EXIT_RIGHT_IDX                                             ((FIT_TURN_TYPE)10)
#define FIT_TURN_TYPE_FERRY_IDX                                                  ((FIT_TURN_TYPE)11)
#define FIT_TURN_TYPE_ROUNDABOUT_45_IDX                                          ((FIT_TURN_TYPE)12)
#define FIT_TURN_TYPE_ROUNDABOUT_90_IDX                                          ((FIT_TURN_TYPE)13)
#define FIT_TURN_TYPE_ROUNDABOUT_135_IDX                                         ((FIT_TURN_TYPE)14)
#define FIT_TURN_TYPE_ROUNDABOUT_180_IDX                                         ((FIT_TURN_TYPE)15)
#define FIT_TURN_TYPE_ROUNDABOUT_225_IDX                                         ((FIT_TURN_TYPE)16)
#define FIT_TURN_TYPE_ROUNDABOUT_270_IDX                                         ((FIT_TURN_TYPE)17)
#define FIT_TURN_TYPE_ROUNDABOUT_315_IDX                                         ((FIT_TURN_TYPE)18)
#define FIT_TURN_TYPE_ROUNDABOUT_360_IDX                                         ((FIT_TURN_TYPE)19)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_45_IDX                                      ((FIT_TURN_TYPE)20)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_90_IDX                                      ((FIT_TURN_TYPE)21)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_135_IDX                                     ((FIT_TURN_TYPE)22)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_180_IDX                                     ((FIT_TURN_TYPE)23)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_225_IDX                                     ((FIT_TURN_TYPE)24)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_270_IDX                                     ((FIT_TURN_TYPE)25)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_315_IDX                                     ((FIT_TURN_TYPE)26)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_360_IDX                                     ((FIT_TURN_TYPE)27)
#define FIT_TURN_TYPE_ROUNDABOUT_GENERIC_IDX                                     ((FIT_TURN_TYPE)28)
#define FIT_TURN_TYPE_ROUNDABOUT_NEG_GENERIC_IDX                                 ((FIT_TURN_TYPE)29)
#define FIT_TURN_TYPE_SHARP_TURN_LEFT_IDX                                        ((FIT_TURN_TYPE)30)
#define FIT_TURN_TYPE_SHARP_TURN_RIGHT_IDX                                       ((FIT_TURN_TYPE)31)
#define FIT_TURN_TYPE_TURN_LEFT_IDX                                              ((FIT_TURN_TYPE)32)
#define FIT_TURN_TYPE_TURN_RIGHT_IDX                                             ((FIT_TURN_TYPE)33)
#define FIT_TURN_TYPE_UTURN_LEFT_IDX                                             ((FIT_TURN_TYPE)34)
#define FIT_TURN_TYPE_UTURN_RIGHT_IDX                                            ((FIT_TURN_TYPE)35)
#define FIT_TURN_TYPE_ICON_INV_IDX                                               ((FIT_TURN_TYPE)36)
#define FIT_TURN_TYPE_ICON_IDX_CNT                                               ((FIT_TURN_TYPE)37)
#define FIT_TURN_TYPE_COUNT                                                      38

typedef FIT_UINT8 FIT_BIKE_LIGHT_BEAM_ANGLE_MODE;
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_INVALID                                   FIT_UINT8_INVALID
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_MANUAL                                    ((FIT_BIKE_LIGHT_BEAM_ANGLE_MODE)0)
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_AUTO                                      ((FIT_BIKE_LIGHT_BEAM_ANGLE_MODE)1)
#define FIT_BIKE_LIGHT_BEAM_ANGLE_MODE_COUNT                                     2

typedef FIT_UINT16 FIT_FIT_BASE_UNIT;
#define FIT_FIT_BASE_UNIT_INVALID                                                FIT_UINT16_INVALID
#define FIT_FIT_BASE_UNIT_OTHER                                                  ((FIT_FIT_BASE_UNIT)0)
#define FIT_FIT_BASE_UNIT_KILOGRAM                                               ((FIT_FIT_BASE_UNIT)1)
#define FIT_FIT_BASE_UNIT_POUND                                                  ((FIT_FIT_BASE_UNIT)2)
#define FIT_FIT_BASE_UNIT_COUNT                                                  3


#endif // !defined(FIT_CPP_INCLUDE_C)

///////////////////////////////////////////////////////////////////////
// Miscellaneous
///////////////////////////////////////////////////////////////////////

#define FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD                                       (FIT_UINT16_INVALID - 1)
#define FIT_SUBFIELD_INDEX_MAIN_FIELD                                            (FIT_UINT16_INVALID)


namespace fit
{

class Profile
{
public:
    enum class Type
    {
        Enum,
        Sint8,
        Uint8,
        Sint16,
        Uint16,
        Sint32,
        Uint32,
        String,
        Float32,
        Float64,
        Uint8z,
        Uint16z,
        Uint32z,
        Byte,
        Sint64,
        Uint64,
        Uint64z,
        Bool,
        File,
        MesgNum,
        Checksum,
        FileFlags,
        MesgCount,
        DateTime,
        LocalDateTime,
        MessageIndex,
        DeviceIndex,
        Gender,
        Language,
        LanguageBits0,
        LanguageBits1,
        LanguageBits2,
        LanguageBits3,
        LanguageBits4,
        TimeZone,
        DisplayMeasure,
        DisplayHeart,
        DisplayPower,
        DisplayPosition,
        Switch,
        Sport,
        SportBits0,
        SportBits1,
        SportBits2,
        SportBits3,
        SportBits4,
        SportBits5,
        SportBits6,
        SubSport,
        SportEvent,
        Activity,
        Intensity,
        SessionTrigger,
        AutolapTrigger,
        LapTrigger,
        TimeMode,
        BacklightMode,
        DateMode,
        Event,
        EventType,
        TimerTrigger,
        FitnessEquipmentState,
        Autoscroll,
        ActivityClass,
        HrZoneCalc,
        PwrZoneCalc,
        WktStepDuration,
        WktStepTarget,
        Goal,
        GoalRecurrence,
        GoalSource,
        Schedule,
        CoursePoint,
        Manufacturer,
        GarminProduct,
        AntplusDeviceType,
        AntNetwork,
        WorkoutCapabilities,
        BatteryStatus,
        HrType,
        CourseCapabilities,
        Weight,
        WorkoutHr,
        WorkoutPower,
        BpStatus,
        UserLocalId,
        SwimStroke,
        ActivityType,
        ActivitySubtype,
        ActivityLevel,
        Side,
        LeftRightBalance,
        LeftRightBalance100,
        LengthType,
        DayOfWeek,
        ConnectivityCapabilities,
        WeatherReport,
        WeatherStatus,
        WeatherSeverity,
        WeatherSevereType,
        TimeIntoDay,
        LocaltimeIntoDay,
        StrokeType,
        BodyLocation,
        SegmentLapStatus,
        SegmentLeaderboardType,
        SegmentDeleteStatus,
        SegmentSelectionType,
        SourceType,
        DisplayOrientation,
        WorkoutEquipment,
        WatchfaceMode,
        DigitalWatchfaceLayout,
        AnalogWatchfaceLayout,
        RiderPositionType,
        PowerPhaseType,
        CameraEventType,
        SensorType,
        BikeLightNetworkConfigType,
        CommTimeoutType,
        CameraOrientationType,
        AttitudeStage,
        AttitudeValidity,
        AutoSyncFrequency,
        ExdLayout,
        ExdDisplayType,
        ExdDataUnits,
        ExdQualifiers,
        ExdDescriptors,
        AutoActivityDetect,
        SupportedExdScreenLayouts,
        FitBaseType,
        TurnType,
        BikeLightBeamAngleMode,
        FitBaseUnit,
        Invalid
    };

    typedef enum
    {
        MESG_FILE_ID,
        MESG_FILE_CREATOR,
        MESG_TIMESTAMP_CORRELATION,
        MESG_SOFTWARE,
        MESG_SLAVE_DEVICE,
        MESG_CAPABILITIES,
        MESG_FILE_CAPABILITIES,
        MESG_MESG_CAPABILITIES,
        MESG_FIELD_CAPABILITIES,
        MESG_DEVICE_SETTINGS,
        MESG_USER_PROFILE,
        MESG_HRM_PROFILE,
        MESG_SDM_PROFILE,
        MESG_BIKE_PROFILE,
        MESG_CONNECTIVITY,
        MESG_WATCHFACE_SETTINGS,
        MESG_OHR_SETTINGS,
        MESG_ZONES_TARGET,
        MESG_SPORT,
        MESG_HR_ZONE,
        MESG_SPEED_ZONE,
        MESG_CADENCE_ZONE,
        MESG_POWER_ZONE,
        MESG_MET_ZONE,
        MESG_GOAL,
        MESG_ACTIVITY,
        MESG_SESSION,
        MESG_LAP,
        MESG_LENGTH,
        MESG_RECORD,
        MESG_EVENT,
        MESG_DEVICE_INFO,
        MESG_TRAINING_FILE,
        MESG_HRV,
        MESG_WEATHER_CONDITIONS,
        MESG_WEATHER_ALERT,
        MESG_GPS_METADATA,
        MESG_CAMERA_EVENT,
        MESG_GYROSCOPE_DATA,
        MESG_ACCELEROMETER_DATA,
        MESG_MAGNETOMETER_DATA,
        MESG_THREE_D_SENSOR_CALIBRATION,
        MESG_VIDEO_FRAME,
        MESG_OBDII_DATA,
        MESG_NMEA_SENTENCE,
        MESG_AVIATION_ATTITUDE,
        MESG_VIDEO,
        MESG_VIDEO_TITLE,
        MESG_VIDEO_DESCRIPTION,
        MESG_VIDEO_CLIP,
        MESG_COURSE,
        MESG_COURSE_POINT,
        MESG_SEGMENT_ID,
        MESG_SEGMENT_LEADERBOARD_ENTRY,
        MESG_SEGMENT_POINT,
        MESG_SEGMENT_LAP,
        MESG_SEGMENT_FILE,
        MESG_WORKOUT,
        MESG_WORKOUT_SESSION,
        MESG_WORKOUT_STEP,
        MESG_SCHEDULE,
        MESG_TOTALS,
        MESG_WEIGHT_SCALE,
        MESG_BLOOD_PRESSURE,
        MESG_MONITORING_INFO,
        MESG_MONITORING,
        MESG_HR,
        MESG_MEMO_GLOB,
        MESG_ANT_CHANNEL_ID,
        MESG_ANT_RX,
        MESG_ANT_TX,
        MESG_EXD_SCREEN_CONFIGURATION,
        MESG_EXD_DATA_FIELD_CONFIGURATION,
        MESG_EXD_DATA_CONCEPT_CONFIGURATION,
        MESG_FIELD_DESCRIPTION,
        MESG_DEVELOPER_DATA_ID,
        MESG_PAD,
        MESGS
    } MESG_INDEX;

    typedef enum
    {
        FILE_ID_MESG_TYPE,
        FILE_ID_MESG_MANUFACTURER,
        FILE_ID_MESG_PRODUCT,
        FILE_ID_MESG_SERIAL_NUMBER,
        FILE_ID_MESG_TIME_CREATED,
        FILE_ID_MESG_NUMBER,
        FILE_ID_MESG_PRODUCT_NAME,
        FILE_ID_MESG_FIELDS
    } FILE_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        FILE_ID_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        FILE_ID_MESG_PRODUCT_FIELD_SUBFIELDS,
        FILE_ID_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        FILE_ID_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } FILE_ID_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        FILE_CREATOR_MESG_SOFTWARE_VERSION,
        FILE_CREATOR_MESG_HARDWARE_VERSION,
        FILE_CREATOR_MESG_FIELDS
    } FILE_CREATOR_MESG_FIELD_INDEX;

    typedef enum
    {
        TIMESTAMP_CORRELATION_MESG_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_FRACTIONAL_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_SYSTEM_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_FRACTIONAL_SYSTEM_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_LOCAL_TIMESTAMP,
        TIMESTAMP_CORRELATION_MESG_TIMESTAMP_MS,
        TIMESTAMP_CORRELATION_MESG_SYSTEM_TIMESTAMP_MS,
        TIMESTAMP_CORRELATION_MESG_FIELDS
    } TIMESTAMP_CORRELATION_MESG_FIELD_INDEX;

    typedef enum
    {
        SOFTWARE_MESG_MESSAGE_INDEX,
        SOFTWARE_MESG_VERSION,
        SOFTWARE_MESG_PART_NUMBER,
        SOFTWARE_MESG_FIELDS
    } SOFTWARE_MESG_FIELD_INDEX;

    typedef enum
    {
        SLAVE_DEVICE_MESG_MANUFACTURER,
        SLAVE_DEVICE_MESG_PRODUCT,
        SLAVE_DEVICE_MESG_FIELDS
    } SLAVE_DEVICE_MESG_FIELD_INDEX;

    typedef enum
    {
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_SUBFIELDS,
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SLAVE_DEVICE_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SLAVE_DEVICE_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        CAPABILITIES_MESG_LANGUAGES,
        CAPABILITIES_MESG_SPORTS,
        CAPABILITIES_MESG_WORKOUTS_SUPPORTED,
        CAPABILITIES_MESG_CONNECTIVITY_SUPPORTED,
        CAPABILITIES_MESG_FIELDS
    } CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        FILE_CAPABILITIES_MESG_MESSAGE_INDEX,
        FILE_CAPABILITIES_MESG_TYPE,
        FILE_CAPABILITIES_MESG_FLAGS,
        FILE_CAPABILITIES_MESG_DIRECTORY,
        FILE_CAPABILITIES_MESG_MAX_COUNT,
        FILE_CAPABILITIES_MESG_MAX_SIZE,
        FILE_CAPABILITIES_MESG_FIELDS
    } FILE_CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        MESG_CAPABILITIES_MESG_MESSAGE_INDEX,
        MESG_CAPABILITIES_MESG_FILE,
        MESG_CAPABILITIES_MESG_MESG_NUM,
        MESG_CAPABILITIES_MESG_COUNT_TYPE,
        MESG_CAPABILITIES_MESG_COUNT,
        MESG_CAPABILITIES_MESG_FIELDS
    } MESG_CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        MESG_CAPABILITIES_MESG_COUNT_FIELD_NUM_PER_FILE,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_MAX_PER_FILE,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_MAX_PER_FILE_TYPE,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_SUBFIELDS,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        MESG_CAPABILITIES_MESG_COUNT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } MESG_CAPABILITIES_MESG_COUNT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        FIELD_CAPABILITIES_MESG_MESSAGE_INDEX,
        FIELD_CAPABILITIES_MESG_FILE,
        FIELD_CAPABILITIES_MESG_MESG_NUM,
        FIELD_CAPABILITIES_MESG_FIELD_NUM,
        FIELD_CAPABILITIES_MESG_COUNT,
        FIELD_CAPABILITIES_MESG_FIELDS
    } FIELD_CAPABILITIES_MESG_FIELD_INDEX;

    typedef enum
    {
        DEVICE_SETTINGS_MESG_ACTIVE_TIME_ZONE,
        DEVICE_SETTINGS_MESG_UTC_OFFSET,
        DEVICE_SETTINGS_MESG_TIME_OFFSET,
        DEVICE_SETTINGS_MESG_TIME_MODE,
        DEVICE_SETTINGS_MESG_TIME_ZONE_OFFSET,
        DEVICE_SETTINGS_MESG_BACKLIGHT_MODE,
        DEVICE_SETTINGS_MESG_ACTIVITY_TRACKER_ENABLED,
        DEVICE_SETTINGS_MESG_CLOCK_TIME,
        DEVICE_SETTINGS_MESG_PAGES_ENABLED,
        DEVICE_SETTINGS_MESG_MOVE_ALERT_ENABLED,
        DEVICE_SETTINGS_MESG_DATE_MODE,
        DEVICE_SETTINGS_MESG_DISPLAY_ORIENTATION,
        DEVICE_SETTINGS_MESG_MOUNTING_SIDE,
        DEVICE_SETTINGS_MESG_DEFAULT_PAGE,
        DEVICE_SETTINGS_MESG_AUTOSYNC_MIN_STEPS,
        DEVICE_SETTINGS_MESG_AUTOSYNC_MIN_TIME,
        DEVICE_SETTINGS_MESG_LACTATE_THRESHOLD_AUTODETECT_ENABLED,
        DEVICE_SETTINGS_MESG_BLE_AUTO_UPLOAD_ENABLED,
        DEVICE_SETTINGS_MESG_AUTO_SYNC_FREQUENCY,
        DEVICE_SETTINGS_MESG_AUTO_ACTIVITY_DETECT,
        DEVICE_SETTINGS_MESG_NUMBER_OF_SCREENS,
        DEVICE_SETTINGS_MESG_SMART_NOTIFICATION_DISPLAY_ORIENTATION,
        DEVICE_SETTINGS_MESG_FIELDS
    } DEVICE_SETTINGS_MESG_FIELD_INDEX;

    typedef enum
    {
        USER_PROFILE_MESG_MESSAGE_INDEX,
        USER_PROFILE_MESG_FRIENDLY_NAME,
        USER_PROFILE_MESG_GENDER,
        USER_PROFILE_MESG_AGE,
        USER_PROFILE_MESG_HEIGHT,
        USER_PROFILE_MESG_WEIGHT,
        USER_PROFILE_MESG_LANGUAGE,
        USER_PROFILE_MESG_ELEV_SETTING,
        USER_PROFILE_MESG_WEIGHT_SETTING,
        USER_PROFILE_MESG_RESTING_HEART_RATE,
        USER_PROFILE_MESG_DEFAULT_MAX_RUNNING_HEART_RATE,
        USER_PROFILE_MESG_DEFAULT_MAX_BIKING_HEART_RATE,
        USER_PROFILE_MESG_DEFAULT_MAX_HEART_RATE,
        USER_PROFILE_MESG_HR_SETTING,
        USER_PROFILE_MESG_SPEED_SETTING,
        USER_PROFILE_MESG_DIST_SETTING,
        USER_PROFILE_MESG_POWER_SETTING,
        USER_PROFILE_MESG_ACTIVITY_CLASS,
        USER_PROFILE_MESG_POSITION_SETTING,
        USER_PROFILE_MESG_TEMPERATURE_SETTING,
        USER_PROFILE_MESG_LOCAL_ID,
        USER_PROFILE_MESG_GLOBAL_ID,
        USER_PROFILE_MESG_WAKE_TIME,
        USER_PROFILE_MESG_SLEEP_TIME,
        USER_PROFILE_MESG_HEIGHT_SETTING,
        USER_PROFILE_MESG_USER_RUNNING_STEP_LENGTH,
        USER_PROFILE_MESG_USER_WALKING_STEP_LENGTH,
        USER_PROFILE_MESG_FIELDS
    } USER_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        HRM_PROFILE_MESG_MESSAGE_INDEX,
        HRM_PROFILE_MESG_ENABLED,
        HRM_PROFILE_MESG_HRM_ANT_ID,
        HRM_PROFILE_MESG_LOG_HRV,
        HRM_PROFILE_MESG_HRM_ANT_ID_TRANS_TYPE,
        HRM_PROFILE_MESG_FIELDS
    } HRM_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        SDM_PROFILE_MESG_MESSAGE_INDEX,
        SDM_PROFILE_MESG_ENABLED,
        SDM_PROFILE_MESG_SDM_ANT_ID,
        SDM_PROFILE_MESG_SDM_CAL_FACTOR,
        SDM_PROFILE_MESG_ODOMETER,
        SDM_PROFILE_MESG_SPEED_SOURCE,
        SDM_PROFILE_MESG_SDM_ANT_ID_TRANS_TYPE,
        SDM_PROFILE_MESG_ODOMETER_ROLLOVER,
        SDM_PROFILE_MESG_FIELDS
    } SDM_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        BIKE_PROFILE_MESG_MESSAGE_INDEX,
        BIKE_PROFILE_MESG_NAME,
        BIKE_PROFILE_MESG_SPORT,
        BIKE_PROFILE_MESG_SUB_SPORT,
        BIKE_PROFILE_MESG_ODOMETER,
        BIKE_PROFILE_MESG_BIKE_SPD_ANT_ID,
        BIKE_PROFILE_MESG_BIKE_CAD_ANT_ID,
        BIKE_PROFILE_MESG_BIKE_SPDCAD_ANT_ID,
        BIKE_PROFILE_MESG_BIKE_POWER_ANT_ID,
        BIKE_PROFILE_MESG_CUSTOM_WHEELSIZE,
        BIKE_PROFILE_MESG_AUTO_WHEELSIZE,
        BIKE_PROFILE_MESG_BIKE_WEIGHT,
        BIKE_PROFILE_MESG_POWER_CAL_FACTOR,
        BIKE_PROFILE_MESG_AUTO_WHEEL_CAL,
        BIKE_PROFILE_MESG_AUTO_POWER_ZERO,
        BIKE_PROFILE_MESG_ID,
        BIKE_PROFILE_MESG_SPD_ENABLED,
        BIKE_PROFILE_MESG_CAD_ENABLED,
        BIKE_PROFILE_MESG_SPDCAD_ENABLED,
        BIKE_PROFILE_MESG_POWER_ENABLED,
        BIKE_PROFILE_MESG_CRANK_LENGTH,
        BIKE_PROFILE_MESG_ENABLED,
        BIKE_PROFILE_MESG_BIKE_SPD_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_BIKE_CAD_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_BIKE_SPDCAD_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_BIKE_POWER_ANT_ID_TRANS_TYPE,
        BIKE_PROFILE_MESG_ODOMETER_ROLLOVER,
        BIKE_PROFILE_MESG_FRONT_GEAR_NUM,
        BIKE_PROFILE_MESG_FRONT_GEAR,
        BIKE_PROFILE_MESG_REAR_GEAR_NUM,
        BIKE_PROFILE_MESG_REAR_GEAR,
        BIKE_PROFILE_MESG_SHIMANO_DI2_ENABLED,
        BIKE_PROFILE_MESG_FIELDS
    } BIKE_PROFILE_MESG_FIELD_INDEX;

    typedef enum
    {
        CONNECTIVITY_MESG_BLUETOOTH_ENABLED,
        CONNECTIVITY_MESG_BLUETOOTH_LE_ENABLED,
        CONNECTIVITY_MESG_ANT_ENABLED,
        CONNECTIVITY_MESG_NAME,
        CONNECTIVITY_MESG_LIVE_TRACKING_ENABLED,
        CONNECTIVITY_MESG_WEATHER_CONDITIONS_ENABLED,
        CONNECTIVITY_MESG_WEATHER_ALERTS_ENABLED,
        CONNECTIVITY_MESG_AUTO_ACTIVITY_UPLOAD_ENABLED,
        CONNECTIVITY_MESG_COURSE_DOWNLOAD_ENABLED,
        CONNECTIVITY_MESG_WORKOUT_DOWNLOAD_ENABLED,
        CONNECTIVITY_MESG_GPS_EPHEMERIS_DOWNLOAD_ENABLED,
        CONNECTIVITY_MESG_INCIDENT_DETECTION_ENABLED,
        CONNECTIVITY_MESG_GROUPTRACK_ENABLED,
        CONNECTIVITY_MESG_FIELDS
    } CONNECTIVITY_MESG_FIELD_INDEX;

    typedef enum
    {
        WATCHFACE_SETTINGS_MESG_MESSAGE_INDEX,
        WATCHFACE_SETTINGS_MESG_MODE,
        WATCHFACE_SETTINGS_MESG_LAYOUT,
        WATCHFACE_SETTINGS_MESG_FIELDS
    } WATCHFACE_SETTINGS_MESG_FIELD_INDEX;

    typedef enum
    {
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_DIGITAL_LAYOUT,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_ANALOG_LAYOUT,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_SUBFIELDS,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WATCHFACE_SETTINGS_MESG_LAYOUT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        OHR_SETTINGS_MESG_ENABLED,
        OHR_SETTINGS_MESG_FIELDS
    } OHR_SETTINGS_MESG_FIELD_INDEX;

    typedef enum
    {
        ZONES_TARGET_MESG_MAX_HEART_RATE,
        ZONES_TARGET_MESG_THRESHOLD_HEART_RATE,
        ZONES_TARGET_MESG_FUNCTIONAL_THRESHOLD_POWER,
        ZONES_TARGET_MESG_HR_CALC_TYPE,
        ZONES_TARGET_MESG_PWR_CALC_TYPE,
        ZONES_TARGET_MESG_FIELDS
    } ZONES_TARGET_MESG_FIELD_INDEX;

    typedef enum
    {
        SPORT_MESG_SPORT,
        SPORT_MESG_SUB_SPORT,
        SPORT_MESG_NAME,
        SPORT_MESG_FIELDS
    } SPORT_MESG_FIELD_INDEX;

    typedef enum
    {
        HR_ZONE_MESG_MESSAGE_INDEX,
        HR_ZONE_MESG_HIGH_BPM,
        HR_ZONE_MESG_NAME,
        HR_ZONE_MESG_FIELDS
    } HR_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        SPEED_ZONE_MESG_MESSAGE_INDEX,
        SPEED_ZONE_MESG_HIGH_VALUE,
        SPEED_ZONE_MESG_NAME,
        SPEED_ZONE_MESG_FIELDS
    } SPEED_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        CADENCE_ZONE_MESG_MESSAGE_INDEX,
        CADENCE_ZONE_MESG_HIGH_VALUE,
        CADENCE_ZONE_MESG_NAME,
        CADENCE_ZONE_MESG_FIELDS
    } CADENCE_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        POWER_ZONE_MESG_MESSAGE_INDEX,
        POWER_ZONE_MESG_HIGH_VALUE,
        POWER_ZONE_MESG_NAME,
        POWER_ZONE_MESG_FIELDS
    } POWER_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        MET_ZONE_MESG_MESSAGE_INDEX,
        MET_ZONE_MESG_HIGH_BPM,
        MET_ZONE_MESG_CALORIES,
        MET_ZONE_MESG_FAT_CALORIES,
        MET_ZONE_MESG_FIELDS
    } MET_ZONE_MESG_FIELD_INDEX;

    typedef enum
    {
        GOAL_MESG_MESSAGE_INDEX,
        GOAL_MESG_SPORT,
        GOAL_MESG_SUB_SPORT,
        GOAL_MESG_START_DATE,
        GOAL_MESG_END_DATE,
        GOAL_MESG_TYPE,
        GOAL_MESG_VALUE,
        GOAL_MESG_REPEAT,
        GOAL_MESG_TARGET_VALUE,
        GOAL_MESG_RECURRENCE,
        GOAL_MESG_RECURRENCE_VALUE,
        GOAL_MESG_ENABLED,
        GOAL_MESG_SOURCE,
        GOAL_MESG_FIELDS
    } GOAL_MESG_FIELD_INDEX;

    typedef enum
    {
        ACTIVITY_MESG_TIMESTAMP,
        ACTIVITY_MESG_TOTAL_TIMER_TIME,
        ACTIVITY_MESG_NUM_SESSIONS,
        ACTIVITY_MESG_TYPE,
        ACTIVITY_MESG_EVENT,
        ACTIVITY_MESG_EVENT_TYPE,
        ACTIVITY_MESG_LOCAL_TIMESTAMP,
        ACTIVITY_MESG_EVENT_GROUP,
        ACTIVITY_MESG_FIELDS
    } ACTIVITY_MESG_FIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_MESSAGE_INDEX,
        SESSION_MESG_TIMESTAMP,
        SESSION_MESG_EVENT,
        SESSION_MESG_EVENT_TYPE,
        SESSION_MESG_START_TIME,
        SESSION_MESG_START_POSITION_LAT,
        SESSION_MESG_START_POSITION_LONG,
        SESSION_MESG_SPORT,
        SESSION_MESG_SUB_SPORT,
        SESSION_MESG_TOTAL_ELAPSED_TIME,
        SESSION_MESG_TOTAL_TIMER_TIME,
        SESSION_MESG_TOTAL_DISTANCE,
        SESSION_MESG_TOTAL_CYCLES,
        SESSION_MESG_TOTAL_CALORIES,
        SESSION_MESG_TOTAL_FAT_CALORIES,
        SESSION_MESG_AVG_SPEED,
        SESSION_MESG_MAX_SPEED,
        SESSION_MESG_AVG_HEART_RATE,
        SESSION_MESG_MAX_HEART_RATE,
        SESSION_MESG_AVG_CADENCE,
        SESSION_MESG_MAX_CADENCE,
        SESSION_MESG_AVG_POWER,
        SESSION_MESG_MAX_POWER,
        SESSION_MESG_TOTAL_ASCENT,
        SESSION_MESG_TOTAL_DESCENT,
        SESSION_MESG_TOTAL_TRAINING_EFFECT,
        SESSION_MESG_FIRST_LAP_INDEX,
        SESSION_MESG_NUM_LAPS,
        SESSION_MESG_EVENT_GROUP,
        SESSION_MESG_TRIGGER,
        SESSION_MESG_NEC_LAT,
        SESSION_MESG_NEC_LONG,
        SESSION_MESG_SWC_LAT,
        SESSION_MESG_SWC_LONG,
        SESSION_MESG_NORMALIZED_POWER,
        SESSION_MESG_TRAINING_STRESS_SCORE,
        SESSION_MESG_INTENSITY_FACTOR,
        SESSION_MESG_LEFT_RIGHT_BALANCE,
        SESSION_MESG_AVG_STROKE_COUNT,
        SESSION_MESG_AVG_STROKE_DISTANCE,
        SESSION_MESG_SWIM_STROKE,
        SESSION_MESG_POOL_LENGTH,
        SESSION_MESG_THRESHOLD_POWER,
        SESSION_MESG_POOL_LENGTH_UNIT,
        SESSION_MESG_NUM_ACTIVE_LENGTHS,
        SESSION_MESG_TOTAL_WORK,
        SESSION_MESG_AVG_ALTITUDE,
        SESSION_MESG_MAX_ALTITUDE,
        SESSION_MESG_GPS_ACCURACY,
        SESSION_MESG_AVG_GRADE,
        SESSION_MESG_AVG_POS_GRADE,
        SESSION_MESG_AVG_NEG_GRADE,
        SESSION_MESG_MAX_POS_GRADE,
        SESSION_MESG_MAX_NEG_GRADE,
        SESSION_MESG_AVG_TEMPERATURE,
        SESSION_MESG_MAX_TEMPERATURE,
        SESSION_MESG_TOTAL_MOVING_TIME,
        SESSION_MESG_AVG_POS_VERTICAL_SPEED,
        SESSION_MESG_AVG_NEG_VERTICAL_SPEED,
        SESSION_MESG_MAX_POS_VERTICAL_SPEED,
        SESSION_MESG_MAX_NEG_VERTICAL_SPEED,
        SESSION_MESG_MIN_HEART_RATE,
        SESSION_MESG_TIME_IN_HR_ZONE,
        SESSION_MESG_TIME_IN_SPEED_ZONE,
        SESSION_MESG_TIME_IN_CADENCE_ZONE,
        SESSION_MESG_TIME_IN_POWER_ZONE,
        SESSION_MESG_AVG_LAP_TIME,
        SESSION_MESG_BEST_LAP_INDEX,
        SESSION_MESG_MIN_ALTITUDE,
        SESSION_MESG_PLAYER_SCORE,
        SESSION_MESG_OPPONENT_SCORE,
        SESSION_MESG_OPPONENT_NAME,
        SESSION_MESG_STROKE_COUNT,
        SESSION_MESG_ZONE_COUNT,
        SESSION_MESG_MAX_BALL_SPEED,
        SESSION_MESG_AVG_BALL_SPEED,
        SESSION_MESG_AVG_VERTICAL_OSCILLATION,
        SESSION_MESG_AVG_STANCE_TIME_PERCENT,
        SESSION_MESG_AVG_STANCE_TIME,
        SESSION_MESG_AVG_FRACTIONAL_CADENCE,
        SESSION_MESG_MAX_FRACTIONAL_CADENCE,
        SESSION_MESG_TOTAL_FRACTIONAL_CYCLES,
        SESSION_MESG_AVG_TOTAL_HEMOGLOBIN_CONC,
        SESSION_MESG_MIN_TOTAL_HEMOGLOBIN_CONC,
        SESSION_MESG_MAX_TOTAL_HEMOGLOBIN_CONC,
        SESSION_MESG_AVG_SATURATED_HEMOGLOBIN_PERCENT,
        SESSION_MESG_MIN_SATURATED_HEMOGLOBIN_PERCENT,
        SESSION_MESG_MAX_SATURATED_HEMOGLOBIN_PERCENT,
        SESSION_MESG_AVG_LEFT_TORQUE_EFFECTIVENESS,
        SESSION_MESG_AVG_RIGHT_TORQUE_EFFECTIVENESS,
        SESSION_MESG_AVG_LEFT_PEDAL_SMOOTHNESS,
        SESSION_MESG_AVG_RIGHT_PEDAL_SMOOTHNESS,
        SESSION_MESG_AVG_COMBINED_PEDAL_SMOOTHNESS,
        SESSION_MESG_SPORT_INDEX,
        SESSION_MESG_TIME_STANDING,
        SESSION_MESG_STAND_COUNT,
        SESSION_MESG_AVG_LEFT_PCO,
        SESSION_MESG_AVG_RIGHT_PCO,
        SESSION_MESG_AVG_LEFT_POWER_PHASE,
        SESSION_MESG_AVG_LEFT_POWER_PHASE_PEAK,
        SESSION_MESG_AVG_RIGHT_POWER_PHASE,
        SESSION_MESG_AVG_RIGHT_POWER_PHASE_PEAK,
        SESSION_MESG_AVG_POWER_POSITION,
        SESSION_MESG_MAX_POWER_POSITION,
        SESSION_MESG_AVG_CADENCE_POSITION,
        SESSION_MESG_MAX_CADENCE_POSITION,
        SESSION_MESG_ENHANCED_AVG_SPEED,
        SESSION_MESG_ENHANCED_MAX_SPEED,
        SESSION_MESG_ENHANCED_AVG_ALTITUDE,
        SESSION_MESG_ENHANCED_MIN_ALTITUDE,
        SESSION_MESG_ENHANCED_MAX_ALTITUDE,
        SESSION_MESG_AVG_LEV_MOTOR_POWER,
        SESSION_MESG_MAX_LEV_MOTOR_POWER,
        SESSION_MESG_LEV_BATTERY_CONSUMPTION,
        SESSION_MESG_AVG_VERTICAL_RATIO,
        SESSION_MESG_AVG_STANCE_TIME_BALANCE,
        SESSION_MESG_AVG_STEP_LENGTH,
        SESSION_MESG_TOTAL_ANAEROBIC_TRAINING_EFFECT,
        SESSION_MESG_AVG_VAM,
        SESSION_MESG_FIELDS
    } SESSION_MESG_FIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES,
        SESSION_MESG_TOTAL_CYCLES_FIELD_SUBFIELDS,
        SESSION_MESG_TOTAL_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SESSION_MESG_TOTAL_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SESSION_MESG_TOTAL_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE,
        SESSION_MESG_AVG_CADENCE_FIELD_SUBFIELDS,
        SESSION_MESG_AVG_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SESSION_MESG_AVG_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SESSION_MESG_AVG_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE,
        SESSION_MESG_MAX_CADENCE_FIELD_SUBFIELDS,
        SESSION_MESG_MAX_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SESSION_MESG_MAX_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SESSION_MESG_MAX_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LAP_MESG_MESSAGE_INDEX,
        LAP_MESG_TIMESTAMP,
        LAP_MESG_EVENT,
        LAP_MESG_EVENT_TYPE,
        LAP_MESG_START_TIME,
        LAP_MESG_START_POSITION_LAT,
        LAP_MESG_START_POSITION_LONG,
        LAP_MESG_END_POSITION_LAT,
        LAP_MESG_END_POSITION_LONG,
        LAP_MESG_TOTAL_ELAPSED_TIME,
        LAP_MESG_TOTAL_TIMER_TIME,
        LAP_MESG_TOTAL_DISTANCE,
        LAP_MESG_TOTAL_CYCLES,
        LAP_MESG_TOTAL_CALORIES,
        LAP_MESG_TOTAL_FAT_CALORIES,
        LAP_MESG_AVG_SPEED,
        LAP_MESG_MAX_SPEED,
        LAP_MESG_AVG_HEART_RATE,
        LAP_MESG_MAX_HEART_RATE,
        LAP_MESG_AVG_CADENCE,
        LAP_MESG_MAX_CADENCE,
        LAP_MESG_AVG_POWER,
        LAP_MESG_MAX_POWER,
        LAP_MESG_TOTAL_ASCENT,
        LAP_MESG_TOTAL_DESCENT,
        LAP_MESG_INTENSITY,
        LAP_MESG_LAP_TRIGGER,
        LAP_MESG_SPORT,
        LAP_MESG_EVENT_GROUP,
        LAP_MESG_NUM_LENGTHS,
        LAP_MESG_NORMALIZED_POWER,
        LAP_MESG_LEFT_RIGHT_BALANCE,
        LAP_MESG_FIRST_LENGTH_INDEX,
        LAP_MESG_AVG_STROKE_DISTANCE,
        LAP_MESG_SWIM_STROKE,
        LAP_MESG_SUB_SPORT,
        LAP_MESG_NUM_ACTIVE_LENGTHS,
        LAP_MESG_TOTAL_WORK,
        LAP_MESG_AVG_ALTITUDE,
        LAP_MESG_MAX_ALTITUDE,
        LAP_MESG_GPS_ACCURACY,
        LAP_MESG_AVG_GRADE,
        LAP_MESG_AVG_POS_GRADE,
        LAP_MESG_AVG_NEG_GRADE,
        LAP_MESG_MAX_POS_GRADE,
        LAP_MESG_MAX_NEG_GRADE,
        LAP_MESG_AVG_TEMPERATURE,
        LAP_MESG_MAX_TEMPERATURE,
        LAP_MESG_TOTAL_MOVING_TIME,
        LAP_MESG_AVG_POS_VERTICAL_SPEED,
        LAP_MESG_AVG_NEG_VERTICAL_SPEED,
        LAP_MESG_MAX_POS_VERTICAL_SPEED,
        LAP_MESG_MAX_NEG_VERTICAL_SPEED,
        LAP_MESG_TIME_IN_HR_ZONE,
        LAP_MESG_TIME_IN_SPEED_ZONE,
        LAP_MESG_TIME_IN_CADENCE_ZONE,
        LAP_MESG_TIME_IN_POWER_ZONE,
        LAP_MESG_REPETITION_NUM,
        LAP_MESG_MIN_ALTITUDE,
        LAP_MESG_MIN_HEART_RATE,
        LAP_MESG_WKT_STEP_INDEX,
        LAP_MESG_OPPONENT_SCORE,
        LAP_MESG_STROKE_COUNT,
        LAP_MESG_ZONE_COUNT,
        LAP_MESG_AVG_VERTICAL_OSCILLATION,
        LAP_MESG_AVG_STANCE_TIME_PERCENT,
        LAP_MESG_AVG_STANCE_TIME,
        LAP_MESG_AVG_FRACTIONAL_CADENCE,
        LAP_MESG_MAX_FRACTIONAL_CADENCE,
        LAP_MESG_TOTAL_FRACTIONAL_CYCLES,
        LAP_MESG_PLAYER_SCORE,
        LAP_MESG_AVG_TOTAL_HEMOGLOBIN_CONC,
        LAP_MESG_MIN_TOTAL_HEMOGLOBIN_CONC,
        LAP_MESG_MAX_TOTAL_HEMOGLOBIN_CONC,
        LAP_MESG_AVG_SATURATED_HEMOGLOBIN_PERCENT,
        LAP_MESG_MIN_SATURATED_HEMOGLOBIN_PERCENT,
        LAP_MESG_MAX_SATURATED_HEMOGLOBIN_PERCENT,
        LAP_MESG_AVG_LEFT_TORQUE_EFFECTIVENESS,
        LAP_MESG_AVG_RIGHT_TORQUE_EFFECTIVENESS,
        LAP_MESG_AVG_LEFT_PEDAL_SMOOTHNESS,
        LAP_MESG_AVG_RIGHT_PEDAL_SMOOTHNESS,
        LAP_MESG_AVG_COMBINED_PEDAL_SMOOTHNESS,
        LAP_MESG_TIME_STANDING,
        LAP_MESG_STAND_COUNT,
        LAP_MESG_AVG_LEFT_PCO,
        LAP_MESG_AVG_RIGHT_PCO,
        LAP_MESG_AVG_LEFT_POWER_PHASE,
        LAP_MESG_AVG_LEFT_POWER_PHASE_PEAK,
        LAP_MESG_AVG_RIGHT_POWER_PHASE,
        LAP_MESG_AVG_RIGHT_POWER_PHASE_PEAK,
        LAP_MESG_AVG_POWER_POSITION,
        LAP_MESG_MAX_POWER_POSITION,
        LAP_MESG_AVG_CADENCE_POSITION,
        LAP_MESG_MAX_CADENCE_POSITION,
        LAP_MESG_ENHANCED_AVG_SPEED,
        LAP_MESG_ENHANCED_MAX_SPEED,
        LAP_MESG_ENHANCED_AVG_ALTITUDE,
        LAP_MESG_ENHANCED_MIN_ALTITUDE,
        LAP_MESG_ENHANCED_MAX_ALTITUDE,
        LAP_MESG_AVG_LEV_MOTOR_POWER,
        LAP_MESG_MAX_LEV_MOTOR_POWER,
        LAP_MESG_LEV_BATTERY_CONSUMPTION,
        LAP_MESG_AVG_VERTICAL_RATIO,
        LAP_MESG_AVG_STANCE_TIME_BALANCE,
        LAP_MESG_AVG_STEP_LENGTH,
        LAP_MESG_AVG_VAM,
        LAP_MESG_FIELDS
    } LAP_MESG_FIELD_INDEX;

    typedef enum
    {
        LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES,
        LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELDS,
        LAP_MESG_TOTAL_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        LAP_MESG_TOTAL_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LAP_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE,
        LAP_MESG_AVG_CADENCE_FIELD_SUBFIELDS,
        LAP_MESG_AVG_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        LAP_MESG_AVG_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } LAP_MESG_AVG_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LAP_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE,
        LAP_MESG_MAX_CADENCE_FIELD_SUBFIELDS,
        LAP_MESG_MAX_CADENCE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        LAP_MESG_MAX_CADENCE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } LAP_MESG_MAX_CADENCE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        LENGTH_MESG_MESSAGE_INDEX,
        LENGTH_MESG_TIMESTAMP,
        LENGTH_MESG_EVENT,
        LENGTH_MESG_EVENT_TYPE,
        LENGTH_MESG_START_TIME,
        LENGTH_MESG_TOTAL_ELAPSED_TIME,
        LENGTH_MESG_TOTAL_TIMER_TIME,
        LENGTH_MESG_TOTAL_STROKES,
        LENGTH_MESG_AVG_SPEED,
        LENGTH_MESG_SWIM_STROKE,
        LENGTH_MESG_AVG_SWIMMING_CADENCE,
        LENGTH_MESG_EVENT_GROUP,
        LENGTH_MESG_TOTAL_CALORIES,
        LENGTH_MESG_LENGTH_TYPE,
        LENGTH_MESG_PLAYER_SCORE,
        LENGTH_MESG_OPPONENT_SCORE,
        LENGTH_MESG_STROKE_COUNT,
        LENGTH_MESG_ZONE_COUNT,
        LENGTH_MESG_FIELDS
    } LENGTH_MESG_FIELD_INDEX;

    typedef enum
    {
        RECORD_MESG_TIMESTAMP,
        RECORD_MESG_POSITION_LAT,
        RECORD_MESG_POSITION_LONG,
        RECORD_MESG_ALTITUDE,
        RECORD_MESG_HEART_RATE,
        RECORD_MESG_CADENCE,
        RECORD_MESG_DISTANCE,
        RECORD_MESG_SPEED,
        RECORD_MESG_POWER,
        RECORD_MESG_COMPRESSED_SPEED_DISTANCE,
        RECORD_MESG_GRADE,
        RECORD_MESG_RESISTANCE,
        RECORD_MESG_TIME_FROM_COURSE,
        RECORD_MESG_CYCLE_LENGTH,
        RECORD_MESG_TEMPERATURE,
        RECORD_MESG_SPEED_1S,
        RECORD_MESG_CYCLES,
        RECORD_MESG_TOTAL_CYCLES,
        RECORD_MESG_COMPRESSED_ACCUMULATED_POWER,
        RECORD_MESG_ACCUMULATED_POWER,
        RECORD_MESG_LEFT_RIGHT_BALANCE,
        RECORD_MESG_GPS_ACCURACY,
        RECORD_MESG_VERTICAL_SPEED,
        RECORD_MESG_CALORIES,
        RECORD_MESG_VERTICAL_OSCILLATION,
        RECORD_MESG_STANCE_TIME_PERCENT,
        RECORD_MESG_STANCE_TIME,
        RECORD_MESG_ACTIVITY_TYPE,
        RECORD_MESG_LEFT_TORQUE_EFFECTIVENESS,
        RECORD_MESG_RIGHT_TORQUE_EFFECTIVENESS,
        RECORD_MESG_LEFT_PEDAL_SMOOTHNESS,
        RECORD_MESG_RIGHT_PEDAL_SMOOTHNESS,
        RECORD_MESG_COMBINED_PEDAL_SMOOTHNESS,
        RECORD_MESG_TIME128,
        RECORD_MESG_STROKE_TYPE,
        RECORD_MESG_ZONE,
        RECORD_MESG_BALL_SPEED,
        RECORD_MESG_CADENCE256,
        RECORD_MESG_FRACTIONAL_CADENCE,
        RECORD_MESG_TOTAL_HEMOGLOBIN_CONC,
        RECORD_MESG_TOTAL_HEMOGLOBIN_CONC_MIN,
        RECORD_MESG_TOTAL_HEMOGLOBIN_CONC_MAX,
        RECORD_MESG_SATURATED_HEMOGLOBIN_PERCENT,
        RECORD_MESG_SATURATED_HEMOGLOBIN_PERCENT_MIN,
        RECORD_MESG_SATURATED_HEMOGLOBIN_PERCENT_MAX,
        RECORD_MESG_DEVICE_INDEX,
        RECORD_MESG_LEFT_PCO,
        RECORD_MESG_RIGHT_PCO,
        RECORD_MESG_LEFT_POWER_PHASE,
        RECORD_MESG_LEFT_POWER_PHASE_PEAK,
        RECORD_MESG_RIGHT_POWER_PHASE,
        RECORD_MESG_RIGHT_POWER_PHASE_PEAK,
        RECORD_MESG_ENHANCED_SPEED,
        RECORD_MESG_ENHANCED_ALTITUDE,
        RECORD_MESG_BATTERY_SOC,
        RECORD_MESG_MOTOR_POWER,
        RECORD_MESG_VERTICAL_RATIO,
        RECORD_MESG_STANCE_TIME_BALANCE,
        RECORD_MESG_STEP_LENGTH,
        RECORD_MESG_FIELDS
    } RECORD_MESG_FIELD_INDEX;

    typedef enum
    {
        EVENT_MESG_TIMESTAMP,
        EVENT_MESG_EVENT,
        EVENT_MESG_EVENT_TYPE,
        EVENT_MESG_DATA16,
        EVENT_MESG_DATA,
        EVENT_MESG_EVENT_GROUP,
        EVENT_MESG_SCORE,
        EVENT_MESG_OPPONENT_SCORE,
        EVENT_MESG_FRONT_GEAR_NUM,
        EVENT_MESG_FRONT_GEAR,
        EVENT_MESG_REAR_GEAR_NUM,
        EVENT_MESG_REAR_GEAR,
        EVENT_MESG_DEVICE_INDEX,
        EVENT_MESG_FIELDS
    } EVENT_MESG_FIELD_INDEX;

    typedef enum
    {
        EVENT_MESG_DATA_FIELD_TIMER_TRIGGER,
        EVENT_MESG_DATA_FIELD_COURSE_POINT_INDEX,
        EVENT_MESG_DATA_FIELD_BATTERY_LEVEL,
        EVENT_MESG_DATA_FIELD_VIRTUAL_PARTNER_SPEED,
        EVENT_MESG_DATA_FIELD_HR_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_HR_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_SPEED_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_SPEED_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_CAD_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_CAD_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_POWER_HIGH_ALERT,
        EVENT_MESG_DATA_FIELD_POWER_LOW_ALERT,
        EVENT_MESG_DATA_FIELD_TIME_DURATION_ALERT,
        EVENT_MESG_DATA_FIELD_DISTANCE_DURATION_ALERT,
        EVENT_MESG_DATA_FIELD_CALORIE_DURATION_ALERT,
        EVENT_MESG_DATA_FIELD_FITNESS_EQUIPMENT_STATE,
        EVENT_MESG_DATA_FIELD_SPORT_POINT,
        EVENT_MESG_DATA_FIELD_GEAR_CHANGE_DATA,
        EVENT_MESG_DATA_FIELD_RIDER_POSITION,
        EVENT_MESG_DATA_FIELD_COMM_TIMEOUT,
        EVENT_MESG_DATA_FIELD_SUBFIELDS,
        EVENT_MESG_DATA_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        EVENT_MESG_DATA_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } EVENT_MESG_DATA_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        DEVICE_INFO_MESG_TIMESTAMP,
        DEVICE_INFO_MESG_DEVICE_INDEX,
        DEVICE_INFO_MESG_DEVICE_TYPE,
        DEVICE_INFO_MESG_MANUFACTURER,
        DEVICE_INFO_MESG_SERIAL_NUMBER,
        DEVICE_INFO_MESG_PRODUCT,
        DEVICE_INFO_MESG_SOFTWARE_VERSION,
        DEVICE_INFO_MESG_HARDWARE_VERSION,
        DEVICE_INFO_MESG_CUM_OPERATING_TIME,
        DEVICE_INFO_MESG_BATTERY_VOLTAGE,
        DEVICE_INFO_MESG_BATTERY_STATUS,
        DEVICE_INFO_MESG_SENSOR_POSITION,
        DEVICE_INFO_MESG_DESCRIPTOR,
        DEVICE_INFO_MESG_ANT_TRANSMISSION_TYPE,
        DEVICE_INFO_MESG_ANT_DEVICE_NUMBER,
        DEVICE_INFO_MESG_ANT_NETWORK,
        DEVICE_INFO_MESG_SOURCE_TYPE,
        DEVICE_INFO_MESG_PRODUCT_NAME,
        DEVICE_INFO_MESG_FIELDS
    } DEVICE_INFO_MESG_FIELD_INDEX;

    typedef enum
    {
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_ANTPLUS_DEVICE_TYPE,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_ANT_DEVICE_TYPE,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_SUBFIELDS,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } DEVICE_INFO_MESG_DEVICE_TYPE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        DEVICE_INFO_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        DEVICE_INFO_MESG_PRODUCT_FIELD_SUBFIELDS,
        DEVICE_INFO_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        DEVICE_INFO_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } DEVICE_INFO_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        TRAINING_FILE_MESG_TIMESTAMP,
        TRAINING_FILE_MESG_TYPE,
        TRAINING_FILE_MESG_MANUFACTURER,
        TRAINING_FILE_MESG_PRODUCT,
        TRAINING_FILE_MESG_SERIAL_NUMBER,
        TRAINING_FILE_MESG_TIME_CREATED,
        TRAINING_FILE_MESG_FIELDS
    } TRAINING_FILE_MESG_FIELD_INDEX;

    typedef enum
    {
        TRAINING_FILE_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        TRAINING_FILE_MESG_PRODUCT_FIELD_SUBFIELDS,
        TRAINING_FILE_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        TRAINING_FILE_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } TRAINING_FILE_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        HRV_MESG_TIME,
        HRV_MESG_FIELDS
    } HRV_MESG_FIELD_INDEX;

    typedef enum
    {
        WEATHER_CONDITIONS_MESG_TIMESTAMP,
        WEATHER_CONDITIONS_MESG_WEATHER_REPORT,
        WEATHER_CONDITIONS_MESG_TEMPERATURE,
        WEATHER_CONDITIONS_MESG_CONDITION,
        WEATHER_CONDITIONS_MESG_WIND_DIRECTION,
        WEATHER_CONDITIONS_MESG_WIND_SPEED,
        WEATHER_CONDITIONS_MESG_PRECIPITATION_PROBABILITY,
        WEATHER_CONDITIONS_MESG_TEMPERATURE_FEELS_LIKE,
        WEATHER_CONDITIONS_MESG_RELATIVE_HUMIDITY,
        WEATHER_CONDITIONS_MESG_LOCATION,
        WEATHER_CONDITIONS_MESG_OBSERVED_AT_TIME,
        WEATHER_CONDITIONS_MESG_OBSERVED_LOCATION_LAT,
        WEATHER_CONDITIONS_MESG_OBSERVED_LOCATION_LONG,
        WEATHER_CONDITIONS_MESG_DAY_OF_WEEK,
        WEATHER_CONDITIONS_MESG_HIGH_TEMPERATURE,
        WEATHER_CONDITIONS_MESG_LOW_TEMPERATURE,
        WEATHER_CONDITIONS_MESG_FIELDS
    } WEATHER_CONDITIONS_MESG_FIELD_INDEX;

    typedef enum
    {
        WEATHER_ALERT_MESG_TIMESTAMP,
        WEATHER_ALERT_MESG_REPORT_ID,
        WEATHER_ALERT_MESG_ISSUE_TIME,
        WEATHER_ALERT_MESG_EXPIRE_TIME,
        WEATHER_ALERT_MESG_SEVERITY,
        WEATHER_ALERT_MESG_TYPE,
        WEATHER_ALERT_MESG_FIELDS
    } WEATHER_ALERT_MESG_FIELD_INDEX;

    typedef enum
    {
        GPS_METADATA_MESG_TIMESTAMP,
        GPS_METADATA_MESG_TIMESTAMP_MS,
        GPS_METADATA_MESG_POSITION_LAT,
        GPS_METADATA_MESG_POSITION_LONG,
        GPS_METADATA_MESG_ENHANCED_ALTITUDE,
        GPS_METADATA_MESG_ENHANCED_SPEED,
        GPS_METADATA_MESG_HEADING,
        GPS_METADATA_MESG_UTC_TIMESTAMP,
        GPS_METADATA_MESG_VELOCITY,
        GPS_METADATA_MESG_FIELDS
    } GPS_METADATA_MESG_FIELD_INDEX;

    typedef enum
    {
        CAMERA_EVENT_MESG_TIMESTAMP,
        CAMERA_EVENT_MESG_TIMESTAMP_MS,
        CAMERA_EVENT_MESG_CAMERA_EVENT_TYPE,
        CAMERA_EVENT_MESG_CAMERA_FILE_UUID,
        CAMERA_EVENT_MESG_CAMERA_ORIENTATION,
        CAMERA_EVENT_MESG_FIELDS
    } CAMERA_EVENT_MESG_FIELD_INDEX;

    typedef enum
    {
        GYROSCOPE_DATA_MESG_TIMESTAMP,
        GYROSCOPE_DATA_MESG_TIMESTAMP_MS,
        GYROSCOPE_DATA_MESG_SAMPLE_TIME_OFFSET,
        GYROSCOPE_DATA_MESG_GYRO_X,
        GYROSCOPE_DATA_MESG_GYRO_Y,
        GYROSCOPE_DATA_MESG_GYRO_Z,
        GYROSCOPE_DATA_MESG_CALIBRATED_GYRO_X,
        GYROSCOPE_DATA_MESG_CALIBRATED_GYRO_Y,
        GYROSCOPE_DATA_MESG_CALIBRATED_GYRO_Z,
        GYROSCOPE_DATA_MESG_FIELDS
    } GYROSCOPE_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        ACCELEROMETER_DATA_MESG_TIMESTAMP,
        ACCELEROMETER_DATA_MESG_TIMESTAMP_MS,
        ACCELEROMETER_DATA_MESG_SAMPLE_TIME_OFFSET,
        ACCELEROMETER_DATA_MESG_ACCEL_X,
        ACCELEROMETER_DATA_MESG_ACCEL_Y,
        ACCELEROMETER_DATA_MESG_ACCEL_Z,
        ACCELEROMETER_DATA_MESG_CALIBRATED_ACCEL_X,
        ACCELEROMETER_DATA_MESG_CALIBRATED_ACCEL_Y,
        ACCELEROMETER_DATA_MESG_CALIBRATED_ACCEL_Z,
        ACCELEROMETER_DATA_MESG_COMPRESSED_CALIBRATED_ACCEL_X,
        ACCELEROMETER_DATA_MESG_COMPRESSED_CALIBRATED_ACCEL_Y,
        ACCELEROMETER_DATA_MESG_COMPRESSED_CALIBRATED_ACCEL_Z,
        ACCELEROMETER_DATA_MESG_FIELDS
    } ACCELEROMETER_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        MAGNETOMETER_DATA_MESG_TIMESTAMP,
        MAGNETOMETER_DATA_MESG_TIMESTAMP_MS,
        MAGNETOMETER_DATA_MESG_SAMPLE_TIME_OFFSET,
        MAGNETOMETER_DATA_MESG_MAG_X,
        MAGNETOMETER_DATA_MESG_MAG_Y,
        MAGNETOMETER_DATA_MESG_MAG_Z,
        MAGNETOMETER_DATA_MESG_CALIBRATED_MAG_X,
        MAGNETOMETER_DATA_MESG_CALIBRATED_MAG_Y,
        MAGNETOMETER_DATA_MESG_CALIBRATED_MAG_Z,
        MAGNETOMETER_DATA_MESG_FIELDS
    } MAGNETOMETER_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        THREE_D_SENSOR_CALIBRATION_MESG_TIMESTAMP,
        THREE_D_SENSOR_CALIBRATION_MESG_SENSOR_TYPE,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_DIVISOR,
        THREE_D_SENSOR_CALIBRATION_MESG_LEVEL_SHIFT,
        THREE_D_SENSOR_CALIBRATION_MESG_OFFSET_CAL,
        THREE_D_SENSOR_CALIBRATION_MESG_ORIENTATION_MATRIX,
        THREE_D_SENSOR_CALIBRATION_MESG_FIELDS
    } THREE_D_SENSOR_CALIBRATION_MESG_FIELD_INDEX;

    typedef enum
    {
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_ACCEL_CAL_FACTOR,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_GYRO_CAL_FACTOR,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_SUBFIELDS,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } THREE_D_SENSOR_CALIBRATION_MESG_CALIBRATION_FACTOR_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        VIDEO_FRAME_MESG_TIMESTAMP,
        VIDEO_FRAME_MESG_TIMESTAMP_MS,
        VIDEO_FRAME_MESG_FRAME_NUMBER,
        VIDEO_FRAME_MESG_FIELDS
    } VIDEO_FRAME_MESG_FIELD_INDEX;

    typedef enum
    {
        OBDII_DATA_MESG_TIMESTAMP,
        OBDII_DATA_MESG_TIMESTAMP_MS,
        OBDII_DATA_MESG_TIME_OFFSET,
        OBDII_DATA_MESG_PID,
        OBDII_DATA_MESG_RAW_DATA,
        OBDII_DATA_MESG_PID_DATA_SIZE,
        OBDII_DATA_MESG_SYSTEM_TIME,
        OBDII_DATA_MESG_START_TIMESTAMP,
        OBDII_DATA_MESG_START_TIMESTAMP_MS,
        OBDII_DATA_MESG_FIELDS
    } OBDII_DATA_MESG_FIELD_INDEX;

    typedef enum
    {
        NMEA_SENTENCE_MESG_TIMESTAMP,
        NMEA_SENTENCE_MESG_TIMESTAMP_MS,
        NMEA_SENTENCE_MESG_SENTENCE,
        NMEA_SENTENCE_MESG_FIELDS
    } NMEA_SENTENCE_MESG_FIELD_INDEX;

    typedef enum
    {
        AVIATION_ATTITUDE_MESG_TIMESTAMP,
        AVIATION_ATTITUDE_MESG_TIMESTAMP_MS,
        AVIATION_ATTITUDE_MESG_SYSTEM_TIME,
        AVIATION_ATTITUDE_MESG_PITCH,
        AVIATION_ATTITUDE_MESG_ROLL,
        AVIATION_ATTITUDE_MESG_ACCEL_LATERAL,
        AVIATION_ATTITUDE_MESG_ACCEL_NORMAL,
        AVIATION_ATTITUDE_MESG_TURN_RATE,
        AVIATION_ATTITUDE_MESG_STAGE,
        AVIATION_ATTITUDE_MESG_ATTITUDE_STAGE_COMPLETE,
        AVIATION_ATTITUDE_MESG_TRACK,
        AVIATION_ATTITUDE_MESG_VALIDITY,
        AVIATION_ATTITUDE_MESG_FIELDS
    } AVIATION_ATTITUDE_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_MESG_URL,
        VIDEO_MESG_HOSTING_PROVIDER,
        VIDEO_MESG_DURATION,
        VIDEO_MESG_FIELDS
    } VIDEO_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_TITLE_MESG_MESSAGE_INDEX,
        VIDEO_TITLE_MESG_MESSAGE_COUNT,
        VIDEO_TITLE_MESG_TEXT,
        VIDEO_TITLE_MESG_FIELDS
    } VIDEO_TITLE_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_DESCRIPTION_MESG_MESSAGE_INDEX,
        VIDEO_DESCRIPTION_MESG_MESSAGE_COUNT,
        VIDEO_DESCRIPTION_MESG_TEXT,
        VIDEO_DESCRIPTION_MESG_FIELDS
    } VIDEO_DESCRIPTION_MESG_FIELD_INDEX;

    typedef enum
    {
        VIDEO_CLIP_MESG_CLIP_NUMBER,
        VIDEO_CLIP_MESG_START_TIMESTAMP,
        VIDEO_CLIP_MESG_START_TIMESTAMP_MS,
        VIDEO_CLIP_MESG_END_TIMESTAMP,
        VIDEO_CLIP_MESG_END_TIMESTAMP_MS,
        VIDEO_CLIP_MESG_CLIP_START,
        VIDEO_CLIP_MESG_CLIP_END,
        VIDEO_CLIP_MESG_FIELDS
    } VIDEO_CLIP_MESG_FIELD_INDEX;

    typedef enum
    {
        COURSE_MESG_SPORT,
        COURSE_MESG_NAME,
        COURSE_MESG_CAPABILITIES,
        COURSE_MESG_SUB_SPORT,
        COURSE_MESG_FIELDS
    } COURSE_MESG_FIELD_INDEX;

    typedef enum
    {
        COURSE_POINT_MESG_MESSAGE_INDEX,
        COURSE_POINT_MESG_TIMESTAMP,
        COURSE_POINT_MESG_POSITION_LAT,
        COURSE_POINT_MESG_POSITION_LONG,
        COURSE_POINT_MESG_DISTANCE,
        COURSE_POINT_MESG_TYPE,
        COURSE_POINT_MESG_NAME,
        COURSE_POINT_MESG_FAVORITE,
        COURSE_POINT_MESG_FIELDS
    } COURSE_POINT_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_ID_MESG_NAME,
        SEGMENT_ID_MESG_UUID,
        SEGMENT_ID_MESG_SPORT,
        SEGMENT_ID_MESG_ENABLED,
        SEGMENT_ID_MESG_USER_PROFILE_PRIMARY_KEY,
        SEGMENT_ID_MESG_DEVICE_ID,
        SEGMENT_ID_MESG_DEFAULT_RACE_LEADER,
        SEGMENT_ID_MESG_DELETE_STATUS,
        SEGMENT_ID_MESG_SELECTION_TYPE,
        SEGMENT_ID_MESG_FIELDS
    } SEGMENT_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_LEADERBOARD_ENTRY_MESG_MESSAGE_INDEX,
        SEGMENT_LEADERBOARD_ENTRY_MESG_NAME,
        SEGMENT_LEADERBOARD_ENTRY_MESG_TYPE,
        SEGMENT_LEADERBOARD_ENTRY_MESG_GROUP_PRIMARY_KEY,
        SEGMENT_LEADERBOARD_ENTRY_MESG_ACTIVITY_ID,
        SEGMENT_LEADERBOARD_ENTRY_MESG_SEGMENT_TIME,
        SEGMENT_LEADERBOARD_ENTRY_MESG_ACTIVITY_ID_STRING,
        SEGMENT_LEADERBOARD_ENTRY_MESG_FIELDS
    } SEGMENT_LEADERBOARD_ENTRY_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_POINT_MESG_MESSAGE_INDEX,
        SEGMENT_POINT_MESG_POSITION_LAT,
        SEGMENT_POINT_MESG_POSITION_LONG,
        SEGMENT_POINT_MESG_DISTANCE,
        SEGMENT_POINT_MESG_ALTITUDE,
        SEGMENT_POINT_MESG_LEADER_TIME,
        SEGMENT_POINT_MESG_FIELDS
    } SEGMENT_POINT_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_LAP_MESG_MESSAGE_INDEX,
        SEGMENT_LAP_MESG_TIMESTAMP,
        SEGMENT_LAP_MESG_EVENT,
        SEGMENT_LAP_MESG_EVENT_TYPE,
        SEGMENT_LAP_MESG_START_TIME,
        SEGMENT_LAP_MESG_START_POSITION_LAT,
        SEGMENT_LAP_MESG_START_POSITION_LONG,
        SEGMENT_LAP_MESG_END_POSITION_LAT,
        SEGMENT_LAP_MESG_END_POSITION_LONG,
        SEGMENT_LAP_MESG_TOTAL_ELAPSED_TIME,
        SEGMENT_LAP_MESG_TOTAL_TIMER_TIME,
        SEGMENT_LAP_MESG_TOTAL_DISTANCE,
        SEGMENT_LAP_MESG_TOTAL_CYCLES,
        SEGMENT_LAP_MESG_TOTAL_CALORIES,
        SEGMENT_LAP_MESG_TOTAL_FAT_CALORIES,
        SEGMENT_LAP_MESG_AVG_SPEED,
        SEGMENT_LAP_MESG_MAX_SPEED,
        SEGMENT_LAP_MESG_AVG_HEART_RATE,
        SEGMENT_LAP_MESG_MAX_HEART_RATE,
        SEGMENT_LAP_MESG_AVG_CADENCE,
        SEGMENT_LAP_MESG_MAX_CADENCE,
        SEGMENT_LAP_MESG_AVG_POWER,
        SEGMENT_LAP_MESG_MAX_POWER,
        SEGMENT_LAP_MESG_TOTAL_ASCENT,
        SEGMENT_LAP_MESG_TOTAL_DESCENT,
        SEGMENT_LAP_MESG_SPORT,
        SEGMENT_LAP_MESG_EVENT_GROUP,
        SEGMENT_LAP_MESG_NEC_LAT,
        SEGMENT_LAP_MESG_NEC_LONG,
        SEGMENT_LAP_MESG_SWC_LAT,
        SEGMENT_LAP_MESG_SWC_LONG,
        SEGMENT_LAP_MESG_NAME,
        SEGMENT_LAP_MESG_NORMALIZED_POWER,
        SEGMENT_LAP_MESG_LEFT_RIGHT_BALANCE,
        SEGMENT_LAP_MESG_SUB_SPORT,
        SEGMENT_LAP_MESG_TOTAL_WORK,
        SEGMENT_LAP_MESG_AVG_ALTITUDE,
        SEGMENT_LAP_MESG_MAX_ALTITUDE,
        SEGMENT_LAP_MESG_GPS_ACCURACY,
        SEGMENT_LAP_MESG_AVG_GRADE,
        SEGMENT_LAP_MESG_AVG_POS_GRADE,
        SEGMENT_LAP_MESG_AVG_NEG_GRADE,
        SEGMENT_LAP_MESG_MAX_POS_GRADE,
        SEGMENT_LAP_MESG_MAX_NEG_GRADE,
        SEGMENT_LAP_MESG_AVG_TEMPERATURE,
        SEGMENT_LAP_MESG_MAX_TEMPERATURE,
        SEGMENT_LAP_MESG_TOTAL_MOVING_TIME,
        SEGMENT_LAP_MESG_AVG_POS_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_AVG_NEG_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_MAX_POS_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_MAX_NEG_VERTICAL_SPEED,
        SEGMENT_LAP_MESG_TIME_IN_HR_ZONE,
        SEGMENT_LAP_MESG_TIME_IN_SPEED_ZONE,
        SEGMENT_LAP_MESG_TIME_IN_CADENCE_ZONE,
        SEGMENT_LAP_MESG_TIME_IN_POWER_ZONE,
        SEGMENT_LAP_MESG_REPETITION_NUM,
        SEGMENT_LAP_MESG_MIN_ALTITUDE,
        SEGMENT_LAP_MESG_MIN_HEART_RATE,
        SEGMENT_LAP_MESG_ACTIVE_TIME,
        SEGMENT_LAP_MESG_WKT_STEP_INDEX,
        SEGMENT_LAP_MESG_SPORT_EVENT,
        SEGMENT_LAP_MESG_AVG_LEFT_TORQUE_EFFECTIVENESS,
        SEGMENT_LAP_MESG_AVG_RIGHT_TORQUE_EFFECTIVENESS,
        SEGMENT_LAP_MESG_AVG_LEFT_PEDAL_SMOOTHNESS,
        SEGMENT_LAP_MESG_AVG_RIGHT_PEDAL_SMOOTHNESS,
        SEGMENT_LAP_MESG_AVG_COMBINED_PEDAL_SMOOTHNESS,
        SEGMENT_LAP_MESG_STATUS,
        SEGMENT_LAP_MESG_UUID,
        SEGMENT_LAP_MESG_AVG_FRACTIONAL_CADENCE,
        SEGMENT_LAP_MESG_MAX_FRACTIONAL_CADENCE,
        SEGMENT_LAP_MESG_TOTAL_FRACTIONAL_CYCLES,
        SEGMENT_LAP_MESG_FRONT_GEAR_SHIFT_COUNT,
        SEGMENT_LAP_MESG_REAR_GEAR_SHIFT_COUNT,
        SEGMENT_LAP_MESG_TIME_STANDING,
        SEGMENT_LAP_MESG_STAND_COUNT,
        SEGMENT_LAP_MESG_AVG_LEFT_PCO,
        SEGMENT_LAP_MESG_AVG_RIGHT_PCO,
        SEGMENT_LAP_MESG_AVG_LEFT_POWER_PHASE,
        SEGMENT_LAP_MESG_AVG_LEFT_POWER_PHASE_PEAK,
        SEGMENT_LAP_MESG_AVG_RIGHT_POWER_PHASE,
        SEGMENT_LAP_MESG_AVG_RIGHT_POWER_PHASE_PEAK,
        SEGMENT_LAP_MESG_AVG_POWER_POSITION,
        SEGMENT_LAP_MESG_MAX_POWER_POSITION,
        SEGMENT_LAP_MESG_AVG_CADENCE_POSITION,
        SEGMENT_LAP_MESG_MAX_CADENCE_POSITION,
        SEGMENT_LAP_MESG_MANUFACTURER,
        SEGMENT_LAP_MESG_FIELDS
    } SEGMENT_LAP_MESG_FIELD_INDEX;

    typedef enum
    {
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES,
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELDS,
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        SEGMENT_FILE_MESG_MESSAGE_INDEX,
        SEGMENT_FILE_MESG_FILE_UUID,
        SEGMENT_FILE_MESG_ENABLED,
        SEGMENT_FILE_MESG_USER_PROFILE_PRIMARY_KEY,
        SEGMENT_FILE_MESG_LEADER_TYPE,
        SEGMENT_FILE_MESG_LEADER_GROUP_PRIMARY_KEY,
        SEGMENT_FILE_MESG_LEADER_ACTIVITY_ID,
        SEGMENT_FILE_MESG_LEADER_ACTIVITY_ID_STRING,
        SEGMENT_FILE_MESG_DEFAULT_RACE_LEADER,
        SEGMENT_FILE_MESG_FIELDS
    } SEGMENT_FILE_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_MESG_SPORT,
        WORKOUT_MESG_CAPABILITIES,
        WORKOUT_MESG_NUM_VALID_STEPS,
        WORKOUT_MESG_WKT_NAME,
        WORKOUT_MESG_SUB_SPORT,
        WORKOUT_MESG_POOL_LENGTH,
        WORKOUT_MESG_POOL_LENGTH_UNIT,
        WORKOUT_MESG_FIELDS
    } WORKOUT_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_SESSION_MESG_MESSAGE_INDEX,
        WORKOUT_SESSION_MESG_SPORT,
        WORKOUT_SESSION_MESG_SUB_SPORT,
        WORKOUT_SESSION_MESG_NUM_VALID_STEPS,
        WORKOUT_SESSION_MESG_FIRST_STEP_INDEX,
        WORKOUT_SESSION_MESG_POOL_LENGTH,
        WORKOUT_SESSION_MESG_POOL_LENGTH_UNIT,
        WORKOUT_SESSION_MESG_FIELDS
    } WORKOUT_SESSION_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_MESSAGE_INDEX,
        WORKOUT_STEP_MESG_WKT_STEP_NAME,
        WORKOUT_STEP_MESG_DURATION_TYPE,
        WORKOUT_STEP_MESG_DURATION_VALUE,
        WORKOUT_STEP_MESG_TARGET_TYPE,
        WORKOUT_STEP_MESG_TARGET_VALUE,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH,
        WORKOUT_STEP_MESG_INTENSITY,
        WORKOUT_STEP_MESG_NOTES,
        WORKOUT_STEP_MESG_EQUIPMENT,
        WORKOUT_STEP_MESG_FIELDS
    } WORKOUT_STEP_MESG_FIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_TIME,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_DISTANCE,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_HR,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_CALORIES,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_STEP,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_DURATION_POWER,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_DURATION_VALUE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_SPEED_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_HR_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_CADENCE_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_POWER_ZONE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_STEPS,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_TIME,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_DISTANCE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_CALORIES,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_HR,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_REPEAT_POWER,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_TARGET_STROKE_TYPE,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_TARGET_VALUE_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_SPEED_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_HEART_RATE_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_CADENCE_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_CUSTOM_TARGET_POWER_LOW,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_LOW_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_SPEED_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_HEART_RATE_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_CADENCE_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_CUSTOM_TARGET_POWER_HIGH,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_SUBFIELDS,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } WORKOUT_STEP_MESG_CUSTOM_TARGET_VALUE_HIGH_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        SCHEDULE_MESG_MANUFACTURER,
        SCHEDULE_MESG_PRODUCT,
        SCHEDULE_MESG_SERIAL_NUMBER,
        SCHEDULE_MESG_TIME_CREATED,
        SCHEDULE_MESG_COMPLETED,
        SCHEDULE_MESG_TYPE,
        SCHEDULE_MESG_SCHEDULED_TIME,
        SCHEDULE_MESG_FIELDS
    } SCHEDULE_MESG_FIELD_INDEX;

    typedef enum
    {
        SCHEDULE_MESG_PRODUCT_FIELD_GARMIN_PRODUCT,
        SCHEDULE_MESG_PRODUCT_FIELD_SUBFIELDS,
        SCHEDULE_MESG_PRODUCT_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        SCHEDULE_MESG_PRODUCT_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } SCHEDULE_MESG_PRODUCT_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        TOTALS_MESG_MESSAGE_INDEX,
        TOTALS_MESG_TIMESTAMP,
        TOTALS_MESG_TIMER_TIME,
        TOTALS_MESG_DISTANCE,
        TOTALS_MESG_CALORIES,
        TOTALS_MESG_SPORT,
        TOTALS_MESG_ELAPSED_TIME,
        TOTALS_MESG_SESSIONS,
        TOTALS_MESG_ACTIVE_TIME,
        TOTALS_MESG_SPORT_INDEX,
        TOTALS_MESG_FIELDS
    } TOTALS_MESG_FIELD_INDEX;

    typedef enum
    {
        WEIGHT_SCALE_MESG_TIMESTAMP,
        WEIGHT_SCALE_MESG_WEIGHT,
        WEIGHT_SCALE_MESG_PERCENT_FAT,
        WEIGHT_SCALE_MESG_PERCENT_HYDRATION,
        WEIGHT_SCALE_MESG_VISCERAL_FAT_MASS,
        WEIGHT_SCALE_MESG_BONE_MASS,
        WEIGHT_SCALE_MESG_MUSCLE_MASS,
        WEIGHT_SCALE_MESG_BASAL_MET,
        WEIGHT_SCALE_MESG_PHYSIQUE_RATING,
        WEIGHT_SCALE_MESG_ACTIVE_MET,
        WEIGHT_SCALE_MESG_METABOLIC_AGE,
        WEIGHT_SCALE_MESG_VISCERAL_FAT_RATING,
        WEIGHT_SCALE_MESG_USER_PROFILE_INDEX,
        WEIGHT_SCALE_MESG_FIELDS
    } WEIGHT_SCALE_MESG_FIELD_INDEX;

    typedef enum
    {
        BLOOD_PRESSURE_MESG_TIMESTAMP,
        BLOOD_PRESSURE_MESG_SYSTOLIC_PRESSURE,
        BLOOD_PRESSURE_MESG_DIASTOLIC_PRESSURE,
        BLOOD_PRESSURE_MESG_MEAN_ARTERIAL_PRESSURE,
        BLOOD_PRESSURE_MESG_MAP_3_SAMPLE_MEAN,
        BLOOD_PRESSURE_MESG_MAP_MORNING_VALUES,
        BLOOD_PRESSURE_MESG_MAP_EVENING_VALUES,
        BLOOD_PRESSURE_MESG_HEART_RATE,
        BLOOD_PRESSURE_MESG_HEART_RATE_TYPE,
        BLOOD_PRESSURE_MESG_STATUS,
        BLOOD_PRESSURE_MESG_USER_PROFILE_INDEX,
        BLOOD_PRESSURE_MESG_FIELDS
    } BLOOD_PRESSURE_MESG_FIELD_INDEX;

    typedef enum
    {
        MONITORING_INFO_MESG_TIMESTAMP,
        MONITORING_INFO_MESG_LOCAL_TIMESTAMP,
        MONITORING_INFO_MESG_ACTIVITY_TYPE,
        MONITORING_INFO_MESG_CYCLES_TO_DISTANCE,
        MONITORING_INFO_MESG_CYCLES_TO_CALORIES,
        MONITORING_INFO_MESG_RESTING_METABOLIC_RATE,
        MONITORING_INFO_MESG_FIELDS
    } MONITORING_INFO_MESG_FIELD_INDEX;

    typedef enum
    {
        MONITORING_MESG_TIMESTAMP,
        MONITORING_MESG_DEVICE_INDEX,
        MONITORING_MESG_CALORIES,
        MONITORING_MESG_DISTANCE,
        MONITORING_MESG_CYCLES,
        MONITORING_MESG_ACTIVE_TIME,
        MONITORING_MESG_ACTIVITY_TYPE,
        MONITORING_MESG_ACTIVITY_SUBTYPE,
        MONITORING_MESG_ACTIVITY_LEVEL,
        MONITORING_MESG_DISTANCE_16,
        MONITORING_MESG_CYCLES_16,
        MONITORING_MESG_ACTIVE_TIME_16,
        MONITORING_MESG_LOCAL_TIMESTAMP,
        MONITORING_MESG_TEMPERATURE,
        MONITORING_MESG_TEMPERATURE_MIN,
        MONITORING_MESG_TEMPERATURE_MAX,
        MONITORING_MESG_ACTIVITY_TIME,
        MONITORING_MESG_ACTIVE_CALORIES,
        MONITORING_MESG_CURRENT_ACTIVITY_TYPE_INTENSITY,
        MONITORING_MESG_TIMESTAMP_MIN_8,
        MONITORING_MESG_TIMESTAMP_16,
        MONITORING_MESG_HEART_RATE,
        MONITORING_MESG_INTENSITY,
        MONITORING_MESG_DURATION_MIN,
        MONITORING_MESG_DURATION,
        MONITORING_MESG_ASCENT,
        MONITORING_MESG_DESCENT,
        MONITORING_MESG_MODERATE_ACTIVITY_MINUTES,
        MONITORING_MESG_VIGOROUS_ACTIVITY_MINUTES,
        MONITORING_MESG_FIELDS
    } MONITORING_MESG_FIELD_INDEX;

    typedef enum
    {
        MONITORING_MESG_CYCLES_FIELD_STEPS,
        MONITORING_MESG_CYCLES_FIELD_STROKES,
        MONITORING_MESG_CYCLES_FIELD_SUBFIELDS,
        MONITORING_MESG_CYCLES_FIELD_ACTIVE_SUBFIELD = FIT_SUBFIELD_INDEX_ACTIVE_SUBFIELD,
        MONITORING_MESG_CYCLES_FIELD_MAIN_FIELD = FIT_SUBFIELD_INDEX_MAIN_FIELD
    } MONITORING_MESG_CYCLES_FIELD_SUBFIELD_INDEX;

    typedef enum
    {
        HR_MESG_TIMESTAMP,
        HR_MESG_FRACTIONAL_TIMESTAMP,
        HR_MESG_TIME256,
        HR_MESG_FILTERED_BPM,
        HR_MESG_EVENT_TIMESTAMP,
        HR_MESG_EVENT_TIMESTAMP_12,
        HR_MESG_FIELDS
    } HR_MESG_FIELD_INDEX;

    typedef enum
    {
        MEMO_GLOB_MESG_PART_INDEX,
        MEMO_GLOB_MESG_MEMO,
        MEMO_GLOB_MESG_MESSAGE_NUMBER,
        MEMO_GLOB_MESG_MESSAGE_INDEX,
        MEMO_GLOB_MESG_FIELDS
    } MEMO_GLOB_MESG_FIELD_INDEX;

    typedef enum
    {
        ANT_CHANNEL_ID_MESG_CHANNEL_NUMBER,
        ANT_CHANNEL_ID_MESG_DEVICE_TYPE,
        ANT_CHANNEL_ID_MESG_DEVICE_NUMBER,
        ANT_CHANNEL_ID_MESG_TRANSMISSION_TYPE,
        ANT_CHANNEL_ID_MESG_DEVICE_INDEX,
        ANT_CHANNEL_ID_MESG_FIELDS
    } ANT_CHANNEL_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        ANT_RX_MESG_TIMESTAMP,
        ANT_RX_MESG_FRACTIONAL_TIMESTAMP,
        ANT_RX_MESG_MESG_ID,
        ANT_RX_MESG_MESG_DATA,
        ANT_RX_MESG_CHANNEL_NUMBER,
        ANT_RX_MESG_DATA,
        ANT_RX_MESG_FIELDS
    } ANT_RX_MESG_FIELD_INDEX;

    typedef enum
    {
        ANT_TX_MESG_TIMESTAMP,
        ANT_TX_MESG_FRACTIONAL_TIMESTAMP,
        ANT_TX_MESG_MESG_ID,
        ANT_TX_MESG_MESG_DATA,
        ANT_TX_MESG_CHANNEL_NUMBER,
        ANT_TX_MESG_DATA,
        ANT_TX_MESG_FIELDS
    } ANT_TX_MESG_FIELD_INDEX;

    typedef enum
    {
        EXD_SCREEN_CONFIGURATION_MESG_SCREEN_INDEX,
        EXD_SCREEN_CONFIGURATION_MESG_FIELD_COUNT,
        EXD_SCREEN_CONFIGURATION_MESG_LAYOUT,
        EXD_SCREEN_CONFIGURATION_MESG_SCREEN_ENABLED,
        EXD_SCREEN_CONFIGURATION_MESG_FIELDS
    } EXD_SCREEN_CONFIGURATION_MESG_FIELD_INDEX;

    typedef enum
    {
        EXD_DATA_FIELD_CONFIGURATION_MESG_SCREEN_INDEX,
        EXD_DATA_FIELD_CONFIGURATION_MESG_CONCEPT_FIELD,
        EXD_DATA_FIELD_CONFIGURATION_MESG_FIELD_ID,
        EXD_DATA_FIELD_CONFIGURATION_MESG_CONCEPT_COUNT,
        EXD_DATA_FIELD_CONFIGURATION_MESG_DISPLAY_TYPE,
        EXD_DATA_FIELD_CONFIGURATION_MESG_TITLE,
        EXD_DATA_FIELD_CONFIGURATION_MESG_FIELDS
    } EXD_DATA_FIELD_CONFIGURATION_MESG_FIELD_INDEX;

    typedef enum
    {
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_SCREEN_INDEX,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_CONCEPT_FIELD,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_FIELD_ID,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_CONCEPT_INDEX,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_DATA_PAGE,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_CONCEPT_KEY,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_SCALING,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_DATA_UNITS,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_QUALIFIER,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_DESCRIPTOR,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_IS_SIGNED,
        EXD_DATA_CONCEPT_CONFIGURATION_MESG_FIELDS
    } EXD_DATA_CONCEPT_CONFIGURATION_MESG_FIELD_INDEX;

    typedef enum
    {
        FIELD_DESCRIPTION_MESG_DEVELOPER_DATA_INDEX,
        FIELD_DESCRIPTION_MESG_FIELD_DEFINITION_NUMBER,
        FIELD_DESCRIPTION_MESG_FIT_BASE_TYPE_ID,
        FIELD_DESCRIPTION_MESG_FIELD_NAME,
        FIELD_DESCRIPTION_MESG_ARRAY,
        FIELD_DESCRIPTION_MESG_COMPONENTS,
        FIELD_DESCRIPTION_MESG_SCALE,
        FIELD_DESCRIPTION_MESG_OFFSET,
        FIELD_DESCRIPTION_MESG_UNITS,
        FIELD_DESCRIPTION_MESG_BITS,
        FIELD_DESCRIPTION_MESG_ACCUMULATE,
        FIELD_DESCRIPTION_MESG_FIT_BASE_UNIT_ID,
        FIELD_DESCRIPTION_MESG_NATIVE_MESG_NUM,
        FIELD_DESCRIPTION_MESG_NATIVE_FIELD_NUM,
        FIELD_DESCRIPTION_MESG_FIELDS
    } FIELD_DESCRIPTION_MESG_FIELD_INDEX;

    typedef enum
    {
        DEVELOPER_DATA_ID_MESG_DEVELOPER_ID,
        DEVELOPER_DATA_ID_MESG_APPLICATION_ID,
        DEVELOPER_DATA_ID_MESG_MANUFACTURER_ID,
        DEVELOPER_DATA_ID_MESG_DEVELOPER_DATA_INDEX,
        DEVELOPER_DATA_ID_MESG_APPLICATION_VERSION,
        DEVELOPER_DATA_ID_MESG_FIELDS
    } DEVELOPER_DATA_ID_MESG_FIELD_INDEX;

    typedef enum
    {
        PAD_MESG_FIELDS
    } PAD_MESG_FIELD_INDEX;

    typedef struct
    {
        FIT_FLOAT64 scale;
        FIT_FLOAT64 offset;
        FIT_UINT8 num;
        FIT_UINT8 bits;
        FIT_BOOL accumulate;
    } FIELD_COMPONENT;

    typedef struct
    {
        FIT_SINT32 refFieldValue;
        FIT_UINT8 refFieldNum;
    } SUBFIELD_MAP;

    typedef struct
    {
        const SUBFIELD_MAP* maps;
        const FIELD_COMPONENT* components;
        std::string name;
        std::string units;
        FIT_FLOAT64 scale;
        FIT_FLOAT64 offset;
        FIT_UINT8 numMaps;
        FIT_UINT16 numComponents;
        FIT_UINT8 type;
    } SUBFIELD;

    typedef struct
    {
        const FIELD_COMPONENT* components;
        const SUBFIELD* subFields;
        std::string name;
        std::string units;
        FIT_FLOAT64 scale;
        FIT_FLOAT64 offset;
        FIT_UINT16 numComponents;
        FIT_UINT16 numSubFields;
        FIT_UINT8 num;
        FIT_UINT8 type;
        FIT_BOOL isAccumulated;
        Type profileType;
    } FIELD;

    typedef struct
    {
        const FIELD* fields;
        std::string name;
        FIT_UINT16 num;
        FIT_UINT16 numFields;
    } MESG;

    static const MESG mesgs[MESGS];

    static const Profile::MESG* GetMesg(const FIT_UINT16 num);
    static const Profile::MESG* GetMesg(const std::string& name);
    static const FIT_UINT16 GetFieldIndex(const FIT_UINT16 mesgNum, const FIT_UINT8 fieldNum);
    static const FIT_UINT16 GetFieldIndex(const std::string& mesgName, const std::string& fieldName);
    static const Profile::FIELD* GetField(const FIT_UINT16 mesgNum, const FIT_UINT8 fieldNum);
    static const Profile::FIELD* GetField(const std::string& mesgName, const std::string& fieldName);
    static const FIT_UINT16 GetSubFieldIndex(const std::string& mesgName, const std::string& fieldName, const std::string& subFieldName);
    static const Profile::SUBFIELD* GetSubField(const FIT_UINT16 mesgNum, const FIT_UINT8 fieldNum, const FIT_UINT16 subFieldIndex);
    static const Profile::SUBFIELD* GetSubField(const std::string& mesgName, const std::string& fieldName, const std::string& subFieldName);
};

} // namespace fit

#endif // !defined(FIT_PROFILE_HPP)
