////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2017 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 20.38Release
// Tag = production/akw/20.38.00-0-geccbce3
////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_SEGMENT_LAP_MESG_HPP)
#define FIT_SEGMENT_LAP_MESG_HPP

#include "fit_mesg.hpp"
#include "fit_mesg_with_event.hpp"

namespace fit
{

class SegmentLapMesg : public Mesg, public MesgWithEvent
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 MessageIndex = 254;
       static const FIT_UINT8 Timestamp = 253;
       static const FIT_UINT8 Event = 0;
       static const FIT_UINT8 EventType = 1;
       static const FIT_UINT8 StartTime = 2;
       static const FIT_UINT8 StartPositionLat = 3;
       static const FIT_UINT8 StartPositionLong = 4;
       static const FIT_UINT8 EndPositionLat = 5;
       static const FIT_UINT8 EndPositionLong = 6;
       static const FIT_UINT8 TotalElapsedTime = 7;
       static const FIT_UINT8 TotalTimerTime = 8;
       static const FIT_UINT8 TotalDistance = 9;
       static const FIT_UINT8 TotalCycles = 10;
       static const FIT_UINT8 TotalCalories = 11;
       static const FIT_UINT8 TotalFatCalories = 12;
       static const FIT_UINT8 AvgSpeed = 13;
       static const FIT_UINT8 MaxSpeed = 14;
       static const FIT_UINT8 AvgHeartRate = 15;
       static const FIT_UINT8 MaxHeartRate = 16;
       static const FIT_UINT8 AvgCadence = 17;
       static const FIT_UINT8 MaxCadence = 18;
       static const FIT_UINT8 AvgPower = 19;
       static const FIT_UINT8 MaxPower = 20;
       static const FIT_UINT8 TotalAscent = 21;
       static const FIT_UINT8 TotalDescent = 22;
       static const FIT_UINT8 Sport = 23;
       static const FIT_UINT8 EventGroup = 24;
       static const FIT_UINT8 NecLat = 25;
       static const FIT_UINT8 NecLong = 26;
       static const FIT_UINT8 SwcLat = 27;
       static const FIT_UINT8 SwcLong = 28;
       static const FIT_UINT8 Name = 29;
       static const FIT_UINT8 NormalizedPower = 30;
       static const FIT_UINT8 LeftRightBalance = 31;
       static const FIT_UINT8 SubSport = 32;
       static const FIT_UINT8 TotalWork = 33;
       static const FIT_UINT8 AvgAltitude = 34;
       static const FIT_UINT8 MaxAltitude = 35;
       static const FIT_UINT8 GpsAccuracy = 36;
       static const FIT_UINT8 AvgGrade = 37;
       static const FIT_UINT8 AvgPosGrade = 38;
       static const FIT_UINT8 AvgNegGrade = 39;
       static const FIT_UINT8 MaxPosGrade = 40;
       static const FIT_UINT8 MaxNegGrade = 41;
       static const FIT_UINT8 AvgTemperature = 42;
       static const FIT_UINT8 MaxTemperature = 43;
       static const FIT_UINT8 TotalMovingTime = 44;
       static const FIT_UINT8 AvgPosVerticalSpeed = 45;
       static const FIT_UINT8 AvgNegVerticalSpeed = 46;
       static const FIT_UINT8 MaxPosVerticalSpeed = 47;
       static const FIT_UINT8 MaxNegVerticalSpeed = 48;
       static const FIT_UINT8 TimeInHrZone = 49;
       static const FIT_UINT8 TimeInSpeedZone = 50;
       static const FIT_UINT8 TimeInCadenceZone = 51;
       static const FIT_UINT8 TimeInPowerZone = 52;
       static const FIT_UINT8 RepetitionNum = 53;
       static const FIT_UINT8 MinAltitude = 54;
       static const FIT_UINT8 MinHeartRate = 55;
       static const FIT_UINT8 ActiveTime = 56;
       static const FIT_UINT8 WktStepIndex = 57;
       static const FIT_UINT8 SportEvent = 58;
       static const FIT_UINT8 AvgLeftTorqueEffectiveness = 59;
       static const FIT_UINT8 AvgRightTorqueEffectiveness = 60;
       static const FIT_UINT8 AvgLeftPedalSmoothness = 61;
       static const FIT_UINT8 AvgRightPedalSmoothness = 62;
       static const FIT_UINT8 AvgCombinedPedalSmoothness = 63;
       static const FIT_UINT8 Status = 64;
       static const FIT_UINT8 Uuid = 65;
       static const FIT_UINT8 AvgFractionalCadence = 66;
       static const FIT_UINT8 MaxFractionalCadence = 67;
       static const FIT_UINT8 TotalFractionalCycles = 68;
       static const FIT_UINT8 FrontGearShiftCount = 69;
       static const FIT_UINT8 RearGearShiftCount = 70;
       static const FIT_UINT8 TimeStanding = 71;
       static const FIT_UINT8 StandCount = 72;
       static const FIT_UINT8 AvgLeftPco = 73;
       static const FIT_UINT8 AvgRightPco = 74;
       static const FIT_UINT8 AvgLeftPowerPhase = 75;
       static const FIT_UINT8 AvgLeftPowerPhasePeak = 76;
       static const FIT_UINT8 AvgRightPowerPhase = 77;
       static const FIT_UINT8 AvgRightPowerPhasePeak = 78;
       static const FIT_UINT8 AvgPowerPosition = 79;
       static const FIT_UINT8 MaxPowerPosition = 80;
       static const FIT_UINT8 AvgCadencePosition = 81;
       static const FIT_UINT8 MaxCadencePosition = 82;
       static const FIT_UINT8 Manufacturer = 83;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    SegmentLapMesg(void) : Mesg(Profile::MESG_SEGMENT_LAP)
    {
    }

    SegmentLapMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of message_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMessageIndexValid() const
    {
        const Field* field = GetField(254);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns message_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetMessageIndex(void) const
    {
        return GetFieldUINT16Value(254, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set message_index field
    ///////////////////////////////////////////////////////////////////////
    void SetMessageIndex(FIT_MESSAGE_INDEX messageIndex)
    {
        SetFieldUINT16Value(254, messageIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timestamp field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimestampValid() const
    {
        const Field* field = GetField(253);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns timestamp field
    // Units: s
    // Comment: Lap end time.
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetTimestamp(void) const
    {
        return GetFieldUINT32Value(253, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timestamp field
    // Units: s
    // Comment: Lap end time.
    ///////////////////////////////////////////////////////////////////////
    void SetTimestamp(FIT_DATE_TIME timestamp)
    {
        SetFieldUINT32Value(253, timestamp, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event field
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT GetEvent(void) const
    {
        return GetFieldENUMValue(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event field
    ///////////////////////////////////////////////////////////////////////
    void SetEvent(FIT_EVENT event)
    {
        SetFieldENUMValue(0, event, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventTypeValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT_TYPE GetEventType(void) const
    {
        return GetFieldENUMValue(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_type field
    ///////////////////////////////////////////////////////////////////////
    void SetEventType(FIT_EVENT_TYPE eventType)
    {
        SetFieldENUMValue(1, eventType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartTimeValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_time field
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetStartTime(void) const
    {
        return GetFieldUINT32Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_time field
    ///////////////////////////////////////////////////////////////////////
    void SetStartTime(FIT_DATE_TIME startTime)
    {
        SetFieldUINT32Value(2, startTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLatValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLat(void) const
    {
        return GetFieldSINT32Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLat(FIT_SINT32 startPositionLat)
    {
        SetFieldSINT32Value(3, startPositionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLongValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLong(void) const
    {
        return GetFieldSINT32Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLong(FIT_SINT32 startPositionLong)
    {
        SetFieldSINT32Value(4, startPositionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of end_position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEndPositionLatValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns end_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetEndPositionLat(void) const
    {
        return GetFieldSINT32Value(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set end_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetEndPositionLat(FIT_SINT32 endPositionLat)
    {
        SetFieldSINT32Value(5, endPositionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of end_position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEndPositionLongValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns end_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetEndPositionLong(void) const
    {
        return GetFieldSINT32Value(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set end_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetEndPositionLong(FIT_SINT32 endPositionLong)
    {
        SetFieldSINT32Value(6, endPositionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_elapsed_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalElapsedTimeValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_elapsed_time field
    // Units: s
    // Comment: Time (includes pauses)
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalElapsedTime(void) const
    {
        return GetFieldFLOAT32Value(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_elapsed_time field
    // Units: s
    // Comment: Time (includes pauses)
    ///////////////////////////////////////////////////////////////////////
    void SetTotalElapsedTime(FIT_FLOAT32 totalElapsedTime)
    {
        SetFieldFLOAT32Value(7, totalElapsedTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_timer_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalTimerTimeValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_timer_time field
    // Units: s
    // Comment: Timer Time (excludes pauses)
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalTimerTime(void) const
    {
        return GetFieldFLOAT32Value(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_timer_time field
    // Units: s
    // Comment: Timer Time (excludes pauses)
    ///////////////////////////////////////////////////////////////////////
    void SetTotalTimerTime(FIT_FLOAT32 totalTimerTime)
    {
        SetFieldFLOAT32Value(8, totalTimerTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDistanceValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalDistance(void) const
    {
        return GetFieldFLOAT32Value(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDistance(FIT_FLOAT32 totalDistance)
    {
        SetFieldFLOAT32Value(9, totalDistance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCyclesValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalCycles(void) const
    {
        return GetFieldUINT32Value(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCycles(FIT_UINT32 totalCycles)
    {
        SetFieldUINT32Value(10, totalCycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_strokes field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalStrokesValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns total_strokes field
    // Units: strokes
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalStrokes(void) const
    {
        return GetFieldUINT32Value(10, 0, (FIT_UINT16) Profile::SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_strokes field
    // Units: strokes
    ///////////////////////////////////////////////////////////////////////
    void SetTotalStrokes(FIT_UINT32 totalStrokes)
    {
        SetFieldUINT32Value(10, totalStrokes, 0, (FIT_UINT16) Profile::SEGMENT_LAP_MESG_TOTAL_CYCLES_FIELD_TOTAL_STROKES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCaloriesValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalCalories(void) const
    {
        return GetFieldUINT16Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCalories(FIT_UINT16 totalCalories)
    {
        SetFieldUINT16Value(11, totalCalories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fat_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFatCaloriesValid() const
    {
        const Field* field = GetField(12);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fat_calories field
    // Units: kcal
    // Comment: If New Leaf
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalFatCalories(void) const
    {
        return GetFieldUINT16Value(12, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fat_calories field
    // Units: kcal
    // Comment: If New Leaf
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFatCalories(FIT_UINT16 totalFatCalories)
    {
        SetFieldUINT16Value(12, totalFatCalories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgSpeedValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgSpeed(void) const
    {
        return GetFieldFLOAT32Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgSpeed(FIT_FLOAT32 avgSpeed)
    {
        SetFieldFLOAT32Value(13, avgSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxSpeedValid() const
    {
        const Field* field = GetField(14);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxSpeed(void) const
    {
        return GetFieldFLOAT32Value(14, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxSpeed(FIT_FLOAT32 maxSpeed)
    {
        SetFieldFLOAT32Value(14, maxSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgHeartRateValid() const
    {
        const Field* field = GetField(15);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgHeartRate(void) const
    {
        return GetFieldUINT8Value(15, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetAvgHeartRate(FIT_UINT8 avgHeartRate)
    {
        SetFieldUINT8Value(15, avgHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxHeartRateValid() const
    {
        const Field* field = GetField(16);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxHeartRate(void) const
    {
        return GetFieldUINT8Value(16, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetMaxHeartRate(FIT_UINT8 maxHeartRate)
    {
        SetFieldUINT8Value(16, maxHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCadenceValid() const
    {
        const Field* field = GetField(17);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_cadence field
    // Units: rpm
    // Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgCadence(void) const
    {
        return GetFieldUINT8Value(17, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_cadence field
    // Units: rpm
    // Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCadence(FIT_UINT8 avgCadence)
    {
        SetFieldUINT8Value(17, avgCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxCadenceValid() const
    {
        const Field* field = GetField(18);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxCadence(void) const
    {
        return GetFieldUINT8Value(18, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetMaxCadence(FIT_UINT8 maxCadence)
    {
        SetFieldUINT8Value(18, maxCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPowerValid() const
    {
        const Field* field = GetField(19);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_power field
    // Units: watts
    // Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgPower(void) const
    {
        return GetFieldUINT16Value(19, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_power field
    // Units: watts
    // Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPower(FIT_UINT16 avgPower)
    {
        SetFieldUINT16Value(19, avgPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPowerValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxPower(void) const
    {
        return GetFieldUINT16Value(20, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPower(FIT_UINT16 maxPower)
    {
        SetFieldUINT16Value(20, maxPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_ascent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalAscentValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalAscent(void) const
    {
        return GetFieldUINT16Value(21, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalAscent(FIT_UINT16 totalAscent)
    {
        SetFieldUINT16Value(21, totalAscent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_descent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDescentValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalDescent(void) const
    {
        return GetFieldUINT16Value(22, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDescent(FIT_UINT16 totalDescent)
    {
        SetFieldUINT16Value(22, totalDescent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sport field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSportValid() const
    {
        const Field* field = GetField(23);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sport field
    ///////////////////////////////////////////////////////////////////////
    FIT_SPORT GetSport(void) const
    {
        return GetFieldENUMValue(23, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sport field
    ///////////////////////////////////////////////////////////////////////
    void SetSport(FIT_SPORT sport)
    {
        SetFieldENUMValue(23, sport, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_group field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventGroupValid() const
    {
        const Field* field = GetField(24);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_group field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetEventGroup(void) const
    {
        return GetFieldUINT8Value(24, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_group field
    ///////////////////////////////////////////////////////////////////////
    void SetEventGroup(FIT_UINT8 eventGroup)
    {
        SetFieldUINT8Value(24, eventGroup, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of nec_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNecLatValid() const
    {
        const Field* field = GetField(25);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns nec_lat field
    // Units: semicircles
    // Comment: North east corner latitude.
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetNecLat(void) const
    {
        return GetFieldSINT32Value(25, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set nec_lat field
    // Units: semicircles
    // Comment: North east corner latitude.
    ///////////////////////////////////////////////////////////////////////
    void SetNecLat(FIT_SINT32 necLat)
    {
        SetFieldSINT32Value(25, necLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of nec_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNecLongValid() const
    {
        const Field* field = GetField(26);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns nec_long field
    // Units: semicircles
    // Comment: North east corner longitude.
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetNecLong(void) const
    {
        return GetFieldSINT32Value(26, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set nec_long field
    // Units: semicircles
    // Comment: North east corner longitude.
    ///////////////////////////////////////////////////////////////////////
    void SetNecLong(FIT_SINT32 necLong)
    {
        SetFieldSINT32Value(26, necLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of swc_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSwcLatValid() const
    {
        const Field* field = GetField(27);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns swc_lat field
    // Units: semicircles
    // Comment: South west corner latitude.
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetSwcLat(void) const
    {
        return GetFieldSINT32Value(27, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set swc_lat field
    // Units: semicircles
    // Comment: South west corner latitude.
    ///////////////////////////////////////////////////////////////////////
    void SetSwcLat(FIT_SINT32 swcLat)
    {
        SetFieldSINT32Value(27, swcLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of swc_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSwcLongValid() const
    {
        const Field* field = GetField(28);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns swc_long field
    // Units: semicircles
    // Comment: South west corner latitude.
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetSwcLong(void) const
    {
        return GetFieldSINT32Value(28, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set swc_long field
    // Units: semicircles
    // Comment: South west corner latitude.
    ///////////////////////////////////////////////////////////////////////
    void SetSwcLong(FIT_SINT32 swcLong)
    {
        SetFieldSINT32Value(28, swcLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of name field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNameValid() const
    {
        const Field* field = GetField(29);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns name field
    ///////////////////////////////////////////////////////////////////////
    FIT_WSTRING GetName(void) const
    {
        return GetFieldSTRINGValue(29, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set name field
    ///////////////////////////////////////////////////////////////////////
    void SetName(FIT_WSTRING name)
    {
        SetFieldSTRINGValue(29, name, 0);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of normalized_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNormalizedPowerValid() const
    {
        const Field* field = GetField(30);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns normalized_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetNormalizedPower(void) const
    {
        return GetFieldUINT16Value(30, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set normalized_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetNormalizedPower(FIT_UINT16 normalizedPower)
    {
        SetFieldUINT16Value(30, normalizedPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_right_balance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftRightBalanceValid() const
    {
        const Field* field = GetField(31);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    FIT_LEFT_RIGHT_BALANCE_100 GetLeftRightBalance(void) const
    {
        return GetFieldUINT16Value(31, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    void SetLeftRightBalance(FIT_LEFT_RIGHT_BALANCE_100 leftRightBalance)
    {
        SetFieldUINT16Value(31, leftRightBalance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sub_sport field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSubSportValid() const
    {
        const Field* field = GetField(32);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sub_sport field
    ///////////////////////////////////////////////////////////////////////
    FIT_SUB_SPORT GetSubSport(void) const
    {
        return GetFieldENUMValue(32, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sub_sport field
    ///////////////////////////////////////////////////////////////////////
    void SetSubSport(FIT_SUB_SPORT subSport)
    {
        SetFieldENUMValue(32, subSport, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_work field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalWorkValid() const
    {
        const Field* field = GetField(33);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_work field
    // Units: J
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalWork(void) const
    {
        return GetFieldUINT32Value(33, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_work field
    // Units: J
    ///////////////////////////////////////////////////////////////////////
    void SetTotalWork(FIT_UINT32 totalWork)
    {
        SetFieldUINT32Value(33, totalWork, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgAltitudeValid() const
    {
        const Field* field = GetField(34);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgAltitude(void) const
    {
        return GetFieldFLOAT32Value(34, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetAvgAltitude(FIT_FLOAT32 avgAltitude)
    {
        SetFieldFLOAT32Value(34, avgAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxAltitudeValid() const
    {
        const Field* field = GetField(35);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxAltitude(void) const
    {
        return GetFieldFLOAT32Value(35, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetMaxAltitude(FIT_FLOAT32 maxAltitude)
    {
        SetFieldFLOAT32Value(35, maxAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gps_accuracy field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGpsAccuracyValid() const
    {
        const Field* field = GetField(36);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetGpsAccuracy(void) const
    {
        return GetFieldUINT8Value(36, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetGpsAccuracy(FIT_UINT8 gpsAccuracy)
    {
        SetFieldUINT8Value(36, gpsAccuracy, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgGradeValid() const
    {
        const Field* field = GetField(37);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgGrade(void) const
    {
        return GetFieldFLOAT32Value(37, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgGrade(FIT_FLOAT32 avgGrade)
    {
        SetFieldFLOAT32Value(37, avgGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_pos_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPosGradeValid() const
    {
        const Field* field = GetField(38);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgPosGrade(void) const
    {
        return GetFieldFLOAT32Value(38, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPosGrade(FIT_FLOAT32 avgPosGrade)
    {
        SetFieldFLOAT32Value(38, avgPosGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_neg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgNegGradeValid() const
    {
        const Field* field = GetField(39);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgNegGrade(void) const
    {
        return GetFieldFLOAT32Value(39, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgNegGrade(FIT_FLOAT32 avgNegGrade)
    {
        SetFieldFLOAT32Value(39, avgNegGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_pos_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPosGradeValid() const
    {
        const Field* field = GetField(40);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxPosGrade(void) const
    {
        return GetFieldFLOAT32Value(40, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPosGrade(FIT_FLOAT32 maxPosGrade)
    {
        SetFieldFLOAT32Value(40, maxPosGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_neg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxNegGradeValid() const
    {
        const Field* field = GetField(41);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxNegGrade(void) const
    {
        return GetFieldFLOAT32Value(41, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetMaxNegGrade(FIT_FLOAT32 maxNegGrade)
    {
        SetFieldFLOAT32Value(41, maxNegGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgTemperatureValid() const
    {
        const Field* field = GetField(42);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgTemperature(void) const
    {
        return GetFieldSINT8Value(42, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetAvgTemperature(FIT_SINT8 avgTemperature)
    {
        SetFieldSINT8Value(42, avgTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxTemperatureValid() const
    {
        const Field* field = GetField(43);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetMaxTemperature(void) const
    {
        return GetFieldSINT8Value(43, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetMaxTemperature(FIT_SINT8 maxTemperature)
    {
        SetFieldSINT8Value(43, maxTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_moving_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalMovingTimeValid() const
    {
        const Field* field = GetField(44);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalMovingTime(void) const
    {
        return GetFieldFLOAT32Value(44, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTotalMovingTime(FIT_FLOAT32 totalMovingTime)
    {
        SetFieldFLOAT32Value(44, totalMovingTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_pos_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPosVerticalSpeedValid() const
    {
        const Field* field = GetField(45);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgPosVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(45, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPosVerticalSpeed(FIT_FLOAT32 avgPosVerticalSpeed)
    {
        SetFieldFLOAT32Value(45, avgPosVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_neg_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgNegVerticalSpeedValid() const
    {
        const Field* field = GetField(46);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgNegVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(46, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgNegVerticalSpeed(FIT_FLOAT32 avgNegVerticalSpeed)
    {
        SetFieldFLOAT32Value(46, avgNegVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_pos_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPosVerticalSpeedValid() const
    {
        const Field* field = GetField(47);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxPosVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(47, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPosVerticalSpeed(FIT_FLOAT32 maxPosVerticalSpeed)
    {
        SetFieldFLOAT32Value(47, maxPosVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_neg_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxNegVerticalSpeedValid() const
    {
        const Field* field = GetField(48);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxNegVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(48, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxNegVerticalSpeed(FIT_FLOAT32 maxNegVerticalSpeed)
    {
        SetFieldFLOAT32Value(48, maxNegVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_hr_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInHrZone(void) const
    {
        return GetFieldNumValues(49, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_hr_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInHrZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(49);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_hr_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInHrZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(49, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_hr_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInHrZone(FIT_UINT8 index, FIT_FLOAT32 timeInHrZone)
    {
        SetFieldFLOAT32Value(49, timeInHrZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_speed_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInSpeedZone(void) const
    {
        return GetFieldNumValues(50, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_speed_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInSpeedZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(50);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_speed_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInSpeedZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(50, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_speed_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInSpeedZone(FIT_UINT8 index, FIT_FLOAT32 timeInSpeedZone)
    {
        SetFieldFLOAT32Value(50, timeInSpeedZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_cadence_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInCadenceZone(void) const
    {
        return GetFieldNumValues(51, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_cadence_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInCadenceZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(51);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_cadence_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInCadenceZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(51, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_cadence_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInCadenceZone(FIT_UINT8 index, FIT_FLOAT32 timeInCadenceZone)
    {
        SetFieldFLOAT32Value(51, timeInCadenceZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_power_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInPowerZone(void) const
    {
        return GetFieldNumValues(52, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_power_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInPowerZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(52);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_power_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInPowerZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(52, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_power_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInPowerZone(FIT_UINT8 index, FIT_FLOAT32 timeInPowerZone)
    {
        SetFieldFLOAT32Value(52, timeInPowerZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of repetition_num field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRepetitionNumValid() const
    {
        const Field* field = GetField(53);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns repetition_num field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetRepetitionNum(void) const
    {
        return GetFieldUINT16Value(53, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set repetition_num field
    ///////////////////////////////////////////////////////////////////////
    void SetRepetitionNum(FIT_UINT16 repetitionNum)
    {
        SetFieldUINT16Value(53, repetitionNum, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinAltitudeValid() const
    {
        const Field* field = GetField(54);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinAltitude(void) const
    {
        return GetFieldFLOAT32Value(54, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetMinAltitude(FIT_FLOAT32 minAltitude)
    {
        SetFieldFLOAT32Value(54, minAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinHeartRateValid() const
    {
        const Field* field = GetField(55);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMinHeartRate(void) const
    {
        return GetFieldUINT8Value(55, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetMinHeartRate(FIT_UINT8 minHeartRate)
    {
        SetFieldUINT8Value(55, minHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of active_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsActiveTimeValid() const
    {
        const Field* field = GetField(56);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns active_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetActiveTime(void) const
    {
        return GetFieldFLOAT32Value(56, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set active_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetActiveTime(FIT_FLOAT32 activeTime)
    {
        SetFieldFLOAT32Value(56, activeTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of wkt_step_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsWktStepIndexValid() const
    {
        const Field* field = GetField(57);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns wkt_step_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetWktStepIndex(void) const
    {
        return GetFieldUINT16Value(57, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set wkt_step_index field
    ///////////////////////////////////////////////////////////////////////
    void SetWktStepIndex(FIT_MESSAGE_INDEX wktStepIndex)
    {
        SetFieldUINT16Value(57, wktStepIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sport_event field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSportEventValid() const
    {
        const Field* field = GetField(58);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sport_event field
    ///////////////////////////////////////////////////////////////////////
    FIT_SPORT_EVENT GetSportEvent(void) const
    {
        return GetFieldENUMValue(58, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sport_event field
    ///////////////////////////////////////////////////////////////////////
    void SetSportEvent(FIT_SPORT_EVENT sportEvent)
    {
        SetFieldENUMValue(58, sportEvent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftTorqueEffectivenessValid() const
    {
        const Field* field = GetField(59);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(59, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftTorqueEffectiveness(FIT_FLOAT32 avgLeftTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(59, avgLeftTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightTorqueEffectivenessValid() const
    {
        const Field* field = GetField(60);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(60, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightTorqueEffectiveness(FIT_FLOAT32 avgRightTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(60, avgRightTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPedalSmoothnessValid() const
    {
        const Field* field = GetField(61);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(61, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPedalSmoothness(FIT_FLOAT32 avgLeftPedalSmoothness)
    {
        SetFieldFLOAT32Value(61, avgLeftPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPedalSmoothnessValid() const
    {
        const Field* field = GetField(62);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(62, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPedalSmoothness(FIT_FLOAT32 avgRightPedalSmoothness)
    {
        SetFieldFLOAT32Value(62, avgRightPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_combined_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCombinedPedalSmoothnessValid() const
    {
        const Field* field = GetField(63);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgCombinedPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(63, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCombinedPedalSmoothness(FIT_FLOAT32 avgCombinedPedalSmoothness)
    {
        SetFieldFLOAT32Value(63, avgCombinedPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of status field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStatusValid() const
    {
        const Field* field = GetField(64);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns status field
    ///////////////////////////////////////////////////////////////////////
    FIT_SEGMENT_LAP_STATUS GetStatus(void) const
    {
        return GetFieldENUMValue(64, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set status field
    ///////////////////////////////////////////////////////////////////////
    void SetStatus(FIT_SEGMENT_LAP_STATUS status)
    {
        SetFieldENUMValue(64, status, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of uuid field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsUuidValid() const
    {
        const Field* field = GetField(65);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns uuid field
    ///////////////////////////////////////////////////////////////////////
    FIT_WSTRING GetUuid(void) const
    {
        return GetFieldSTRINGValue(65, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set uuid field
    ///////////////////////////////////////////////////////////////////////
    void SetUuid(FIT_WSTRING uuid)
    {
        SetFieldSTRINGValue(65, uuid, 0);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_fractional_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgFractionalCadenceValid() const
    {
        const Field* field = GetField(66);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the avg_cadence
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgFractionalCadence(void) const
    {
        return GetFieldFLOAT32Value(66, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the avg_cadence
    ///////////////////////////////////////////////////////////////////////
    void SetAvgFractionalCadence(FIT_FLOAT32 avgFractionalCadence)
    {
        SetFieldFLOAT32Value(66, avgFractionalCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_fractional_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxFractionalCadenceValid() const
    {
        const Field* field = GetField(67);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the max_cadence
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxFractionalCadence(void) const
    {
        return GetFieldFLOAT32Value(67, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the max_cadence
    ///////////////////////////////////////////////////////////////////////
    void SetMaxFractionalCadence(FIT_FLOAT32 maxFractionalCadence)
    {
        SetFieldFLOAT32Value(67, maxFractionalCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fractional_cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFractionalCyclesValid() const
    {
        const Field* field = GetField(68);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fractional_cycles field
    // Units: cycles
    // Comment: fractional part of the total_cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalFractionalCycles(void) const
    {
        return GetFieldFLOAT32Value(68, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fractional_cycles field
    // Units: cycles
    // Comment: fractional part of the total_cycles
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFractionalCycles(FIT_FLOAT32 totalFractionalCycles)
    {
        SetFieldFLOAT32Value(68, totalFractionalCycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of front_gear_shift_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFrontGearShiftCountValid() const
    {
        const Field* field = GetField(69);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns front_gear_shift_count field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetFrontGearShiftCount(void) const
    {
        return GetFieldUINT16Value(69, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set front_gear_shift_count field
    ///////////////////////////////////////////////////////////////////////
    void SetFrontGearShiftCount(FIT_UINT16 frontGearShiftCount)
    {
        SetFieldUINT16Value(69, frontGearShiftCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of rear_gear_shift_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRearGearShiftCountValid() const
    {
        const Field* field = GetField(70);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns rear_gear_shift_count field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetRearGearShiftCount(void) const
    {
        return GetFieldUINT16Value(70, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set rear_gear_shift_count field
    ///////////////////////////////////////////////////////////////////////
    void SetRearGearShiftCount(FIT_UINT16 rearGearShiftCount)
    {
        SetFieldUINT16Value(70, rearGearShiftCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_standing field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeStandingValid() const
    {
        const Field* field = GetField(71);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_standing field
    // Units: s
    // Comment: Total time spent in the standing position
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeStanding(void) const
    {
        return GetFieldFLOAT32Value(71, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_standing field
    // Units: s
    // Comment: Total time spent in the standing position
    ///////////////////////////////////////////////////////////////////////
    void SetTimeStanding(FIT_FLOAT32 timeStanding)
    {
        SetFieldFLOAT32Value(71, timeStanding, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stand_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStandCountValid() const
    {
        const Field* field = GetField(72);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stand_count field
    // Comment: Number of transitions to the standing state
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetStandCount(void) const
    {
        return GetFieldUINT16Value(72, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stand_count field
    // Comment: Number of transitions to the standing state
    ///////////////////////////////////////////////////////////////////////
    void SetStandCount(FIT_UINT16 standCount)
    {
        SetFieldUINT16Value(72, standCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPcoValid() const
    {
        const Field* field = GetField(73);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_pco field
    // Units: mm
    // Comment: Average left platform center offset
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgLeftPco(void) const
    {
        return GetFieldSINT8Value(73, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_pco field
    // Units: mm
    // Comment: Average left platform center offset
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPco(FIT_SINT8 avgLeftPco)
    {
        SetFieldSINT8Value(73, avgLeftPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPcoValid() const
    {
        const Field* field = GetField(74);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_pco field
    // Units: mm
    // Comment: Average right platform center offset
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgRightPco(void) const
    {
        return GetFieldSINT8Value(74, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_pco field
    // Units: mm
    // Comment: Average right platform center offset
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPco(FIT_SINT8 avgRightPco)
    {
        SetFieldSINT8Value(74, avgRightPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_left_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgLeftPowerPhase(void) const
    {
        return GetFieldNumValues(75, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(75);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_power_phase field
    // Units: degrees
    // Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(75, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_power_phase field
    // Units: degrees
    // Comment: Average left power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPowerPhase(FIT_UINT8 index, FIT_FLOAT32 avgLeftPowerPhase)
    {
        SetFieldFLOAT32Value(75, avgLeftPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_left_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgLeftPowerPhasePeak(void) const
    {
        return GetFieldNumValues(76, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(76);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_power_phase_peak field
    // Units: degrees
    // Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(76, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_power_phase_peak field
    // Units: degrees
    // Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 avgLeftPowerPhasePeak)
    {
        SetFieldFLOAT32Value(76, avgLeftPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_right_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgRightPowerPhase(void) const
    {
        return GetFieldNumValues(77, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(77);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_power_phase field
    // Units: degrees
    // Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(77, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_power_phase field
    // Units: degrees
    // Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPowerPhase(FIT_UINT8 index, FIT_FLOAT32 avgRightPowerPhase)
    {
        SetFieldFLOAT32Value(77, avgRightPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_right_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgRightPowerPhasePeak(void) const
    {
        return GetFieldNumValues(78, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(78);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_power_phase_peak field
    // Units: degrees
    // Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(78, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_power_phase_peak field
    // Units: degrees
    // Comment: Average right power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 avgRightPowerPhasePeak)
    {
        SetFieldFLOAT32Value(78, avgRightPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_power_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgPowerPosition(void) const
    {
        return GetFieldNumValues(79, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_power_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPowerPositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(79);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_power_position field
    // Units: watts
    // Comment: Average power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgPowerPosition(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(79, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_power_position field
    // Units: watts
    // Comment: Average power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPowerPosition(FIT_UINT8 index, FIT_UINT16 avgPowerPosition)
    {
        SetFieldUINT16Value(79, avgPowerPosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_power_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxPowerPosition(void) const
    {
        return GetFieldNumValues(80, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_power_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPowerPositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(80);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_power_position field
    // Units: watts
    // Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxPowerPosition(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(80, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_power_position field
    // Units: watts
    // Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPowerPosition(FIT_UINT8 index, FIT_UINT16 maxPowerPosition)
    {
        SetFieldUINT16Value(80, maxPowerPosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_cadence_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgCadencePosition(void) const
    {
        return GetFieldNumValues(81, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_cadence_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCadencePositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(81);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_cadence_position field
    // Units: rpm
    // Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgCadencePosition(FIT_UINT8 index) const
    {
        return GetFieldUINT8Value(81, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_cadence_position field
    // Units: rpm
    // Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCadencePosition(FIT_UINT8 index, FIT_UINT8 avgCadencePosition)
    {
        SetFieldUINT8Value(81, avgCadencePosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_cadence_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxCadencePosition(void) const
    {
        return GetFieldNumValues(82, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_cadence_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxCadencePositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(82);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_cadence_position field
    // Units: rpm
    // Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxCadencePosition(FIT_UINT8 index) const
    {
        return GetFieldUINT8Value(82, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_cadence_position field
    // Units: rpm
    // Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetMaxCadencePosition(FIT_UINT8 index, FIT_UINT8 maxCadencePosition)
    {
        SetFieldUINT8Value(82, maxCadencePosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of manufacturer field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsManufacturerValid() const
    {
        const Field* field = GetField(83);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns manufacturer field
    // Comment: Manufacturer that produced the segment
    ///////////////////////////////////////////////////////////////////////
    FIT_MANUFACTURER GetManufacturer(void) const
    {
        return GetFieldUINT16Value(83, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set manufacturer field
    // Comment: Manufacturer that produced the segment
    ///////////////////////////////////////////////////////////////////////
    void SetManufacturer(FIT_MANUFACTURER manufacturer)
    {
        SetFieldUINT16Value(83, manufacturer, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_SEGMENT_LAP_MESG_HPP)
