////////////////////////////////////////////////////////////////////////////////
// The following FIT Protocol software provided may be used with FIT protocol
// devices only and remains the copyrighted property of Dynastream Innovations Inc.
// The software is being provided on an "as-is" basis and as an accommodation,
// and therefore all warranties, representations, or guarantees of any kind
// (whether express, implied or statutory) including, without limitation,
// warranties of merchantability, non-infringement, or fitness for a particular
// purpose, are specifically disclaimed.
//
// Copyright 2017 Dynastream Innovations Inc.
////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 20.38Release
// Tag = production/akw/20.38.00-0-geccbce3
////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_SESSION_MESG_HPP)
#define FIT_SESSION_MESG_HPP

#include "fit_mesg.hpp"
#include "fit_mesg_with_event.hpp"

namespace fit
{

class SessionMesg : public Mesg, public MesgWithEvent
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 MessageIndex = 254;
       static const FIT_UINT8 Timestamp = 253;
       static const FIT_UINT8 Event = 0;
       static const FIT_UINT8 EventType = 1;
       static const FIT_UINT8 StartTime = 2;
       static const FIT_UINT8 StartPositionLat = 3;
       static const FIT_UINT8 StartPositionLong = 4;
       static const FIT_UINT8 Sport = 5;
       static const FIT_UINT8 SubSport = 6;
       static const FIT_UINT8 TotalElapsedTime = 7;
       static const FIT_UINT8 TotalTimerTime = 8;
       static const FIT_UINT8 TotalDistance = 9;
       static const FIT_UINT8 TotalCycles = 10;
       static const FIT_UINT8 TotalCalories = 11;
       static const FIT_UINT8 TotalFatCalories = 13;
       static const FIT_UINT8 AvgSpeed = 14;
       static const FIT_UINT8 MaxSpeed = 15;
       static const FIT_UINT8 AvgHeartRate = 16;
       static const FIT_UINT8 MaxHeartRate = 17;
       static const FIT_UINT8 AvgCadence = 18;
       static const FIT_UINT8 MaxCadence = 19;
       static const FIT_UINT8 AvgPower = 20;
       static const FIT_UINT8 MaxPower = 21;
       static const FIT_UINT8 TotalAscent = 22;
       static const FIT_UINT8 TotalDescent = 23;
       static const FIT_UINT8 TotalTrainingEffect = 24;
       static const FIT_UINT8 FirstLapIndex = 25;
       static const FIT_UINT8 NumLaps = 26;
       static const FIT_UINT8 EventGroup = 27;
       static const FIT_UINT8 Trigger = 28;
       static const FIT_UINT8 NecLat = 29;
       static const FIT_UINT8 NecLong = 30;
       static const FIT_UINT8 SwcLat = 31;
       static const FIT_UINT8 SwcLong = 32;
       static const FIT_UINT8 NormalizedPower = 34;
       static const FIT_UINT8 TrainingStressScore = 35;
       static const FIT_UINT8 IntensityFactor = 36;
       static const FIT_UINT8 LeftRightBalance = 37;
       static const FIT_UINT8 AvgStrokeCount = 41;
       static const FIT_UINT8 AvgStrokeDistance = 42;
       static const FIT_UINT8 SwimStroke = 43;
       static const FIT_UINT8 PoolLength = 44;
       static const FIT_UINT8 ThresholdPower = 45;
       static const FIT_UINT8 PoolLengthUnit = 46;
       static const FIT_UINT8 NumActiveLengths = 47;
       static const FIT_UINT8 TotalWork = 48;
       static const FIT_UINT8 AvgAltitude = 49;
       static const FIT_UINT8 MaxAltitude = 50;
       static const FIT_UINT8 GpsAccuracy = 51;
       static const FIT_UINT8 AvgGrade = 52;
       static const FIT_UINT8 AvgPosGrade = 53;
       static const FIT_UINT8 AvgNegGrade = 54;
       static const FIT_UINT8 MaxPosGrade = 55;
       static const FIT_UINT8 MaxNegGrade = 56;
       static const FIT_UINT8 AvgTemperature = 57;
       static const FIT_UINT8 MaxTemperature = 58;
       static const FIT_UINT8 TotalMovingTime = 59;
       static const FIT_UINT8 AvgPosVerticalSpeed = 60;
       static const FIT_UINT8 AvgNegVerticalSpeed = 61;
       static const FIT_UINT8 MaxPosVerticalSpeed = 62;
       static const FIT_UINT8 MaxNegVerticalSpeed = 63;
       static const FIT_UINT8 MinHeartRate = 64;
       static const FIT_UINT8 TimeInHrZone = 65;
       static const FIT_UINT8 TimeInSpeedZone = 66;
       static const FIT_UINT8 TimeInCadenceZone = 67;
       static const FIT_UINT8 TimeInPowerZone = 68;
       static const FIT_UINT8 AvgLapTime = 69;
       static const FIT_UINT8 BestLapIndex = 70;
       static const FIT_UINT8 MinAltitude = 71;
       static const FIT_UINT8 PlayerScore = 82;
       static const FIT_UINT8 OpponentScore = 83;
       static const FIT_UINT8 OpponentName = 84;
       static const FIT_UINT8 StrokeCount = 85;
       static const FIT_UINT8 ZoneCount = 86;
       static const FIT_UINT8 MaxBallSpeed = 87;
       static const FIT_UINT8 AvgBallSpeed = 88;
       static const FIT_UINT8 AvgVerticalOscillation = 89;
       static const FIT_UINT8 AvgStanceTimePercent = 90;
       static const FIT_UINT8 AvgStanceTime = 91;
       static const FIT_UINT8 AvgFractionalCadence = 92;
       static const FIT_UINT8 MaxFractionalCadence = 93;
       static const FIT_UINT8 TotalFractionalCycles = 94;
       static const FIT_UINT8 AvgTotalHemoglobinConc = 95;
       static const FIT_UINT8 MinTotalHemoglobinConc = 96;
       static const FIT_UINT8 MaxTotalHemoglobinConc = 97;
       static const FIT_UINT8 AvgSaturatedHemoglobinPercent = 98;
       static const FIT_UINT8 MinSaturatedHemoglobinPercent = 99;
       static const FIT_UINT8 MaxSaturatedHemoglobinPercent = 100;
       static const FIT_UINT8 AvgLeftTorqueEffectiveness = 101;
       static const FIT_UINT8 AvgRightTorqueEffectiveness = 102;
       static const FIT_UINT8 AvgLeftPedalSmoothness = 103;
       static const FIT_UINT8 AvgRightPedalSmoothness = 104;
       static const FIT_UINT8 AvgCombinedPedalSmoothness = 105;
       static const FIT_UINT8 SportIndex = 111;
       static const FIT_UINT8 TimeStanding = 112;
       static const FIT_UINT8 StandCount = 113;
       static const FIT_UINT8 AvgLeftPco = 114;
       static const FIT_UINT8 AvgRightPco = 115;
       static const FIT_UINT8 AvgLeftPowerPhase = 116;
       static const FIT_UINT8 AvgLeftPowerPhasePeak = 117;
       static const FIT_UINT8 AvgRightPowerPhase = 118;
       static const FIT_UINT8 AvgRightPowerPhasePeak = 119;
       static const FIT_UINT8 AvgPowerPosition = 120;
       static const FIT_UINT8 MaxPowerPosition = 121;
       static const FIT_UINT8 AvgCadencePosition = 122;
       static const FIT_UINT8 MaxCadencePosition = 123;
       static const FIT_UINT8 EnhancedAvgSpeed = 124;
       static const FIT_UINT8 EnhancedMaxSpeed = 125;
       static const FIT_UINT8 EnhancedAvgAltitude = 126;
       static const FIT_UINT8 EnhancedMinAltitude = 127;
       static const FIT_UINT8 EnhancedMaxAltitude = 128;
       static const FIT_UINT8 AvgLevMotorPower = 129;
       static const FIT_UINT8 MaxLevMotorPower = 130;
       static const FIT_UINT8 LevBatteryConsumption = 131;
       static const FIT_UINT8 AvgVerticalRatio = 132;
       static const FIT_UINT8 AvgStanceTimeBalance = 133;
       static const FIT_UINT8 AvgStepLength = 134;
       static const FIT_UINT8 TotalAnaerobicTrainingEffect = 137;
       static const FIT_UINT8 AvgVam = 139;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    SessionMesg(void) : Mesg(Profile::MESG_SESSION)
    {
    }

    SessionMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of message_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMessageIndexValid() const
    {
        const Field* field = GetField(254);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns message_index field
    // Comment: Selected bit is set for the current session.
    ///////////////////////////////////////////////////////////////////////
    FIT_MESSAGE_INDEX GetMessageIndex(void) const
    {
        return GetFieldUINT16Value(254, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set message_index field
    // Comment: Selected bit is set for the current session.
    ///////////////////////////////////////////////////////////////////////
    void SetMessageIndex(FIT_MESSAGE_INDEX messageIndex)
    {
        SetFieldUINT16Value(254, messageIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timestamp field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimestampValid() const
    {
        const Field* field = GetField(253);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns timestamp field
    // Units: s
    // Comment: Sesson end time.
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetTimestamp(void) const
    {
        return GetFieldUINT32Value(253, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timestamp field
    // Units: s
    // Comment: Sesson end time.
    ///////////////////////////////////////////////////////////////////////
    void SetTimestamp(FIT_DATE_TIME timestamp)
    {
        SetFieldUINT32Value(253, timestamp, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event field
    // Comment: session
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT GetEvent(void) const
    {
        return GetFieldENUMValue(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event field
    // Comment: session
    ///////////////////////////////////////////////////////////////////////
    void SetEvent(FIT_EVENT event)
    {
        SetFieldENUMValue(0, event, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventTypeValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_type field
    // Comment: stop
    ///////////////////////////////////////////////////////////////////////
    FIT_EVENT_TYPE GetEventType(void) const
    {
        return GetFieldENUMValue(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_type field
    // Comment: stop
    ///////////////////////////////////////////////////////////////////////
    void SetEventType(FIT_EVENT_TYPE eventType)
    {
        SetFieldENUMValue(1, eventType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartTimeValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_time field
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetStartTime(void) const
    {
        return GetFieldUINT32Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_time field
    ///////////////////////////////////////////////////////////////////////
    void SetStartTime(FIT_DATE_TIME startTime)
    {
        SetFieldUINT32Value(2, startTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLatValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLat(void) const
    {
        return GetFieldSINT32Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLat(FIT_SINT32 startPositionLat)
    {
        SetFieldSINT32Value(3, startPositionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of start_position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStartPositionLongValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetStartPositionLong(void) const
    {
        return GetFieldSINT32Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set start_position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetStartPositionLong(FIT_SINT32 startPositionLong)
    {
        SetFieldSINT32Value(4, startPositionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sport field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSportValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sport field
    ///////////////////////////////////////////////////////////////////////
    FIT_SPORT GetSport(void) const
    {
        return GetFieldENUMValue(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sport field
    ///////////////////////////////////////////////////////////////////////
    void SetSport(FIT_SPORT sport)
    {
        SetFieldENUMValue(5, sport, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sub_sport field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSubSportValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sub_sport field
    ///////////////////////////////////////////////////////////////////////
    FIT_SUB_SPORT GetSubSport(void) const
    {
        return GetFieldENUMValue(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sub_sport field
    ///////////////////////////////////////////////////////////////////////
    void SetSubSport(FIT_SUB_SPORT subSport)
    {
        SetFieldENUMValue(6, subSport, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_elapsed_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalElapsedTimeValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_elapsed_time field
    // Units: s
    // Comment: Time (includes pauses)
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalElapsedTime(void) const
    {
        return GetFieldFLOAT32Value(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_elapsed_time field
    // Units: s
    // Comment: Time (includes pauses)
    ///////////////////////////////////////////////////////////////////////
    void SetTotalElapsedTime(FIT_FLOAT32 totalElapsedTime)
    {
        SetFieldFLOAT32Value(7, totalElapsedTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_timer_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalTimerTimeValid() const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_timer_time field
    // Units: s
    // Comment: Timer Time (excludes pauses)
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalTimerTime(void) const
    {
        return GetFieldFLOAT32Value(8, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_timer_time field
    // Units: s
    // Comment: Timer Time (excludes pauses)
    ///////////////////////////////////////////////////////////////////////
    void SetTotalTimerTime(FIT_FLOAT32 totalTimerTime)
    {
        SetFieldFLOAT32Value(8, totalTimerTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDistanceValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalDistance(void) const
    {
        return GetFieldFLOAT32Value(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDistance(FIT_FLOAT32 totalDistance)
    {
        SetFieldFLOAT32Value(9, totalDistance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCyclesValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalCycles(void) const
    {
        return GetFieldUINT32Value(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCycles(FIT_UINT32 totalCycles)
    {
        SetFieldUINT32Value(10, totalCycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_strides field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalStridesValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns total_strides field
    // Units: strides
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalStrides(void) const
    {
        return GetFieldUINT32Value(10, 0, (FIT_UINT16) Profile::SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_strides field
    // Units: strides
    ///////////////////////////////////////////////////////////////////////
    void SetTotalStrides(FIT_UINT32 totalStrides)
    {
        SetFieldUINT32Value(10, totalStrides, 0, (FIT_UINT16) Profile::SESSION_MESG_TOTAL_CYCLES_FIELD_TOTAL_STRIDES);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCaloriesValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalCalories(void) const
    {
        return GetFieldUINT16Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCalories(FIT_UINT16 totalCalories)
    {
        SetFieldUINT16Value(11, totalCalories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fat_calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFatCaloriesValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fat_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalFatCalories(void) const
    {
        return GetFieldUINT16Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fat_calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFatCalories(FIT_UINT16 totalFatCalories)
    {
        SetFieldUINT16Value(13, totalFatCalories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgSpeedValid() const
    {
        const Field* field = GetField(14);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_speed field
    // Units: m/s
    // Comment: total_distance / total_timer_time
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgSpeed(void) const
    {
        return GetFieldFLOAT32Value(14, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_speed field
    // Units: m/s
    // Comment: total_distance / total_timer_time
    ///////////////////////////////////////////////////////////////////////
    void SetAvgSpeed(FIT_FLOAT32 avgSpeed)
    {
        SetFieldFLOAT32Value(14, avgSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxSpeedValid() const
    {
        const Field* field = GetField(15);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxSpeed(void) const
    {
        return GetFieldFLOAT32Value(15, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxSpeed(FIT_FLOAT32 maxSpeed)
    {
        SetFieldFLOAT32Value(15, maxSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgHeartRateValid() const
    {
        const Field* field = GetField(16);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_heart_rate field
    // Units: bpm
    // Comment: average heart rate (excludes pause time)
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgHeartRate(void) const
    {
        return GetFieldUINT8Value(16, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_heart_rate field
    // Units: bpm
    // Comment: average heart rate (excludes pause time)
    ///////////////////////////////////////////////////////////////////////
    void SetAvgHeartRate(FIT_UINT8 avgHeartRate)
    {
        SetFieldUINT8Value(16, avgHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxHeartRateValid() const
    {
        const Field* field = GetField(17);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxHeartRate(void) const
    {
        return GetFieldUINT8Value(17, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetMaxHeartRate(FIT_UINT8 maxHeartRate)
    {
        SetFieldUINT8Value(17, maxHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCadenceValid() const
    {
        const Field* field = GetField(18);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_cadence field
    // Units: rpm
    // Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgCadence(void) const
    {
        return GetFieldUINT8Value(18, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_cadence field
    // Units: rpm
    // Comment: total_cycles / total_timer_time if non_zero_avg_cadence otherwise total_cycles / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCadence(FIT_UINT8 avgCadence)
    {
        SetFieldUINT8Value(18, avgCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_running_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRunningCadenceValid() const
    {
        const Field* field = GetField(18);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns avg_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgRunningCadence(void) const
    {
        return GetFieldUINT8Value(18, 0, (FIT_UINT16) Profile::SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRunningCadence(FIT_UINT8 avgRunningCadence)
    {
        SetFieldUINT8Value(18, avgRunningCadence, 0, (FIT_UINT16) Profile::SESSION_MESG_AVG_CADENCE_FIELD_AVG_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxCadenceValid() const
    {
        const Field* field = GetField(19);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxCadence(void) const
    {
        return GetFieldUINT8Value(19, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetMaxCadence(FIT_UINT8 maxCadence)
    {
        SetFieldUINT8Value(19, maxCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_running_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxRunningCadenceValid() const
    {
        const Field* field = GetField(19);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        if( !CanSupportSubField( field, (FIT_UINT16) Profile::SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE ) )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(0, (FIT_UINT16) Profile::SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
    }


    ///////////////////////////////////////////////////////////////////////
    // Returns max_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxRunningCadence(void) const
    {
        return GetFieldUINT8Value(19, 0, (FIT_UINT16) Profile::SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_running_cadence field
    // Units: strides/min
    ///////////////////////////////////////////////////////////////////////
    void SetMaxRunningCadence(FIT_UINT8 maxRunningCadence)
    {
        SetFieldUINT8Value(19, maxRunningCadence, 0, (FIT_UINT16) Profile::SESSION_MESG_MAX_CADENCE_FIELD_MAX_RUNNING_CADENCE);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPowerValid() const
    {
        const Field* field = GetField(20);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_power field
    // Units: watts
    // Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgPower(void) const
    {
        return GetFieldUINT16Value(20, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_power field
    // Units: watts
    // Comment: total_power / total_timer_time if non_zero_avg_power otherwise total_power / total_elapsed_time
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPower(FIT_UINT16 avgPower)
    {
        SetFieldUINT16Value(20, avgPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPowerValid() const
    {
        const Field* field = GetField(21);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxPower(void) const
    {
        return GetFieldUINT16Value(21, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPower(FIT_UINT16 maxPower)
    {
        SetFieldUINT16Value(21, maxPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_ascent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalAscentValid() const
    {
        const Field* field = GetField(22);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalAscent(void) const
    {
        return GetFieldUINT16Value(22, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_ascent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalAscent(FIT_UINT16 totalAscent)
    {
        SetFieldUINT16Value(22, totalAscent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_descent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalDescentValid() const
    {
        const Field* field = GetField(23);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetTotalDescent(void) const
    {
        return GetFieldUINT16Value(23, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_descent field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetTotalDescent(FIT_UINT16 totalDescent)
    {
        SetFieldUINT16Value(23, totalDescent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_training_effect field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalTrainingEffectValid() const
    {
        const Field* field = GetField(24);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_training_effect field
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalTrainingEffect(void) const
    {
        return GetFieldFLOAT32Value(24, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_training_effect field
    ///////////////////////////////////////////////////////////////////////
    void SetTotalTrainingEffect(FIT_FLOAT32 totalTrainingEffect)
    {
        SetFieldFLOAT32Value(24, totalTrainingEffect, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of first_lap_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFirstLapIndexValid() const
    {
        const Field* field = GetField(25);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns first_lap_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetFirstLapIndex(void) const
    {
        return GetFieldUINT16Value(25, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set first_lap_index field
    ///////////////////////////////////////////////////////////////////////
    void SetFirstLapIndex(FIT_UINT16 firstLapIndex)
    {
        SetFieldUINT16Value(25, firstLapIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of num_laps field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNumLapsValid() const
    {
        const Field* field = GetField(26);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns num_laps field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetNumLaps(void) const
    {
        return GetFieldUINT16Value(26, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set num_laps field
    ///////////////////////////////////////////////////////////////////////
    void SetNumLaps(FIT_UINT16 numLaps)
    {
        SetFieldUINT16Value(26, numLaps, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of event_group field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEventGroupValid() const
    {
        const Field* field = GetField(27);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns event_group field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetEventGroup(void) const
    {
        return GetFieldUINT8Value(27, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set event_group field
    ///////////////////////////////////////////////////////////////////////
    void SetEventGroup(FIT_UINT8 eventGroup)
    {
        SetFieldUINT8Value(27, eventGroup, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of trigger field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTriggerValid() const
    {
        const Field* field = GetField(28);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns trigger field
    ///////////////////////////////////////////////////////////////////////
    FIT_SESSION_TRIGGER GetTrigger(void) const
    {
        return GetFieldENUMValue(28, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set trigger field
    ///////////////////////////////////////////////////////////////////////
    void SetTrigger(FIT_SESSION_TRIGGER trigger)
    {
        SetFieldENUMValue(28, trigger, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of nec_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNecLatValid() const
    {
        const Field* field = GetField(29);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns nec_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetNecLat(void) const
    {
        return GetFieldSINT32Value(29, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set nec_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetNecLat(FIT_SINT32 necLat)
    {
        SetFieldSINT32Value(29, necLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of nec_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNecLongValid() const
    {
        const Field* field = GetField(30);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns nec_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetNecLong(void) const
    {
        return GetFieldSINT32Value(30, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set nec_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetNecLong(FIT_SINT32 necLong)
    {
        SetFieldSINT32Value(30, necLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of swc_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSwcLatValid() const
    {
        const Field* field = GetField(31);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns swc_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetSwcLat(void) const
    {
        return GetFieldSINT32Value(31, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set swc_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetSwcLat(FIT_SINT32 swcLat)
    {
        SetFieldSINT32Value(31, swcLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of swc_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSwcLongValid() const
    {
        const Field* field = GetField(32);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns swc_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetSwcLong(void) const
    {
        return GetFieldSINT32Value(32, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set swc_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetSwcLong(FIT_SINT32 swcLong)
    {
        SetFieldSINT32Value(32, swcLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of normalized_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNormalizedPowerValid() const
    {
        const Field* field = GetField(34);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns normalized_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetNormalizedPower(void) const
    {
        return GetFieldUINT16Value(34, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set normalized_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetNormalizedPower(FIT_UINT16 normalizedPower)
    {
        SetFieldUINT16Value(34, normalizedPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of training_stress_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTrainingStressScoreValid() const
    {
        const Field* field = GetField(35);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns training_stress_score field
    // Units: tss
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTrainingStressScore(void) const
    {
        return GetFieldFLOAT32Value(35, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set training_stress_score field
    // Units: tss
    ///////////////////////////////////////////////////////////////////////
    void SetTrainingStressScore(FIT_FLOAT32 trainingStressScore)
    {
        SetFieldFLOAT32Value(35, trainingStressScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of intensity_factor field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsIntensityFactorValid() const
    {
        const Field* field = GetField(36);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns intensity_factor field
    // Units: if
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetIntensityFactor(void) const
    {
        return GetFieldFLOAT32Value(36, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set intensity_factor field
    // Units: if
    ///////////////////////////////////////////////////////////////////////
    void SetIntensityFactor(FIT_FLOAT32 intensityFactor)
    {
        SetFieldFLOAT32Value(36, intensityFactor, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_right_balance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftRightBalanceValid() const
    {
        const Field* field = GetField(37);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    FIT_LEFT_RIGHT_BALANCE_100 GetLeftRightBalance(void) const
    {
        return GetFieldUINT16Value(37, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    void SetLeftRightBalance(FIT_LEFT_RIGHT_BALANCE_100 leftRightBalance)
    {
        SetFieldUINT16Value(37, leftRightBalance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stroke_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStrokeCountValid() const
    {
        const Field* field = GetField(41);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stroke_count field
    // Units: strokes/lap
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStrokeCount(void) const
    {
        return GetFieldFLOAT32Value(41, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stroke_count field
    // Units: strokes/lap
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStrokeCount(FIT_FLOAT32 avgStrokeCount)
    {
        SetFieldFLOAT32Value(41, avgStrokeCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stroke_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStrokeDistanceValid() const
    {
        const Field* field = GetField(42);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stroke_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStrokeDistance(void) const
    {
        return GetFieldFLOAT32Value(42, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stroke_distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStrokeDistance(FIT_FLOAT32 avgStrokeDistance)
    {
        SetFieldFLOAT32Value(42, avgStrokeDistance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of swim_stroke field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSwimStrokeValid() const
    {
        const Field* field = GetField(43);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns swim_stroke field
    // Units: swim_stroke
    ///////////////////////////////////////////////////////////////////////
    FIT_SWIM_STROKE GetSwimStroke(void) const
    {
        return GetFieldENUMValue(43, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set swim_stroke field
    // Units: swim_stroke
    ///////////////////////////////////////////////////////////////////////
    void SetSwimStroke(FIT_SWIM_STROKE swimStroke)
    {
        SetFieldENUMValue(43, swimStroke, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of pool_length field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPoolLengthValid() const
    {
        const Field* field = GetField(44);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns pool_length field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetPoolLength(void) const
    {
        return GetFieldFLOAT32Value(44, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set pool_length field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetPoolLength(FIT_FLOAT32 poolLength)
    {
        SetFieldFLOAT32Value(44, poolLength, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of threshold_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsThresholdPowerValid() const
    {
        const Field* field = GetField(45);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns threshold_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetThresholdPower(void) const
    {
        return GetFieldUINT16Value(45, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set threshold_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetThresholdPower(FIT_UINT16 thresholdPower)
    {
        SetFieldUINT16Value(45, thresholdPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of pool_length_unit field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPoolLengthUnitValid() const
    {
        const Field* field = GetField(46);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns pool_length_unit field
    ///////////////////////////////////////////////////////////////////////
    FIT_DISPLAY_MEASURE GetPoolLengthUnit(void) const
    {
        return GetFieldENUMValue(46, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set pool_length_unit field
    ///////////////////////////////////////////////////////////////////////
    void SetPoolLengthUnit(FIT_DISPLAY_MEASURE poolLengthUnit)
    {
        SetFieldENUMValue(46, poolLengthUnit, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of num_active_lengths field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNumActiveLengthsValid() const
    {
        const Field* field = GetField(47);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns num_active_lengths field
    // Units: lengths
    // Comment: # of active lengths of swim pool
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetNumActiveLengths(void) const
    {
        return GetFieldUINT16Value(47, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set num_active_lengths field
    // Units: lengths
    // Comment: # of active lengths of swim pool
    ///////////////////////////////////////////////////////////////////////
    void SetNumActiveLengths(FIT_UINT16 numActiveLengths)
    {
        SetFieldUINT16Value(47, numActiveLengths, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_work field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalWorkValid() const
    {
        const Field* field = GetField(48);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_work field
    // Units: J
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalWork(void) const
    {
        return GetFieldUINT32Value(48, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_work field
    // Units: J
    ///////////////////////////////////////////////////////////////////////
    void SetTotalWork(FIT_UINT32 totalWork)
    {
        SetFieldUINT32Value(48, totalWork, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgAltitudeValid() const
    {
        const Field* field = GetField(49);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgAltitude(void) const
    {
        return GetFieldFLOAT32Value(49, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetAvgAltitude(FIT_FLOAT32 avgAltitude)
    {
        SetFieldFLOAT32Value(49, avgAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxAltitudeValid() const
    {
        const Field* field = GetField(50);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxAltitude(void) const
    {
        return GetFieldFLOAT32Value(50, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetMaxAltitude(FIT_FLOAT32 maxAltitude)
    {
        SetFieldFLOAT32Value(50, maxAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gps_accuracy field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGpsAccuracyValid() const
    {
        const Field* field = GetField(51);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetGpsAccuracy(void) const
    {
        return GetFieldUINT8Value(51, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetGpsAccuracy(FIT_UINT8 gpsAccuracy)
    {
        SetFieldUINT8Value(51, gpsAccuracy, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgGradeValid() const
    {
        const Field* field = GetField(52);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgGrade(void) const
    {
        return GetFieldFLOAT32Value(52, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgGrade(FIT_FLOAT32 avgGrade)
    {
        SetFieldFLOAT32Value(52, avgGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_pos_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPosGradeValid() const
    {
        const Field* field = GetField(53);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgPosGrade(void) const
    {
        return GetFieldFLOAT32Value(53, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPosGrade(FIT_FLOAT32 avgPosGrade)
    {
        SetFieldFLOAT32Value(53, avgPosGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_neg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgNegGradeValid() const
    {
        const Field* field = GetField(54);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgNegGrade(void) const
    {
        return GetFieldFLOAT32Value(54, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetAvgNegGrade(FIT_FLOAT32 avgNegGrade)
    {
        SetFieldFLOAT32Value(54, avgNegGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_pos_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPosGradeValid() const
    {
        const Field* field = GetField(55);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxPosGrade(void) const
    {
        return GetFieldFLOAT32Value(55, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_pos_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPosGrade(FIT_FLOAT32 maxPosGrade)
    {
        SetFieldFLOAT32Value(55, maxPosGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_neg_grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxNegGradeValid() const
    {
        const Field* field = GetField(56);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxNegGrade(void) const
    {
        return GetFieldFLOAT32Value(56, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_neg_grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetMaxNegGrade(FIT_FLOAT32 maxNegGrade)
    {
        SetFieldFLOAT32Value(56, maxNegGrade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgTemperatureValid() const
    {
        const Field* field = GetField(57);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgTemperature(void) const
    {
        return GetFieldSINT8Value(57, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetAvgTemperature(FIT_SINT8 avgTemperature)
    {
        SetFieldSINT8Value(57, avgTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxTemperatureValid() const
    {
        const Field* field = GetField(58);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetMaxTemperature(void) const
    {
        return GetFieldSINT8Value(58, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetMaxTemperature(FIT_SINT8 maxTemperature)
    {
        SetFieldSINT8Value(58, maxTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_moving_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalMovingTimeValid() const
    {
        const Field* field = GetField(59);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalMovingTime(void) const
    {
        return GetFieldFLOAT32Value(59, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_moving_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTotalMovingTime(FIT_FLOAT32 totalMovingTime)
    {
        SetFieldFLOAT32Value(59, totalMovingTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_pos_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPosVerticalSpeedValid() const
    {
        const Field* field = GetField(60);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgPosVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(60, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPosVerticalSpeed(FIT_FLOAT32 avgPosVerticalSpeed)
    {
        SetFieldFLOAT32Value(60, avgPosVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_neg_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgNegVerticalSpeedValid() const
    {
        const Field* field = GetField(61);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgNegVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(61, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgNegVerticalSpeed(FIT_FLOAT32 avgNegVerticalSpeed)
    {
        SetFieldFLOAT32Value(61, avgNegVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_pos_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPosVerticalSpeedValid() const
    {
        const Field* field = GetField(62);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxPosVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(62, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_pos_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPosVerticalSpeed(FIT_FLOAT32 maxPosVerticalSpeed)
    {
        SetFieldFLOAT32Value(62, maxPosVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_neg_vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxNegVerticalSpeedValid() const
    {
        const Field* field = GetField(63);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxNegVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(63, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_neg_vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxNegVerticalSpeed(FIT_FLOAT32 maxNegVerticalSpeed)
    {
        SetFieldFLOAT32Value(63, maxNegVerticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinHeartRateValid() const
    {
        const Field* field = GetField(64);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMinHeartRate(void) const
    {
        return GetFieldUINT8Value(64, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetMinHeartRate(FIT_UINT8 minHeartRate)
    {
        SetFieldUINT8Value(64, minHeartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_hr_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInHrZone(void) const
    {
        return GetFieldNumValues(65, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_hr_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInHrZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(65);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_hr_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInHrZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(65, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_hr_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInHrZone(FIT_UINT8 index, FIT_FLOAT32 timeInHrZone)
    {
        SetFieldFLOAT32Value(65, timeInHrZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_speed_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInSpeedZone(void) const
    {
        return GetFieldNumValues(66, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_speed_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInSpeedZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(66);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_speed_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInSpeedZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(66, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_speed_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInSpeedZone(FIT_UINT8 index, FIT_FLOAT32 timeInSpeedZone)
    {
        SetFieldFLOAT32Value(66, timeInSpeedZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_cadence_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInCadenceZone(void) const
    {
        return GetFieldNumValues(67, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_cadence_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInCadenceZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(67);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_cadence_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInCadenceZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(67, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_cadence_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInCadenceZone(FIT_UINT8 index, FIT_FLOAT32 timeInCadenceZone)
    {
        SetFieldFLOAT32Value(67, timeInCadenceZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of time_in_power_zone
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumTimeInPowerZone(void) const
    {
        return GetFieldNumValues(68, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_in_power_zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeInPowerZoneValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(68);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_in_power_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeInPowerZone(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(68, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_in_power_zone field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeInPowerZone(FIT_UINT8 index, FIT_FLOAT32 timeInPowerZone)
    {
        SetFieldFLOAT32Value(68, timeInPowerZone, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_lap_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLapTimeValid() const
    {
        const Field* field = GetField(69);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_lap_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLapTime(void) const
    {
        return GetFieldFLOAT32Value(69, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_lap_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLapTime(FIT_FLOAT32 avgLapTime)
    {
        SetFieldFLOAT32Value(69, avgLapTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of best_lap_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBestLapIndexValid() const
    {
        const Field* field = GetField(70);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns best_lap_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetBestLapIndex(void) const
    {
        return GetFieldUINT16Value(70, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set best_lap_index field
    ///////////////////////////////////////////////////////////////////////
    void SetBestLapIndex(FIT_UINT16 bestLapIndex)
    {
        SetFieldUINT16Value(70, bestLapIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinAltitudeValid() const
    {
        const Field* field = GetField(71);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinAltitude(void) const
    {
        return GetFieldFLOAT32Value(71, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetMinAltitude(FIT_FLOAT32 minAltitude)
    {
        SetFieldFLOAT32Value(71, minAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of player_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPlayerScoreValid() const
    {
        const Field* field = GetField(82);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns player_score field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetPlayerScore(void) const
    {
        return GetFieldUINT16Value(82, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set player_score field
    ///////////////////////////////////////////////////////////////////////
    void SetPlayerScore(FIT_UINT16 playerScore)
    {
        SetFieldUINT16Value(82, playerScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of opponent_score field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsOpponentScoreValid() const
    {
        const Field* field = GetField(83);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns opponent_score field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetOpponentScore(void) const
    {
        return GetFieldUINT16Value(83, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set opponent_score field
    ///////////////////////////////////////////////////////////////////////
    void SetOpponentScore(FIT_UINT16 opponentScore)
    {
        SetFieldUINT16Value(83, opponentScore, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of opponent_name field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsOpponentNameValid() const
    {
        const Field* field = GetField(84);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns opponent_name field
    ///////////////////////////////////////////////////////////////////////
    FIT_WSTRING GetOpponentName(void) const
    {
        return GetFieldSTRINGValue(84, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set opponent_name field
    ///////////////////////////////////////////////////////////////////////
    void SetOpponentName(FIT_WSTRING opponentName)
    {
        SetFieldSTRINGValue(84, opponentName, 0);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of stroke_count
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumStrokeCount(void) const
    {
        return GetFieldNumValues(85, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stroke_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStrokeCountValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(85);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stroke_count field
    // Units: counts
    // Comment: stroke_type enum used as the index
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetStrokeCount(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(85, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stroke_count field
    // Units: counts
    // Comment: stroke_type enum used as the index
    ///////////////////////////////////////////////////////////////////////
    void SetStrokeCount(FIT_UINT8 index, FIT_UINT16 strokeCount)
    {
        SetFieldUINT16Value(85, strokeCount, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of zone_count
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumZoneCount(void) const
    {
        return GetFieldNumValues(86, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of zone_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsZoneCountValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(86);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns zone_count field
    // Units: counts
    // Comment: zone number used as the index
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetZoneCount(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(86, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set zone_count field
    // Units: counts
    // Comment: zone number used as the index
    ///////////////////////////////////////////////////////////////////////
    void SetZoneCount(FIT_UINT8 index, FIT_UINT16 zoneCount)
    {
        SetFieldUINT16Value(86, zoneCount, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_ball_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxBallSpeedValid() const
    {
        const Field* field = GetField(87);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_ball_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxBallSpeed(void) const
    {
        return GetFieldFLOAT32Value(87, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_ball_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetMaxBallSpeed(FIT_FLOAT32 maxBallSpeed)
    {
        SetFieldFLOAT32Value(87, maxBallSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_ball_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgBallSpeedValid() const
    {
        const Field* field = GetField(88);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_ball_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgBallSpeed(void) const
    {
        return GetFieldFLOAT32Value(88, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_ball_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgBallSpeed(FIT_FLOAT32 avgBallSpeed)
    {
        SetFieldFLOAT32Value(88, avgBallSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_vertical_oscillation field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgVerticalOscillationValid() const
    {
        const Field* field = GetField(89);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_vertical_oscillation field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgVerticalOscillation(void) const
    {
        return GetFieldFLOAT32Value(89, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_vertical_oscillation field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    void SetAvgVerticalOscillation(FIT_FLOAT32 avgVerticalOscillation)
    {
        SetFieldFLOAT32Value(89, avgVerticalOscillation, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stance_time_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStanceTimePercentValid() const
    {
        const Field* field = GetField(90);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stance_time_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStanceTimePercent(void) const
    {
        return GetFieldFLOAT32Value(90, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stance_time_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStanceTimePercent(FIT_FLOAT32 avgStanceTimePercent)
    {
        SetFieldFLOAT32Value(90, avgStanceTimePercent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stance_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStanceTimeValid() const
    {
        const Field* field = GetField(91);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stance_time field
    // Units: ms
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStanceTime(void) const
    {
        return GetFieldFLOAT32Value(91, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stance_time field
    // Units: ms
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStanceTime(FIT_FLOAT32 avgStanceTime)
    {
        SetFieldFLOAT32Value(91, avgStanceTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_fractional_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgFractionalCadenceValid() const
    {
        const Field* field = GetField(92);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the avg_cadence
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgFractionalCadence(void) const
    {
        return GetFieldFLOAT32Value(92, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the avg_cadence
    ///////////////////////////////////////////////////////////////////////
    void SetAvgFractionalCadence(FIT_FLOAT32 avgFractionalCadence)
    {
        SetFieldFLOAT32Value(92, avgFractionalCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_fractional_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxFractionalCadenceValid() const
    {
        const Field* field = GetField(93);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the max_cadence
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxFractionalCadence(void) const
    {
        return GetFieldFLOAT32Value(93, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_fractional_cadence field
    // Units: rpm
    // Comment: fractional part of the max_cadence
    ///////////////////////////////////////////////////////////////////////
    void SetMaxFractionalCadence(FIT_FLOAT32 maxFractionalCadence)
    {
        SetFieldFLOAT32Value(93, maxFractionalCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_fractional_cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalFractionalCyclesValid() const
    {
        const Field* field = GetField(94);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_fractional_cycles field
    // Units: cycles
    // Comment: fractional part of the total_cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalFractionalCycles(void) const
    {
        return GetFieldFLOAT32Value(94, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_fractional_cycles field
    // Units: cycles
    // Comment: fractional part of the total_cycles
    ///////////////////////////////////////////////////////////////////////
    void SetTotalFractionalCycles(FIT_FLOAT32 totalFractionalCycles)
    {
        SetFieldFLOAT32Value(94, totalFractionalCycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_total_hemoglobin_conc
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgTotalHemoglobinConc(void) const
    {
        return GetFieldNumValues(95, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_total_hemoglobin_conc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgTotalHemoglobinConcValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(95);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Avg saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgTotalHemoglobinConc(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(95, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Avg saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetAvgTotalHemoglobinConc(FIT_UINT8 index, FIT_FLOAT32 avgTotalHemoglobinConc)
    {
        SetFieldFLOAT32Value(95, avgTotalHemoglobinConc, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of min_total_hemoglobin_conc
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMinTotalHemoglobinConc(void) const
    {
        return GetFieldNumValues(96, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_total_hemoglobin_conc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinTotalHemoglobinConcValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(96);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Min saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinTotalHemoglobinConc(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(96, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Min saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetMinTotalHemoglobinConc(FIT_UINT8 index, FIT_FLOAT32 minTotalHemoglobinConc)
    {
        SetFieldFLOAT32Value(96, minTotalHemoglobinConc, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_total_hemoglobin_conc
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxTotalHemoglobinConc(void) const
    {
        return GetFieldNumValues(97, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_total_hemoglobin_conc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxTotalHemoglobinConcValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(97);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Max saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxTotalHemoglobinConc(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(97, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Max saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetMaxTotalHemoglobinConc(FIT_UINT8 index, FIT_FLOAT32 maxTotalHemoglobinConc)
    {
        SetFieldFLOAT32Value(97, maxTotalHemoglobinConc, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_saturated_hemoglobin_percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgSaturatedHemoglobinPercent(void) const
    {
        return GetFieldNumValues(98, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_saturated_hemoglobin_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgSaturatedHemoglobinPercentValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(98);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Avg percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgSaturatedHemoglobinPercent(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(98, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Avg percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetAvgSaturatedHemoglobinPercent(FIT_UINT8 index, FIT_FLOAT32 avgSaturatedHemoglobinPercent)
    {
        SetFieldFLOAT32Value(98, avgSaturatedHemoglobinPercent, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of min_saturated_hemoglobin_percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMinSaturatedHemoglobinPercent(void) const
    {
        return GetFieldNumValues(99, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of min_saturated_hemoglobin_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMinSaturatedHemoglobinPercentValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(99);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns min_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Min percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMinSaturatedHemoglobinPercent(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(99, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set min_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Min percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetMinSaturatedHemoglobinPercent(FIT_UINT8 index, FIT_FLOAT32 minSaturatedHemoglobinPercent)
    {
        SetFieldFLOAT32Value(99, minSaturatedHemoglobinPercent, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_saturated_hemoglobin_percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxSaturatedHemoglobinPercent(void) const
    {
        return GetFieldNumValues(100, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_saturated_hemoglobin_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxSaturatedHemoglobinPercentValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(100);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Max percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetMaxSaturatedHemoglobinPercent(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(100, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_saturated_hemoglobin_percent field
    // Units: %
    // Comment: Max percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetMaxSaturatedHemoglobinPercent(FIT_UINT8 index, FIT_FLOAT32 maxSaturatedHemoglobinPercent)
    {
        SetFieldFLOAT32Value(100, maxSaturatedHemoglobinPercent, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftTorqueEffectivenessValid() const
    {
        const Field* field = GetField(101);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(101, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftTorqueEffectiveness(FIT_FLOAT32 avgLeftTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(101, avgLeftTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightTorqueEffectivenessValid() const
    {
        const Field* field = GetField(102);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(102, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightTorqueEffectiveness(FIT_FLOAT32 avgRightTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(102, avgRightTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPedalSmoothnessValid() const
    {
        const Field* field = GetField(103);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(103, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPedalSmoothness(FIT_FLOAT32 avgLeftPedalSmoothness)
    {
        SetFieldFLOAT32Value(103, avgLeftPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPedalSmoothnessValid() const
    {
        const Field* field = GetField(104);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(104, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPedalSmoothness(FIT_FLOAT32 avgRightPedalSmoothness)
    {
        SetFieldFLOAT32Value(104, avgRightPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_combined_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCombinedPedalSmoothnessValid() const
    {
        const Field* field = GetField(105);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgCombinedPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(105, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCombinedPedalSmoothness(FIT_FLOAT32 avgCombinedPedalSmoothness)
    {
        SetFieldFLOAT32Value(105, avgCombinedPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of sport_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSportIndexValid() const
    {
        const Field* field = GetField(111);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns sport_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetSportIndex(void) const
    {
        return GetFieldUINT8Value(111, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set sport_index field
    ///////////////////////////////////////////////////////////////////////
    void SetSportIndex(FIT_UINT8 sportIndex)
    {
        SetFieldUINT8Value(111, sportIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_standing field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeStandingValid() const
    {
        const Field* field = GetField(112);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_standing field
    // Units: s
    // Comment: Total time spend in the standing position
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeStanding(void) const
    {
        return GetFieldFLOAT32Value(112, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_standing field
    // Units: s
    // Comment: Total time spend in the standing position
    ///////////////////////////////////////////////////////////////////////
    void SetTimeStanding(FIT_FLOAT32 timeStanding)
    {
        SetFieldFLOAT32Value(112, timeStanding, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stand_count field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStandCountValid() const
    {
        const Field* field = GetField(113);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stand_count field
    // Comment: Number of transitions to the standing state
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetStandCount(void) const
    {
        return GetFieldUINT16Value(113, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stand_count field
    // Comment: Number of transitions to the standing state
    ///////////////////////////////////////////////////////////////////////
    void SetStandCount(FIT_UINT16 standCount)
    {
        SetFieldUINT16Value(113, standCount, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPcoValid() const
    {
        const Field* field = GetField(114);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_pco field
    // Units: mm
    // Comment: Average platform center offset Left
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgLeftPco(void) const
    {
        return GetFieldSINT8Value(114, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_pco field
    // Units: mm
    // Comment: Average platform center offset Left
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPco(FIT_SINT8 avgLeftPco)
    {
        SetFieldSINT8Value(114, avgLeftPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPcoValid() const
    {
        const Field* field = GetField(115);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_pco field
    // Units: mm
    // Comment: Average platform center offset Right
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetAvgRightPco(void) const
    {
        return GetFieldSINT8Value(115, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_pco field
    // Units: mm
    // Comment: Average platform center offset Right
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPco(FIT_SINT8 avgRightPco)
    {
        SetFieldSINT8Value(115, avgRightPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_left_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgLeftPowerPhase(void) const
    {
        return GetFieldNumValues(116, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(116);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_power_phase field
    // Units: degrees
    // Comment: Average left power phase angles. Indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(116, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_power_phase field
    // Units: degrees
    // Comment: Average left power phase angles. Indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPowerPhase(FIT_UINT8 index, FIT_FLOAT32 avgLeftPowerPhase)
    {
        SetFieldFLOAT32Value(116, avgLeftPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_left_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgLeftPowerPhasePeak(void) const
    {
        return GetFieldNumValues(117, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_left_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLeftPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(117);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_left_power_phase_peak field
    // Units: degrees
    // Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgLeftPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(117, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_left_power_phase_peak field
    // Units: degrees
    // Comment: Average left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLeftPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 avgLeftPowerPhasePeak)
    {
        SetFieldFLOAT32Value(117, avgLeftPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_right_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgRightPowerPhase(void) const
    {
        return GetFieldNumValues(118, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(118);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_power_phase field
    // Units: degrees
    // Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(118, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_power_phase field
    // Units: degrees
    // Comment: Average right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPowerPhase(FIT_UINT8 index, FIT_FLOAT32 avgRightPowerPhase)
    {
        SetFieldFLOAT32Value(118, avgRightPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_right_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgRightPowerPhasePeak(void) const
    {
        return GetFieldNumValues(119, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_right_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgRightPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(119);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_right_power_phase_peak field
    // Units: degrees
    // Comment: Average right power phase peak angles data value indexes  defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgRightPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(119, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_right_power_phase_peak field
    // Units: degrees
    // Comment: Average right power phase peak angles data value indexes  defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgRightPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 avgRightPowerPhasePeak)
    {
        SetFieldFLOAT32Value(119, avgRightPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_power_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgPowerPosition(void) const
    {
        return GetFieldNumValues(120, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_power_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgPowerPositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(120);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_power_position field
    // Units: watts
    // Comment: Average power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgPowerPosition(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(120, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_power_position field
    // Units: watts
    // Comment: Average power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgPowerPosition(FIT_UINT8 index, FIT_UINT16 avgPowerPosition)
    {
        SetFieldUINT16Value(120, avgPowerPosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_power_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxPowerPosition(void) const
    {
        return GetFieldNumValues(121, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_power_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxPowerPositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(121);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_power_position field
    // Units: watts
    // Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxPowerPosition(FIT_UINT8 index) const
    {
        return GetFieldUINT16Value(121, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_power_position field
    // Units: watts
    // Comment: Maximum power by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetMaxPowerPosition(FIT_UINT8 index, FIT_UINT16 maxPowerPosition)
    {
        SetFieldUINT16Value(121, maxPowerPosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of avg_cadence_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumAvgCadencePosition(void) const
    {
        return GetFieldNumValues(122, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_cadence_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgCadencePositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(122);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_cadence_position field
    // Units: rpm
    // Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetAvgCadencePosition(FIT_UINT8 index) const
    {
        return GetFieldUINT8Value(122, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_cadence_position field
    // Units: rpm
    // Comment: Average cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetAvgCadencePosition(FIT_UINT8 index, FIT_UINT8 avgCadencePosition)
    {
        SetFieldUINT8Value(122, avgCadencePosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of max_cadence_position
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumMaxCadencePosition(void) const
    {
        return GetFieldNumValues(123, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_cadence_position field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxCadencePositionValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(123);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_cadence_position field
    // Units: rpm
    // Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetMaxCadencePosition(FIT_UINT8 index) const
    {
        return GetFieldUINT8Value(123, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_cadence_position field
    // Units: rpm
    // Comment: Maximum cadence by position. Data value indexes defined by rider_position_type.
    ///////////////////////////////////////////////////////////////////////
    void SetMaxCadencePosition(FIT_UINT8 index, FIT_UINT8 maxCadencePosition)
    {
        SetFieldUINT8Value(123, maxCadencePosition, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_avg_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedAvgSpeedValid() const
    {
        const Field* field = GetField(124);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_avg_speed field
    // Units: m/s
    // Comment: total_distance / total_timer_time
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedAvgSpeed(void) const
    {
        return GetFieldFLOAT32Value(124, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_avg_speed field
    // Units: m/s
    // Comment: total_distance / total_timer_time
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedAvgSpeed(FIT_FLOAT32 enhancedAvgSpeed)
    {
        SetFieldFLOAT32Value(124, enhancedAvgSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_max_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedMaxSpeedValid() const
    {
        const Field* field = GetField(125);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedMaxSpeed(void) const
    {
        return GetFieldFLOAT32Value(125, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_max_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedMaxSpeed(FIT_FLOAT32 enhancedMaxSpeed)
    {
        SetFieldFLOAT32Value(125, enhancedMaxSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_avg_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedAvgAltitudeValid() const
    {
        const Field* field = GetField(126);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedAvgAltitude(void) const
    {
        return GetFieldFLOAT32Value(126, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_avg_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedAvgAltitude(FIT_FLOAT32 enhancedAvgAltitude)
    {
        SetFieldFLOAT32Value(126, enhancedAvgAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_min_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedMinAltitudeValid() const
    {
        const Field* field = GetField(127);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedMinAltitude(void) const
    {
        return GetFieldFLOAT32Value(127, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_min_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedMinAltitude(FIT_FLOAT32 enhancedMinAltitude)
    {
        SetFieldFLOAT32Value(127, enhancedMinAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_max_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedMaxAltitudeValid() const
    {
        const Field* field = GetField(128);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedMaxAltitude(void) const
    {
        return GetFieldFLOAT32Value(128, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_max_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedMaxAltitude(FIT_FLOAT32 enhancedMaxAltitude)
    {
        SetFieldFLOAT32Value(128, enhancedMaxAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_lev_motor_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgLevMotorPowerValid() const
    {
        const Field* field = GetField(129);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_lev_motor_power field
    // Units: watts
    // Comment: lev average motor power during session
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetAvgLevMotorPower(void) const
    {
        return GetFieldUINT16Value(129, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_lev_motor_power field
    // Units: watts
    // Comment: lev average motor power during session
    ///////////////////////////////////////////////////////////////////////
    void SetAvgLevMotorPower(FIT_UINT16 avgLevMotorPower)
    {
        SetFieldUINT16Value(129, avgLevMotorPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of max_lev_motor_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMaxLevMotorPowerValid() const
    {
        const Field* field = GetField(130);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns max_lev_motor_power field
    // Units: watts
    // Comment: lev maximum motor power during session
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMaxLevMotorPower(void) const
    {
        return GetFieldUINT16Value(130, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set max_lev_motor_power field
    // Units: watts
    // Comment: lev maximum motor power during session
    ///////////////////////////////////////////////////////////////////////
    void SetMaxLevMotorPower(FIT_UINT16 maxLevMotorPower)
    {
        SetFieldUINT16Value(130, maxLevMotorPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of lev_battery_consumption field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLevBatteryConsumptionValid() const
    {
        const Field* field = GetField(131);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns lev_battery_consumption field
    // Units: percent
    // Comment: lev battery consumption during session
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLevBatteryConsumption(void) const
    {
        return GetFieldFLOAT32Value(131, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set lev_battery_consumption field
    // Units: percent
    // Comment: lev battery consumption during session
    ///////////////////////////////////////////////////////////////////////
    void SetLevBatteryConsumption(FIT_FLOAT32 levBatteryConsumption)
    {
        SetFieldFLOAT32Value(131, levBatteryConsumption, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_vertical_ratio field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgVerticalRatioValid() const
    {
        const Field* field = GetField(132);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_vertical_ratio field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgVerticalRatio(void) const
    {
        return GetFieldFLOAT32Value(132, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_vertical_ratio field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgVerticalRatio(FIT_FLOAT32 avgVerticalRatio)
    {
        SetFieldFLOAT32Value(132, avgVerticalRatio, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_stance_time_balance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStanceTimeBalanceValid() const
    {
        const Field* field = GetField(133);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_stance_time_balance field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStanceTimeBalance(void) const
    {
        return GetFieldFLOAT32Value(133, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_stance_time_balance field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStanceTimeBalance(FIT_FLOAT32 avgStanceTimeBalance)
    {
        SetFieldFLOAT32Value(133, avgStanceTimeBalance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_step_length field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgStepLengthValid() const
    {
        const Field* field = GetField(134);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_step_length field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgStepLength(void) const
    {
        return GetFieldFLOAT32Value(134, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_step_length field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    void SetAvgStepLength(FIT_FLOAT32 avgStepLength)
    {
        SetFieldFLOAT32Value(134, avgStepLength, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_anaerobic_training_effect field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalAnaerobicTrainingEffectValid() const
    {
        const Field* field = GetField(137);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_anaerobic_training_effect field
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalAnaerobicTrainingEffect(void) const
    {
        return GetFieldFLOAT32Value(137, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_anaerobic_training_effect field
    ///////////////////////////////////////////////////////////////////////
    void SetTotalAnaerobicTrainingEffect(FIT_FLOAT32 totalAnaerobicTrainingEffect)
    {
        SetFieldFLOAT32Value(137, totalAnaerobicTrainingEffect, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of avg_vam field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAvgVamValid() const
    {
        const Field* field = GetField(139);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns avg_vam field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAvgVam(void) const
    {
        return GetFieldFLOAT32Value(139, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set avg_vam field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAvgVam(FIT_FLOAT32 avgVam)
    {
        SetFieldFLOAT32Value(139, avgVam, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_SESSION_MESG_HPP)
